# ambient_backend_api_client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.4.0
- Generator version: 7.5.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/ambientlabscomputing/ambient_backend_api_client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/ambientlabscomputing/ambient_backend_api_client.git`)

Then import the package:
```python
import ambient_backend_api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ambient_backend_api_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import ambient_backend_api_client
from ambient_backend_api_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = ambient_backend_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]


# Enter a context with an instance of the API client
async with ambient_backend_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ambient_backend_api_client.ClustersApi(api_client)
    cluster_create = ambient_backend_api_client.ClusterCreate() # ClusterCreate | 

    try:
        # Create Cluster
        api_response = await api_instance.create_cluster_clusters_post(cluster_create)
        print("The response of ClustersApi->create_cluster_clusters_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ClustersApi->create_cluster_clusters_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ClustersApi* | [**create_cluster_clusters_post**](docs/ClustersApi.md#create_cluster_clusters_post) | **POST** /clusters | Create Cluster
*ClustersApi* | [**delete_cluster_clusters_cluster_id_delete**](docs/ClustersApi.md#delete_cluster_clusters_cluster_id_delete) | **DELETE** /clusters/{cluster_id} | Delete Cluster
*ClustersApi* | [**deploy_cluster_clusters_cluster_id_deployments_post**](docs/ClustersApi.md#deploy_cluster_clusters_cluster_id_deployments_post) | **POST** /clusters/{cluster_id}/deployments | Deploy Cluster
*ClustersApi* | [**get_cluster_clusters_cluster_id_get**](docs/ClustersApi.md#get_cluster_clusters_cluster_id_get) | **GET** /clusters/{cluster_id} | Get Cluster
*ClustersApi* | [**get_cluster_deployments_clusters_cluster_id_deployments_get**](docs/ClustersApi.md#get_cluster_deployments_clusters_cluster_id_deployments_get) | **GET** /clusters/{cluster_id}/deployments | Get Cluster Deployments
*ClustersApi* | [**get_clusters_clusters_get**](docs/ClustersApi.md#get_clusters_clusters_get) | **GET** /clusters | Get Clusters
*ClustersApi* | [**patch_cluster_clusters_cluster_id_patch**](docs/ClustersApi.md#patch_cluster_clusters_cluster_id_patch) | **PATCH** /clusters/{cluster_id} | Patch Cluster
*HealthApi* | [**health_health_get**](docs/HealthApi.md#health_health_get) | **GET** /health | Health
*NodesApi* | [**authorize_node_nodes_node_id_authorize_post**](docs/NodesApi.md#authorize_node_nodes_node_id_authorize_post) | **POST** /nodes/{node_id}/authorize | Authorize Node
*NodesApi* | [**create_node_nodes_post**](docs/NodesApi.md#create_node_nodes_post) | **POST** /nodes | Create Node
*NodesApi* | [**delete_node_nodes_node_id_delete**](docs/NodesApi.md#delete_node_nodes_node_id_delete) | **DELETE** /nodes/{node_id} | Delete Node
*NodesApi* | [**get_node_nodes_node_id_get**](docs/NodesApi.md#get_node_nodes_node_id_get) | **GET** /nodes/{node_id} | Get Node
*NodesApi* | [**get_nodes_nodes_get**](docs/NodesApi.md#get_nodes_nodes_get) | **GET** /nodes | Get Nodes
*NodesApi* | [**refresh_node_token_nodes_node_id_refresh_token_post**](docs/NodesApi.md#refresh_node_token_nodes_node_id_refresh_token_post) | **POST** /nodes/{node_id}/refresh_token | Refresh Node Token
*NodesApi* | [**request_new_auth_nodes_node_id_auth_post**](docs/NodesApi.md#request_new_auth_nodes_node_id_auth_post) | **POST** /nodes/{node_id}/auth | Request New Auth
*NodesApi* | [**update_node_nodes_node_id_patch**](docs/NodesApi.md#update_node_nodes_node_id_patch) | **PATCH** /nodes/{node_id} | Update Node
*NotificationsApi* | [**create_notification_notifications_post**](docs/NotificationsApi.md#create_notification_notifications_post) | **POST** /notifications | Create Notification
*NotificationsApi* | [**delete_notification_notifications_notification_id_delete**](docs/NotificationsApi.md#delete_notification_notifications_notification_id_delete) | **DELETE** /notifications/{notification_id} | Delete Notification
*NotificationsApi* | [**get_notification_notifications_notification_id_get**](docs/NotificationsApi.md#get_notification_notifications_notification_id_get) | **GET** /notifications/{notification_id} | Get Notification
*NotificationsApi* | [**get_notifications_notifications_get**](docs/NotificationsApi.md#get_notifications_notifications_get) | **GET** /notifications | Get Notifications
*NotificationsApi* | [**patch_notification_notifications_notification_id_patch**](docs/NotificationsApi.md#patch_notification_notifications_notification_id_patch) | **PATCH** /notifications/{notification_id} | Patch Notification
*PingApi* | [**auth_ping_auth_ping_get**](docs/PingApi.md#auth_ping_auth_ping_get) | **GET** /auth_ping | Auth Ping
*PingApi* | [**ping_ping_get**](docs/PingApi.md#ping_ping_get) | **GET** /ping | Ping
*RequestsApi* | [**get_request_requests_request_id_get**](docs/RequestsApi.md#get_request_requests_request_id_get) | **GET** /requests/{request_id} | Get Request
*RequestsApi* | [**patch_request_requests_request_id_patch**](docs/RequestsApi.md#patch_request_requests_request_id_patch) | **PATCH** /requests/{request_id} | Patch Request
*ServicesApi* | [**deploy_service_services_post**](docs/ServicesApi.md#deploy_service_services_post) | **POST** /services | Deploy Service
*ServicesApi* | [**get_service_services_service_id_get**](docs/ServicesApi.md#get_service_services_service_id_get) | **GET** /services/{service_id} | Get Service
*ServicesApi* | [**get_services_services_get**](docs/ServicesApi.md#get_services_services_get) | **GET** /services | Get Services
*ServicesApi* | [**patch_service_services_service_id_patch**](docs/ServicesApi.md#patch_service_services_service_id_patch) | **PATCH** /services/{service_id} | Patch Service
*UnimplementedApi* | [**create_event_events_event_get**](docs/UnimplementedApi.md#create_event_events_event_get) | **GET** /events/event | Create Event
*UnimplementedApi* | [**create_event_label_events_event_label_get**](docs/UnimplementedApi.md#create_event_label_events_event_label_get) | **GET** /events/event_label | Create Event Label
*UnimplementedApi* | [**create_event_template_events_event_template_get**](docs/UnimplementedApi.md#create_event_template_events_event_template_get) | **GET** /events/event_template | Create Event Template
*UsersApi* | [**create_service_account_users_service_accounts_post**](docs/UsersApi.md#create_service_account_users_service_accounts_post) | **POST** /users/service_accounts | Create Service Account
*UsersApi* | [**create_user_users_post**](docs/UsersApi.md#create_user_users_post) | **POST** /users | Create User
*UsersApi* | [**delete_user_users_user_id_delete**](docs/UsersApi.md#delete_user_users_user_id_delete) | **DELETE** /users/{user_id} | Delete User
*UsersApi* | [**get_user_users_user_id_get**](docs/UsersApi.md#get_user_users_user_id_get) | **GET** /users/{user_id} | Get User
*UsersApi* | [**login_user_users_login_post**](docs/UsersApi.md#login_user_users_login_post) | **POST** /users/login | Login User
*UsersApi* | [**update_user_users_user_id_patch**](docs/UsersApi.md#update_user_users_user_id_patch) | **PATCH** /users/{user_id} | Update User


## Documentation For Models

 - [AccountType](docs/AccountType.md)
 - [AmbientActionEnum](docs/AmbientActionEnum.md)
 - [AmbientEventTypeEnum](docs/AmbientEventTypeEnum.md)
 - [ArchitectureEnum](docs/ArchitectureEnum.md)
 - [Auth0DeviceCodeResponse](docs/Auth0DeviceCodeResponse.md)
 - [Cluster](docs/Cluster.md)
 - [ClusterCreate](docs/ClusterCreate.md)
 - [CreateServiceAcctRequest](docs/CreateServiceAcctRequest.md)
 - [CreationMethod](docs/CreationMethod.md)
 - [Event](docs/Event.md)
 - [EventLabel](docs/EventLabel.md)
 - [EventTemplate](docs/EventTemplate.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [InterfaceTypeEnum](docs/InterfaceTypeEnum.md)
 - [ListResultsResponse](docs/ListResultsResponse.md)
 - [ModelsClusterStatusEnum](docs/ModelsClusterStatusEnum.md)
 - [ModelsNodeStatusEnum](docs/ModelsNodeStatusEnum.md)
 - [NetworkInterface](docs/NetworkInterface.md)
 - [Node](docs/Node.md)
 - [NodeArchitectureEnum](docs/NodeArchitectureEnum.md)
 - [NodeCreate](docs/NodeCreate.md)
 - [NodeRoleEnum](docs/NodeRoleEnum.md)
 - [Notification](docs/Notification.md)
 - [NotificationList](docs/NotificationList.md)
 - [NotificationRequest](docs/NotificationRequest.md)
 - [NotificationSeverityEnum](docs/NotificationSeverityEnum.md)
 - [OrganizationCreate](docs/OrganizationCreate.md)
 - [OwnerTypeEnum](docs/OwnerTypeEnum.md)
 - [PostClustersResponse](docs/PostClustersResponse.md)
 - [PostServiceResponse](docs/PostServiceResponse.md)
 - [Request](docs/Request.md)
 - [RequestStatusEnum](docs/RequestStatusEnum.md)
 - [ResourceTypeEnum](docs/ResourceTypeEnum.md)
 - [RoleEnum](docs/RoleEnum.md)
 - [Service](docs/Service.md)
 - [ServiceCreate](docs/ServiceCreate.md)
 - [ServiceList](docs/ServiceList.md)
 - [ServiceState](docs/ServiceState.md)
 - [ServiceStatusEnum](docs/ServiceStatusEnum.md)
 - [StatusEnumInput](docs/StatusEnumInput.md)
 - [SubscriptionModelEnum](docs/SubscriptionModelEnum.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [User](docs/User.md)
 - [UserPreferences](docs/UserPreferences.md)
 - [UserRoleEnum](docs/UserRoleEnum.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="OAuth2PasswordBearer"></a>
### OAuth2PasswordBearer

- **Type**: OAuth
- **Flow**: password
- **Authorization URL**: 
- **Scopes**: N/A


## Author




