# coding: utf-8

"""
    Ambient API

     This API provides access to Ambient services. It is designed to be used by Ambient applications and services. 

    The version of the OpenAPI document: 0.3.2
    Contact: jose@ambientlabscomputing.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ambient_backend_api_client.models.account_type import AccountType
from ambient_backend_api_client.models.creation_method import CreationMethod
from ambient_backend_api_client.models.resource_type_enum import ResourceTypeEnum
from ambient_backend_api_client.models.user_preferences import UserPreferences
from ambient_backend_api_client.models.user_role_enum import UserRoleEnum
from typing import Optional, Set
from typing_extensions import Self

class User(BaseModel):
    """
    User
    """ # noqa: E501
    id: StrictInt
    name: StrictStr
    resource_type: Optional[ResourceTypeEnum] = None
    description: Optional[StrictStr] = None
    org_id: StrictInt
    user_id: Optional[StrictInt] = None
    account_type: Optional[AccountType] = None
    creation_method: Optional[CreationMethod] = None
    email: StrictStr
    first_name: StrictStr
    last_name: StrictStr
    role: Optional[UserRoleEnum] = None
    preferences: Optional[UserPreferences] = None
    auth_provider_uid: Optional[StrictStr] = None
    phone_number: Optional[StrictStr] = None
    username: Optional[StrictStr] = None
    is_super_admin: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "name", "resource_type", "description", "org_id", "user_id", "account_type", "creation_method", "email", "first_name", "last_name", "role", "preferences", "auth_provider_uid", "phone_number", "username", "is_super_admin"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of preferences
        if self.preferences:
            _dict['preferences'] = self.preferences.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['user_id'] = None

        # set to None if preferences (nullable) is None
        # and model_fields_set contains the field
        if self.preferences is None and "preferences" in self.model_fields_set:
            _dict['preferences'] = None

        # set to None if auth_provider_uid (nullable) is None
        # and model_fields_set contains the field
        if self.auth_provider_uid is None and "auth_provider_uid" in self.model_fields_set:
            _dict['auth_provider_uid'] = None

        # set to None if phone_number (nullable) is None
        # and model_fields_set contains the field
        if self.phone_number is None and "phone_number" in self.model_fields_set:
            _dict['phone_number'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if is_super_admin (nullable) is None
        # and model_fields_set contains the field
        if self.is_super_admin is None and "is_super_admin" in self.model_fields_set:
            _dict['is_super_admin'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "resource_type": obj.get("resource_type"),
            "description": obj.get("description"),
            "org_id": obj.get("org_id"),
            "user_id": obj.get("user_id"),
            "account_type": obj.get("account_type"),
            "creation_method": obj.get("creation_method"),
            "email": obj.get("email"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "role": obj.get("role"),
            "preferences": UserPreferences.from_dict(obj["preferences"]) if obj.get("preferences") is not None else None,
            "auth_provider_uid": obj.get("auth_provider_uid"),
            "phone_number": obj.get("phone_number"),
            "username": obj.get("username"),
            "is_super_admin": obj.get("is_super_admin")
        })
        return _obj


