import subprocess
import re
import platform

"""
Creates a new python project managed by relaxed-poetry
"""

global ask
global arg
global rp

LICENSES = [
    "Aladdin Free Public License (AFPL)", "CC0 1.0 Universal (CC0 1.0) Public Domain Dedication",
    "DFSG approved", "Eiffel Forum License (EFL)", "Free For Educational Use", "Free For Home Use",
    "Free for non-commercial use", "Freely Distributable", "Free To Use But Restricted", "Freeware",
    "Netscape Public License (NPL)", "Nokia Open Source License (NOKOS)", "Academic Free License (AFL)",
    "Apache Software License", "Apple Public Source License", "Artistic License",
    "Attribution Assurance License", "BSD License", "CEA CNRS Inria Logiciel Libre License, version 2.1 (CeCILL-2.1)",
    "Common Public License", "Eiffel Forum License", "European Union Public Licence 1.0 (EUPL 1.0)",
    "European Union Public Licence 1.1 (EUPL 1.1)", "GNU Affero General Public License v3",
    "GNU Affero General Public License v3 or later (AGPLv3+)", "GNU Free Documentation License (FDL)",
    "GNU General Public License (GPL)", "GNU General Public License v2 (GPLv2)",
    "GNU General Public License v2 or later (GPLv2+)", "GNU General Public License v3 (GPLv3)",
    "GNU General Public License v3 or later (GPLv3+)", "GNU Lesser General Public License v2 (LGPLv2)",
    "GNU Lesser General Public License v2 or later (LGPLv2+)", "GNU Lesser General Public License v3 (LGPLv3)",
    "GNU Lesser General Public License v3 or later (LGPLv3+)", "GNU Library or Lesser General Public License (LGPL)",
    "IBM Public License", "Intel Open Source License", "ISC License (ISCL)", "Jabber Open Source License",
    "MIT License", "MITRE Collaborative Virtual Workspace License (CVW)", "Motosoto License",
    "Mozilla Public License 1.0 (MPL)", "Mozilla Public License 1.1 (MPL 1.1)", "Mozilla Public License 2.0 (MPL 2.0)",
    "Nethack General Public License", "Nokia Open Source License", "Open Group Test Suite License",
    "Python License (CNRI Python License)", "Python Software Foundation License", "Qt Public License (QPL)",
    "Ricoh Source Code Public License", "Sleepycat License", "Sun Industry Standards Source License (SISSL)",
    "Sun Public License", "University of Illinois/NCSA Open Source License", "Vovida Software License 1.0",
    "W3C License", "X.Net License", "zlib/libpng License", "Zope Public License", "Other/Proprietary License",
    "Public Domain", "Repoze Public License", ]

project_name = ask("project_name", prompt="Your project name", positional_arg=0)
package_name = project_name.translate({ord(it): '_' for it in '- .'}).lower()
version = arg("version", doc="Your project initial version", default="0.1.0")
description = ask("project_description", prompt="Your project description", default="")
readme_format = ask(
    "readme_format", prompt='README file type to use', default=0,
    choices=["Markdown", "reStructuredText"])

readme_file = "README.md" if readme_format == "Markdown" else "README.rst"
author = arg("author", doc="Author Name") or rp.project_defaults.author_name or ask("author", prompt="Author Name")
license = ask("license", prompt="Your project license", autocomplete=LICENSES, default="MIT License")
python = ask("python_version", prompt="Required Python version classifier", default=rp.project_defaults.python_requirements)

child_project = False
if rp.active_project:
    say(f"<info> You are creating a project inside an existing project - {rp.active_project.name} </info>")
    child_project = confirm("child_project", prompt=f"Create a child project and update {rp.active_project.name}?", doc="If executed inside a project, create a child project and update its parent")

buildsys_classifier = rp.project_defaults.buildsys_requirements


def _nd_get(d, path):
    r = d
    for p in path:
        if p not in r:
            r[p] = {}
        r = r[p]
    return r

def post_generation():
    if child_project:
        with rp.active_project.edit() as data:
            _nd_get(data, ['tool','relaxed-poetry','sub-projects'])[project_name] = project_name
            
