/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLBitString;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestResult;

public class BitStringTest
extends SimpleTest {
    private void testZeroLengthStrings() throws Exception {
        DERBitString s1;
        block10: {
            block9: {
                block8: {
                    s1 = new DERBitString(new byte[0], 0);
                    s1.getBytes();
                    DERBitString derBit = (DERBitString)ASN1Primitive.fromByteArray(s1.getEncoded());
                    if (!Arrays.areEqual(s1.getEncoded(), Hex.decode("030100"))) {
                        this.fail("zero encoding wrong");
                    }
                    try {
                        new DERBitString(null, 1);
                        this.fail("exception not thrown");
                    }
                    catch (NullPointerException e) {
                        if ("data cannot be null".equals(e.getMessage())) break block8;
                        this.fail("Unexpected exception");
                    }
                }
                try {
                    new DERBitString(new byte[0], 1);
                    this.fail("exception not thrown");
                }
                catch (IllegalArgumentException e) {
                    if ("zero length data with non-zero pad bits".equals(e.getMessage())) break block9;
                    this.fail("Unexpected exception");
                }
            }
            try {
                new DERBitString(new byte[1], 8);
                this.fail("exception not thrown");
            }
            catch (IllegalArgumentException e) {
                if ("pad bits cannot be greater than 7 or less than 0".equals(e.getMessage())) break block10;
                this.fail("Unexpected exception");
            }
        }
        DERBitString s2 = new DERBitString(0);
        if (!Arrays.areEqual(s1.getEncoded(), s2.getEncoded())) {
            this.fail("zero encoding wrong");
        }
    }

    private void testRandomPadBits() throws Exception {
        byte[] test = Hex.decode("030206c0");
        byte[] test1 = Hex.decode("030206f0");
        byte[] test2 = Hex.decode("030206c1");
        byte[] test3 = Hex.decode("030206c7");
        byte[] test4 = Hex.decode("030206d1");
        this.encodingCheck(test, test1);
        this.encodingCheck(test, test2);
        this.encodingCheck(test, test3);
        this.encodingCheck(test, test4);
    }

    private void encodingCheck(byte[] derData, byte[] dlData) throws IOException {
        if (Arrays.areEqual(derData, ASN1Primitive.fromByteArray(dlData).getEncoded())) {
            this.fail("failed DL check");
        }
        ASN1BitString dl = DLBitString.getInstance(dlData);
        this.isTrue("DL test failed", dl instanceof DLBitString);
        if (!Arrays.areEqual(derData, ASN1Primitive.fromByteArray(dlData).getEncoded("DER"))) {
            this.fail("failed DER check");
        }
        try {
            DERBitString.getInstance(dlData);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DERBitString der = DERBitString.getInstance(derData);
        this.isTrue("DER test failed", der instanceof DERBitString);
    }

    @Override
    public void performTest() throws Exception {
        KeyUsage k = new KeyUsage(128);
        if (k.getBytes()[0] != -128 || k.getPadBits() != 7) {
            this.fail("failed digitalSignature");
        }
        if ((k = new KeyUsage(64)).getBytes()[0] != 64 || k.getPadBits() != 6) {
            this.fail("failed nonRepudiation");
        }
        if ((k = new KeyUsage(32)).getBytes()[0] != 32 || k.getPadBits() != 5) {
            this.fail("failed keyEncipherment");
        }
        if ((k = new KeyUsage(2)).getBytes()[0] != 2 || k.getPadBits() != 1) {
            this.fail("failed cRLSign");
        }
        if ((k = new KeyUsage(32768)).getBytes()[1] != -128 || k.getPadBits() != 7) {
            this.fail("failed decipherOnly");
        }
        try {
            ASN1Primitive.fromByteArray(new DERBitString(new byte[0], 0).getEncoded());
        }
        catch (IOException e) {
            this.fail(e.toString());
        }
        this.testRandomPadBits();
        this.testZeroLengthStrings();
    }

    @Override
    public String getName() {
        return "BitString";
    }

    public static void main(String[] args) {
        BitStringTest test = new BitStringTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

