/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.isismtt.x509.MonetaryLimit;
import org.bouncycastle.asn1.test.ASN1UnitTest;

public class MonetaryLimitUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "MonetaryLimit";
    }

    @Override
    public void performTest() throws Exception {
        String currency = "AUD";
        int amount = 1;
        int exponent = 2;
        MonetaryLimit limit = new MonetaryLimit(currency, amount, exponent);
        this.checkConstruction(limit, currency, amount, exponent);
        limit = MonetaryLimit.getInstance(null);
        if (limit != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            MonetaryLimit.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(MonetaryLimit limit, String currency, int amount, int exponent) throws IOException {
        this.checkValues(limit, currency, amount, exponent);
        limit = MonetaryLimit.getInstance(limit);
        this.checkValues(limit, currency, amount, exponent);
        ASN1InputStream aIn = new ASN1InputStream(limit.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        limit = MonetaryLimit.getInstance(seq);
        this.checkValues(limit, currency, amount, exponent);
    }

    private void checkValues(MonetaryLimit limit, String currency, int amount, int exponent) {
        this.checkMandatoryField("currency", currency, limit.getCurrency());
        this.checkMandatoryField("amount", amount, limit.getAmount().intValue());
        this.checkMandatoryField("exponent", exponent, limit.getExponent().intValue());
    }

    public static void main(String[] args) {
        MonetaryLimitUnitTest.runTest(new MonetaryLimitUnitTest());
    }
}

