/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cmc.BodyPartID;
import org.bouncycastle.asn1.cmc.CertificationRequest;
import org.bouncycastle.asn1.cmc.TaggedCertificationRequest;
import org.bouncycastle.asn1.cmc.TaggedRequest;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.Controls;
import org.bouncycastle.asn1.crmf.POPOSigningKey;
import org.bouncycastle.asn1.crmf.POPOSigningKeyInput;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class TaggedRequestTest
extends SimpleTest {
    private static byte[] req1 = Base64.decode("MIHoMIGTAgEAMC4xDjAMBgNVBAMTBVRlc3QyMQ8wDQYDVQQKEwZBbmFUb20xCzAJBgNVBAYTAlNFMFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBALlEt31Tzt2MlcOljvacJgzQVhmlMoqAOgqJ9Pgd3GuxZ7/WcIlgW4QCB7WZT21O1YoghwBhPDMcNGrHei9kHQkCAwEAAaAAMA0GCSqGSIb3DQEBBQUAA0EANDEI4ecNtJ3uHwGGlitNFq9WxcoZ0djbQJ5hABMotav6gtqlrwKXY2evaIrsNwkJtNdwwH18aQDUKCjOuBL38Q==");

    public static void main(String[] args) {
        TaggedRequestTest.runTest(new TaggedRequestTest());
    }

    @Override
    public String getName() {
        return "TaggedRequestTest";
    }

    @Override
    public void performTest() throws Exception {
        TaggedRequest tr = new TaggedRequest(new TaggedCertificationRequest(new BodyPartID(10L), CertificationRequest.getInstance(req1)));
        byte[] b = tr.getEncoded();
        TaggedRequest trResult = TaggedRequest.getInstance(b);
        this.isEquals("Tag", tr.getTagNo(), trResult.getTagNo());
        this.isEquals("Is TCR tag", 0L, tr.getTagNo());
        this.isEquals("Value", tr.getValue(), trResult.getValue());
        POPOSigningKeyInput pski = new POPOSigningKeyInput(new GeneralName(1, "fish"), new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.certBag, new ASN1Integer(5L)), new ASN1Integer(4L)));
        AlgorithmIdentifier aid = new AlgorithmIdentifier(PKCSObjectIdentifiers.crlTypes, new ASN1Integer(1L));
        DERBitString dbi = new DERBitString(2);
        POPOSigningKey popoSigningKey = new POPOSigningKey(pski, aid, dbi);
        ProofOfPossession proofOfPossession = new ProofOfPossession(new POPOSigningKey(pski, aid, dbi));
        TaggedRequest tr2 = new TaggedRequest(new CertReqMsg(new CertRequest(new ASN1Integer(1L), CertTemplate.getInstance(new DERSequence(new DERTaggedObject(0, new ASN1Integer(3L)))), new Controls(new AttributeTypeAndValue(PKCSObjectIdentifiers.pkcs_9, (ASN1Encodable)new ASN1Integer(3L)))), proofOfPossession, new AttributeTypeAndValue[0]));
        byte[] b2 = tr2.getEncoded();
        TaggedRequest trResult2 = TaggedRequest.getInstance(b2);
        this.isEquals("Tag", tr2.getTagNo(), trResult2.getTagNo());
        this.isEquals("Is CRM tag", 1L, tr2.getTagNo());
        this.isEquals("Value", tr2.getValue(), trResult2.getValue());
        tr = TaggedRequest.getInstance(new DERTaggedObject(2, new DERSequence(new ASN1Encodable[]{new BodyPartID(1L), PKCSObjectIdentifiers.data, new DERSet(new ASN1Encodable[]{new ASN1Integer(5L)})})));
        b = tr.getEncoded();
        trResult = TaggedRequest.getInstance(b);
        this.isEquals("Tag", tr.getTagNo(), trResult.getTagNo());
        this.isEquals("Is ORM tag", 2L, tr.getTagNo());
        this.isEquals("Value", tr.getValue(), trResult.getValue());
    }
}

