/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.tls.test.TlsTestCase;
import org.bouncycastle.crypto.tls.test.TlsTestConfig;

public class TlsTestSuite
extends TestSuite {
    public TlsTestSuite() {
        super("TLS");
    }

    public static Test suite() {
        TlsTestSuite testSuite = new TlsTestSuite();
        TlsTestSuite.addFallbackTests(testSuite);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.SSLv3);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv10);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv11);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv12);
        return testSuite;
    }

    private static void addFallbackTests(TestSuite testSuite) {
        TlsTestConfig c = TlsTestSuite.createTlsTestConfig(ProtocolVersion.TLSv12);
        c.clientFallback = true;
        TlsTestSuite.addTestCase(testSuite, c, "FallbackGood");
        c = TlsTestSuite.createTlsTestConfig(ProtocolVersion.TLSv12);
        c.clientOfferVersion = ProtocolVersion.TLSv11;
        c.clientFallback = true;
        c.expectServerFatalAlert((short)86);
        TlsTestSuite.addTestCase(testSuite, c, "FallbackBad");
        c = TlsTestSuite.createTlsTestConfig(ProtocolVersion.TLSv12);
        c.clientOfferVersion = ProtocolVersion.TLSv11;
        TlsTestSuite.addTestCase(testSuite, c, "FallbackNone");
    }

    private static void addVersionTests(TestSuite testSuite, ProtocolVersion version) {
        String prefix = String.valueOf(version.toString().replaceAll("[ \\.]", "")) + "_";
        TlsTestConfig c = TlsTestSuite.createTlsTestConfig(version);
        TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "GoodDefault");
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version);
            c.clientAuth = 1;
            c.clientAuthSigAlg = new SignatureAndHashAlgorithm(1, 1);
            c.serverCertReqSigAlgs = TlsUtils.getDefaultRSASignatureAlgorithms();
            c.expectClientFatalAlert((short)80);
            TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "BadCertificateVerifyHashAlg");
        }
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version);
            c.clientAuth = 1;
            c.clientAuthSigAlg = new SignatureAndHashAlgorithm(2, 1);
            c.serverCertReqSigAlgs = TlsUtils.getDefaultECDSASignatureAlgorithms();
            c.expectServerFatalAlert((short)47);
            TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "BadCertificateVerifySigAlg");
        }
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version);
            c.clientAuth = 1;
            c.clientAuthSigAlg = new SignatureAndHashAlgorithm(2, 1);
            c.clientAuthSigAlgClaimed = new SignatureAndHashAlgorithm(2, 3);
            c.serverCertReqSigAlgs = TlsUtils.getDefaultECDSASignatureAlgorithms();
            c.expectServerFatalAlert((short)51);
            TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "BadCertificateVerifySigAlgMismatch");
        }
        c = TlsTestSuite.createTlsTestConfig(version);
        c.clientAuth = 3;
        c.expectServerFatalAlert((short)51);
        TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "BadCertificateVerifySignature");
        c = TlsTestSuite.createTlsTestConfig(version);
        c.clientAuth = 2;
        c.expectServerFatalAlert((short)42);
        TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "BadClientCertificate");
        c = TlsTestSuite.createTlsTestConfig(version);
        c.clientAuth = 0;
        c.serverCertReq = 2;
        c.expectServerFatalAlert((short)40);
        TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "BadMandatoryCertReqDeclined");
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version);
            c.serverAuthSigAlg = new SignatureAndHashAlgorithm(1, 1);
            c.expectClientFatalAlert((short)47);
            TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "BadServerKeyExchangeSigAlg");
        }
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version);
            c.clientSendSignatureAlgorithms = false;
            c.serverAuthSigAlg = new SignatureAndHashAlgorithm(1, 1);
            c.expectClientFatalAlert((short)47);
            TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "BadServerKeyExchangeSigAlg2");
        }
        c = TlsTestSuite.createTlsTestConfig(version);
        c.serverCertReq = 0;
        TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "GoodNoCertReq");
        c = TlsTestSuite.createTlsTestConfig(version);
        c.clientAuth = 0;
        TlsTestSuite.addTestCase(testSuite, c, String.valueOf(prefix) + "GoodOptionalCertReqDeclined");
    }

    private static void addTestCase(TestSuite testSuite, TlsTestConfig config, String name) {
        testSuite.addTest((Test)new TlsTestCase(config, name));
    }

    private static TlsTestConfig createTlsTestConfig(ProtocolVersion version) {
        TlsTestConfig c = new TlsTestConfig();
        c.clientMinimumVersion = ProtocolVersion.SSLv3;
        c.clientOfferVersion = ProtocolVersion.TLSv12;
        c.serverMaximumVersion = version;
        c.serverMinimumVersion = ProtocolVersion.SSLv3;
        return c;
    }

    static abstract class C
    extends TlsTestConfig {
        C() {
        }
    }
}

