/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

abstract class JceTestUtil {
    private JceTestUtil() {
    }

    static String[] getRegisteredAlgorithms(String prefix, String[] exclusionPatterns) {
        BouncyCastleProvider prov = (BouncyCastleProvider)Security.getProvider("BC");
        ArrayList<String> matches = new ArrayList<String>();
        Enumeration<Object> algos = prov.keys();
        while (algos.hasMoreElements()) {
            String algoName;
            String algo = (String)algos.nextElement();
            if (!algo.startsWith(prefix) || JceTestUtil.isExcluded(algoName = algo.substring(prefix.length()), exclusionPatterns)) continue;
            matches.add(algoName);
        }
        return matches.toArray(new String[matches.size()]);
    }

    private static boolean isExcluded(String algoName, String[] exclusionPatterns) {
        int i = 0;
        while (i < exclusionPatterns.length) {
            if (algoName.contains(exclusionPatterns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

