/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PKIXTest
implements Test {
    static byte[] rootCertBin = Hex.decode("308202bb3082027ba003020102020111300906072a8648ce380403302a310b3009060355040613025553310c300a060355040a1303676f76310d300b060355040b13044e495354301e170d3937303633303030303030305a170d3937313233313030303030305a302a310b3009060355040613025553310c300a060355040a1303676f76310d300b060355040b13044e495354308201b83082012c06072a8648ce3804013082011f02818100b68b0f942b9acea525c6f2edfcfb9532ac011233b9e01cad909bbc48549ef394773c2c713555e6fe4f22cbd5d83e8993334dfcbd4f41643ea29870ec31b450deebf198280ac93e44b3fd22979683d018a3e3bd355bffeea321726a7b96dab93f1e5a90af24d620f00d21a7d402b91afcac21fb9e949e4b42459e6ab24863fe43021500b20db0b101df0c6624fc1392ba55f77d577481e5028181009abf46b1f53f443dc9a565fb91c08e47f10ac30147c2444236a99281de57c5e0688658007b1ff99b77a1c510a580917851513cf6fcfccc46c6817892843df4933d0c387e1a5b994eab1464f60c21224e28089c92b9669f40e895f6d5312aef39a262c7b26d9e58c43aa81181846daff8b419b4c211aed0223baa207fee1e57180381850002818100b59e1f490447d1dbf53addca0475e8dd75f69b8ab197d6596982d3034dfd3b365f4af2d14ec107f5d12ad378776356ea96614d420b7a1dfbab91a4cedeef77c8e5ef20aea62848afbe69c36aa530f2c2b9d9822b7dd9c4841fde0de854d71b992eb3d088f6d6639ba7e20e82d43b8a681b065631590b49eb99a5d581417bc955a3323030301d0603551d0e0416041486caa5228162efad0a89bcad72412c2949f48656300f0603551d130101ff040530030101ff300906072a8648ce380403032f00302c0214431bcf292545c04e52e77dd6fcb1664c83cf2d7702140b5b9a241198e8f3869004f608a9e18da5cc3ad4");
    static byte[] userCert1Bin = Hex.decode("308202da30820299a003020102020112300906072a8648ce380403302a310b3009060355040613025553310c300a060355040a1303676f76310d300b060355040b13044e495354301e170d3937303733303030303030305a170d3937313230313030303030305a303d310b3009060355040613025553310c300a060355040a1303676f76310d300b060355040b13044e4953543111300f0603550403130854696d20506f6c6b308201b73082012c06072a8648ce3804013082011f02818100b68b0f942b9acea525c6f2edfcfb9532ac011233b9e01cad909bbc48549ef394773c2c713555e6fe4f22cbd5d83e8993334dfcbd4f41643ea29870ec31b450deebf198280ac93e44b3fd22979683d018a3e3bd355bffeea321726a7b96dab93f1e5a90af24d620f00d21a7d402b91afcac21fb9e949e4b42459e6ab24863fe43021500b20db0b101df0c6624fc1392ba55f77d577481e5028181009abf46b1f53f443dc9a565fb91c08e47f10ac30147c2444236a99281de57c5e0688658007b1ff99b77a1c510a580917851513cf6fcfccc46c6817892843df4933d0c387e1a5b994eab1464f60c21224e28089c92b9669f40e895f6d5312aef39a262c7b26d9e58c43aa81181846daff8b419b4c211aed0223baa207fee1e57180381840002818030b675f77c2031ae38bb7e0d2baba09c4bdf20d524133ccd98e55f6cb7c1ba4abaa9958053f00d72dc3337f4010bf5041f9d2e1f62d8843a9b25095a2dc8468e2bd4f50d3bc72dc66cb998c1253a444e8eca9561357cce15315c23131ea205d17a241ccbd3720990ff9b9d28c0a10aec469f0db8d0dcd018a62b5ef98fb595bea33e303c30190603551d1104123010810e77706f6c6b406e6973742e676f76301f0603551d2304183016801486caa5228162efad0a89bcad72412c2949f48656300906072a8648ce380403033000302d02143697cbe3b42ce1bb61a9d3cc24cc22929ff4f587021500abc979afd2161ca9e368a91410b4a02eff225a73");
    static byte[] userCert2Bin = Hex.decode("3082028e308201f7a00302010202020100300d06092a864886f70d0101050500302a310b3009060355040613025553310c300a060355040b1303676f76310d300b060355040a13044e495354301e170d3936303532313039353832365a170d3937303532313039353832365a303d310b3009060355040613025553310c300a060355040b1303676f76310d300b060355040a13044e4953543111300f0603550403130854696d20506f6c6b30819f300d06092a864886f70d010101050003818d0030818902818100e16ae4033097023cf410f3b51e4d7f147bf6f5d078e9a48af0a375ecedb656967f8899859af23e687787eb9ed19fc0b417dcab8923a41d7e16234c4fa84df531b87caae31a4909f44b26db2767308212014ae91ab6c10c538b6cfc2f7a43ec33367e32b27bd5aacf0114c612ec13f22d147a8b215814134c46a39af21695ff230203010001a381af3081ac303f0603551d11043830368634687474703a2f2f7777772e69746c2e6e6973742e676f762f6469763839332f73746166662f706f6c6b2f696e6465782e68746d6c301f0603551d12041830168614687474703a2f2f7777772e6e6973742e676f762f301f0603551d230418301680140868af8533c8394a7af882938e706a4a20842c3230170603551d200410300e300c060a60864801650302013009300e0603551d0f0101ff040403020780300d06092a864886f70d0101050500038181008e8e3656788bbfa13975172ee310dc832b6834521cf66c1d525e5420105e4ca940f94b729e82b961dceb32a5bdb1b148f99b01bbebaf9b83f6528cb06d7cd09a39543e6d206fcdd0debe275f204fb6ab0df5b7e1bab4dfdf3dd4f6ed01fb6ecb9859ac41fb489c1ff65b46e029e276ecc43a0afc92c5c0d2a9c9d32952876533");
    static byte[] crlBin = Hex.decode("3081cb30818c020101300906072a8648ce380403302a310b3009060355040613025553310c300a060355040a1303676f76310d300b060355040b13044e495354170d3937303830373030303030305a170d3937303930373030303030305a30223020020112170d3937303733313030303030305a300c300a0603551d1504030a0101a00e300c300a0603551d14040302010c300906072a8648ce380403032f00302c0214224e9f43ba950634f2bb5e65dba68005c03a29470214591a57c982d7022114c3d40b321b9616b11f465a");

    @Override
    public TestResult perform() {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(rootCertBin));
            X509Certificate userCert1 = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(userCert1Bin));
            X509Certificate userCert2 = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(userCert2Bin));
            X509CRL crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(crlBin));
            rootCert.verify(rootCert.getPublicKey(), "BC");
            userCert1.verify(rootCert.getPublicKey(), "BC");
            crl.verify(rootCert.getPublicKey(), "BC");
            if (!crl.isRevoked(userCert1)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": usercert1 not revoked.");
            }
            if (crl.isRevoked(userCert2)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": usercert2 revoked.");
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + e.toString());
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    @Override
    public String getName() {
        return "PKIX";
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        PKIXTest test = new PKIXTest();
        TestResult result = test.perform();
        System.out.println(result.toString());
    }
}

