/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.Serializable;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SealedTest
implements Test {
    static final String provider = "BC";

    @Override
    public String getName() {
        return "SealedObject";
    }

    @Override
    public TestResult perform() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("DES", provider);
            SecretKey key = keyGen.generateKey();
            Cipher c = Cipher.getInstance("DES/ECB/PKCS5Padding", provider);
            c.init(1, key);
            String object = "Hello world";
            SealedObject so = new SealedObject((Serializable)((Object)object), c);
            c.init(2, key);
            Object o = so.getObject(c);
            if (!o.equals(object)) {
                return new SimpleTestResult(false, "Result object 1 not equalorig: " + object + " res: " + o);
            }
            o = so.getObject(key);
            if (!o.equals(object)) {
                return new SimpleTestResult(false, "Result object 2 not equalorig: " + object + " res: " + o);
            }
            o = so.getObject(key, provider);
            if (!o.equals(object)) {
                return new SimpleTestResult(false, "Result object 3 not equalorig: " + object + " res: " + o);
            }
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed excpetion - " + e.toString(), e);
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        SealedTest test = new SealedTest();
        TestResult result = test.perform();
        System.out.println(result.toString());
    }
}

