/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509LDAPCertStoreParameters;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.x509.X509CRLStoreSelector;
import org.bouncycastle.x509.X509CertStoreSelector;
import org.bouncycastle.x509.X509Store;
import org.bouncycastle.x509.X509StoreParameters;

public class X509LDAPCertStoreTest
extends SimpleTest {
    private static final byte[] cert1 = Base64.decode("MIIDyTCCAzKgAwIBAgIEL64+8zANBgkqhkiG9w0BAQUFADBVMQswCQYDVQQGEwJERTEcMBoGA1UEChQTRGV1dHNjaGUgVGVsZWtvbSBBRzEoMAwGBwKCBgEKBxQTATEwGAYDVQQDFBFUVEMgVGVzdCBDQSAxMTpQTjAeFw0wMzAzMjUxNDM1MzFaFw0wNjAzMjUxNDM1MzFaMGIxCzAJBgNVBAYTAkRFMRswGQYDVQQKDBJHRlQgU29sdXRpb25zIEdtYkgxEjAQBgNVBAsMCUhZUEFSQ0hJVjEWMBQGA1UEAwwNRGllZ2UsIFNpbW9uZTEKMAgGA1UEBRMBMTCBoDANBgkqhkiG9w0BAQEFAAOBjgAwgYoCgYEAiEYsFbs4FesQpMjBkzJB92c0p8tJ02nbCNA5l17VVbbrv6/twnQHW4kgA+9lZlXfzI8iunT1KuiwVupWObHgFaGPkelIN/qIbuwbQzh7T+IUKdKETE12Lc+xk9YvQ6mJVgosmwprnMMjezymh8DjPhe7MC7/H3AotrHVNM3mEJcCBEAAAIGjggGWMIIBkjAfBgNVHSMEGDAWgBTQc8wTeltcAM3iTE63fk/wTA+IJTAdBgNVHQ4EFgQUq6ChBvXPiqhMHLS3kiKpSeGWDz4wDgYDVR0PAQH/BAQDAgQwMB8GA1UdEQQYMBaBFHNpbW9uZS5kaWVnZUBnZnQuY29tMIHoBgNVHR8EgeAwgd0wgdqgaqBohjVsZGFwOi8vcGtzbGRhcC50dHRjLmRlOjM4OS9jPWRlLG89RGV1dHNjaGUgVGVsZWtvbSBBR4YvaHR0cDovL3d3dy50dHRjLmRlL3RlbGVzZWMvc2VydmxldC9kb3dubG9hZF9jcmyibKRqMGgxCzAJBgNVBAYTAkRFMRwwGgYDVQQKFBNEZXV0c2NoZSBUZWxla29tIEFHMTswDAYHAoIGAQoHFBMBMTArBgNVBAMUJFRlbGVTZWMgRGlyZWN0b3J5IFNlcnZpY2UgU2lnRyAxMDpQTjA0BggrBgEFBQcBAQQoMCYwJAYIKwYBBQUHMAGGGGh0dHA6Ly93d3cudHR0Yy5kZS9vY3NwcjANBgkqhkiG9w0BAQUFAAOBgQBCPudAtrP9Bx7GRhHQgYS6kaoNvYb/yDss86pyn0uiFuwT+mT1popcAfxPo2yxL0jqqlsDNFBC2hJob5rjihsKPmqVrSaW0VJu/zBihsX7hLKOVMf5gvUYMS5ulq/bp8jOj8a+5SmxVY+WWZVFghWjISseT3WABdTS9S3zjnQiyg==");
    private static final byte[] directCRL = Base64.decode("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");
    private static final String ldapURL1 = "ldap://pksldap.tttc.de:389";
    private static final X509LDAPCertStoreParameters params1 = new X509LDAPCertStoreParameters.Builder("ldap://pksldap.tttc.de:389", "o=Deutsche Telekom AG, c=DE").setAACertificateSubjectAttributeName("ou cn").setAttributeAuthorityRevocationListIssuerAttributeName("cn").setAttributeCertificateAttributeSubjectAttributeName("cn").setAttributeCertificateRevocationListIssuerAttributeName("cn").setAttributeDescriptorCertificateSubjectAttributeName("ou cn").setAuthorityRevocationListIssuerAttributeName("cn").setCACertificateSubjectAttributeName("ou cn").setCertificateRevocationListIssuerAttributeName("cn").setCrossCertificateSubjectAttributeName("cn").setDeltaRevocationListIssuerAttributeName("cn").setSearchForSerialNumberIn("cn").build();
    private static final String ldapURL2 = "ldap://directory.d-trust.de:389";
    private static final X509LDAPCertStoreParameters params2 = new X509LDAPCertStoreParameters.Builder("ldap://directory.d-trust.de:389", "o=D-Trust GmbH, c=DE").setAACertificateSubjectAttributeName("cn o").setAttributeAuthorityRevocationListIssuerAttributeName("cn").setAttributeCertificateAttributeSubjectAttributeName("cn").setAttributeCertificateRevocationListIssuerAttributeName("cn").setAttributeDescriptorCertificateSubjectAttributeName("cn o").setAuthorityRevocationListIssuerAttributeName("cn").setCACertificateSubjectAttributeName("cn o").setCertificateRevocationListIssuerAttributeName("cn").setCrossCertificateSubjectAttributeName("cn o").setDeltaRevocationListIssuerAttributeName("cn").setSearchForSerialNumberIn("uid").build();
    private static final byte[] cert2 = Base64.decode("MIIEADCCAuigAwIBAgIDAJ/QMA0GCSqGSIb3DQEBBQUAMD8xCzAJBgNVBAYTAkRFMRUwEwYDVQQKDAxELVRydXN0IEdtYkgxGTAXBgNVBAMMEEQtVFJVU1QgRGVtbyBDQTEwHhcNMDYwMzAyMTYxNTU3WhcNMDgwMzEyMTYxNTU3WjB+MQswCQYDVQQGEwJERTEUMBIGA1UECgwLTXVzdGVyIEdtYkgxFzAVBgNVBAMMDk1heCBNdXN0ZXJtYW5uMRMwEQYDVQQEDApNdXN0ZXJtYW5uMQwwCgYDVQQqDANNYXgxHTAbBgNVBAUTFERUUldFMTQxMjk5NDU1MTgwMTIxMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjLDFeviSZDEZgLzTdptU4biPgNV7SvLqsNholfqkyQm2r5WSghGZSjhKYIneqKmZ08W59a51bGqDEsifYR7Tw9JC/AhH19fyK01+1ZAXHalgVthaRtLw31lcoTVJR7j9fvrnW0sMPVP4m5gePb3P5/pYHVmN1MjdPIm38us5aJOytOO5Li2IwQIG0t4MbEC6/1horBR5TgRl7ACamrdaPHOvO1QVweOqYU7uVxLgDTK4mSV6heyrisFMfkbj7jT/c44kXM7dtgNcmESINudu6bnqaB1CxOFTJ/Jzv81R5lf7pBX2LOG1Bu94Yw2xcHUVROs2UWY8kQrNUozsBHzQ0QIDAKq5o4HFMIHCMBMGA1UdIwQMMAqACEITKrPLWuYiMDMGCCsGAQUFBwEBBCcwJTAjBggrBgEFBQcwAYYXaHR0cDovL29jc3AuZC10cnVzdC5uZXQwEAYDVR0gBAkwBzAFBgMqAwQwEQYDVR0OBAoECEvE8bXFHkFLMA4GA1UdDwEB/wQEAwIGQDAPBgUrJAgDCAQGDARUZXN0MB8GA1UdEQQYMBaBFG0ubXVzdGVybWFubkB0ZXN0LmRlMA8GBSskCAMPBAYMBFRlc3QwDQYJKoZIhvcNAQEFBQADggEBADD/X+UZZN30nCBDzJ7MtmgwvMBVDAU6HkPlzfyn9pxIKFrq3uR9wcY2pedMyQQk0NpTDCIhAYIjAHysMue0ViQnW5qq8uUCFn0+fsgMqqTQNRmE4NIqUrnYO40gWjcepCEApkTqGf3RFaDMf9zpRvj9qUx18De+V0GC22uD2vPKpqRcvS2dSw6pHBW2NwEU+RgNhoPXrHt332PEYdwO0zOL7eSLBD9AmkpP2uDjpMQ02Lu9kXG6OOfanwfSjHioCvDXyl5pwSHwrHNWQRb5dLF12Fg41LMapDwR7awAKE9h6qHBonvCMBPMvqrrNktqQcoQkluR9MItONJI5XHADtU=");
    private static final String ldapURL3 = "ldap://dir.signtrust.de:389";
    private static final X509LDAPCertStoreParameters params3 = new X509LDAPCertStoreParameters.Builder("ldap://dir.signtrust.de:389", "o=Deutsche Post AG, c=de").setAACertificateSubjectAttributeName("ou").setAttributeAuthorityRevocationListIssuerAttributeName("cn").setAttributeCertificateAttributeSubjectAttributeName("cn").setAttributeCertificateRevocationListIssuerAttributeName("o").setAttributeDescriptorCertificateSubjectAttributeName("ou").setAuthorityRevocationListIssuerAttributeName("o").setCACertificateSubjectAttributeName("ou").setCertificateRevocationListIssuerAttributeName("o").setCrossCertificateSubjectAttributeName("o").setDeltaRevocationListIssuerAttributeName("o").setSearchForSerialNumberIn("serialNumber").build();
    private static final byte[] cert3 = Base64.decode("MIICwDCCAimgAwIBAgIBKzANBgkqhkiG9w0BAQUFADA6MRAwDgYDVQQDEwdQQ0ExOlBOMRkwFwYDVQQKExBEZXV0c2NoZSBQb3N0IEFHMQswCQYDVQQGEwJERTAeFw0wMDA0MTkyMjAwMDBaFw0wMzA0MTkyMjAwMDBaMIGOMRAwDgYDVQQEFAdN5G5jaGVyMQ4wDAYDVQQqEwVLbGF1czEWMBQGA1UEAxQNS2xhdXMgTeRuY2hlcjEVMBMGA1UECRMMV2llc2Vuc3RyLiAzMQ4wDAYDVQQREwU2MzMyOTESMBAGA1UEBxMJRWdlbHNiYWNoMQswCQYDVQQGEwJERTEKMAgGA1UEBRMBMTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAn7z6Ba9wpv/mNBIaricY/d0KpxGpqGAXdqKlvqkk/seJEoBLvmL7wZz88RPELQqzDhc4oXYohS2dh3NHus9FpSPMq0JzKAcE3ArrVDxwtXtlcwN2v7iSTcHurgLOb9C/r8JdsMHNgwHMkkdp96cJk/sioyP5sLPYmgWxg1JH0vMCAwEAAaOBgDB+MAwGA1UdEwEB/wQCMAAwDwYDVR0PAQH/BAUDAwfAADBKBgNVHSMEQzBBoTykOjEQMA4GA1UEAxMHUENBMTpQTjEZMBcGA1UEChMQRGV1dHNjaGUgUG9zdCBBRzELMAkGA1UEBhMCREWCAQEwEQYDVR0OBAoECEAeJ6R3USjxMA0GCSqGSIb3DQEBBQUAA4GBADMRtdiQJF2fg7IcedTjnAW+QGl/wNSKy7A4oaBQeahcruo+hzH+ZU+DsiSuTJZaf2X1eUUEPmV+5zZlopGa3HvFfgmIYIXBw9ZO3Qb/HWGsPNgW0yg5eXEGwNEtvV85BTMGuMjiuDw841IuAZaMKqOKnVXHmd2pLJz7Wv0MLJhw");
    private static final byte[] caCert3 = Base64.decode("MIICUjCCAb6gAwIBAgIDD2ptMAoGBiskAwMBAgUAMG8xCzAJBgNVBAYTAkRFMT0wOwYDVQQKFDRSZWd1bGllcnVuZ3NiZWjIb3JkZSBmyHVyIFRlbGVrb21tdW5pa2F0aW9uIHVuZCBQb3N0MSEwDAYHAoIGAQoHFBMBMTARBgNVBAMUCjRSLUNBIDE6UE4wIhgPMjAwMDA0MTIwODIyMDNaGA8yMDA0MDQxMjA4MjIwM1owWzELMAkGA1UEBhMCREUxGTAXBgNVBAoUEERldXRzY2hlIFBvc3QgQUcxMTAMBgcCggYBCgcUEwExMCEGA1UEAxQaQ0EgREVSIERFVVRTQ0hFTiBQT1NUIDU6UE4wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIH3c+gig1KkY5ceR6n/AMq+xz7hi3f0PMdpwIe2v2w6Hu5kjipe++NvU3r6wakIY2royHl3gKWrExOisBico9aQmn8lMJnWZ7SUbB+WpRn0mAWNZM9YT+/U5hRCffeeuLWClzrbScaWnAeaaI0G+N/QKnSSjrV/l64jogyADWCTAgMBAAGjEjAQMA4GA1UdDwEB/wQEAwIBBjAKBgYrJAMDAQIFAAOBgQAaV5WClEneXk9sLO8zTQAsf4KvDaLd1BFcFeYM7kLLRHKeWQ0MAd0xkuAMme5NVwWNpNZP74B4HX7Q/Q0h/wo/9LTgQaxw52lLs4Ml0HUyJbSFjoQ+sqgjg2fGNGw7aGkVNY5dQTAy8oSviG8mxTsQ7Fxaush3cIB0qDDwXar/hg==");
    private static final byte[] crossCert3 = Base64.decode("MIICVDCCAcCgAwIBAgIDDIOsMAoGBiskAwMBAgUAMG8xCzAJBgNVBAYTAkRFMT0wOwYDVQQKFDRSZWd1bGllcnVuZ3NiZWjIb3JkZSBmyHVyIFRlbGVrb21tdW5pa2F0aW9uIHVuZCBQb3N0MSEwDAYHAoIGAQoHFBMBMTARBgNVBAMUCjRSLUNBIDE6UE4wIhgPMjAwMDAzMjIwOTQzNTBaGA8yMDA0MDEyMTE2MDQ1M1owbzELMAkGA1UEBhMCREUxPTA7BgNVBAoUNFJlZ3VsaWVydW5nc2JlaMhvcmRlIGbIdXIgVGVsZWtvbW11bmlrYXRpb24gdW5kIFBvc3QxITAMBgcCggYBCgcUEwExMBEGA1UEAxQKNVItQ0EgMTpQTjCBoTANBgkqhkiG9w0BAQEFAAOBjwAwgYsCgYEAih5BUycfBpqKhU8RDsaSvV5AtzWeXQRColL9CH3t0DKnhjKAlJ8iccFtJNv+d3bh8bb9sh0maRSo647xP7hsHTjKgTE4zM5BYNfXvST79OtcMgAzrnDiGjQIIWv8xbfV1MqxxdtZJygrwzRMb9jGCAGoJEymoyzAMNG7tSdBWnUCBQDAAAABMAoGBiskAwMBAgUAA4GBAIBWrl6aEy4d2d6U/924YK8Tv9oChmaKVhklkiTzcKv1N8dhLnLTibq4/stop03CY3rKU4X5aTfu0J77FIV1Poy9jLT5Tm1NBpi71m4uO3AUoSeyhJXGQGsYFjAc3URqkznbTL/nr9reIoBhf6u9cX+idnN6Uy1q+j/LOrcy3zgj");

    @Override
    public void performTest() throws Exception {
        this.certStoretest();
        this.x509StoreTest();
    }

    private void certStoretest() throws Exception {
        CertStore cs = CertStore.getInstance("X509LDAP", (CertStoreParameters)params1, "BC");
        X509CertSelector sl = new X509CertSelector();
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate xcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert1));
        sl.setCertificate(xcert);
        Collection<Object> coll = cs.getCertificates(sl);
        if (coll.isEmpty() || !((Object)coll.iterator().next()).equals(xcert)) {
            this.fail("certificate could not be picked from LDAP directory.");
        }
        sl.setCertificate(null);
        sl.setSubject(this.getSubject(xcert).getEncoded());
        coll = cs.getCertificates(sl);
        if (coll.isEmpty() || !((Object)coll.iterator().next()).equals(xcert)) {
            this.fail("certificate could not be picked from LDAP directory.");
        }
        X509CRLSelector sl2 = new X509CRLSelector();
        X509CRL crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(directCRL));
        sl2.addIssuerName(this.getCRLIssuer(crl).getEncoded());
        coll = cs.getCRLs(sl2);
        if (!coll.iterator().hasNext()) {
            this.fail("CRL could not be picked from LDAP directory.");
        }
        cs = CertStore.getInstance("X509LDAP", (CertStoreParameters)params2, "BC");
        sl = new X509CertSelector();
        xcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert2));
        sl.setCertificate(xcert);
        coll = cs.getCertificates(sl);
        if (coll.isEmpty() || !coll.iterator().next().equals(xcert)) {
            this.fail("Certificate could not be picked from LDAP directory.");
        }
        cs = CertStore.getInstance("X509LDAP", (CertStoreParameters)params3, "BC");
        sl = new X509CertSelector();
        xcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert3));
        sl.setCertificate(xcert);
        coll = cs.getCertificates(sl);
        if (coll.isEmpty() || !coll.iterator().next().equals(xcert)) {
            this.fail("Certificate could not be picked from LDAP directory.");
        }
        xcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(caCert3));
        sl = new X509CertSelector();
        sl.setSubject(this.getSubject(xcert).getEncoded());
        coll = cs.getCertificates(sl);
        boolean found = false;
        if (coll.isEmpty()) {
            this.fail("Certificate could not be picked from LDAP directory.");
        }
        Iterator<Object> it = coll.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(xcert)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.fail("Certificate could not be picked from LDAP directory.");
        }
        sl = new X509CertSelector();
        xcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(crossCert3));
        sl = new X509CertSelector();
        sl.setSubject(this.getSubject(xcert).getEncoded());
        coll = cs.getCertificates(sl);
        if (coll.isEmpty()) {
            this.fail("Cross certificate pair could not be picked from LDAP directory.");
        }
        found = false;
        it = coll.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(xcert)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.fail("Cross certificate pair could not be picked from LDAP directory.");
        }
    }

    private void x509StoreTest() throws Exception {
        X509Store cs = X509Store.getInstance("CERTIFICATE/LDAP", (X509StoreParameters)params1, "BC");
        X509CertStoreSelector sl = new X509CertStoreSelector();
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate xcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert1));
        sl.setCertificate(xcert);
        Collection coll = cs.getMatches((Selector)sl);
        if (coll.isEmpty() || !coll.iterator().next().equals(xcert)) {
            this.fail("certificate could not be picked from LDAP directory.");
        }
        sl.setCertificate(null);
        sl.setSubject(this.getSubject(xcert).getEncoded());
        coll = cs.getMatches((Selector)sl);
        if (coll.isEmpty() || !coll.iterator().next().equals(xcert)) {
            this.fail("certificate could not be picked from LDAP directory.");
        }
        X509CRLStoreSelector sl2 = new X509CRLStoreSelector();
        X509CRL crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(directCRL));
        sl2.setIssuers(Collections.singleton(crl.getIssuerX500Principal()));
        cs = X509Store.getInstance("CRL/LDAP", (X509StoreParameters)params1, "BC");
        coll = cs.getMatches((Selector)sl2);
        if (!coll.iterator().hasNext()) {
            this.fail("CRL could not be picked from LDAP directory.");
        }
        cs = X509Store.getInstance("CERTIFICATE/LDAP", (X509StoreParameters)params2, "BC");
        sl = new X509CertStoreSelector();
        xcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert2));
        sl.setCertificate(xcert);
        coll = cs.getMatches((Selector)sl);
        if (coll.isEmpty() || !coll.iterator().next().equals(xcert)) {
            this.fail("Certificate could not be picked from LDAP directory.");
        }
        cs = X509Store.getInstance("CERTIFICATE/LDAP", (X509StoreParameters)params3, "BC");
        sl = new X509CertStoreSelector();
        xcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert3));
        sl.setCertificate(xcert);
        coll = cs.getMatches((Selector)sl);
        if (coll.isEmpty() || !coll.iterator().next().equals(xcert)) {
            this.fail("Certificate could not be picked from LDAP directory.");
        }
        xcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(caCert3));
        sl = new X509CertStoreSelector();
        sl.setSubject(this.getSubject(xcert).getEncoded());
        coll = cs.getMatches((Selector)sl);
        boolean found = false;
        if (coll.isEmpty()) {
            this.fail("Certificate could not be picked from LDAP directory.");
        }
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(xcert)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.fail("Certificate could not be picked from LDAP directory.");
        }
        sl = new X509CertStoreSelector();
        xcert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(crossCert3));
        sl.setSubject(this.getSubject(xcert).getEncoded());
        coll = cs.getMatches((Selector)sl);
        if (coll.isEmpty()) {
            this.fail("Cross certificate pair could not be picked from LDAP directory.");
        }
        found = false;
        it = coll.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(xcert)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.fail("Cross certificate pair could not be picked from LDAP directory.");
        }
    }

    private X509Principal getSubject(X509Certificate cert) throws CertificateEncodingException {
        return PrincipalUtil.getSubjectX509Principal(cert);
    }

    private X509Principal getCRLIssuer(X509CRL crl) throws CRLException {
        return PrincipalUtil.getIssuerX509Principal(crl);
    }

    @Override
    public String getName() {
        return "LDAPCertStoreTest";
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        X509LDAPCertStoreTest.runTest(new X509LDAPCertStoreTest());
    }
}

