/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.pqc.crypto.ntru.NTRUSigner;
import org.bouncycastle.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUSigningKeyPairGenerator;
import org.bouncycastle.pqc.crypto.ntru.NTRUSigningPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;

public class NTRUSignatureKeyTest
extends TestCase {
    public void testEncode() throws IOException {
        NTRUSigningKeyGenerationParameters[] nTRUSigningKeyGenerationParametersArray = new NTRUSigningKeyGenerationParameters[]{NTRUSigningKeyGenerationParameters.TEST157, NTRUSigningKeyGenerationParameters.TEST157_PROD};
        int n = nTRUSigningKeyGenerationParametersArray.length;
        int n2 = 0;
        while (n2 < n) {
            NTRUSigningKeyGenerationParameters params = nTRUSigningKeyGenerationParametersArray[n2];
            this.testEncode(params);
            ++n2;
        }
    }

    private void testEncode(NTRUSigningKeyGenerationParameters params) throws IOException {
        NTRUSigner ntru = new NTRUSigner(params.getSigningParameters());
        NTRUSigningKeyPairGenerator kGen = new NTRUSigningKeyPairGenerator();
        kGen.init(params);
        AsymmetricCipherKeyPair kp = kGen.generateKeyPair();
        NTRUSigningPrivateKeyParameters kPriv = (NTRUSigningPrivateKeyParameters)kp.getPrivate();
        NTRUSigningPublicKeyParameters kPub = (NTRUSigningPublicKeyParameters)kp.getPublic();
        byte[] priv = kPriv.getEncoded();
        byte[] pub = kPub.getEncoded();
        AsymmetricCipherKeyPair kp2 = new AsymmetricCipherKeyPair(new NTRUSigningPublicKeyParameters(pub, params.getSigningParameters()), new NTRUSigningPrivateKeyParameters(priv, params));
        NTRUSignatureKeyTest.assertEquals((Object)kPub, (Object)kp2.getPublic());
        NTRUSignatureKeyTest.assertEquals((Object)kPriv, (Object)kp2.getPrivate());
        ByteArrayOutputStream bos1 = new ByteArrayOutputStream();
        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
        kPriv.writeTo(bos1);
        kPub.writeTo(bos2);
        ByteArrayInputStream bis1 = new ByteArrayInputStream(bos1.toByteArray());
        ByteArrayInputStream bis2 = new ByteArrayInputStream(bos2.toByteArray());
        AsymmetricCipherKeyPair kp3 = new AsymmetricCipherKeyPair(new NTRUSigningPublicKeyParameters(bis2, params.getSigningParameters()), new NTRUSigningPrivateKeyParameters(bis1, params));
        NTRUSignatureKeyTest.assertEquals((Object)kPub, (Object)kp3.getPublic());
        NTRUSignatureKeyTest.assertEquals((Object)kPriv, (Object)kp3.getPrivate());
    }
}

