/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import junit.framework.TestCase;
import org.bouncycastle.pqc.crypto.xmss.DefaultXMSSOid;

public class XMSSOidTest
extends TestCase {
    public void testXMSSOidException1() {
        DefaultXMSSOid xmssOid = DefaultXMSSOid.lookup("SHA-256", 32, 16, 67, -1);
        XMSSOidTest.assertEquals((Object)xmssOid, null);
    }

    public void testXMSSOidException2() {
        DefaultXMSSOid xmssOid = DefaultXMSSOid.lookup("SHA-256", 32, 16, 67, 8);
        XMSSOidTest.assertEquals((Object)xmssOid, null);
    }

    public void testXMSSOidException3() {
        DefaultXMSSOid xmssOid = DefaultXMSSOid.lookup("SHA-256", 32, 4, 67, 10);
        XMSSOidTest.assertEquals((Object)xmssOid, null);
    }

    public void testXMSSOid() {
        DefaultXMSSOid xmssOid = DefaultXMSSOid.lookup("SHA-256", 32, 16, 67, 10);
        XMSSOidTest.assertEquals((int)0x1000001, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHA2-256_W16_H10", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHA-256", 32, 16, 67, 16);
        XMSSOidTest.assertEquals((int)0x2000002, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHA2-256_W16_H16", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHA-256", 32, 16, 67, 20);
        XMSSOidTest.assertEquals((int)0x3000003, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHA2-256_W16_H20", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHA-512", 64, 16, 131, 10);
        XMSSOidTest.assertEquals((int)0x4000004, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHA2-512_W16_H10", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHA-512", 64, 16, 131, 16);
        XMSSOidTest.assertEquals((int)0x5000005, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHA2-512_W16_H16", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHA-512", 64, 16, 131, 20);
        XMSSOidTest.assertEquals((int)0x6000006, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHA2-512_W16_H20", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHAKE128", 32, 16, 67, 10);
        XMSSOidTest.assertEquals((int)0x7000007, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHAKE128_W16_H10", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHAKE128", 32, 16, 67, 16);
        XMSSOidTest.assertEquals((int)0x8000008, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHAKE128_W16_H16", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHAKE128", 32, 16, 67, 20);
        XMSSOidTest.assertEquals((int)0x9000009, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHAKE128_W16_H20", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHAKE256", 64, 16, 131, 10);
        XMSSOidTest.assertEquals((int)0xA00000A, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHAKE256_W16_H10", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHAKE256", 64, 16, 131, 16);
        XMSSOidTest.assertEquals((int)0xB00000B, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHAKE256_W16_H16", (String)xmssOid.toString());
        xmssOid = DefaultXMSSOid.lookup("SHAKE256", 64, 16, 131, 20);
        XMSSOidTest.assertEquals((int)0xC00000C, (int)xmssOid.getOid());
        XMSSOidTest.assertEquals((String)"XMSS_SHAKE256_W16_H20", (String)xmssOid.toString());
    }
}

