/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import junit.framework.TestCase;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.pqc.crypto.test.NullPRNG;
import org.bouncycastle.pqc.crypto.xmss.XMSS;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSSignature;
import org.bouncycastle.util.Arrays;

public class XMSSSignatureTest
extends TestCase {
    public void testSignatureParsingSHA256() {
        XMSSParameters params = new XMSSParameters(10, new SHA256Digest());
        XMSS xmss = new XMSS(params, new NullPRNG());
        xmss.generateKeys();
        byte[] message = new byte[1024];
        byte[] sig1 = xmss.sign(message);
        XMSSSignature sig2 = new XMSSSignature.Builder(params).withSignature(sig1).build();
        byte[] sig3 = sig2.toByteArray();
        XMSSSignatureTest.assertEquals((boolean)true, (boolean)Arrays.areEqual(sig1, sig3));
    }

    public void testSignatureParsingSHA512() {
        XMSSParameters params = new XMSSParameters(10, new SHA512Digest());
        XMSS xmss = new XMSS(params, new NullPRNG());
        xmss.generateKeys();
        byte[] message = new byte[1024];
        byte[] sig1 = xmss.sign(message);
        XMSSSignature sig2 = new XMSSSignature.Builder(params).withSignature(sig1).build();
        byte[] sig3 = sig2.toByteArray();
        XMSSSignatureTest.assertEquals((boolean)true, (boolean)Arrays.areEqual(sig1, sig3));
    }

    public void testConstructor() {
        XMSSParameters params = new XMSSParameters(10, new SHA256Digest());
        XMSSSignature sig = new XMSSSignature.Builder(params).build();
        byte[] sigByte = sig.toByteArray();
        int i = 0;
        while (i < sigByte.length) {
            XMSSSignatureTest.assertEquals((int)0, (int)sigByte[i]);
            ++i;
        }
    }
}

