"""empty message

Revision ID: abeec1a4eabe
Revises: 
Create Date: 2020-12-20 16:23:46.468018

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "abeec1a4eabe"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "appointments",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=100), nullable=True),
        sa.Column("date", sa.String(length=20), nullable=True),
        sa.Column("time", sa.String(length=20), nullable=True),
        sa.Column("active", sa.String(length=20), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "categories",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=100), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "contact",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created_date", sa.DateTime(), nullable=True),
        sa.Column("name", sa.String(length=100), nullable=True),
        sa.Column("email", sa.String(length=100), nullable=True),
        sa.Column("message", sa.String(length=1024), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "coupons",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("string", sa.String(length=300), nullable=True),
        sa.Column("type", sa.String(length=300), nullable=True),
        sa.Column("value", sa.String(length=300), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "deliveryoptions",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("option", sa.String(length=300), nullable=True),
        sa.Column("price", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "images",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("filename", sa.String(length=50), nullable=False),
        sa.Column("thumbnail", sa.String(length=50), nullable=False),
        sa.Column("file_size", sa.Integer(), nullable=False),
        sa.Column("file_width", sa.Integer(), nullable=False),
        sa.Column("file_height", sa.Integer(), nullable=False),
        sa.Column("create_date", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "orders",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("time", sa.DateTime(), nullable=True),
        sa.Column(
            "logged_in_customer_email", sa.String(length=120), nullable=True
        ),
        sa.Column("coupon_string", sa.String(length=120), nullable=True),
        sa.Column("status", sa.String(length=120), nullable=True),
        sa.Column(
            "shipping_option_name", sa.String(length=120), nullable=True
        ),
        sa.Column(
            "shipping_option_price", sa.String(length=120), nullable=True
        ),
        sa.Column("payment_option_name", sa.String(length=120), nullable=True),
        sa.Column("payment_option_text", sa.String(length=120), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "pages",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created_date", sa.DateTime(), nullable=True),
        sa.Column("title", sa.String(length=100), nullable=True),
        sa.Column("slug", sa.String(length=100), nullable=True),
        sa.Column("content", sa.String(length=1024), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "paymentoptions",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=300), nullable=True),
        sa.Column("text", sa.String(length=300), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "people",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=100), nullable=True),
        sa.Column("phone", sa.Integer(), nullable=True),
        sa.Column("mobile", sa.Integer(), nullable=True),
        sa.Column("email", sa.String(length=100), nullable=True),
        sa.Column("facebook", sa.String(length=128), nullable=True),
        sa.Column("twitter", sa.String(length=128), nullable=True),
        sa.Column("linkedin", sa.String(length=128), nullable=True),
        sa.Column("age", sa.Integer(), nullable=True),
        sa.Column("birthday", sa.String(length=100), nullable=True),
        sa.Column("notes", sa.String(length=100), nullable=True),
        sa.Column("is_manufacturer", sa.Boolean(), nullable=True),
        sa.Column("manufacturer_name", sa.String(length=100), nullable=True),
        sa.Column("manufacturer_phone", sa.Integer(), nullable=True),
        sa.Column(
            "manufacturer_address", sa.String(length=200), nullable=True
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "roles",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=100), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "settings",
        sa.Column("setting", sa.String(length=100), nullable=False),
        sa.Column("value", sa.String(length=100), nullable=True),
        sa.PrimaryKeyConstraint("setting"),
    )
    op.create_table(
        "transactions",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("chashier_id", sa.Integer(), nullable=True),
        sa.Column("time", sa.DateTime(), nullable=True),
        sa.Column("quantity", sa.Integer(), nullable=True),
        sa.Column("price", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "users",
        sa.Column("id", sa.String(length=10), nullable=False),
        sa.Column("username", sa.String(length=100), nullable=True),
        sa.Column("password", sa.String(length=128), nullable=False),
        sa.Column("first_name", sa.String(length=128), nullable=True),
        sa.Column("last_name", sa.String(length=128), nullable=True),
        sa.Column("is_admin", sa.Boolean(), nullable=True),
        sa.Column("email", sa.String(length=120), nullable=False),
        sa.Column("date_registered", sa.DateTime(), nullable=False),
        sa.Column("email_confirmed", sa.Boolean(), nullable=False),
        sa.Column("email_confirm_date", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("email"),
        sa.UniqueConstraint("username"),
    )
    op.create_table(
        "billing_details",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("first_name", sa.String(length=100), nullable=True),
        sa.Column("last_name", sa.String(length=100), nullable=True),
        sa.Column("country", sa.String(length=100), nullable=True),
        sa.Column("street", sa.String(length=100), nullable=True),
        sa.Column("town_city", sa.String(length=100), nullable=True),
        sa.Column("phone", sa.String(length=100), nullable=True),
        sa.Column("email", sa.String(length=100), nullable=True),
        sa.Column("order_notes", sa.String(length=100), nullable=True),
        sa.Column("order_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["order_id"], ["orders.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "order_items",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("order_id", sa.String(length=100), nullable=True),
        sa.Column("barcode", sa.String(length=100), nullable=True),
        sa.Column("quantity", sa.Integer(), nullable=True),
        sa.Column("price", sa.Float(), nullable=True),
        sa.ForeignKeyConstraint(["order_id"], ["orders.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "role_helpers",
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.Column("role_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["role_id"], ["roles.id"],),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"],),
    )
    op.create_table(
        "subcategories",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=100), nullable=True),
        sa.Column("category_name", sa.String(length=100), nullable=True),
        sa.ForeignKeyConstraint(["category_name"], ["categories.name"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "product",
        sa.Column("barcode", sa.String(length=100), nullable=False),
        sa.Column("price", sa.Float(), nullable=True),
        sa.Column("name", sa.String(length=100), nullable=True),
        sa.Column("description", sa.String(length=300), nullable=True),
        sa.Column("date", sa.String(length=100), nullable=True),
        sa.Column("in_stock", sa.Integer(), nullable=True),
        sa.Column("discontinued", sa.Boolean(), nullable=True),
        sa.Column("selling_price", sa.Float(), nullable=True),
        sa.Column("is_onsale", sa.Boolean(), nullable=True),
        sa.Column("is_featured", sa.Boolean(), nullable=True),
        sa.Column("subcategory_name", sa.String(length=100), nullable=True),
        sa.ForeignKeyConstraint(["subcategory_name"], ["subcategories.name"],),
        sa.PrimaryKeyConstraint("barcode"),
    )
    op.create_table(
        "resources",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("filename", sa.String(length=50), nullable=False),
        sa.Column("type", sa.String(length=50), nullable=False),
        sa.Column("category", sa.String(length=50), nullable=False),
        sa.Column("created_date", sa.DateTime(), nullable=False),
        sa.Column("product_barcode", sa.String(length=100), nullable=True),
        sa.Column("category_name", sa.String(length=100), nullable=True),
        sa.Column("subcategory_name", sa.String(length=100), nullable=True),
        sa.ForeignKeyConstraint(["category_name"], ["categories.name"],),
        sa.ForeignKeyConstraint(["product_barcode"], ["product.barcode"],),
        sa.ForeignKeyConstraint(["subcategory_name"], ["subcategories.name"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "transaction_helpers",
        sa.Column("product_barcode", sa.Integer(), nullable=True),
        sa.Column("transaction_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["product_barcode"], ["product.barcode"],),
        sa.ForeignKeyConstraint(["transaction_id"], ["transactions.id"],),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("transaction_helpers")
    op.drop_table("resources")
    op.drop_table("product")
    op.drop_table("subcategories")
    op.drop_table("role_helpers")
    op.drop_table("order_items")
    op.drop_table("billing_details")
    op.drop_table("users")
    op.drop_table("transactions")
    op.drop_table("settings")
    op.drop_table("roles")
    op.drop_table("people")
    op.drop_table("paymentoptions")
    op.drop_table("pages")
    op.drop_table("orders")
    op.drop_table("images")
    op.drop_table("deliveryoptions")
    op.drop_table("coupons")
    op.drop_table("contact")
    op.drop_table("categories")
    op.drop_table("appointments")
    # ### end Alembic commands ###
