from __future__ import annotations

from enum import Enum as Enum
from typing import Any, Optional

from .recorder import MetricsRecorder as MetricsRecorder
from .storable import Storable as Storable
from .tunable_space import TunableSpace as TunableSpace

class TrialStatus:
    RUNNING: str = ...
    COMPLETED: str = ...
    STOPPED: str = ...
    INVALID: str = ...

class Trial(Storable):
    def __init__(self, tunable_space: Any, trial_id: Optional[Any] = ..., status: Any = ...) -> None: ...
    @property
    def id(self): ...
    @property
    def space(self): ...
    @property
    def recorder(self): ...
    @property
    def score(self): ...
    @score.setter
    def score(self, score: Any) -> None: ...
    @property
    def best_step(self): ...
    @best_step.setter
    def best_step(self, best_step: Any) -> None: ...
    @property
    def status(self): ...
    @status.setter
    def status(self, status: Any) -> None: ...
    def summary(self) -> None: ...
    def get_state(self): ...
    def set_state(self, state: Any) -> None: ...
    @classmethod
    def from_state(cls, state: Any): ...
