from __future__ import annotations

from typing import Any, Optional

class MetricBase:
    def __init__(self, name: Any) -> None: ...
    def reset(self) -> None: ...
    def get_config(self): ...
    def update(self, preds: Any, labels: Any) -> None: ...
    def eval(self) -> None: ...

class CompositeMetric(MetricBase):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def add_metric(self, metric: Any) -> None: ...
    def update(self, preds: Any, labels: Any) -> None: ...
    def eval(self): ...

class Precision(MetricBase):
    tp: int = ...
    fp: int = ...
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def update(self, preds: Any, labels: Any) -> None: ...
    def eval(self): ...

class Recall(MetricBase):
    tp: int = ...
    fn: int = ...
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def update(self, preds: Any, labels: Any) -> None: ...
    def eval(self): ...

class Accuracy(MetricBase):
    value: float = ...
    weight: float = ...
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def update(self, value: Any, weight: Any) -> None: ...
    def eval(self): ...

class ChunkEvaluator(MetricBase):
    num_infer_chunks: int = ...
    num_label_chunks: int = ...
    num_correct_chunks: int = ...
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def update(self, num_infer_chunks: Any, num_label_chunks: Any, num_correct_chunks: Any) -> None: ...
    def eval(self): ...

class EditDistance(MetricBase):
    total_distance: float = ...
    seq_num: int = ...
    instance_error: int = ...
    def __init__(self, name: Any) -> None: ...
    def update(self, distances: Any, seq_num: Any) -> None: ...
    def eval(self): ...

class Auc(MetricBase):
    def __init__(self, name: Any, curve: str = ..., num_thresholds: int = ...) -> None: ...
    def update(self, preds: Any, labels: Any) -> None: ...
    @staticmethod
    def trapezoid_area(x1: Any, x2: Any, y1: Any, y2: Any): ...
    def eval(self): ...

class DetectionMAP:
    helper: Any = ...
    has_state: Any = ...
    cur_map: Any = ...
    accum_map: Any = ...
    def __init__(
        self,
        input: Any,
        gt_label: Any,
        gt_box: Any,
        gt_difficult: Optional[Any] = ...,
        class_num: Optional[Any] = ...,
        background_label: int = ...,
        overlap_threshold: float = ...,
        evaluate_difficult: bool = ...,
        ap_version: str = ...,
    ) -> None: ...
    def get_map_var(self): ...
    def reset(self, executor: Any, reset_program: Optional[Any] = ...): ...
