import typing
from typing import (
    Any,
    BinaryIO,
    Collection,
    List,
    Optional,
    SupportsInt,
    Text,
    Tuple,
    Union,
)
import six
from . import errors
from .base import FS
from .info import Info, RawInfo
from .iotools import RawWrapper
from .permissions import Permissions
from .subfs import SubFS
from .wrapfs import WrapFS

if typing.TYPE_CHECKING:
    R = ...

class _ZipExtFile(RawWrapper):
    def __init__(self, fs: ReadZipFS, name: Text) -> None: ...
    def read(self, size: int = ...) -> bytes: ...
    def read1(self, size: int = ...) -> bytes: ...
    def seek(self, offset: int, whence: SupportsInt = ...) -> int: ...
    def tell(self) -> int: ...

class ZipFS(WrapFS):
    def __new__(
        cls,
        file: Union[Text, BinaryIO],
        write: bool = ...,
        compression: int = ...,
        encoding: Text = ...,
        temp_fs: Union[Text, FS] = ...,
    ) -> FS: ...
    if typing.TYPE_CHECKING:
        def __init__(
            self,
            file: Union[Text, BinaryIO],
            write: bool = ...,
            compression: int = ...,
            encoding: Text = ...,
            temp_fs: Text = ...,
        ) -> None: ...

@six.python_2_unicode_compatible
class WriteZipFS(WrapFS):
    def __init__(
        self,
        file: Union[Text, BinaryIO],
        compression: int = ...,
        encoding: Text = ...,
        temp_fs: Union[Text, FS] = ...,
    ) -> None: ...
    def __repr__(self) -> Text: ...
    def __str__(self) -> Text: ...
    def delegate_path(self, path: Text) -> Tuple[FS, Text]: ...
    def delegate_fs(self) -> FS: ...
    def close(self) -> None: ...
    def write_zip(
        self,
        file: Union[Text, BinaryIO, None] = ...,
        compression: Optional[int] = ...,
        encoding: Optional[Text] = ...,
    ) -> None: ...

@six.python_2_unicode_compatible
class ReadZipFS(FS):
    _meta = ...
    @errors.CreateFailed.catch_all
    def __init__(self, file: Union[BinaryIO, Text], encoding: Text = ...) -> None: ...
    def __repr__(self) -> Text: ...
    def __str__(self) -> Text: ...
    def getinfo(
        self, path: Text, namespaces: Optional[Collection[Text]] = ...
    ) -> Info: ...
    def setinfo(self, path: Text, info: RawInfo) -> None: ...
    def listdir(self, path: Text) -> List[Text]: ...
    def makedir(
        self: R,
        path: Text,
        permissions: Optional[Permissions] = ...,
        recreate: bool = ...,
    ) -> SubFS[R]: ...
    def openbin(
        self, path: Text, mode: Text = ..., buffering: int = ..., **kwargs: Any
    ) -> BinaryIO: ...
    def remove(self, path: Text) -> None: ...
    def removedir(self, path: Text) -> None: ...
    def close(self) -> None: ...
    def readbytes(self, path: Text) -> bytes: ...
    def geturl(self, path: Text, purpose: Text = ...) -> Text: ...
