import typing as t
from io import BufferedRandom, BytesIO
from .decoders import *
from .exceptions import *

_missing: object = ...
STATE_BEFORE_FIELD: int = ...
STATE_FIELD_NAME: int = ...
STATE_FIELD_DATA: int = ...
STATE_START: int = ...
STATE_START_BOUNDARY: int = ...
STATE_HEADER_FIELD_START: int = ...
STATE_HEADER_FIELD: int = ...
STATE_HEADER_VALUE_START: int = ...
STATE_HEADER_VALUE: int = ...
STATE_HEADER_VALUE_ALMOST_DONE: int = ...
STATE_HEADERS_ALMOST_DONE: int = ...
STATE_PART_DATA_START: int = ...
STATE_PART_DATA: int = ...
STATE_PART_DATA_END: int = ...
STATE_END: int = ...
STATES: t.List[str] = ...
FLAG_PART_BOUNDARY: int = ...
FLAG_LAST_BOUNDARY: int = ...
CR: int = ...
LF: int = ...
COLON: int = ...
SPACE: int = ...
HYPHEN: int = ...
AMPERSAND: int = ...
SEMICOLON: int = ...
LOWER_A: int = ...
LOWER_Z: int = ...
NULL: int = ...
lower_char: t.Callable[[int], int] = ...
ord_char: t.Callable[..., t.Any] = ...
join_bytes: t.Callable[[bytes], t.ByteString] = ...
SPECIAL_CHARS: t.ByteString = ...
QUOTED_STR: t.ByteString = ...
VALUE_STR: t.ByteString = ...
OPTION_RE_STR: t.ByteString = ...
OPTION_RE: t.ByteString = ...
QUOTE: t.ByteString = ...

def parse_options_header(
    value: t.AnyStr,
) -> t.Tuple[bytes, t.Dict[t.ByteString, t.ByteString]]: ...

class Field:
    def __init__(self, name: str) -> None: ...
    @classmethod
    def from_value(klass: "Field", name: str, value: t.Any) -> "Field": ...
    def write(self, data: bytes) -> None: ...
    def on_data(self, data) -> None: ...
    def on_end(self) -> None: ...
    def finalize(self) -> None: ...
    def close(self) -> None: ...
    def set_none(self) -> None: ...
    @property
    def field_name(self) -> str: ...
    @property
    def value(self) -> t.Optional[t.Union[bytes, object]]: ...
    def __eq__(self, other) -> bool: ...
    def __repr__(self) -> str: ...

class File:
    def __init__(self, file_name, field_name=..., config=...) -> None: ...
    @property
    def field_name(self) -> str: ...
    @property
    def file_name(self) -> str: ...
    @property
    def actual_file_name(self) -> t.Optional[bytes]: ...
    @property
    def file_object(self) -> t.Union[BytesIO, BufferedRandom, t.IO[str]]: ...
    @property
    def size(self) -> int: ...
    @property
    def in_memory(self) -> bool: ...
    def flush_to_disk(self) -> None: ...
    def write(self, data: bytes) -> None: ...
    def on_data(self, data: bytes) -> None: ...
    def on_end(self) -> None: ...
    def finalize(self) -> None: ...
    def close(self) -> None: ...
    def __repr__(self) -> str: ...

class BaseParser:
    def __init__(self) -> None: ...
    def callback(self, name=..., data=..., start=..., end=...) -> None: ...
    def set_callback(self, name: str, new_func: t.Callable[..., t.Any]) -> None: ...
    def close(self) -> None: ...
    def finalize(self) -> None: ...
    def __repr__(self) -> str: ...

class OctetStreamParser(BaseParser):
    def __init__(self, callbacks=..., max_size=...) -> None: ...
    def write(self, data: bytes) -> None: ...
    def finalize(self) -> None: ...
    def __repr__(self) -> str: ...

class QuerystringParser(BaseParser):
    def __init__(self, callbacks=..., strict_parsing=..., max_size=...) -> None: ...
    def write(self, data: bytes) -> int: ...
    def finalize(self) -> None: ...
    def __repr__(self) -> str: ...

class MultipartParser(BaseParser):
    def __init__(self, boundary=..., callbacks=..., max_size=...) -> None: ...
    def write(self, data: bytes) -> None: ...
    def finalize(self) -> None: ...
    def __repr__(self) -> str: ...

class FormParser:
    DEFAULT_CONFIG: t.Dict[str, t.Any] = ...
    def __init__(
        self,
        content_type: str,
        on_field: t.Callable[..., t.Any],
        on_file: t.Callable[..., t.Any],
        on_end=...,
        boundary=...,
        file_name=...,
        FileClass=...,
        FieldClass=...,
        config=...,
    ) -> None: ...
    def write(self, data: bytes) -> None: ...
    def finalize(self) -> None: ...
    def close(self) -> None: ...
    def __repr__(self) -> str: ...

def create_form_parser(
    headers: t.Dict[bytes, bytes],
    on_field: t.Callable[..., t.Any],
    on_file: t.Callable[..., t.Any],
    trust_x_headers: bool = ...,
    config: t.Dict[str, t.Any] = ...,
) -> FormParser: ...
def parse_form(
    headers: t.Dict[bytes, bytes],
    input_stream: t.BinaryIO,
    on_field: t.Callable[..., t.Any],
    on_file: t.Callable[..., t.Any],
    chunk_size: int = ...,
    **kwargs: str
): ...
