import typing
from starlette.datastructures import URLPath
from starlette.middleware import Middleware
from starlette.routing import BaseRoute
from starlette.types import ASGIApp, Receive, Scope, Send

class Starlette:
    def __init__(
        self,
        debug: bool = ...,
        routes: typing.Sequence[BaseRoute] = ...,
        middleware: typing.Sequence[Middleware] = ...,
        exception_handlers: typing.Dict[
            typing.Union[int, typing.Type[Exception]], typing.Callable
        ] = ...,
        on_startup: typing.Sequence[typing.Callable] = ...,
        on_shutdown: typing.Sequence[typing.Callable] = ...,
        lifespan: typing.Callable[[Starlette], typing.AsyncContextManager] = ...,
    ) -> None: ...
    def build_middleware_stack(self) -> ASGIApp: ...
    @property
    def routes(self) -> typing.List[BaseRoute]: ...
    @property
    def debug(self) -> bool: ...
    @debug.setter
    def debug(self, value: bool) -> None: ...
    def url_path_for(self, name: str, **path_params: str) -> URLPath: ...
    async def __call__(self, scope: Scope, receive: Receive, send: Send) -> None: ...
    def on_event(self, event_type: str) -> typing.Callable: ...
    def mount(self, path: str, app: ASGIApp, name: str = ...) -> None: ...
    def host(self, host: str, app: ASGIApp, name: str = ...) -> None: ...
    def add_middleware(self, middleware_class: type, **options: typing.Any) -> None: ...
    def add_exception_handler(
        self,
        exc_class_or_status_code: typing.Union[int, typing.Type[Exception]],
        handler: typing.Callable,
    ) -> None: ...
    def add_event_handler(self, event_type: str, func: typing.Callable) -> None: ...
    def add_route(
        self,
        path: str,
        route: typing.Callable,
        methods: typing.List[str] = ...,
        name: str = ...,
        include_in_schema: bool = ...,
    ) -> None: ...
    def add_websocket_route(
        self, path: str, route: typing.Callable, name: str = ...
    ) -> None: ...
    def exception_handler(
        self, exc_class_or_status_code: typing.Union[int, typing.Type[Exception]]
    ) -> typing.Callable: ...
    def route(
        self,
        path: str,
        methods: typing.List[str] = ...,
        name: str = ...,
        include_in_schema: bool = ...,
    ) -> typing.Callable: ...
    def websocket_route(self, path: str, name: str = ...) -> typing.Callable: ...
    def middleware(self, middleware_type: str) -> typing.Callable: ...
