import typing
from starlette.requests import Request
from starlette.responses import Response
from starlette.routing import BaseRoute

class OpenAPIResponse(Response):
    media_type = ...
    def render(self, content: typing.Any) -> bytes: ...

class EndpointInfo(typing.NamedTuple):
    path: str
    http_method: str
    func: typing.Callable
    ...

class BaseSchemaGenerator:
    def get_schema(self, routes: typing.List[BaseRoute]) -> dict: ...
    def get_endpoints(
        self, routes: typing.List[BaseRoute]
    ) -> typing.List[EndpointInfo]: ...
    def parse_docstring(self, func_or_method: typing.Callable) -> dict: ...
    def OpenAPIResponse(self, request: Request) -> Response: ...

class SchemaGenerator(BaseSchemaGenerator):
    def __init__(self, base_schema: dict) -> None: ...
    def get_schema(self, routes: typing.List[BaseRoute]) -> dict: ...
