import os, typing
from starlette.datastructures import Headers
from starlette.responses import Response
from starlette.types import Receive, Scope, Send

PathLike = typing.Union[str, "os.PathLike[str]"]

class NotModifiedResponse(Response):
    NOT_MODIFIED_HEADERS = ...
    def __init__(self, headers: Headers) -> None: ...

class StaticFiles:
    def __init__(
        self,
        *,
        directory: PathLike = ...,
        packages: typing.List[str] = ...,
        html: bool = ...,
        check_dir: bool = ...
    ) -> None: ...
    def get_directories(
        self, directory: PathLike = ..., packages: typing.List[str] = ...
    ) -> typing.List[PathLike]: ...
    async def __call__(self, scope: Scope, receive: Receive, send: Send) -> None: ...
    def get_path(self, scope: Scope) -> str: ...
    async def get_response(self, path: str, scope: Scope) -> Response: ...
    async def lookup_path(
        self, path: str
    ) -> typing.Tuple[str, typing.Optional[os.stat_result]]: ...
    def file_response(
        self,
        full_path: PathLike,
        stat_result: os.stat_result,
        scope: Scope,
        status_code: int = ...,
    ) -> Response: ...
    async def check_config(self) -> None: ...
    def is_not_modified(
        self, response_headers: Headers, request_headers: Headers
    ) -> bool: ...
