# configen

Automatically generates Structured Configs that can be used with hydra.utils.instantiate()

This is optional at two levels:
1. Structured Configs are optional, one can use Hydra without them.
2. One can manually code these dataclasses. The advantage of this tool is that it does the work automatically.

# Setup
Configen requires config file per project. The config indicates what classes to generate code for, where to put
the generated code etc.
Configen will suggest creating a config on the first run:
```
$ configen 
[2020-08-14 12:06:11,359][configen.configen][ERROR] - Use --config-dir DIR.
If you have no config dir yet use the following command to create an initial config in the `conf` dir:
        configen init_config_dir=conf
$ configen init_config_dir=conf
[2020-08-14 12:07:07,752][configen.configen][INFO] - Initializing config in 'conf'
```

This will generate a basic config similar to:
```yaml
$ cat conf/configen.yaml 
configen:
  # output directory
  output_dir: ${hydra:runtime.cwd}/gen

  header: |
    # Generated by configen, do not edit.
    # See https://github.com/facebookresearch/hydra/tree/master/tools/configen

  # The directory of each module under output_dir
  module_dir: '{{module_path}}/conf'

  # list of modules to generate configs for
  modules:
    - name: configen.samples.user
      # for each module, a list of classes
      classes:
        - User
```

Configen comes with a few samples [classes](configen/samples) that are being processed by the default config.
For example:
```python title="configen/samples/user.py"
class User:
    def __init__(self, age: int, name: str):
        self.age = age
        self.name = name
```

Running configen with this config directory:
```
$ configen --config-dir conf
[2020-08-14 12:44:54,990][configen.configen][INFO] - configen.samples.user.User -> /home/omry/tmp/configen/gen/configen/samples/user/conf/User.py
```

Will result in a file `gen/configen/samples/user/conf/User.py` like:
```python
# Generated by configen, do not edit.
# See https://github.com/facebookresearch/hydra/tree/master/tools/configen
# fmt: off
# isort:skip_file
# flake8: noqa

from dataclasses import dataclass
from typing import *

from omegaconf import MISSING


@dataclass
class UserConf:
    _target_: str = "configen.samples.user.User"
    age: int = MISSING
    name: str = MISSING
```

The generated code can be used by a Hydra application to instantiate the user object.
See the [example aplication](example/my_app.py).
