# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['configen', 'configen.samples']

package_data = \
{'': ['*'], 'configen': ['templates/*']}

install_requires = \
['hydra-core>=1.1.0dev1,<2.0.0',
 'jinja2>=2.11.3,<3.0.0',
 'markupsafe<=2.0.1',
 'typing-inspect>=0.7.1,<0.8.0']

entry_points = \
{'console_scripts': ['configen = configen.configen:main']}

setup_kwargs = {
    'name': 'neoconfigen',
    'version': '2.1.1',
    'description': "A fork of hydra-core's configen with extended type-compatibility.",
    'long_description': '# configen\n\nAutomatically generates Structured Configs that can be used with hydra.utils.instantiate()\n\nThis is optional at two levels:\n1. Structured Configs are optional, one can use Hydra without them.\n2. One can manually code these dataclasses. The advantage of this tool is that it does the work automatically.\n\n# Setup\nConfigen requires config file per project. The config indicates what classes to generate code for, where to put\nthe generated code etc.\nConfigen will suggest creating a config on the first run:\n```\n$ configen \n[2020-08-14 12:06:11,359][configen.configen][ERROR] - Use --config-dir DIR.\nIf you have no config dir yet use the following command to create an initial config in the `conf` dir:\n        configen init_config_dir=conf\n$ configen init_config_dir=conf\n[2020-08-14 12:07:07,752][configen.configen][INFO] - Initializing config in \'conf\'\n```\n\nThis will generate a basic config similar to:\n```yaml\n$ cat conf/configen.yaml \nconfigen:\n  # output directory\n  output_dir: ${hydra:runtime.cwd}/gen\n\n  header: |\n    # Generated by configen, do not edit.\n    # See https://github.com/facebookresearch/hydra/tree/master/tools/configen\n\n  # The directory of each module under output_dir\n  module_dir: \'{{module_path}}/conf\'\n\n  # list of modules to generate configs for\n  modules:\n    - name: configen.samples.user\n      # for each module, a list of classes\n      classes:\n        - User\n```\n\nConfigen comes with a few samples [classes](configen/samples) that are being processed by the default config.\nFor example:\n```python title="configen/samples/user.py"\nclass User:\n    def __init__(self, age: int, name: str):\n        self.age = age\n        self.name = name\n```\n\nRunning configen with this config directory:\n```\n$ configen --config-dir conf\n[2020-08-14 12:44:54,990][configen.configen][INFO] - configen.samples.user.User -> /home/omry/tmp/configen/gen/configen/samples/user/conf/User.py\n```\n\nWill result in a file `gen/configen/samples/user/conf/User.py` like:\n```python\n# Generated by configen, do not edit.\n# See https://github.com/facebookresearch/hydra/tree/master/tools/configen\n# fmt: off\n# isort:skip_file\n# flake8: noqa\n\nfrom dataclasses import dataclass\nfrom typing import *\n\nfrom omegaconf import MISSING\n\n\n@dataclass\nclass UserConf:\n    _target_: str = "configen.samples.user.User"\n    age: int = MISSING\n    name: str = MISSING\n```\n\nThe generated code can be used by a Hydra application to instantiate the user object.\nSee the [example aplication](example/my_app.py).\n',
    'author': 'Omry Yadan',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/predictive-analytics-lab/neoconfigen',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
