# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.events.v1.schema.schema_version import VersionList


class SchemaList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the SchemaList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.events.v1.schema.SchemaList
        :rtype: twilio.rest.events.v1.schema.SchemaList
        """
        super(SchemaList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self, id):
        """
        Constructs a SchemaContext

        :param id: The unique identifier of the schema.

        :returns: twilio.rest.events.v1.schema.SchemaContext
        :rtype: twilio.rest.events.v1.schema.SchemaContext
        """
        return SchemaContext(self._version, id=id, )

    def __call__(self, id):
        """
        Constructs a SchemaContext

        :param id: The unique identifier of the schema.

        :returns: twilio.rest.events.v1.schema.SchemaContext
        :rtype: twilio.rest.events.v1.schema.SchemaContext
        """
        return SchemaContext(self._version, id=id, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Events.V1.SchemaList>'


class SchemaPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the SchemaPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.events.v1.schema.SchemaPage
        :rtype: twilio.rest.events.v1.schema.SchemaPage
        """
        super(SchemaPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SchemaInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.events.v1.schema.SchemaInstance
        :rtype: twilio.rest.events.v1.schema.SchemaInstance
        """
        return SchemaInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Events.V1.SchemaPage>'


class SchemaContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, id):
        """
        Initialize the SchemaContext

        :param Version version: Version that contains the resource
        :param id: The unique identifier of the schema.

        :returns: twilio.rest.events.v1.schema.SchemaContext
        :rtype: twilio.rest.events.v1.schema.SchemaContext
        """
        super(SchemaContext, self).__init__(version)

        # Path Solution
        self._solution = {'id': id, }
        self._uri = '/Schemas/{id}'.format(**self._solution)

        # Dependents
        self._versions = None

    def fetch(self):
        """
        Fetch the SchemaInstance

        :returns: The fetched SchemaInstance
        :rtype: twilio.rest.events.v1.schema.SchemaInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return SchemaInstance(self._version, payload, id=self._solution['id'], )

    @property
    def versions(self):
        """
        Access the versions

        :returns: twilio.rest.events.v1.schema.schema_version.VersionList
        :rtype: twilio.rest.events.v1.schema.schema_version.VersionList
        """
        if self._versions is None:
            self._versions = VersionList(self._version, id=self._solution['id'], )
        return self._versions

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Events.V1.SchemaContext {}>'.format(context)


class SchemaInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, id=None):
        """
        Initialize the SchemaInstance

        :returns: twilio.rest.events.v1.schema.SchemaInstance
        :rtype: twilio.rest.events.v1.schema.SchemaInstance
        """
        super(SchemaInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'id': payload.get('id'),
            'url': payload.get('url'),
            'links': payload.get('links'),
            'last_created': deserialize.iso8601_datetime(payload.get('last_created')),
            'last_version': deserialize.integer(payload.get('last_version')),
        }

        # Context
        self._context = None
        self._solution = {'id': id or self._properties['id'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: SchemaContext for this SchemaInstance
        :rtype: twilio.rest.events.v1.schema.SchemaContext
        """
        if self._context is None:
            self._context = SchemaContext(self._version, id=self._solution['id'], )
        return self._context

    @property
    def id(self):
        """
        :returns: Schema Identifier.
        :rtype: unicode
        """
        return self._properties['id']

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: Nested resource URLs.
        :rtype: unicode
        """
        return self._properties['links']

    @property
    def last_created(self):
        """
        :returns: The date that the last schema version was created.
        :rtype: datetime
        """
        return self._properties['last_created']

    @property
    def last_version(self):
        """
        :returns: Last schema version.
        :rtype: unicode
        """
        return self._properties['last_version']

    def fetch(self):
        """
        Fetch the SchemaInstance

        :returns: The fetched SchemaInstance
        :rtype: twilio.rest.events.v1.schema.SchemaInstance
        """
        return self._proxy.fetch()

    @property
    def versions(self):
        """
        Access the versions

        :returns: twilio.rest.events.v1.schema.schema_version.VersionList
        :rtype: twilio.rest.events.v1.schema.schema_version.VersionList
        """
        return self._proxy.versions

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Events.V1.SchemaInstance {}>'.format(context)
