# Asynchronous QvaPay client for Python

[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)
[![Test](https://github.com/leynier/aioqvapay/workflows/CI/badge.svg)](https://github.com/leynier/aioqvapay/actions?query=workflow%3ACI)
[![codecov](https://codecov.io/gh/leynier/aioqvapay/branch/main/graph/badge.svg?token=Z1MEEL3EAB)](https://codecov.io/gh/leynier/aioqvapay)
[![DeepSource](https://deepsource.io/gh/leynier/aioqvapay.svg/?label=active+issues)](https://deepsource.io/gh/leynier/aioqvapay/?ref=repository-badge)
[![Version](https://img.shields.io/pypi/v/aioqvapay?color=%2334D058&label=Version)](https://pypi.org/project/aioqvapay)
[![Last commit](https://img.shields.io/github/last-commit/leynier/aioqvapay.svg?style=flat)](https://github.com/leynier/aioqvapay/commits)
[![GitHub commit activity](https://img.shields.io/github/commit-activity/m/leynier/aioqvapay)](https://github.com/leynier/aioqvapay/commits)
[![Github Stars](https://img.shields.io/github/stars/leynier/aioqvapay?style=flat&logo=github)](https://github.com/leynier/aioqvapay/stargazers)
[![Github Forks](https://img.shields.io/github/forks/leynier/aioqvapay?style=flat&logo=github)](https://github.com/leynier/aioqvapay/network/members)
[![Github Watchers](https://img.shields.io/github/watchers/leynier/aioqvapay?style=flat&logo=github)](https://github.com/leynier/aioqvapay)
[![Website](https://img.shields.io/website?up_message=online&url=https%3A%2F%2Fleynier.github.io/aioqvapay)](https://leynier.github.io/aioqvapay)
[![GitHub contributors](https://img.shields.io/github/contributors/leynier/aioqvapay)](https://github.com/leynier/aioqvapay/graphs/contributors)

**IMPORTANT:** This library is still under development, the interface could be changed and it is not yet fully tested.

[Asynchronous](https://docs.python.org/3/library/asyncio-task.html) **non-official** [QvaPay](https://qvapay.com) client for [asyncio](https://docs.python.org/3/library/asyncio.html) and [Python language](https://www.python.org).

## Features

* Response models with type hints annotated fully.
* Also internal code have type hints annotated fully.
* Asynchronous behavior thank you to [aiohttp](aiohttp.org).
* Project collaborative and open source.

For a **synchronous** behavior, <https://pypi.org/project/qvapay> can be used.

For more information about **QvaPay API**, read the [QvaPay docs](https://qvapay.com/docs).
