# generated by datamodel-codegen:
#   filename:  api-docs.yaml
#   timestamp: 2022-09-11T00:24:32+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import AnyUrl, Field, constr

from kodexa.model.base import KodexaBaseModel


class ExceptionResponse(KodexaBaseModel):
    date_time: Optional[datetime] = Field(None, alias='dateTime')
    message: Optional[str] = None
    incident_id: Optional[str] = Field(None, alias='incidentId')
    context_path: Optional[str] = Field(None, alias='contextPath')
    errors: Optional[Dict[str, Any]] = None
    stack_trace: Optional[str] = Field(None, alias='stackTrace')
    root_cause_stack_trace: Optional[List[str]] = Field(
        None, alias='rootCauseStackTrace'
    )


class StatusType(KodexaBaseModel):
    reason_phrase: Optional[str] = Field(None, alias='reasonPhrase')
    status_code: Optional[int] = Field(None, alias='statusCode')


class StackTraceItem(KodexaBaseModel):
    class_loader_name: Optional[str] = Field(None, alias='classLoaderName')
    module_name: Optional[str] = Field(None, alias='moduleName')
    module_version: Optional[str] = Field(None, alias='moduleVersion')
    method_name: Optional[str] = Field(None, alias='methodName')
    file_name: Optional[str] = Field(None, alias='fileName')
    line_number: Optional[int] = Field(None, alias='lineNumber')
    native_method: Optional[bool] = Field(None, alias='nativeMethod')
    class_name: Optional[str] = Field(None, alias='className')


class StackTraceItem1(KodexaBaseModel):
    class_loader_name: Optional[str] = Field(None, alias='classLoaderName')
    module_name: Optional[str] = Field(None, alias='moduleName')
    module_version: Optional[str] = Field(None, alias='moduleVersion')
    method_name: Optional[str] = Field(None, alias='methodName')
    file_name: Optional[str] = Field(None, alias='fileName')
    line_number: Optional[int] = Field(None, alias='lineNumber')
    native_method: Optional[bool] = Field(None, alias='nativeMethod')
    class_name: Optional[str] = Field(None, alias='className')


class Cause(KodexaBaseModel):
    stack_trace: Optional[List[StackTraceItem1]] = Field(None, alias='stackTrace')
    message: Optional[str] = None
    localized_message: Optional[str] = Field(None, alias='localizedMessage')


class StackTraceItem2(KodexaBaseModel):
    class_loader_name: Optional[str] = Field(None, alias='classLoaderName')
    module_name: Optional[str] = Field(None, alias='moduleName')
    module_version: Optional[str] = Field(None, alias='moduleVersion')
    method_name: Optional[str] = Field(None, alias='methodName')
    file_name: Optional[str] = Field(None, alias='fileName')
    line_number: Optional[int] = Field(None, alias='lineNumber')
    native_method: Optional[bool] = Field(None, alias='nativeMethod')
    class_name: Optional[str] = Field(None, alias='className')


class SuppressedItem(KodexaBaseModel):
    cause: Optional[Cause] = None
    stack_trace: Optional[List[StackTraceItem2]] = Field(None, alias='stackTrace')
    message: Optional[str] = None
    localized_message: Optional[str] = Field(None, alias='localizedMessage')


class ThrowableProblem(KodexaBaseModel):
    cause: Optional[ThrowableProblem] = None
    stack_trace: Optional[List[StackTraceItem]] = Field(None, alias='stackTrace')
    message: Optional[str] = None
    instance: Optional[AnyUrl] = None
    type: Optional[AnyUrl] = None
    parameters: Optional[Dict[str, Any]] = None
    title: Optional[str] = None
    detail: Optional[str] = None
    status: Optional[StatusType] = None
    suppressed: Optional[List[SuppressedItem]] = None
    localized_message: Optional[str] = Field(None, alias='localizedMessage')


class FavoriteLink(KodexaBaseModel):
    link: Optional[str] = None


class UserStorage(KodexaBaseModel):
    favorite_links: Optional[List[FavoriteLink]] = Field(None, alias='favoriteLinks')


class CompletePasswordReset(KodexaBaseModel):
    reset_token: str = Field(..., alias='resetToken')
    password: str


class Organization(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    name: str
    slug: constr(regex=r'^[a-zA-Z0-9\-_]{0,100}$')
    public_access: Optional[bool] = Field(None, alias='publicAccess')
    description: Optional[str] = None
    has_image: Optional[bool] = Field(None, alias='hasImage')


class Team(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    name: Optional[str] = None
    description: Optional[str] = None
    organization: Optional[Organization] = None


class AssistantImplementation(KodexaBaseModel):
    """
    The implementation of the assistant
    """

    package: Optional[str] = None
    class_: Optional[str] = Field(None, alias='class')


class AssistantTaxonomy(KodexaBaseModel):
    """
    Taxonomies that the assistant uses
    """

    ref: Optional[str] = None


class Avatar(KodexaBaseModel):
    icon: Optional[str] = None
    icon_group: Optional[str] = Field(None, alias='iconGroup')


class Card(KodexaBaseModel):
    id: Optional[str] = None
    type: Optional[str] = Field(None, description='The type of the card')
    properties: Optional[Dict[str, Any]] = None
    children: Optional[List[Card]] = None


class ColumnState(KodexaBaseModel):
    field: Optional[str] = None
    title: Optional[str] = None
    cell: Optional[str] = None
    width: Optional[str] = None
    groupable: Optional[bool] = None
    sortable: Optional[bool] = None
    resizeable: Optional[bool] = None


class ContainerResources(KodexaBaseModel):
    memory: Optional[str] = None
    cpu: Optional[str] = None


class ContentMetadata(KodexaBaseModel):
    """
    The metadata for this store
    """

    type: Optional[str] = None


class DashboardWidget(KodexaBaseModel):
    id: Optional[str] = None
    name: Optional[str] = None
    type: Optional[str] = None
    properties: Optional[Dict[str, Any]] = None
    children: Optional[List[DashboardWidget]] = None


class DataFormSource(KodexaBaseModel):
    id: Optional[str] = None
    name: Optional[str] = None
    type: Optional[str] = None
    properties: Optional[Dict[str, Any]] = None


class DataFormView(KodexaBaseModel):
    id: Optional[str] = None
    data_object_subscription: Optional[str] = Field(
        None, alias='dataObjectSubscription'
    )
    properties: Optional[Dict[str, Any]] = None
    data_source_id: Optional[str] = Field(None, alias='dataSourceId')
    name: Optional[str] = None
    cards: Optional[List[Card]] = None


class DeploymentType(Enum):
    kubernetes = 'KUBERNETES'
    aws_lambda = 'AWS_LAMBDA'
    azure_cloud_function = 'AZURE_CLOUD_FUNCTION'
    none = 'NONE'


class DocumentColumn(KodexaBaseModel):
    label: Optional[str] = Field(
        None, description='The label to use for the column heading'
    )
    path: Optional[str] = Field(None, description='The path to the data')


class DocumentMetadataProperty(KodexaBaseModel):
    name: Optional[str] = None
    values: Optional[List[Dict[str, Any]]] = None
    query_available: Optional[bool] = Field(None, alias='queryAvailable')


class Status(Enum):
    pending = 'PENDING'
    building = 'BUILDING'
    built = 'BUILT'
    available = 'AVAILABLE'
    failed = 'FAILED'
    undeployed = 'UNDEPLOYED'
    awaiting_deployment = 'AWAITING_DEPLOYMENT'
    deploying = 'DEPLOYING'
    deployment_failed = 'DEPLOYMENT_FAILED'


class ExtensionPackSource(KodexaBaseModel):
    type: Optional[str] = None


class MatchLabel(KodexaBaseModel):
    label: Optional[str] = None
    value: Optional[str] = None


class MetadataTag(KodexaBaseModel):
    """
    A list of associated tags
    """

    tag: Optional[str] = None
    image_url: Optional[str] = Field(None, alias='imageUrl')


class State(Enum):
    """
    The state of the model in this store
    """

    pending = 'PENDING'
    preparing = 'PREPARING'
    prepared = 'PREPARED'
    training = 'TRAINING'
    trained = 'TRAINED'
    deployed = 'DEPLOYED'
    undeployed = 'UNDEPLOYED'
    failed = 'FAILED'


class DeploymentType1(Enum):
    """
    The deployment to use, local means that the model runtime can be re-used across models, while container means that the model store must be deployed with the model runtime
    """

    local = 'LOCAL'
    container = 'CONTAINER'


class OverlayCondition(KodexaBaseModel):
    pass


class StepType(Enum):
    """
    The type of step (ACTION or MODEL)
    """

    action = 'ACTION'
    model = 'MODEL'


class PipelineStepMetadata(KodexaBaseModel):
    """
    The metadata for the steps in this pipeline
    """

    name: Optional[str] = Field(None, description='The name of the step')
    ref: Optional[str] = Field(None, description='The reference to the action')
    options: Optional[Dict[str, Any]] = Field(
        None, description='The options for the step in the pipeline'
    )
    step_type: Optional[StepType] = Field(
        None, alias='stepType', description='The type of step (ACTION or MODEL)'
    )


class PossibleValue(KodexaBaseModel):
    label: Optional[str] = None
    value: Optional[Any] = None
    description: Optional[str] = None


class ProjectDashboard(KodexaBaseModel):
    """
    The dashboards that will be created with the project template
    """

    slug: Optional[str] = None
    name: Optional[str] = None
    description: Optional[str] = None
    widgets: Optional[List[DashboardWidget]] = None
    template_ref: Optional[str] = Field(None, alias='templateRef')


class StoreType(Enum):
    document = 'DOCUMENT'
    table = 'TABLE'
    dictionary = 'DICTIONARY'
    model = 'MODEL'


class StorePurpose(Enum):
    operational = 'OPERATIONAL'
    training = 'TRAINING'


class ProjectStore(KodexaBaseModel):
    """
    The stores that will be created with the project template
    """

    slug: Optional[str] = None
    name: Optional[str] = None
    description: Optional[str] = None
    store_type: Optional[StoreType] = Field(None, alias='storeType')
    store_purpose: Optional[StorePurpose] = Field(None, alias='storePurpose')
    template_ref: Optional[str] = Field(None, alias='templateRef')


class TaxonomyType(Enum):
    """
    The type of taxonomy
    """

    content = 'CONTENT'
    classification = 'CLASSIFICATION'
    processing = 'PROCESSING'
    model = 'MODEL'


class Category(Enum):
    """
    The category of project template
    """

    task = 'TASK'
    document = 'DOCUMENT'
    connector = 'CONNECTOR'
    machine_learning = 'MACHINE_LEARNING'
    supplemental = 'SUPPLEMENTAL'


class Purpose(Enum):
    suggestion = 'SUGGESTION'
    source = 'SOURCE'


class RelatedTaxon(KodexaBaseModel):
    """
    A list of relationships to other taxons and the purpose of the relationship
    """

    path: Optional[str] = None
    purpose: Optional[Purpose] = None
    priority: Optional[int] = None


class ScheduleDefinition(KodexaBaseModel):
    """
    The default schedules that the assistant has
    """

    type: Optional[str] = None
    cron_expression: Optional[str] = Field(None, alias='cronExpression')
    last_event: Optional[datetime] = Field(None, alias='lastEvent')
    next_event: Optional[datetime] = Field(None, alias='nextEvent')


class SelectionOption(KodexaBaseModel):
    """
    If data type is SELECTION, this is the list of available options
    """

    label: Optional[str] = None
    id: Optional[str] = None
    description: Optional[str] = None


class SlugBasedMetadata1(KodexaBaseModel):
    ref: Optional[str] = Field(None, description='The reference to the metadata object')
    template: Optional[bool] = Field(
        None,
        description='Is this component a template that can be used to create new components',
    )
    schema_version: Optional[int] = Field(
        None, alias='schemaVersion', description='The version of the schema'
    )
    org_slug: Optional[str] = Field(
        None,
        alias='orgSlug',
        description='The slug of the organization that owns this metadata object',
    )
    slug: constr(regex=r'^[a-zA-Z0-9\-_]{0,255}$') = Field(
        ..., description='The slug used when referencing this metadata object'
    )
    type: str = Field(..., description='The type of metadata object')
    name: str = Field(..., description='The name of the object')
    description: Optional[str] = Field(
        None, description='The description of the object'
    )
    version: Optional[constr(regex=r'^\d+\.\d+\.\d+(?:\-\d+)?$')] = Field(
        None, description='The version of the object'
    )
    deployed: Optional[datetime] = Field(
        None,
        description='The date/time the object was deployed into this Kodexa instance',
    )
    public_access: Optional[bool] = Field(
        None,
        alias='publicAccess',
        description='Is the metadata object publicly accessible by other organizations',
    )
    image_url: Optional[str] = Field(
        None,
        alias='imageUrl',
        description='URL of image when presenting this object in a UI',
    )
    icon: Optional[str] = Field(None, description='Material Icon name to use in the UI')
    overview_markdown: Optional[str] = Field(
        None,
        alias='overviewMarkdown',
        description='Markdown that is used to present the overview of the object',
    )
    metadata_tag: Optional[List[MetadataTag]] = Field(
        None, alias='metadataTag', description='A list of associated tags'
    )
    provider: Optional[str] = Field(None, description='The details of the of provider')
    provider_url: Optional[str] = Field(
        None, alias='providerUrl', description='The link to the provider website'
    )
    provider_image_url: Optional[str] = Field(
        None, alias='providerImageUrl', description='The link to the model image'
    )


class StepImplementation(KodexaBaseModel):
    package: Optional[str] = None
    class_: Optional[str] = Field(None, alias='class')


class StoreType1(Enum):
    """
    The type of object the store will contain
    """

    document = 'DOCUMENT'
    table = 'TABLE'
    dictionary = 'DICTIONARY'
    model = 'MODEL'


class StorePurpose1(Enum):
    """
    The purpose of the store (used by UI and assistants to understand how to interact with the store events)
    """

    operational = 'OPERATIONAL'
    training = 'TRAINING'


class StoreViewOptions(KodexaBaseModel):
    """
    Options for viewing this store
    """

    show_last_event: Optional[bool] = Field(None, alias='showLastEvent')
    show_extension: Optional[bool] = Field(None, alias='showExtension')
    show_created: Optional[bool] = Field(None, alias='showCreated')
    show_modified: Optional[bool] = Field(None, alias='showModified')
    show_path_counts: Optional[bool] = Field(None, alias='showPathCounts')
    show_classifications: Optional[bool] = Field(None, alias='showClassifications')
    show_size: Optional[bool] = Field(None, alias='showSize')
    show_assignments: Optional[bool] = Field(None, alias='showAssignments')
    show_status: Optional[bool] = Field(None, alias='showStatus')
    additional_columns: Optional[List[DocumentColumn]] = Field(
        None, alias='additionalColumns'
    )
    column_states: Optional[Dict[str, List[ColumnState]]] = Field(
        None, alias='columnStates'
    )


class TabGroup(KodexaBaseModel):
    id: Optional[str] = None
    name: Optional[str] = None
    icon: Optional[str] = None
    show_if: Optional[str] = Field(None, alias='showIf')


class ValuePath(Enum):
    """
    Where to get the value for this taxon when extracting
    """

    value_or_all_content = 'VALUE_OR_ALL_CONTENT'
    value_only = 'VALUE_ONLY'
    all_content = 'ALL_CONTENT'
    data_path = 'DATA_PATH'
    metadata = 'METADATA'
    expression = 'EXPRESSION'


class MetadataValue(Enum):
    """
    If the type is metadata this will be the metadata option
    """

    filename = 'FILENAME'
    transaction_uuid = 'TRANSACTION_UUID'
    created_datetime = 'CREATED_DATETIME'


class TaxonType(Enum):
    """
    Expected data type to coalesce to (defaults to STRING)
    """

    string = 'STRING'
    date = 'DATE'
    date_time = 'DATE_TIME'
    number = 'NUMBER'
    decimal = 'DECIMAL'
    float = 'FLOAT'
    boolean = 'BOOLEAN'
    currency = 'CURRENCY'
    url = 'URL'
    email_address = 'EMAIL_ADDRESS'
    phone_number = 'PHONE_NUMBER'
    selection = 'SELECTION'


class TaxonomyType1(Enum):
    """
    The type of taxonomy
    """

    content = 'CONTENT'
    classification = 'CLASSIFICATION'
    processing = 'PROCESSING'
    model = 'MODEL'


class ViewPreset(KodexaBaseModel):
    """
    View presets that have been saved for this store
    """

    id: Optional[str] = None
    name: Optional[str] = None
    filter_string: Optional[str] = Field(None, alias='filterString')
    enabled_taxons: Optional[Dict[str, bool]] = Field(None, alias='enabledTaxons')


class ReprocessRequest(KodexaBaseModel):
    assistant_ids: Optional[List[str]] = Field(None, alias='assistantIds')
    family_ids: Optional[List[str]] = Field(None, alias='familyIds')
    all: Optional[bool] = None


class AssistantSchedule(KodexaBaseModel):
    type: Optional[str] = None
    cron_expression: Optional[str] = Field(None, alias='cronExpression')
    last_event: Optional[datetime] = Field(None, alias='lastEvent')
    next_event: Optional[datetime] = Field(None, alias='nextEvent')
    id: Optional[str] = None


class StatusType1(Enum):
    unresolved = 'UNRESOLVED'
    resolved = 'RESOLVED'


class AttributeStatus(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    color: Optional[str] = None
    icon: Optional[str] = None
    status: Optional[str] = None
    status_type: Optional[StatusType1] = Field(None, alias='statusType')


class ContentClassification(KodexaBaseModel):
    """
    The classification classes from the latest content object in the family
    """

    label: Optional[str] = None
    taxonomy: Optional[str] = None
    selector: Optional[str] = None
    confidence: Optional[float] = None


class ContentType(Enum):
    """
    The type of content
    """

    document = 'DOCUMENT'
    native = 'NATIVE'


class ActorType(Enum):
    """
    The type of actor
    """

    user = 'USER'
    assistant = 'ASSISTANT'
    access_token = 'ACCESS_TOKEN'
    api = 'API'


class DocumentActor(KodexaBaseModel):
    """
    Provides the definition of an actor in a transition
    """

    actor_id: Optional[str] = Field(
        None,
        alias='actorId',
        description='The ID for the actor (dependent on the actor type)',
    )
    actor_type: Optional[ActorType] = Field(
        None, alias='actorType', description='The type of actor'
    )


class StatusType2(Enum):
    unresolved = 'UNRESOLVED'
    resolved = 'RESOLVED'


class DocumentStatus(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    color: Optional[str] = None
    icon: Optional[str] = None
    status: str
    status_type: Optional[StatusType2] = Field(None, alias='statusType')


class TransitionType(Enum):
    """
    The type of transition
    """

    derived = 'DERIVED'


class DocumentTransition(KodexaBaseModel):
    """
    Provides the definition of a transition for a document, where a change was applied by an assistant, user or external process
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    unknown_fields: Optional[Dict[str, str]] = Field(None, alias='unknownFields')
    transition_type: Optional[TransitionType] = Field(
        None, alias='transitionType', description='The type of transition'
    )
    index: Optional[int] = None
    date_time: Optional[datetime] = Field(
        None, alias='dateTime', description='The date/time of the transition'
    )
    actor: Optional[DocumentActor] = None
    label: Optional[str] = Field(
        None,
        description='A label for the transition (this can be used later if we want to prune based on a label)',
    )
    source_content_object_id: Optional[str] = Field(None, alias='sourceContentObjectId')
    destination_content_object_id: Optional[str] = Field(
        None, alias='destinationContentObjectId'
    )


class Status1(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'
    pending_reprocessing = 'PENDING_REPROCESSING'


class Status2(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'
    pending_reprocessing = 'PENDING_REPROCESSING'


class Status3(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'
    pending_reprocessing = 'PENDING_REPROCESSING'


class StepType1(Enum):
    action = 'ACTION'
    model = 'MODEL'


class Type(Enum):
    document_store = 'DOCUMENT_STORE'
    taxonomy_store = 'TAXONOMY_STORE'
    data_store = 'DATA_STORE'


class ExecutionTarget(KodexaBaseModel):
    type: Optional[Type] = None
    ref: Optional[str] = None
    document_family_id: Optional[str] = Field(None, alias='documentFamilyId')
    content_object_id: Optional[str] = Field(None, alias='contentObjectId')
    actor: Optional[DocumentActor] = None
    taxonomy_refs: Optional[List[str]] = Field(None, alias='taxonomyRefs')
    labels_to_apply: Optional[List[str]] = Field(None, alias='labelsToApply')


class ExecutionTargets(KodexaBaseModel):
    instances: Optional[List[ExecutionTarget]] = None


class Label(KodexaBaseModel):
    """
    The labels from the latest content object in the family
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    name: str
    color: Optional[str] = None
    label: str


class PathExtractedData(KodexaBaseModel):
    id: Optional[str] = None
    taxonomy_id: Optional[str] = Field(None, alias='taxonomyId')
    path: Optional[str] = None
    label: Optional[str] = None
    count: Optional[int] = None
    exception_count: Optional[int] = Field(None, alias='exceptionCount')


class ProjectMemory(KodexaBaseModel):
    recent_filters: Optional[Dict[str, List[str]]] = Field(None, alias='recentFilters')


class ProjectMetadata(KodexaBaseModel):
    tags: Optional[List[str]] = Field(default_factory=list, unique_items=True)


class State1(Enum):
    open = 'OPEN'
    closed = 'CLOSED'


class Session(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    state: State1
    token: Optional[str] = None
    last_accessed: Optional[datetime] = Field(None, alias='lastAccessed')


class Status4(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'
    pending_reprocessing = 'PENDING_REPROCESSING'


class StatusDetails(KodexaBaseModel):
    status: Optional[Status4] = None
    message: Optional[str] = None
    detail: Optional[str] = None
    progress_max: Optional[int] = Field(None, alias='progressMax')
    progress: Optional[int] = None


class ValidationError(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    message: Optional[str] = None
    option: Optional[str] = None
    description: Optional[str] = None


class ValidationResults(KodexaBaseModel):
    instances: Optional[List[ValidationError]] = None


class BulkCopy(KodexaBaseModel):
    target_store_ref: Optional[str] = Field(None, alias='targetStoreRef')
    all: Optional[bool] = None
    document_family_ids: Optional[List[str]] = Field(None, alias='documentFamilyIds')


class FamilyRename(KodexaBaseModel):
    path: str


class ContentFeature(KodexaBaseModel):
    feature_type: Optional[str] = Field(None, alias='featureType')
    name: Optional[str] = None
    value: Optional[List[Dict[str, Any]]] = None
    single: Optional[bool] = None


class NodeFeatures(KodexaBaseModel):
    node_uuid: Optional[str] = Field(None, alias='nodeUuid')
    features: Optional[List[ContentFeature]] = None


class DataException(KodexaBaseModel):
    """
    A list of the data exceptions
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    message: str
    exception_details: Optional[str] = Field(None, alias='exceptionDetails')
    severity: Optional[str] = None
    exception_type: Optional[str] = Field(None, alias='exceptionType')
    closing_comment: Optional[str] = Field(None, alias='closingComment')
    open: Optional[bool] = None


class DataLineage(KodexaBaseModel):
    store_ref: Optional[str] = Field(None, alias='storeRef')
    document_family_id: Optional[str] = Field(None, alias='documentFamilyId')
    execution_id: Optional[str] = Field(None, alias='executionId')
    content_object_id: Optional[str] = Field(None, alias='contentObjectId')


class WorkflowDefinition(KodexaBaseModel):
    description: Optional[str] = None
    definition_xml: Optional[str] = Field(None, alias='definitionXml')


class ProjectResourcesUpdate(KodexaBaseModel):
    taxonomy_refs: Optional[List[str]] = Field(None, alias='taxonomyRefs')
    store_refs: Optional[List[str]] = Field(None, alias='storeRefs')
    dashboard_refs: Optional[List[str]] = Field(None, alias='dashboardRefs')
    data_form_refs: Optional[List[str]] = Field(None, alias='dataFormRefs')


class Role1(Enum):
    owner = 'OWNER'
    read = 'READ'
    write = 'WRITE'


class DeploymentType2(Enum):
    kubernetes = 'KUBERNETES'
    aws_lambda = 'AWS_LAMBDA'
    azure_cloud_function = 'AZURE_CLOUD_FUNCTION'
    none = 'NONE'


class DeploymentOptions(KodexaBaseModel):
    deployment_type: Optional[DeploymentType2] = Field(None, alias='deploymentType')
    max_replicas: Optional[int] = Field(None, alias='maxReplicas')
    min_replicas: Optional[int] = Field(None, alias='minReplicas')
    reserved_concurrency: Optional[int] = Field(None, alias='reservedConcurrency')
    memory_assigned: Optional[str] = Field(None, alias='memoryAssigned')
    cpu: Optional[str] = None
    pod_match_labels: Optional[List[MatchLabel]] = Field(None, alias='podMatchLabels')


class SourceType(Enum):
    data_object = 'DATA_OBJECT'
    data_attribute = 'DATA_ATTRIBUTE'
    fixed = 'FIXED'


class DataFormSourceParameter(KodexaBaseModel):
    name: Optional[str] = None
    required: Optional[bool] = None


class DataFormProviderExchange(KodexaBaseModel):
    method: Optional[str] = None
    parameters: Optional[Dict[str, Any]] = None
    payload: Optional[Dict[str, Any]] = None


class PlatformConfiguration(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    welcome_markdown: Optional[str] = Field(None, alias='welcomeMarkdown')
    news_markdown: Optional[str] = Field(None, alias='newsMarkdown')
    about_markdown: Optional[str] = Field(None, alias='aboutMarkdown')
    login_message: Optional[str] = Field(None, alias='loginMessage')
    base_org_slug: Optional[str] = Field(None, alias='baseOrgSlug')
    title: Optional[str] = None
    organization_title: Optional[str] = Field(None, alias='organizationTitle')
    organizations_title: Optional[str] = Field(None, alias='organizationsTitle')
    organization_description: Optional[str] = Field(
        None, alias='organizationDescription'
    )
    project_title: Optional[str] = Field(None, alias='projectTitle')
    projects_title: Optional[str] = Field(None, alias='projectsTitle')
    project_description: Optional[str] = Field(None, alias='projectDescription')
    developer_links: Optional[bool] = Field(None, alias='developerLinks')
    allow_registration: Optional[bool] = Field(None, alias='allowRegistration')
    allow_password_reset: Optional[bool] = Field(None, alias='allowPasswordReset')
    default_to_design: Optional[bool] = Field(None, alias='defaultToDesign')
    extension_pack_bridge: Optional[str] = Field(None, alias='extensionPackBridge')
    fallback_feature_flags: Optional[str] = Field(None, alias='fallbackFeatureFlags')


class UserActivation(KodexaBaseModel):
    first_name: Optional[str] = Field(None, alias='firstName')
    last_name: Optional[str] = Field(None, alias='lastName')
    password: Optional[str] = None


class ModelTraining(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    name: Optional[str] = None
    state: Optional[str] = None
    training_materials_generated: Optional[bool] = Field(None, alias='trainingMaterialsGenerated')
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    training_date: Optional[datetime] = Field(None, alias='trainingDate')
    properties: Optional[Dict[str, Any]] = None
    training_parameters: Optional[Dict[str, Any]] = Field(
        None,
        alias='trainingParameters',
        description='The values for the training options',
    )
    inference_options: Optional[List[Option]] = Field(
        None,
        alias='inferenceOptions',
        description='The inference options for this model',
    )


class Status5(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'
    pending_reprocessing = 'PENDING_REPROCESSING'


class BaseEvent1(KodexaBaseModel):
    type: Optional[str] = Field(None, description='The type of the event')


class ObjectEventType(Enum):
    new_object = 'NEW_OBJECT'
    derived_object = 'DERIVED_OBJECT'


class Type1(Enum):
    start_execution = 'START_EXECUTION'
    step_update = 'STEP_UPDATE'
    assistant_event = 'ASSISTANT_EVENT'
    assistant_response = 'ASSISTANT_RESPONSE'


class Status6(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'
    pending_reprocessing = 'PENDING_REPROCESSING'


class ExecutionLogEntry(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    log_date: Optional[datetime] = Field(None, alias='logDate')
    entry: Optional[str] = None


class LoginRequest(KodexaBaseModel):
    email: str
    password: str


class RegisterUser(KodexaBaseModel):
    email: str
    first_name: str = Field(..., alias='firstName')
    last_name: str = Field(..., alias='lastName')


class PasswordReset(KodexaBaseModel):
    email: str


class PasswordChange(KodexaBaseModel):
    old_password: str = Field(..., alias='oldPassword')
    new_password: str = Field(..., alias='newPassword')


class PlatformOverview(KodexaBaseModel):
    """
    Provides details on the version, build and environment that is currently running
    """

    name: Optional[str] = None
    release: Optional[str] = None
    description: Optional[str] = None
    host_name: Optional[str] = Field(
        None, alias='hostName', description='The hostname for this instance'
    )
    environment: Optional[str] = Field(
        None,
        description='The name of the environment in which this instance is running',
    )
    commit_id: Optional[str] = Field(
        None,
        alias='commitId',
        description='The git commit ID for this API server instance running',
    )
    build_time: Optional[str] = Field(
        None,
        alias='buildTime',
        description='The build time for this API server instance running',
    )
    version: Optional[str] = Field(
        None, description='The version of API server instance running'
    )
    recommended_client_version: Optional[str] = Field(
        None,
        alias='recommendedClientVersion',
        description='The recommended version of the Kodexa client to use',
    )
    extension_packs: Optional[List[Dict[str, str]]] = Field(
        None, alias='extensionPacks', description='Installed extension packs'
    )


class QueryContext(KodexaBaseModel):
    page_size: Optional[int] = Field(
        None, alias='pageSize', description='Page size (default 20)'
    )
    page: Optional[int] = Field(None, description='Page number (default 1)')
    sort: Optional[str] = Field(None, description='Sorts to apply')
    filter: Optional[str] = Field(None, description='Simple filter to apply')
    query: Optional[str] = Field(
        None, description='Simple query to apply (if available)'
    )


class SortObject(KodexaBaseModel):
    empty: Optional[bool] = None
    unsorted: Optional[bool] = None
    sorted: Optional[bool] = None


class StoreStatistics(KodexaBaseModel):
    """
    Statistics for the contents of the store instance
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    statistic_name: Optional[str] = Field(None, alias='statisticName')
    label: Optional[str] = None
    count: Optional[int] = None
    size: Optional[int] = None
    point_in_time: Optional[datetime] = Field(None, alias='pointInTime')


class SearchEntity(KodexaBaseModel):
    """
    Entities identified in search content
    """

    id: Optional[str] = None
    entity: Optional[str] = Field(None, description='The type of entity')
    value: Optional[str] = Field(None, description='The entity value')
    start: Optional[int] = Field(None, description='Start position')
    end: Optional[int] = Field(None, description='End position')


class EventType(Enum):
    created = 'CREATED'
    deleted = 'DELETED'
    updated = 'UPDATED'


class DataAttributeValues(KodexaBaseModel):
    value: Optional[str] = None
    truncated: Optional[bool] = None
    tag: str
    tag_uuid: Optional[str] = Field(None, alias='tagUuid')
    date_value: Optional[datetime] = Field(None, alias='dateValue')
    float_value: Optional[float] = Field(None, alias='floatValue')
    decimal_value: Optional[float] = Field(None, alias='decimalValue')
    number_value: Optional[int] = Field(None, alias='numberValue')
    boolean_value: Optional[bool] = Field(None, alias='booleanValue')
    string_value: Optional[str] = Field(None, alias='stringValue')
    attribute_status: Optional[AttributeStatus] = Field(None, alias='attributeStatus')
    confidence: Optional[float] = None


class BulkDelete(KodexaBaseModel):
    all: Optional[bool] = None
    document_family_ids: Optional[List[str]] = Field(None, alias='documentFamilyIds')


class User(KodexaBaseModel):
    """
    A user within the Kodexa platform
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    email: str
    first_name: str = Field(..., alias='firstName')
    last_name: str = Field(..., alias='lastName')
    activated: Optional[bool] = None
    platform_admin: Optional[bool] = Field(None, alias='platformAdmin')
    password_reset_date: Optional[datetime] = Field(None, alias='passwordResetDate')
    last_connected: Optional[datetime] = Field(None, alias='lastConnected')
    user_storage: Optional[UserStorage] = Field(None, alias='userStorage')
    has_image: Optional[bool] = Field(None, alias='hasImage')
    show_developer_tools: Optional[bool] = Field(None, alias='showDeveloperTools')


class DeploymentMetadata(KodexaBaseModel):
    deployment_type: Optional[DeploymentType] = Field(None, alias='deploymentType')
    min_replicas: Optional[int] = Field(None, alias='minReplicas')
    max_replicas: Optional[int] = Field(None, alias='maxReplicas')
    reserved_concurrency: Optional[int] = Field(None, alias='reservedConcurrency')
    limits: Optional[ContainerResources] = None
    requests: Optional[ContainerResources] = None
    memory_assigned: Optional[str] = Field(None, alias='memoryAssigned')
    scheduler_token: Optional[str] = Field(None, alias='schedulerToken')
    service_name: Optional[str] = Field(None, alias='serviceName')
    container_name: Optional[str] = Field(None, alias='containerName')
    function_arn: Optional[str] = Field(None, alias='functionArn')
    environment: Optional[Dict[str, str]] = None
    pod_match_labels: Optional[List[MatchLabel]] = Field(None, alias='podMatchLabels')
    subscription_id: Optional[str] = Field(None, alias='subscriptionId')
    plan_name: Optional[str] = Field(None, alias='planName')
    resource_group: Optional[str] = Field(None, alias='resourceGroup')
    function_url: Optional[str] = Field(None, alias='functionUrl')
    app_key: Optional[str] = Field(None, alias='appKey')


class DockerSource(ExtensionPackSource):
    location: Optional[str] = None


class DocumentMetadataDefaults(KodexaBaseModel):
    document_metadata_properties: Optional[List[DocumentMetadataProperty]] = Field(
        None, alias='documentMetadataProperties'
    )


class ExtensionPackProvided(KodexaBaseModel):
    ref: Optional[str] = Field(None, description='The reference to the metadata object')
    template: Optional[bool] = Field(
        None,
        description='Is this component a template that can be used to create new components',
    )
    schema_version: Optional[int] = Field(
        None, alias='schemaVersion', description='The version of the schema'
    )
    org_slug: Optional[str] = Field(
        None,
        alias='orgSlug',
        description='The slug of the organization that owns this metadata object',
    )
    slug: constr(regex=r'^[a-zA-Z0-9\-_]{0,255}$') = Field(
        ..., description='The slug used when referencing this metadata object'
    )
    type: str = Field(..., description='The type of metadata object')
    name: str = Field(..., description='The name of the object')
    description: Optional[str] = Field(
        None, description='The description of the object'
    )
    version: Optional[constr(regex=r'^\d+\.\d+\.\d+(?:\-\d+)?$')] = Field(
        None, description='The version of the object'
    )
    deployed: Optional[datetime] = Field(
        None,
        description='The date/time the object was deployed into this Kodexa instance',
    )
    public_access: Optional[bool] = Field(
        None,
        alias='publicAccess',
        description='Is the metadata object publicly accessible by other organizations',
    )
    image_url: Optional[str] = Field(
        None,
        alias='imageUrl',
        description='URL of image when presenting this object in a UI',
    )
    icon: Optional[str] = Field(None, description='Material Icon name to use in the UI')
    overview_markdown: Optional[str] = Field(
        None,
        alias='overviewMarkdown',
        description='Markdown that is used to present the overview of the object',
    )
    metadata_tag: Optional[List[MetadataTag]] = Field(
        None, alias='metadataTag', description='A list of associated tags'
    )
    provider: Optional[str] = Field(None, description='The details of the of provider')
    provider_url: Optional[str] = Field(
        None, alias='providerUrl', description='The link to the provider website'
    )
    provider_image_url: Optional[str] = Field(
        None, alias='providerImageUrl', description='The link to the model image'
    )
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )


class Option(KodexaBaseModel):
    """
    Options available for this event
    """

    group_options: Optional[List[Option]] = Field(None, alias='groupOptions')
    tab_name: Optional[str] = Field(None, alias='tabName')
    name: Optional[str] = None
    label: Optional[str] = None
    false_label: Optional[str] = Field(None, alias='falseLabel')
    hint: Optional[str] = None
    required: Optional[bool] = None
    type: Optional[str] = None
    list_type: Optional[str] = Field(None, alias='listType')
    list_label: Optional[str] = Field(None, alias='listLabel')
    list_description: Optional[str] = Field(None, alias='listDescription')
    feature_flag: Optional[str] = Field(None, alias='featureFlag')
    default: Optional[Any] = None
    description: Optional[str] = None
    support_article: Optional[str] = Field(None, alias='supportArticle')
    show_if: Optional[str] = Field(None, alias='showIf')
    possible_values: Optional[List[PossibleValue]] = Field(None, alias='possibleValues')


class Overlay(KodexaBaseModel):
    """
    Overlays provide the ability to apply validation, normalization and enrichment
    """

    id: Optional[str] = Field(None, description='The ID of the taxon')
    name: Optional[str] = None
    conditions: Optional[List[OverlayCondition]] = None


class PipelineImplementationMetadata(KodexaBaseModel):
    """
    Metadata captured when publishing a pipeline definition
    """

    steps: Optional[List[PipelineStepMetadata]] = Field(
        None, description='The metadata for the steps in this pipeline'
    )


class ProjectAssistant(KodexaBaseModel):
    """
    The assistants that will be created with the project template
    """

    name: Optional[str] = None
    description: Optional[str] = None
    assistant_definition_ref: Optional[str] = Field(
        None, alias='assistantDefinitionRef'
    )
    options: Optional[Dict[str, Any]] = None
    stores: Optional[List[str]] = Field(default_factory=list, unique_items=True)
    schedules: Optional[List[ScheduleDefinition]] = Field(default_factory=list, unique_items=True)
    subscription: Optional[str] = None


class Taxon(KodexaBaseModel):
    """
    A taxon is an individual label within a taxonomy
    """

    id: Optional[str] = Field(None, description='The ID of the taxon')
    label: Optional[str] = Field(None, description='The text to display for this taxon')
    generate_name: Optional[bool] = Field(
        None,
        alias='generateName',
        description='Is the name generated, this allows that you can change displays without impacted existing content',
    )
    group: Optional[bool] = Field(
        None,
        description="Is this taxon a group, and therefore can't have a value, can only have children",
    )
    name: constr(regex=r'^[a-zA-Z0-9\-_]{0,255}$') = Field(
        ..., description='The name to be used'
    )
    external_name: Optional[str] = Field(
        None,
        alias='externalName',
        description='The name to be used when we are publishing this taxon to external systems',
    )
    value_path: Optional[ValuePath] = Field(
        None,
        alias='valuePath',
        description='Where to get the value for this taxon when extracting',
    )
    metadata_value: Optional[MetadataValue] = Field(
        None,
        alias='metadataValue',
        description='If the type is metadata this will be the metadata option',
    )
    data_path: Optional[str] = Field(
        None,
        alias='dataPath',
        description='The path to the data, based on the data inside the label (tag) within the document',
    )
    expression: Optional[str] = Field(
        None,
        description='If the taxon is based on expression, this is the expression based on the available objects',
    )
    enable_fallback_expression: Optional[bool] = Field(
        None,
        alias='enableFallbackExpression',
        description="Allow for the use of a fallback expression if the taxon wasn't found",
    )
    fallback_expression: Optional[str] = Field(
        None,
        alias='fallbackExpression',
        description='Fallback expression if enabled, this is the expression based on the available objects',
    )
    nullable: Optional[bool] = Field(
        None, description='Determine if the value of the taxon can be null (unknown)'
    )
    null_value: Optional[str] = Field(
        None,
        alias='nullValue',
        description='Allows the setting of a value to replace null if the taxon is nullable',
    )
    description: Optional[str] = Field(None, description='The description of the taxon')
    enabled: Optional[bool] = Field(
        None, description='Is the taxon enabled (used in the UI)'
    )
    color: Optional[str] = Field(
        None, description='Hex encoding of the color to use for the taxon'
    )
    children: Optional[List[Taxon]] = Field(
        None, description='The children under this taxon'
    )
    options: Optional[List[Option]] = Field(
        None,
        description='Options that can be shown for the taxon (usually used in assistant taxonomies)',
    )
    related_taxons: Optional[List[RelatedTaxon]] = Field(
        None,
        alias='relatedTaxons',
        description='A list of relationships to other taxons and the purpose of the relationship',
    )
    node_types: Optional[List[str]] = Field(
        None,
        alias='nodeTypes',
        description='A list of the node types that this taxon applies to (empty means everything), used in the UI',
    )
    taxon_type: Optional[TaxonType] = Field(
        None,
        alias='taxonType',
        description='Expected data type to coalesce to (defaults to STRING)',
    )
    selection_options: Optional[List[SelectionOption]] = Field(
        None,
        alias='selectionOptions',
        description='If data type is SELECTION, this is the list of available options',
    )
    type_features: Optional[Dict[str, Any]] = Field(
        None,
        alias='typeFeatures',
        description='Additional features for the type handling',
    )
    path: Optional[str] = Field(None, description='The path to the node')
    multi_value: Optional[bool] = Field(
        None, alias='multiValue', description='Does this taxon allow multiple values'
    )
    user_editable: Optional[bool] = Field(
        None,
        alias='userEditable',
        description='Can the value of this taxon be edited by a user',
    )
    use_post_expression: Optional[bool] = Field(
        None, alias='usePostExpression', description='Use a post extraction expression'
    )
    post_expression: Optional[str] = Field(
        None,
        alias='postExpression',
        description='An expression that is applied post extraction of the data',
    )
    default_attribute_status_id: Optional[str] = Field(
        None,
        alias='defaultAttributeStatusId',
        description='Default attribute status ID',
    )


class ContentObject(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    content_type: ContentType = Field(
        ..., alias='contentType', description='The type of content'
    )
    document_version: Optional[str] = Field(None, alias='documentVersion')
    index: Optional[int] = None
    labels: Optional[List[Label]] = Field(default_factory=list, unique_items=True)
    metadata: Optional[Dict[str, Any]] = None
    mixins: Optional[List[str]] = Field(default_factory=list, unique_items=True)
    created: Optional[datetime] = None
    modified: Optional[datetime] = None
    size: Optional[int] = None
    store_ref: Optional[str] = Field(None, alias='storeRef')
    document_family_id: Optional[str] = Field(None, alias='documentFamilyId')


class DocumentAssignment(KodexaBaseModel):
    """
    A list of the assignments to users for this document
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    user: User


class ExceptionDetails(KodexaBaseModel):
    message: Optional[str] = None
    status_code: Optional[int] = Field(None, alias='statusCode')
    error_message: Optional[str] = Field(None, alias='errorMessage')
    error_type: Optional[str] = Field(None, alias='errorType')
    executed_version: Optional[str] = Field(None, alias='executedVersion')
    advice: Optional[str] = None
    description: Optional[str] = None
    cause: Optional[Dict[str, Any]] = None
    documentation_url: Optional[str] = Field(None, alias='documentationUrl')
    stack_trace: Optional[List[Dict[str, Any]]] = Field(None, alias='stackTrace')
    help: Optional[str] = None
    option_errors: Optional[Dict[str, Any]] = Field(
        None, alias='optionErrors'
    )
    validation_errors: Optional[List[ValidationError]] = Field(
        None, alias='validationErrors'
    )


class ExecutionStep(KodexaBaseModel):
    id: Optional[str] = None
    status: Optional[Status3] = None
    exception_details: Optional[ExceptionDetails] = Field(
        None, alias='exceptionDetails'
    )
    name: Optional[str] = None
    start: Optional[datetime] = None
    end: Optional[datetime] = None
    processing_time: Optional[int] = Field(None, alias='processingTime')
    options: Optional[Dict[str, Any]] = None
    option_types: Optional[Dict[str, str]] = Field(None, alias='optionTypes')
    context: Optional[Dict[str, Any]] = None
    content_objects: Optional[List[ContentObject]] = Field(
        None, alias='contentObjects', unique_items=True
    )
    input_id: Optional[str] = Field(None, alias='inputId')
    output_id: Optional[str] = Field(None, alias='outputId')
    ref: Optional[str] = None
    extension_pack_ref: Optional[str] = Field(None, alias='extensionPackRef')
    step_type: Optional[StepType1] = Field(None, alias='stepType')


class Project(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    organization: Optional[Organization] = None
    name: Optional[str] = None
    description: Optional[str] = None
    metadata: Optional[ProjectMetadata] = None
    show_tasks: Optional[bool] = Field(None, alias='showTasks')
    show_thumbnails: Optional[bool] = Field(None, alias='showThumbnails')
    has_image: Optional[bool] = Field(None, alias='hasImage')
    show_search: Optional[bool] = Field(None, alias='showSearch')
    project_template_ref: Optional[str] = Field(None, alias='projectTemplateRef')
    memory: Optional[ProjectMemory] = None
    document_statuses: Optional[List[DocumentStatus]] = Field(
        None, alias='documentStatuses', unique_items=True
    )
    attribute_statuses: Optional[List[AttributeStatus]] = Field(
        None, alias='attributeStatuses', unique_items=True
    )


class FeatureSet(KodexaBaseModel):
    node_features: Optional[List[NodeFeatures]] = Field(None, alias='nodeFeatures')


class DataAttribute(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    value: Optional[str] = None
    truncated: Optional[bool] = None
    data_exceptions: Optional[List[DataException]] = Field(
        None,
        alias='dataExceptions',
        description='A list of the data exceptions',
        unique_items=True,
    )
    tag: str
    tag_uuid: Optional[str] = Field(None, alias='tagUuid')
    date_value: Optional[datetime] = Field(None, alias='dateValue')
    float_value: Optional[float] = Field(None, alias='floatValue')
    decimal_value: Optional[float] = Field(None, alias='decimalValue')
    number_value: Optional[int] = Field(None, alias='numberValue')
    boolean_value: Optional[bool] = Field(None, alias='booleanValue')
    string_value: Optional[str] = Field(None, alias='stringValue')
    attribute_status: Optional[AttributeStatus] = Field(None, alias='attributeStatus')
    confidence: Optional[float] = None
    number_of_notes: Optional[int] = Field(
        None,
        alias='numberOfNotes',
        description='The number of notes associated with this attribute',
    )
    data_features: Optional[Dict[str, Any]] = Field(
        None, alias='dataFeatures', description='Additional features for the data'
    )
    path: Optional[str] = None
    data_obj_id: Optional[str] = Field(None, alias='dataObjId')
    label: Optional[str] = None


class Note(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    user: Optional[User] = None
    content: Optional[str] = None


class Role(KodexaBaseModel):
    """
    A role that can be used to manage rights
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    name: str
    users: Optional[List[User]] = Field(default_factory=list, unique_items=True)
    teams: Optional[List[Team]] = Field(default_factory=list, unique_items=True)


class Membership(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    role: Optional[Role1] = None
    organization: Optional[Organization] = None
    user: Optional[User] = None


class DataFormSourceMethod(KodexaBaseModel):
    name: Optional[str] = None
    parameters: Optional[List[DataFormSourceParameter]] = None


class PageableObject(KodexaBaseModel):
    offset: Optional[int] = None
    paged: Optional[bool] = None
    unpaged: Optional[bool] = None
    page_number: Optional[int] = Field(None, alias='pageNumber')
    page_size: Optional[int] = Field(None, alias='pageSize')


class PageTeam(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Team]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageModelTraining(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[ModelTraining]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageStoreStatistics(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[StoreStatistics]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageNote(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Note]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageDataAttribute(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[DataAttribute]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageSession(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Session]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageRole(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Role]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageProject(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Project]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageOrganization(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Organization]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageMembership(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Membership]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageExecutionLogEntry(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[ExecutionLogEntry]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class AssistantMetadata(KodexaBaseModel):
    """
    Additional metadata for the assistant
    """

    avatar: Optional[Avatar] = None
    tags: Optional[List[str]] = None
    tabs: Optional[List[TabGroup]] = None
    options: Optional[List[Option]] = None


class CustomEvent(KodexaBaseModel):
    """
    A Custom Event allows you to define an subtype of assistant event with options
    """

    name: Optional[constr(regex=r'^[a-zA-Z0-9\-_]{0,40}$')] = Field(
        None, description='The name of the event'
    )
    icon: Optional[str] = Field(
        None, description='The name of a Material Design Icon to use for the event'
    )
    label: Optional[str] = Field(
        None, description='The label to use on the event in the UI'
    )
    description: Optional[str] = Field(
        None, description='The long description for the event'
    )
    content_object: Optional[bool] = Field(
        None,
        alias='contentObject',
        description='Does the event require a content object',
    )
    entry_points: Optional[List[str]] = Field(
        None,
        alias='entryPoints',
        description='Entrypoints should we show this event (test, assistantBar, documentFamily)',
    )
    options: Optional[List[Option]] = Field(
        None, description='Options available for this event'
    )


class ObjectMetadata(KodexaBaseModel):
    options: Optional[List[Option]] = None


class ProjectTaxonomy(KodexaBaseModel):
    """
    The taxonomies that will be created with the project template
    """

    slug: Optional[str] = None
    name: Optional[str] = None
    description: Optional[str] = None
    taxonomy_type: Optional[TaxonomyType] = Field(
        None, alias='taxonomyType', description='The type of taxonomy'
    )
    taxons: Optional[List[Taxon]] = Field(
        None, description="The hierarchical structure of taxon's in this taxonomy"
    )
    template_ref: Optional[str] = Field(None, alias='templateRef')


class ContentException(KodexaBaseModel):
    """
    A list of the content exceptions from the content objects
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    tag: Optional[str] = None
    message: str
    exception_type: str = Field(..., alias='exceptionType')
    severity: str
    exception_details: Optional[str] = Field(None, alias='exceptionDetails')
    group_uuid: Optional[str] = Field(None, alias='groupUuid')
    tag_uuid: Optional[str] = Field(None, alias='tagUuid')
    content_object: Optional[ContentObject] = Field(None, alias='contentObject')


class ExecutionPipeline(KodexaBaseModel):
    valid: Optional[bool] = None
    ref: Optional[str] = None
    id: Optional[str] = None
    exceptions: Optional[List[ExceptionDetails]] = None
    steps: Optional[List[ExecutionStep]] = None


class DataFormSourceDefinition(KodexaBaseModel):
    source_type: Optional[SourceType] = Field(None, alias='sourceType')
    valid: Optional[bool] = None
    methods: Optional[List[DataFormSourceMethod]] = None


class PageUser(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[User]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class Execution(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    description: Optional[str] = None
    targets: Optional[ExecutionTargets] = None
    session: Optional[Session] = None
    start_date: Optional[datetime] = Field(None, alias='startDate')
    end_date: Optional[datetime] = Field(None, alias='endDate')
    processing_time: Optional[int] = Field(None, alias='processingTime')
    logging_enabled: Optional[bool] = Field(None, alias='loggingEnabled')
    status: Optional[Status1] = None
    exception_details: Optional[ExceptionDetails] = Field(
        None, alias='exceptionDetails'
    )
    status_details: Optional[StatusDetails] = Field(None, alias='statusDetails')
    pipeline: Optional[ExecutionPipeline] = None
    parameters: Optional[Dict[str, Any]] = None
    custom_options: Optional[Dict[str, Any]] = Field(
        None, alias='customOptions'
    )
    context: Optional[Dict[str, Any]] = None
    content_objects: Optional[List[ContentObject]] = Field(
        None, alias='contentObjects', unique_items=True
    )


class ExecutionSnapshot(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    description: Optional[str] = None
    targets: Optional[ExecutionTargets] = None
    session: Optional[Session] = None
    start_date: Optional[datetime] = Field(None, alias='startDate')
    end_date: Optional[datetime] = Field(None, alias='endDate')
    processing_time: Optional[int] = Field(None, alias='processingTime')
    logging_enabled: Optional[bool] = Field(None, alias='loggingEnabled')
    status: Optional[Status2] = None
    exception_details: Optional[ExceptionDetails] = Field(
        None, alias='exceptionDetails'
    )
    status_details: Optional[StatusDetails] = Field(None, alias='statusDetails')
    pipeline: Optional[ExecutionPipeline] = None
    parameters: Optional[Dict[str, Any]] = None
    custom_options: Optional[Dict[str, Any]] = Field(
        None, alias='customOptions'
    )
    context: Optional[Dict[str, Any]] = None
    child_executions: Optional[List[Execution]] = Field(
        None, alias='childExecutions', unique_items=True
    )
    content_objects: Optional[List[ContentObject]] = Field(
        None, alias='contentObjects', unique_items=True
    )


class PageExecution(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Execution]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class ContentMetadata1(KodexaBaseModel):
    pass


class SlugBasedMetadata(KodexaBaseModel):
    pass


class DocumentFamily(KodexaBaseModel):
    """
    A document family is the representation of a single piece of external content (ie. a PDF) and all the related document representations of that file
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    document_status: Optional[DocumentStatus] = Field(None, alias='documentStatus')
    assignments: Optional[List[DocumentAssignment]] = Field(
        None,
        description='A list of the assignments to users for this document',
        unique_items=True,
    )
    store_ref: Optional[str] = Field(
        None,
        alias='storeRef',
        description='The reference to the store that is holding this document family',
    )
    path: str = Field(..., description='The path to the document family in the store')
    locked: Optional[bool] = Field(
        None,
        description='Is the document family locked. If locked then you can no longer modify or add any new document transitions',
    )
    created: Optional[datetime] = Field(None, description='Date/Time Created')
    modified: Optional[datetime] = Field(None, description='Date/Time Modified')
    size: Optional[int] = Field(
        None, description='Size of the original native content in bytes'
    )
    indexed: Optional[bool] = Field(
        None, description='Is the document family indexed for search'
    )
    content_objects: Optional[List[ContentObject]] = Field(
        None,
        alias='contentObjects',
        description='An ordered list of the content objects in the document family',
        unique_items=True,
    )
    content_exceptions: Optional[List[ContentException]] = Field(
        default_factory=list,
        alias='contentExceptions',
        description='A list of the content exceptions from the content objects',
        unique_items=True,
    )
    transitions: Optional[List[DocumentTransition]] = Field(
        None,
        description='An ordered list of the transitions in the document family',
        unique_items=True,
    )
    labels: Optional[List[Label]] = Field(
        None,
        description='The labels from the latest content object in the family',
        unique_items=True,
    )
    mixins: Optional[List[str]] = Field(
        None,
        description='The mixins from the latest content object in the family',
        unique_items=True,
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None, description='The metadata from the latest document content object'
    )
    metadata_source: Optional[Dict[str, str]] = Field(
        None,
        alias='metadataSource',
        description='This identified the content object ID that added each of the metadata keys',
    )
    statistics: Optional[DocumentFamilyStatistics] = None
    classes: Optional[List[ContentClassification]] = Field(
        None,
        description='The classification classes from the latest content object in the family',
        unique_items=True,
    )


class DocumentFamilyStatistics(KodexaBaseModel):
    """
    A collection of statistics about the document family
    """

    path_counts: Optional[List[PathExtractedData]] = Field(None, alias='pathCounts')
    recent_executions: Optional[List[ExecutionOverview]] = Field(
        None, alias='recentExecutions'
    )


class ExecutionAssistant(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    subscription: Optional[str] = None
    schedules: Optional[List[AssistantSchedule]] = Field(default_factory=list, unique_items=True)
    project: Optional[Project] = None
    name: str
    description: Optional[str] = None
    assistant_definition_ref: Optional[str] = Field(
        None, alias='assistantDefinitionRef'
    )
    logging_enabled: Optional[bool] = Field(None, alias='loggingEnabled')
    active: Optional[bool] = None
    run_on_existing_content: Optional[bool] = Field(None, alias='runOnExistingContent')
    options: Optional[Dict[str, Any]] = None
    validation_errors: Optional[ValidationResults] = Field(
        None, alias='validationErrors'
    )
    definition: Optional[AssistantDefinition] = None


class ExecutionOverview(KodexaBaseModel):
    assistant: Optional[ExecutionAssistant] = None
    execution: Optional[ExecutionSnapshot] = None


class DataObject(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    document_family: DocumentFamily = Field(..., alias='documentFamily')
    data_exceptions: Optional[List[DataException]] = Field(
        None,
        alias='dataExceptions',
        description='A list of the data exceptions',
        unique_items=True,
    )
    taxonomy_ref: Optional[str] = Field(None, alias='taxonomyRef')
    path: Optional[str] = None
    row_num: Optional[int] = Field(None, alias='rowNum')
    source_ordering: Optional[str] = Field(None, alias='sourceOrdering')
    date_time: Optional[datetime] = Field(None, alias='dateTime')
    lineage: Optional[DataLineage] = None
    attributes: Optional[List[DataAttribute]] = Field(default_factory=list, unique_items=True)
    parent_id: Optional[str] = Field(None, alias='parentId')
    store_ref: Optional[str] = Field(None, alias='storeRef')


class Assistant(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    subscription: Optional[str] = None
    schedules: Optional[List[AssistantSchedule]] = Field(default_factory=list, unique_items=True)
    project: Optional[Project] = None
    name: str
    description: Optional[str] = None
    assistant_definition_ref: Optional[str] = Field(
        None, alias='assistantDefinitionRef'
    )
    logging_enabled: Optional[bool] = Field(None, alias='loggingEnabled')
    active: Optional[bool] = None
    run_on_existing_content: Optional[bool] = Field(None, alias='runOnExistingContent')
    options: Optional[Dict[str, Any]] = None
    validation_errors: Optional[ValidationResults] = Field(
        None, alias='validationErrors'
    )
    definition: Optional[AssistantDefinition] = None


class AssistantExecution(KodexaBaseModel):
    assistant_id: Optional[str] = Field(None, alias='assistantId')
    project_id: Optional[str] = Field(None, alias='projectId')
    assistant_name: Optional[str] = Field(None, alias='assistantName')
    ref: Optional[str] = None
    options: Optional[Dict[str, Any]] = None
    option_types: Optional[Dict[str, str]] = Field(None, alias='optionTypes')
    status: Optional[Status5] = None
    exception_details: Optional[ExceptionDetails] = Field(
        None, alias='exceptionDetails'
    )
    event: Optional[
        Union[
            AssistantEvent,
            ContentEvent,
            DataObjectEvent,
            DocumentFamilyEvent,
            ScheduledEvent,
        ]
    ] = None
    response: Optional[AssistantExecutionResponse] = None
    start_date: Optional[datetime] = Field(None, alias='startDate')
    end_date: Optional[datetime] = Field(None, alias='endDate')
    processing_time: Optional[int] = Field(None, alias='processingTime')


class AssistantExecutionResponse(KodexaBaseModel):
    text: Optional[str] = None
    pipelines: Optional[List[AssistantResponsePipeline]] = None


class AssistantResponsePipeline(KodexaBaseModel):
    description: Optional[str] = None
    pipeline: Optional[Pipeline] = None
    write_back_to_store: Optional[bool] = Field(None, alias='writeBackToStore')
    data_source_ref: Optional[str] = Field(None, alias='dataSourceRef')
    taxonomy_refs: Optional[List[str]] = Field(None, alias='taxonomyRefs')
    labels_to_apply: Optional[List[str]] = Field(None, alias='labelsToApply')
    logging_enabled: Optional[bool] = Field(None, alias='loggingEnabled')


class BaseEvent(KodexaBaseModel):
    __root__: Union[
        BaseEvent1,
        DocumentFamilyEvent,
        DataObjectEvent,
        ContentEvent,
        ScheduledEvent,
        AssistantEvent,
    ]


class ExecutionEvent(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    type: Type1
    status: Optional[Status6] = None
    execution: Optional[Execution] = None
    store_ref: Optional[str] = Field(None, alias='storeRef')
    document_family_id: Optional[str] = Field(None, alias='documentFamilyId')
    session_id: str = Field(..., alias='sessionId')
    token: str
    pipeline: Optional[ExecutionPipeline] = None
    assistant: Optional[AssistantExecution] = None
    source: Optional[Dict[str, Any]] = None
    payload: Optional[Dict[str, Any]] = None
    input_id: Optional[str] = Field(None, alias='inputId')
    platform_url: Optional[str] = Field(None, alias='platformUrl')
    session_call_back_url: Optional[str] = Field(None, alias='sessionCallBackUrl')
    created: Optional[datetime] = None
    start_date: Optional[datetime] = Field(None, alias='startDate')
    end_date: Optional[datetime] = Field(None, alias='endDate')


class PageTaxonomy(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Taxonomy]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageStore(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Store]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageDocumentFamily(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[DocumentFamily]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class SearchContent(KodexaBaseModel):
    """
    A document family is the representation of a single peice of external content (ie. a PDF) and all the related document representations of that file
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    store: Optional[StoreMetadata] = None
    document_family: Optional[DocumentFamily] = Field(None, alias='documentFamily')
    container_type: Optional[str] = Field(
        None, alias='containerType', description='The container node type'
    )
    container_uuid: Optional[str] = Field(
        None, alias='containerUuid', description='The container node UUID'
    )
    container_index: Optional[int] = Field(
        None, alias='containerIndex', description='The index of the container'
    )
    source_ordering: Optional[int] = Field(
        None,
        alias='sourceOrdering',
        description='The source ordering for the content (starting at 0)',
    )
    entities: Optional[List[SearchEntity]] = Field(
        None, description='Entities found in the search content'
    )
    node_uuid: Optional[str] = Field(
        None, alias='nodeUuid', description='The unique ID of the content node'
    )
    node_type: Optional[str] = Field(
        None, alias='nodeType', description='The node type'
    )
    content: Optional[str] = None
    child_content: Optional[List[str]] = Field(
        None, alias='childContent', description='The content broken out in children'
    )


class StoreMetadata(KodexaBaseModel):
    """
    The store containing the document family
    """

    template: Optional[bool] = Field(
        None,
        description='Is this component a template that can be used to create new components',
    )
    organization: Optional[Organization] = None
    slug: str
    extension_pack_ref: Optional[str] = Field(None, alias='extensionPackRef')
    id: Optional[str] = None
    uuid: Optional[str] = None
    version: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    name: Optional[str] = None
    public_access: Optional[bool] = Field(
        None,
        alias='publicAccess',
        description='Is this component available to all organizations',
    )
    ref: Optional[str] = None
    projects: Optional[List[Project]] = Field(default_factory=list, unique_items=True)
    assistants: Optional[List[Assistant]] = Field(default_factory=list, unique_items=True)
    metadata: Optional[Store] = None


class PlatformEvent(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    date_time: Optional[datetime] = Field(None, alias='dateTime')
    assistant: Optional[Assistant] = None
    event_detail: Optional[
        Union[
            AssistantEvent,
            ContentEvent,
            DataObjectEvent,
            DocumentFamilyEvent,
            ScheduledEvent,
        ]
    ] = Field(None, alias='eventDetail')
    document_family: Optional[DocumentFamily] = Field(None, alias='documentFamily')


class PageDataObject(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[DataObject]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class AuditEvent(KodexaBaseModel):
    """
    An audit event captures a data to a data structure or document
    """

    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    platform_user: Optional[User] = Field(None, alias='platformUser')
    document_family: Optional[DocumentFamily] = Field(None, alias='documentFamily')
    data_object: Optional[DataObject] = Field(None, alias='dataObject')
    data_attribute: Optional[DataAttribute] = Field(None, alias='dataAttribute')
    tag: Optional[str] = None
    event_type: Optional[EventType] = Field(None, alias='eventType')
    old_value: Optional[DataAttributeValues] = Field(None, alias='oldValue')
    new_value: Optional[DataAttributeValues] = Field(None, alias='newValue')


class PageAuditEvent(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[AuditEvent]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageRuleSet(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[RuleSet]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageProjectTemplate(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[ProjectTemplate]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PagePipeline(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Pipeline]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageModelRuntime(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[ModelRuntime]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageSlugBasedMetadata(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[
        List[
            Union[
                SlugBasedMetadata,
                Action,
                AssistantDefinition,
                CredentialDefinition,
                Dashboard,
                DataForm,
                ExtensionPack,
                ModelRuntime,
                Pipeline,
                ProjectTemplate,
                Store,
                Taxonomy,
            ]
        ]
    ] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageExtensionPack(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[ExtensionPack]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PagePlatformEvent(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[PlatformEvent]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageDataForm(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[DataForm]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageDashboard(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Dashboard]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageCredentialDefinition(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[CredentialDefinition]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageAssistantDefinition(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[AssistantDefinition]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class PageAction(KodexaBaseModel):
    total_pages: Optional[int] = Field(None, alias='totalPages')
    total_elements: Optional[int] = Field(None, alias='totalElements')
    size: Optional[int] = None
    content: Optional[List[Action]] = None
    number: Optional[int] = None
    pageable: Optional[PageableObject] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    first: Optional[bool] = None
    last: Optional[bool] = None
    empty: Optional[bool] = None


class DocumentContentMetadata(KodexaBaseModel):
    document_metadata: Optional[DocumentMetadataDefaults] = Field(
        None, alias='documentMetadata'
    )
    type: Optional[str] = Field(None, description='The type of content metadata')


class ModelContentMetadata(KodexaBaseModel):
    type: Optional[str] = Field(None, description='The type of content metadata')
    model_runtime_ref: Optional[str] = Field(
        None,
        alias='modelRuntimeRef',
        description='The reference to the model runtime to use',
    )
    state_hash: Optional[str] = Field(
        None,
        alias='stateHash',
        description='The state has is used to determine the last update of the model',
    )
    model_runtime_parameters: Optional[Dict[str, Any]] = Field(
        None,
        alias='modelRuntimeParameters',
        description='The parameters to be passed to the model runtime',
    )
    state: Optional[State] = Field(
        None, description='The state of the model in this store'
    )
    trainable: Optional[bool] = Field(None, description='Can this model be trained')
    use_implementation_from_template: Optional[bool] = Field(
        None,
        alias='useImplementationFromTemplate',
        description='Use implementation from template',
    )
    template_ref: Optional[str] = Field(
        None,
        alias='templateRef',
        description='The template ref that will be used if we are going to use the implementation from the template',
    )
    vue_template: Optional[str] = Field(
        None,
        alias='vueTemplate',
        description='The Vue template to render for the configuration of this model',
    )
    training_options: Optional[List[Option]] = Field(
        None, alias='trainingOptions', description='The training options for this model'
    )

    inference_options: Optional[List[Option]] = Field(
        None,
        alias='inferenceOptions',
        description='The inference options for this model',
    )

    build_statistics: Optional[Dict[str, Any]] = Field(
        None,
        alias='buildStatistics',
        description='Build statistics (note this will update if the model is training)',
    )
    final_statistics: Optional[Dict[str, Any]] = Field(
        None, alias='finalStatistics', description='Final statistics from the model'
    )
    deployment: Optional[DeploymentMetadata] = None
    taxonomy: Optional[Taxonomy] = None
    additional_taxon_options: Optional[List[Option]] = Field(
        None,
        alias='additionalTaxonOptions',
        description='This are additional properties that can be set on a label when the model is part of the project',
    )
    contents: Optional[List[str]] = Field(
        None,
        description='A list of the paths (with wildcards) that hold the content of this model',
    )
    ignored_contents: Optional[List[str]] = Field(
        None,
        alias='ignoredContents',
        description='A list of the paths (with wildcards) that are ignored when picking up the content of this model',
    )
    base_dir: Optional[str] = Field(
        None,
        alias='baseDir',
        description='A base directory that was used for uploading of the model',
    )


class Action(ExtensionPackProvided):
    """
    The definition of an available action
    """

    step: Optional[StepImplementation] = None
    metadata: Optional[ObjectMetadata] = None


class AssistantDefinition(ExtensionPackProvided):
    template: Optional[bool] = None
    schedulable: Optional[bool] = Field(
        None, description='The assistant can be scheduled'
    )
    reactive: Optional[bool] = Field(
        None, description='The assistant is reactive to content changes'
    )
    assistant: Optional[AssistantImplementation] = None
    metadata: Optional[AssistantMetadata] = None
    services: Optional[List[SlugBasedMetadata]] = Field(
        None, description='Services used by the assistant'
    )
    processing_taxonomies: Optional[List[AssistantTaxonomy]] = Field(
        None,
        alias='processingTaxonomies',
        description='Taxonomies that the assistant uses',
    )
    options: Optional[List[Option]] = Field(
        None, description='Options for the assistant'
    )
    additional_taxon_options: Optional[List[Option]] = Field(
        None,
        alias='additionalTaxonOptions',
        description='This are additional properties that can be set on a label when the assistant is part of the project',
    )
    event_types: Optional[List[CustomEvent]] = Field(
        None,
        alias='eventTypes',
        description='Custom event types that the assistant is able to response to',
    )
    default_schedules: Optional[List[ScheduleDefinition]] = Field(
        None,
        alias='defaultSchedules',
        description='The default schedules that the assistant has',
    )
    subscription: Optional[str] = Field(
        None,
        description='The subscription that the assistant has, this can not be overridden by the subscription in the instance',
    )


class CredentialDefinition(ExtensionPackProvided):
    """
    Defines a type of credential that can be created as part of a project
    """

    credential_type: Optional[str] = Field(None, alias='credentialType')
    options: Optional[List[Option]] = Field(
        None, description='Options for the credential type'
    )


class Dashboard(ExtensionPackProvided):
    widgets: Optional[List[DashboardWidget]] = None


class DataForm(ExtensionPackProvided):
    entrypoints: Optional[List[str]] = None
    sources: Optional[List[DataFormSource]] = None
    views: Optional[List[DataFormView]] = None


class ExtensionPack(ExtensionPackProvided):
    """
    Extension packs provide new components to the platform
    """

    org_slug: Optional[constr(regex=r'^[a-zA-Z0-9\-_]{0,100}$')] = Field(
        None, alias='orgSlug'
    )
    slug: Optional[constr(regex=r'^[a-zA-Z0-9\-_]{0,100}$')] = None
    name: Optional[str] = None
    description: Optional[str] = None
    public_access: Optional[bool] = Field(None, alias='publicAccess')
    pack_uri: Optional[str] = Field(None, alias='packUri')
    status: Optional[Status] = None
    deployable: Optional[bool] = None
    services: Optional[List[SlugBasedMetadata]] = None
    source: Optional[ExtensionPackSource] = None
    deployment: Optional[DeploymentMetadata] = None


class ModelRuntime(ExtensionPackProvided):
    """
    The definition of an available model runtime
    """

    inference_action: Optional[str] = Field(
        None,
        alias='inferenceAction',
        description='The reference to the action that will be used for inference',
    )
    training_action: Optional[str] = Field(
        None,
        alias='trainingAction',
        description='A reference to the action that will be used for training',
    )
    deployment_type: Optional[DeploymentType1] = Field(
        None,
        alias='deploymentType',
        description='The deployment to use, local means that the model runtime can be re-used across models, while container means that the model store must be deployed with the model runtime',
    )
    container_url: Optional[str] = Field(
        None,
        alias='containerUrl',
        description='The URL of the container to use if the deployment type is CONTAINER',
    )
    deployment_defaults: Optional[DeploymentMetadata] = Field(
        None, alias='deploymentDefaults'
    )


class Pipeline(KodexaBaseModel):
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )
    metadata: Optional[PipelineImplementationMetadata] = None


class ProjectTemplate(ExtensionPackProvided):
    """
    A template for new project
    """

    stores: Optional[List[ProjectStore]] = Field(
        None, description='The stores that will be created with the project template'
    )
    assistants: Optional[List[ProjectAssistant]] = Field(
        None,
        description='The assistants that will be created with the project template',
    )
    taxonomies: Optional[List[ProjectTaxonomy]] = Field(
        None,
        description='The taxonomies that will be created with the project template',
    )
    dashboards: Optional[List[ProjectDashboard]] = Field(
        None,
        description='The dashboards that will be created with the project template',
    )
    help_url: Optional[str] = Field(
        None,
        alias='helpUrl',
        description='A help URL where you can learn more about the assistant',
    )
    category: Optional[Category] = Field(
        None, description='The category of project template'
    )
    document_statuses: Optional[List[DocumentStatus]] = Field(
        None,
        alias='documentStatuses',
        description='The document statuses that will be created with the project template',
    )
    attribute_statuses: Optional[List[AttributeStatus]] = Field(
        None,
        alias='attributeStatuses',
        description='The attribute statuses that will be created with the project template',
    )


class Store(ExtensionPackProvided):
    """
    Provides the definition and metadata for a store
    """

    metadata: Optional[ContentMetadata1] = None
    store_type: Optional[StoreType1] = Field(
        None, alias='storeType', description='The type of object the store will contain'
    )
    searchable: Optional[bool] = Field(
        None, description='Is the store indexed, and thus searchable'
    )
    store_purpose: Optional[StorePurpose1] = Field(
        None,
        alias='storePurpose',
        description='The purpose of the store (used by UI and assistants to understand how to interact with the store events)',
    )
    view_options: Optional[StoreViewOptions] = Field(None, alias='viewOptions')
    view_presets: Optional[List[ViewPreset]] = Field(
        None,
        alias='viewPresets',
        description='View presets that have been saved for this store',
    )


class Taxonomy(ExtensionPackProvided):
    """
    Provides the taxonomy hierarchy that is used for content and document classification and labeling
    """

    type: Optional[str] = Field(None, description='The metadata object type')
    taxonomy_type: Optional[TaxonomyType1] = Field(
        None, alias='taxonomyType', description='The type of taxonomy'
    )
    enabled: Optional[bool] = Field(
        None, description='Is the taxonomy enabled (effects display in the UI)'
    )
    taxons: Optional[List[Taxon]] = Field(
        None, description="The hierarchical structure of taxon's in this taxonomy"
    )
    overlays: Optional[List[Overlay]] = Field(
        None,
        description='Overlays provide the ability to apply validation, normalization and enrichment',
    )
    total_taxons: Optional[int] = Field(
        None,
        alias='totalTaxons',
        description='The total number of taxons in the taxonomy',
    )


class RuleSet(ExtensionPackProvided):
    """
    Defines a ruleset that can be applied to data objects and attributes
    """

    ref: Optional[str] = Field(None, description='The reference to the metadata object')
    template: Optional[bool] = Field(
        None,
        description='Is this component a template that can be used to create new components',
    )
    schema_version: Optional[int] = Field(
        None, alias='schemaVersion', description='The version of the schema'
    )
    org_slug: Optional[str] = Field(
        None,
        alias='orgSlug',
        description='The slug of the organization that owns this metadata object',
    )
    slug: Optional[constr(regex=r'^[a-zA-Z0-9\-_]{0,255}$')] = Field(
        None, description='The slug used when referencing this metadata object'
    )
    type: Optional[str] = Field(None, description='The type of metadata object')
    name: Optional[str] = Field(None, description='The name of the object')
    description: Optional[str] = Field(
        None, description='The description of the object'
    )
    version: Optional[constr(regex=r'^\d+\.\d+\.\d+(?:\-\d+)?$')] = Field(
        None, description='The version of the object'
    )
    deployed: Optional[datetime] = Field(
        None,
        description='The date/time the object was deployed into this Kodexa instance',
    )
    public_access: Optional[bool] = Field(
        None,
        alias='publicAccess',
        description='Is the metadata object publicly accessible by other organizations',
    )
    image_url: Optional[str] = Field(
        None,
        alias='imageUrl',
        description='URL of image when presenting this object in a UI',
    )
    icon: Optional[str] = Field(None, description='Material Icon name to use in the UI')
    overview_markdown: Optional[str] = Field(
        None,
        alias='overviewMarkdown',
        description='Markdown that is used to present the overview of the object',
    )
    metadata_tag: Optional[List[MetadataTag]] = Field(
        None, alias='metadataTag', description='A list of associated tags'
    )
    provider: Optional[str] = Field(None, description='The details of the of provider')
    provider_url: Optional[str] = Field(
        None, alias='providerUrl', description='The link to the provider website'
    )
    provider_image_url: Optional[str] = Field(
        None, alias='providerImageUrl', description='The link to the model image'
    )
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )


class AssistantEvent(KodexaBaseModel):
    type: Optional[str] = None
    content_object: Optional[ContentObject] = Field(None, alias='contentObject')
    options: Optional[Dict[str, Any]] = None
    event_type: Optional[str] = Field(None, alias='eventType')
    assistant: Optional[Assistant] = None


class ContentEvent(KodexaBaseModel):
    type: Optional[str] = None
    content_object: Optional[ContentObject] = Field(None, alias='contentObject')
    document_family: Optional[DocumentFamily] = Field(None, alias='documentFamily')
    object_event_type: Optional[ObjectEventType] = Field(None, alias='objectEventType')


class DataObjectEvent(KodexaBaseModel):
    type: Optional[str] = None
    data_object: Optional[DataObject] = Field(None, alias='dataObject')


class DocumentFamilyEvent(KodexaBaseModel):
    type: Optional[str] = None
    document_family: Optional[DocumentFamily] = Field(None, alias='documentFamily')


class ScheduledEvent(KodexaBaseModel):
    type: Optional[str] = None
    last_event: Optional[datetime] = Field(None, alias='lastEvent')
    next_event: Optional[datetime] = Field(None, alias='nextEvent')


ThrowableProblem.update_forward_refs()
Option.update_forward_refs()
Taxon.update_forward_refs()
ContentMetadata1.update_forward_refs()
SlugBasedMetadata.update_forward_refs()
DocumentFamily.update_forward_refs()
DocumentFamilyStatistics.update_forward_refs()
ExecutionAssistant.update_forward_refs()
Assistant.update_forward_refs()
AssistantExecution.update_forward_refs()
AssistantExecutionResponse.update_forward_refs()
AssistantResponsePipeline.update_forward_refs()
BaseEvent.update_forward_refs()
PageTaxonomy.update_forward_refs()
PageStore.update_forward_refs()
SearchContent.update_forward_refs()
StoreMetadata.update_forward_refs()
PlatformEvent.update_forward_refs()
PageRuleSet.update_forward_refs()
PageProjectTemplate.update_forward_refs()
PagePipeline.update_forward_refs()
PageModelRuntime.update_forward_refs()
PageSlugBasedMetadata.update_forward_refs()
PageExtensionPack.update_forward_refs()
PageDataForm.update_forward_refs()
PageDashboard.update_forward_refs()
PageCredentialDefinition.update_forward_refs()
PageAssistantDefinition.update_forward_refs()
PageAction.update_forward_refs()
DocumentContentMetadata.update_forward_refs()
ModelContentMetadata.update_forward_refs()
Action.update_forward_refs()
AssistantDefinition.update_forward_refs()
CredentialDefinition.update_forward_refs()
Dashboard.update_forward_refs()
DataForm.update_forward_refs()
ExtensionPack.update_forward_refs()
ModelRuntime.update_forward_refs()
Pipeline.update_forward_refs()
ProjectTemplate.update_forward_refs()
Store.update_forward_refs()
Taxonomy.update_forward_refs()
RuleSet.update_forward_refs()
AssistantEvent.update_forward_refs()
ContentEvent.update_forward_refs()
DataObjectEvent.update_forward_refs()
DocumentFamilyEvent.update_forward_refs()
ScheduledEvent.update_forward_refs()



