"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const sns_generated_1 = require("./sns.generated");
const topic_base_1 = require("./topic-base");
/**
 * A new SNS topic
 */
class Topic extends topic_base_1.TopicBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.topicName,
        });
        this.autoCreatePolicy = true;
        jsiiDeprecationWarnings._aws_cdk_aws_sns_TopicProps(props);
        if (props.fifo && !props.topicName) {
            // NOTE: Workaround for CloudFormation problem reported in CDK issue 12386
            // see https://github.com/aws/aws-cdk/issues/12386
            throw new Error('FIFO SNS topics must be given a topic name.');
        }
        if (props.contentBasedDeduplication && !props.fifo) {
            throw new Error('Content based deduplication can only be enabled for FIFO SNS topics.');
        }
        let cfnTopicName;
        if (props.fifo && props.topicName && !props.topicName.endsWith('.fifo')) {
            cfnTopicName = this.physicalName + '.fifo';
        }
        else {
            cfnTopicName = this.physicalName;
        }
        const resource = new sns_generated_1.CfnTopic(this, 'Resource', {
            displayName: props.displayName,
            topicName: cfnTopicName,
            kmsMasterKeyId: props.masterKey && props.masterKey.keyArn,
            contentBasedDeduplication: props.contentBasedDeduplication,
            fifoTopic: props.fifo,
        });
        this.topicArn = this.getResourceArnAttribute(resource.ref, {
            service: 'sns',
            resource: this.physicalName,
        });
        this.topicName = this.getResourceNameAttribute(resource.attrTopicName);
        this.fifo = props.fifo || false;
    }
    /**
     * Import an existing SNS topic provided an ARN
     *
     * @param scope The parent creating construct
     * @param id The construct's name
     * @param topicArn topic ARN (i.e. arn:aws:sns:us-east-2:444455556666:MyTopic)
     */
    static fromTopicArn(scope, id, topicArn) {
        class Import extends topic_base_1.TopicBase {
            constructor() {
                super(...arguments);
                this.topicArn = topicArn;
                this.topicName = core_1.Stack.of(scope).splitArn(topicArn, core_1.ArnFormat.NO_RESOURCE_NAME).resource;
                this.fifo = this.topicName.endsWith('.fifo');
                this.autoCreatePolicy = false;
            }
        }
        return new Import(scope, id);
    }
}
exports.Topic = Topic;
_a = JSII_RTTI_SYMBOL_1;
Topic[_a] = { fqn: "@aws-cdk/aws-sns.Topic", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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