# LetterBomb

### A fork of the classic Wii hacking tool from [fail0verflow](https://github.com/fail0verflow)

<p align="center">

<a href="https://gitlab.com/whoatemybutter/letterbomb"><img src="https://i.imgur.com/llzHJiw.png" width="250"/></a>

*([LetterBomb source](https://github.com/fail0verflow/letterbomb), [Webservice](https://please.hackmii.com), [WiiBrew Wiki](http://wiibrew.org/wiki/LetterBomb), [PyPi](https://pypi.org/project/letterbomb))*

<a href="https://gitlab.com/whoatemybutter/letterbomb/-/pipelines"><img src="https://img.shields.io/gitlab/pipeline/whoatemybutter/letterbomb/master?label=ci%2Fcd&style=flat-square"></a>
<a href="https://pypi.org/project/letterbomb"><img src="https://img.shields.io/pypi/dd/letterbomb?style=flat-square"></a>
<a href="https://pypi.org/project/letterbomb"><img src="https://img.shields.io/pypi/v/letterbomb?style=flat-square"></a>

</p>

## Installation
* [PyPi](https://pypi.org/project/letterbomb): **(recommended)**
```shell script
python3 -m pip install letterbomb
```

* Manual: **(development)**
```shell script
git clone https://gitlab.com/whoatemybutter/letterbomb.git
cd letterbomb-master
python setup.py build
python setup.py install
```

## Improvements over original
|                   | WhoAteMyButter's    | fail0verflow's          |
|-------------------|---------------------|-------------------------|
| Network required  | No                  | Yes                     |
| CLI               | Yes                 | No                      |
| OS support        | *nix, Windows, Mac  | *nix                    |
| Logging           | Yes, logging module | Yes, dependent on Flask |
| Packaging         | Git, PyPi           | Git                     |
| Dependencies      | None                | Flask, geoip2           |
| Pylint            | 9.45/10.00          | 4.65/10.00              |
| Python version    | 3.6+                | 2.7 only                |

## Images

<img src="https://i.imgur.com/EuBlJbF.png" width=300 />
<img src="https://i.imgur.com/B1Wb2uo.png" width=300 />
<img src="https://i.imgur.com/LjZh24c.png" width=300 />
<img src="https://i.imgur.com/YYG9XnU.png" width=300/>

## Usage
* Python:
```python
import letterbomb

# To include BootMii:
letterbomb.__main__(mac="mac address", region="region letter", pack_bundle=True, output_file="letterbomb.zip")
# To exclude BootMii
letterbomb.__main__(mac="mac address", region="region letter", pack_bundle=False, output_file="letterbomb.zip")
# To log debug messages
letterbomb.LOGGING_LEVEL = letterbomb.logging.DEBUG
# To log output to a file
letterbomb.LOGGING_FILE = "log.txt"
```
* CLI:
```shell script
# Help
python3 -m letterbomb -h

# To include BootMii
python3 -m letterbomb mac_address region -b

# To enable logging debug
python3 -m letterbomb mac_address region -g debug

# To use a file for logging output
python3 -m letterbomb mac_address region -l logfile.txt
```

## License
Letterbomb is licensed under [GPLv3+](https://www.gnu.org/licenses/gpl-3.0.txt). ([included file](https://gitlab.com/whoatemybutter/letterbomb/-/raw/master/LICENSE.txt))