"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtensibleBase = exports.Extension = exports.Parameter = exports.Action = exports.EventBridgeDestination = exports.SnsDestination = exports.SqsDestination = exports.LambdaDestination = exports.SourceType = exports.ActionPoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_appconfig_1 = require("aws-cdk-lib/aws-appconfig");
const iam = require("aws-cdk-lib/aws-iam");
const hash_1 = require("./private/hash");
/**
 * Defines Extension action points.
 *
 * @see https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions-about.html#working-with-appconfig-extensions-how-it-works-step-2
 */
var ActionPoint;
(function (ActionPoint) {
    ActionPoint["PRE_CREATE_HOSTED_CONFIGURATION_VERSION"] = "PRE_CREATE_HOSTED_CONFIGURATION_VERSION";
    ActionPoint["PRE_START_DEPLOYMENT"] = "PRE_START_DEPLOYMENT";
    ActionPoint["ON_DEPLOYMENT_START"] = "ON_DEPLOYMENT_START";
    ActionPoint["ON_DEPLOYMENT_STEP"] = "ON_DEPLOYMENT_STEP";
    ActionPoint["ON_DEPLOYMENT_BAKING"] = "ON_DEPLOYMENT_BAKING";
    ActionPoint["ON_DEPLOYMENT_COMPLETE"] = "ON_DEPLOYMENT_COMPLETE";
    ActionPoint["ON_DEPLOYMENT_ROLLED_BACK"] = "ON_DEPLOYMENT_ROLLED_BACK";
})(ActionPoint || (exports.ActionPoint = ActionPoint = {}));
var SourceType;
(function (SourceType) {
    SourceType["LAMBDA"] = "lambda";
    SourceType["SQS"] = "sqs";
    SourceType["SNS"] = "sns";
    SourceType["EVENTS"] = "events";
})(SourceType || (exports.SourceType = SourceType = {}));
/**
 * Use an AWS Lambda function as an event destination.
 */
class LambdaDestination {
    constructor(func) {
        this.extensionUri = func.functionArn;
        this.type = SourceType.LAMBDA;
        const policy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [this.extensionUri],
            actions: [
                'lambda:InvokeFunction',
                'lambda:InvokeAsync',
            ],
        });
        this.policyDocument = new iam.PolicyDocument({
            statements: [policy],
        });
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "@aws-cdk/aws-appconfig-alpha.LambdaDestination", version: "2.91.0-alpha.0" };
/**
 * Use an Amazon SQS queue as an event destination.
 */
class SqsDestination {
    constructor(queue) {
        this.extensionUri = queue.queueArn;
        this.type = SourceType.SQS;
        const policy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [this.extensionUri],
            actions: ['sqs:SendMessage'],
        });
        this.policyDocument = new iam.PolicyDocument({
            statements: [policy],
        });
    }
}
exports.SqsDestination = SqsDestination;
_b = JSII_RTTI_SYMBOL_1;
SqsDestination[_b] = { fqn: "@aws-cdk/aws-appconfig-alpha.SqsDestination", version: "2.91.0-alpha.0" };
/**
 * Use an Amazon SNS topic as an event destination.
 */
class SnsDestination {
    constructor(topic) {
        this.extensionUri = topic.topicArn;
        this.type = SourceType.SNS;
        const policy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [this.extensionUri],
            actions: ['sns:Publish'],
        });
        this.policyDocument = new iam.PolicyDocument({
            statements: [policy],
        });
    }
}
exports.SnsDestination = SnsDestination;
_c = JSII_RTTI_SYMBOL_1;
SnsDestination[_c] = { fqn: "@aws-cdk/aws-appconfig-alpha.SnsDestination", version: "2.91.0-alpha.0" };
/**
 * Use an Amazon EventBridge event bus as an event destination.
 */
class EventBridgeDestination {
    constructor(bus) {
        this.extensionUri = bus.eventBusArn;
        this.type = SourceType.EVENTS;
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
_d = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_d] = { fqn: "@aws-cdk/aws-appconfig-alpha.EventBridgeDestination", version: "2.91.0-alpha.0" };
/**
 * Defines an action for an extension.
 */
class Action {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Action);
            }
            throw error;
        }
        this.actionPoints = props.actionPoints;
        this.eventDestination = props.eventDestination;
        this.name = props.name;
        this.executionRole = props.executionRole;
        this.description = props.description;
        this.invokeWithoutExecutionRole = props.invokeWithoutExecutionRole || false;
    }
}
exports.Action = Action;
_e = JSII_RTTI_SYMBOL_1;
Action[_e] = { fqn: "@aws-cdk/aws-appconfig-alpha.Action", version: "2.91.0-alpha.0" };
/**
 * Defines a parameter for an extension.
 */
class Parameter {
    /**
     * A required parameter for an extension.
     *
     * @param name The name of the parameter
     * @param value The value of the parameter
     * @param description A description for the parameter
     */
    static required(name, value, description) {
        return new Parameter(name, true, value, description);
    }
    /**
     * An optional parameter for an extension.
     *
     * @param name The name of the parameter
     * @param value The value of the parameter
     * @param description A description for the parameter
     */
    static notRequired(name, value, description) {
        return new Parameter(name, false, value, description);
    }
    constructor(name, isRequired, value, description) {
        this.name = name;
        this.isRequired = isRequired;
        this.value = value;
        this.description = description;
    }
}
exports.Parameter = Parameter;
_f = JSII_RTTI_SYMBOL_1;
Parameter[_f] = { fqn: "@aws-cdk/aws-appconfig-alpha.Parameter", version: "2.91.0-alpha.0" };
/**
 * An AWS AppConfig extension.
 *
 * @resource AWS::AppConfig::Extension
 * @see https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html
 */
class Extension extends aws_cdk_lib_1.Resource {
    /**
     * Imports an extension into the CDK using its Amazon Resource Name (ARN).
     *
     * @param scope The parent construct
     * @param id The name of the extension construct
     * @param extensionArn The Amazon Resource Name (ARN) of the extension
     */
    static fromExtensionArn(scope, id, extensionArn) {
        const parsedArn = aws_cdk_lib_1.Stack.of(scope).splitArn(extensionArn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parsedArn.resourceName) {
            throw new Error(`Missing required /$/{extensionId}//$/{extensionVersionNumber} from configuration profile ARN: ${parsedArn.resourceName}`);
        }
        const resourceName = parsedArn.resourceName.split('/');
        if (resourceName.length != 2 || !resourceName[0] || !resourceName[1]) {
            throw new Error('Missing required parameters for extension ARN: format should be /$/{extensionId}//$/{extensionVersionNumber}');
        }
        const extensionId = resourceName[0];
        const extensionVersionNumber = resourceName[1];
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.extensionId = extensionId;
                this.extensionVersionNumber = parseInt(extensionVersionNumber);
                this.extensionArn = extensionArn;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: extensionArn,
        });
    }
    /**
     * Imports an extension into the CDK using its attributes.
     *
     * @param scope The parent construct
     * @param id The name of the extension construct
     * @param attr The attributes of the extension
     */
    static fromExtensionAttributes(scope, id, attr) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionAttributes(attr);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromExtensionAttributes);
            }
            throw error;
        }
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const extensionArn = attr.extensionArn || stack.formatArn({
            service: 'appconfig',
            resource: 'extension',
            resourceName: `${attr.extensionId}/${attr.extensionVersionNumber}`,
        });
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.extensionId = attr.extensionId;
                this.extensionVersionNumber = attr.extensionVersionNumber;
                this.extensionArn = extensionArn;
                this.name = attr.name;
                this.actions = attr.actions;
                this.description = attr.description;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: extensionArn,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.name,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Extension);
            }
            throw error;
        }
        this.actions = props.actions;
        this.name = props.name || aws_cdk_lib_1.Names.uniqueResourceName(this, {
            maxLength: 64,
            separator: '-',
        });
        this.description = props.description;
        this.latestVersionNumber = props.latestVersionNumber;
        this.parameters = props.parameters;
        const resource = new aws_appconfig_1.CfnExtension(this, 'Resource', {
            actions: this.actions.reduce((acc, cur) => {
                const extensionUri = cur.eventDestination.extensionUri;
                const sourceType = cur.eventDestination.type;
                this.executionRole = cur.executionRole;
                cur.actionPoints.forEach((actionPoint) => {
                    acc[actionPoint] = [
                        {
                            Name: cur.name || aws_cdk_lib_1.Names.uniqueResourceName(this, {
                                maxLength: 64,
                                separator: '-',
                            }),
                            Uri: extensionUri,
                            ...(sourceType === SourceType.EVENTS || cur.invokeWithoutExecutionRole
                                ? {}
                                : { RoleArn: this.executionRole?.roleArn || this.getExecutionRole(cur.eventDestination).roleArn }),
                            ...(cur.description ? { Description: cur.description } : {}),
                        },
                    ];
                });
                return acc;
            }, {}),
            name: this.name,
            description: this.description,
            latestVersionNumber: this.latestVersionNumber,
            parameters: this.parameters?.reduce((acc, cur) => {
                acc[cur.name] = {
                    required: cur.isRequired,
                    description: cur.description,
                };
                return acc;
            }, {}),
        });
        this._cfnExtension = resource;
        this.extensionId = this._cfnExtension.attrId;
        this.extensionVersionNumber = this._cfnExtension.attrVersionNumber;
        this.extensionArn = this.getResourceArnAttribute(this._cfnExtension.attrArn, {
            service: 'appconfig',
            resource: 'extension',
            resourceName: `${this.extensionId}/${this.extensionVersionNumber}`,
        });
    }
    getExecutionRole(eventDestination) {
        this.executionRole = new iam.Role(this, `Role${(0, hash_1.getHash)(eventDestination.extensionUri)}`, {
            roleName: aws_cdk_lib_1.PhysicalName.GENERATE_IF_NEEDED,
            assumedBy: new iam.ServicePrincipal('appconfig.amazonaws.com'),
            inlinePolicies: {
                ['AllowAppConfigInvokeExtensionEventSourcePolicy']: eventDestination.policyDocument,
            },
        });
        return this.executionRole;
    }
}
exports.Extension = Extension;
_g = JSII_RTTI_SYMBOL_1;
Extension[_g] = { fqn: "@aws-cdk/aws-appconfig-alpha.Extension", version: "2.91.0-alpha.0" };
/**
 * This class is meant to be used by AWS AppConfig resources (application,
 * configuration profile, environment) directly. There is currently no use
 * for this class outside of the AWS AppConfig construct implementation. It is
 * intended to be used with the resources since there is currently no way to
 * inherit from two classes (at least within JSII constraints).
 */
class ExtensibleBase {
    constructor(scope, resourceArn, resourceName) {
        this.resourceArn = resourceArn;
        this.resourceName = resourceName;
        this.scope = scope;
    }
    on(actionPoint, eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ActionPoint(actionPoint);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.on);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, actionPoint, options);
    }
    preCreateHostedConfigurationVersion(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.preCreateHostedConfigurationVersion);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.PRE_CREATE_HOSTED_CONFIGURATION_VERSION, options);
    }
    preStartDeployment(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.preStartDeployment);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.PRE_START_DEPLOYMENT, options);
    }
    onDeploymentStart(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onDeploymentStart);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.ON_DEPLOYMENT_START, options);
    }
    onDeploymentStep(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onDeploymentStep);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.ON_DEPLOYMENT_STEP, options);
    }
    onDeploymentBaking(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onDeploymentBaking);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.ON_DEPLOYMENT_BAKING, options);
    }
    onDeploymentComplete(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onDeploymentComplete);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.ON_DEPLOYMENT_COMPLETE, options);
    }
    onDeploymentRolledBack(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onDeploymentRolledBack);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.ON_DEPLOYMENT_ROLLED_BACK, options);
    }
    addExtension(extension) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IExtension(extension);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addExtension);
            }
            throw error;
        }
        this.addExtensionAssociation(extension, {
            parameters: extension.parameters,
        });
    }
    getExtensionForActionPoint(eventDestination, actionPoint, options) {
        const extension = new Extension(this.scope, `Extension${this.getExtensionHash(eventDestination, actionPoint, options)}`, {
            actions: [
                new Action({
                    eventDestination,
                    actionPoints: [
                        actionPoint,
                    ],
                }),
            ],
            ...(options?.description ? { description: options.description } : {}),
            ...(options?.latestVersionNumber ? { latestVersionNumber: options.latestVersionNumber } : {}),
            ...(options?.name ? { name: options.name } : {}),
            ...(options?.parameters ? { parameters: options.parameters } : {}),
        });
        this.addExtensionAssociation(extension, options);
    }
    addExtensionAssociation(extension, options) {
        new aws_appconfig_1.CfnExtensionAssociation(this.scope, `AssociationResource${this.getExtensionAssociationHash(extension)}`, {
            extensionIdentifier: extension.extensionId,
            resourceIdentifier: this.resourceArn,
            extensionVersionNumber: extension.extensionVersionNumber,
            parameters: options?.parameters?.reduce((acc, cur) => {
                if (cur.value) {
                    acc[cur.name] = cur.value;
                }
                return acc;
            }, {}),
        });
    }
    getExtensionHash(eventDestination, actionPoint, options) {
        const combinedString = (0, hash_1.stringifyObjects)(eventDestination, actionPoint, options);
        return (0, hash_1.getHash)(combinedString);
    }
    getExtensionAssociationHash(extension) {
        const resourceIdentifier = this.resourceName ? this.resourceName : this.resourceArn;
        const combinedString = (0, hash_1.stringifyObjects)(resourceIdentifier, extension.name, extension.extensionVersionNumber);
        return (0, hash_1.getHash)(combinedString);
    }
}
exports.ExtensibleBase = ExtensibleBase;
_h = JSII_RTTI_SYMBOL_1;
ExtensibleBase[_h] = { fqn: "@aws-cdk/aws-appconfig-alpha.ExtensibleBase", version: "2.91.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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