import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [snow-device-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowdevicemanagement.html).
 *
 * @experimental
 */
export declare class SnowDeviceManagement extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [snow-device-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowdevicemanagement.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to cancel tasks on remote devices.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/CancelTask.html
     *
     * @experimental
     */
    toCancelTask(): this;
    /**
     * (experimental) Grants permission to create tasks on remote devices.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/CreateTask.html
     *
     * @experimental
     */
    toCreateTask(): this;
    /**
     * (experimental) Grants permission to describe a remotely-managed device.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/DescribeDevice.html
     *
     * @experimental
     */
    toDescribeDevice(): this;
    /**
     * (experimental) Grants permission to describe a remotely-managed device's EC2 instances.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/DescribeDeviceEc2Instances.html
     *
     * @experimental
     */
    toDescribeDeviceEc2Instances(): this;
    /**
     * (experimental) Grants permission to describe task executions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/DescribeExecution.html
     *
     * @experimental
     */
    toDescribeExecution(): this;
    /**
     * (experimental) Grants permission to describe a task.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/DescribeTask.html
     *
     * @experimental
     */
    toDescribeTask(): this;
    /**
     * (experimental) Grants permission to list a remotely-managed device's resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/ListDeviceResources.html
     *
     * @experimental
     */
    toListDeviceResources(): this;
    /**
     * (experimental) Grants permission to list remotely-managed devices.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/ListDevices.html
     *
     * @experimental
     */
    toListDevices(): this;
    /**
     * (experimental) Grants permission to list task executions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/ListExecutions.html
     *
     * @experimental
     */
    toListExecutions(): this;
    /**
     * (experimental) Grants permission to list the tags for a resource (device or task).
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list tasks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/ListTasks.html
     *
     * @experimental
     */
    toListTasks(): this;
    /**
     * (experimental) Grants permission to tag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snow-device-management/latest/APIReference/UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type managed-device to the statement.
     *
     * https://docs.aws.amazon.com/IAM/snow-device-management/UserGuide/managed-device.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onManagedDevice(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type task to the statement.
     *
     * https://docs.aws.amazon.com/IAM/snow-device-management/UserGuide/task.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTask(resourceId: string, account?: string, region?: string, partition?: string): this;
}
