"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import dag_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Job(google.protobuf.message.Message):
    """Job is the definition of a Job ceated by nbox, with a schedule"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _Status:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Job._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: Job._Status.ValueType  # 0
        NOT_SET: Job._Status.ValueType  # 1
        """when user creates from FE"""

        PREPARING: Job._Status.ValueType  # 2
        """if the run is being prepared"""

        PAUSED: Job._Status.ValueType  # 3
        """if user from FE/nbox said pause"""

        SCHEDULED: Job._Status.ValueType  # 4
        """is a run is scheduled"""

        ACTIVE: Job._Status.ValueType  # 5
        """run is running"""

        ERROR: Job._Status.ValueType  # 6
        """run errored -> paused"""

        COMPLETED: Job._Status.ValueType  # 7
        """last run done and there is nothing scheduled"""

        ARCHIVED: Job._Status.ValueType  # 8
        """when user deletes this job"""

        CANCELLED: Job._Status.ValueType  # 9
        """run status if job is pasued or archive"""

        KILLED: Job._Status.ValueType  # 10
        """run status if job is archived or paused while run is active"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        pass

    UNKNOWN: Job.Status.ValueType  # 0
    NOT_SET: Job.Status.ValueType  # 1
    """when user creates from FE"""

    PREPARING: Job.Status.ValueType  # 2
    """if the run is being prepared"""

    PAUSED: Job.Status.ValueType  # 3
    """if user from FE/nbox said pause"""

    SCHEDULED: Job.Status.ValueType  # 4
    """is a run is scheduled"""

    ACTIVE: Job.Status.ValueType  # 5
    """run is running"""

    ERROR: Job.Status.ValueType  # 6
    """run errored -> paused"""

    COMPLETED: Job.Status.ValueType  # 7
    """last run done and there is nothing scheduled"""

    ARCHIVED: Job.Status.ValueType  # 8
    """when user deletes this job"""

    CANCELLED: Job.Status.ValueType  # 9
    """run status if job is pasued or archive"""

    KILLED: Job.Status.ValueType  # 10
    """run status if job is archived or paused while run is active"""


    class Code(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class _Type:
            ValueType = typing.NewType('ValueType', builtins.int)
            V: typing_extensions.TypeAlias = ValueType
        class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Job.Code._Type.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            NOT_SET: Job.Code._Type.ValueType  # 0
            NBOX: Job.Code._Type.ValueType  # 1
            ZIP: Job.Code._Type.ValueType  # 2
            BINARY: Job.Code._Type.ValueType  # 3
        class Type(_Type, metaclass=_TypeEnumTypeWrapper):
            pass

        NOT_SET: Job.Code.Type.ValueType  # 0
        NBOX: Job.Code.Type.ValueType  # 1
        ZIP: Job.Code.Type.ValueType  # 2
        BINARY: Job.Code.Type.ValueType  # 3

        class S3MetaEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            value: typing.Text
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Text = ...,
                ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        S3_URL_FIELD_NUMBER: builtins.int
        SIZE_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        S3_META_FIELD_NUMBER: builtins.int
        s3_url: typing.Text
        size: builtins.int
        type: global___Job.Code.Type.ValueType
        @property
        def s3_meta(self) -> google.protobuf.internal.containers.ScalarMap[typing.Text, typing.Text]: ...
        def __init__(self,
            *,
            s3_url: typing.Text = ...,
            size: builtins.int = ...,
            type: global___Job.Code.Type.ValueType = ...,
            s3_meta: typing.Optional[typing.Mapping[typing.Text, typing.Text]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["s3_meta",b"s3_meta","s3_url",b"s3_url","size",b"size","type",b"type"]) -> None: ...

    class FeatureGatesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        value: typing.Text
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class Schedule(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        START_FIELD_NUMBER: builtins.int
        END_FIELD_NUMBER: builtins.int
        CRON_FIELD_NUMBER: builtins.int
        @property
        def start(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
        @property
        def end(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
        cron: typing.Text
        def __init__(self,
            *,
            start: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
            end: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
            cron: typing.Text = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["end",b"end","start",b"start"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["cron",b"cron","end",b"end","start",b"start"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    FEATURE_GATES_FIELD_NUMBER: builtins.int
    AUTH_INFO_FIELD_NUMBER: builtins.int
    SCHEDULE_FIELD_NUMBER: builtins.int
    DAG_FIELD_NUMBER: builtins.int
    PAUSED_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    K8SINFO_FIELD_NUMBER: builtins.int
    id: typing.Text
    """unique id of the job"""

    name: typing.Text
    """user defined name of the job
    // user provided description of the job
    string description = 3;
    """

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """time created"""
        pass
    @property
    def code(self) -> global___Job.Code: ...
    @property
    def resource(self) -> global___Resource: ...
    @property
    def feature_gates(self) -> google.protobuf.internal.containers.ScalarMap[typing.Text, typing.Text]: ...
    @property
    def auth_info(self) -> global___NBXAuthInfo:
        """some blank space for future fields

        """
        pass
    @property
    def schedule(self) -> global___Job.Schedule:
        """schedule of the job"""
        pass
    @property
    def dag(self) -> dag_pb2.DAG:
        """nbox created DAG information
        get this from dag.proto
        """
        pass
    paused: builtins.bool
    """if the job is/has to be paused"""

    status: global___Job.Status.ValueType
    """Job Status, as used within WS"""

    @property
    def k8sInfo(self) -> global___K8sInfo: ...
    def __init__(self,
        *,
        id: typing.Text = ...,
        name: typing.Text = ...,
        created_at: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        code: typing.Optional[global___Job.Code] = ...,
        resource: typing.Optional[global___Resource] = ...,
        feature_gates: typing.Optional[typing.Mapping[typing.Text, typing.Text]] = ...,
        auth_info: typing.Optional[global___NBXAuthInfo] = ...,
        schedule: typing.Optional[global___Job.Schedule] = ...,
        dag: typing.Optional[dag_pb2.DAG] = ...,
        paused: builtins.bool = ...,
        status: global___Job.Status.ValueType = ...,
        k8sInfo: typing.Optional[global___K8sInfo] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info","code",b"code","created_at",b"created_at","dag",b"dag","k8sInfo",b"k8sInfo","resource",b"resource","schedule",b"schedule"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info","code",b"code","created_at",b"created_at","dag",b"dag","feature_gates",b"feature_gates","id",b"id","k8sInfo",b"k8sInfo","name",b"name","paused",b"paused","resource",b"resource","schedule",b"schedule","status",b"status"]) -> None: ...
global___Job = Job

class NBXAuthInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    USERNAME_FIELD_NUMBER: builtins.int
    WORKSPACE_ID_FIELD_NUMBER: builtins.int
    ACCESS_TOKEN_FIELD_NUMBER: builtins.int
    REFRESH_TOKEN_FIELD_NUMBER: builtins.int
    ACCESS_KEY_FIELD_NUMBER: builtins.int
    username: typing.Text
    workspace_id: typing.Text
    """Workspace ID"""

    access_token: typing.Text
    refresh_token: typing.Text
    access_key: typing.Text
    """NBX Access Key for use with Jobs"""

    def __init__(self,
        *,
        username: typing.Text = ...,
        workspace_id: typing.Text = ...,
        access_token: typing.Text = ...,
        refresh_token: typing.Text = ...,
        access_key: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["access_key",b"access_key","access_token",b"access_token","refresh_token",b"refresh_token","username",b"username","workspace_id",b"workspace_id"]) -> None: ...
global___NBXAuthInfo = NBXAuthInfo

class K8sInfo(google.protobuf.message.Message):
    """Some k8s cluster resource info"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CRON_JOB_FIELD_NUMBER: builtins.int
    PODS_FIELD_NUMBER: builtins.int
    cron_job: typing.Text
    """Name of CronJob obj in k8s"""

    @property
    def pods(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Names of pods in k8s"""
        pass
    def __init__(self,
        *,
        cron_job: typing.Text = ...,
        pods: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cron_job",b"cron_job","pods",b"pods"]) -> None: ...
global___K8sInfo = K8sInfo

class Resource(google.protobuf.message.Message):
    """Resources required by Job"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CPU_FIELD_NUMBER: builtins.int
    MEMORY_FIELD_NUMBER: builtins.int
    GPU_FIELD_NUMBER: builtins.int
    GPU_COUNT_FIELD_NUMBER: builtins.int
    DISK_SIZE_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    MAX_RETRIES_FIELD_NUMBER: builtins.int
    cpu: typing.Text
    """CPU in milli-core"""

    memory: typing.Text
    """Memory in MiB"""

    gpu: typing.Text
    """GPU Type"""

    gpu_count: typing.Text
    """Number of GPUs as a fraction"""

    disk_size: typing.Text
    """in GiBs"""

    timeout: builtins.int
    """in seconds. Note this is inclusive of jobs and init containers, enforced by k8s, regardless of `max_retries` set"""

    max_retries: builtins.int
    """max number of retries for a job"""

    def __init__(self,
        *,
        cpu: typing.Text = ...,
        memory: typing.Text = ...,
        gpu: typing.Text = ...,
        gpu_count: typing.Text = ...,
        disk_size: typing.Text = ...,
        timeout: builtins.int = ...,
        max_retries: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cpu",b"cpu","disk_size",b"disk_size","gpu",b"gpu","gpu_count",b"gpu_count","max_retries",b"max_retries","memory",b"memory","timeout",b"timeout"]) -> None: ...
global___Resource = Resource
