# MedCAT Tutorials

## Introductory tutorials

In this tutorial, we will walk you through each stage of a basic MedCAT project. The blog posts are there to tell a story and explain why several steps or processes which we have decided to take are necessary. While the Jupyter Notebooks are for a hands-on experience building and training your MedCAT models for information extraction tasks.

| Part | Title                                                                       | Google Colab                                                                       | Blog Post |
| ---- |-----------------------------------------------------------------------------|------------------------------------------------------------------------------------|-----------|
| 1    | Introduction                                                                | -                                                                                  | [TDS](https://towardsdatascience.com/medcat-introduction-analyzing-electronic-health-records-e1c420afa13a)         |
| 2    | Data set Preparation and Basic Statistics                                   | [Colab](https://colab.research.google.com/drive/1nQ3H7plYoOyC6MzqxECbm02oxoY6F3ZL) | [TDS](https://towardsdatascience.com/medcat-dataset-analysis-and-preparation-be8bc910bd6d)         |
| 3.1  | Building a new Concept Database (CDB) and Vocabulary (Vocab)                | [Colab](https://colab.research.google.com/drive/1s1QXJ2E76sZLm5P0Lremw8-kWWXxX_w2) | [TDS](https://towardsdatascience.com/medcat-extracting-diseases-from-electronic-health-records-f53c45b3d1c1)         |
| 3.2  | Unsupervised training and NER+L                                             | [Colab](https://colab.research.google.com/drive/1LL0EP_qN78ljs1PozaoiUDMaBo6zb4Gm) | [TDS](https://towardsdatascience.com/medcat-extracting-diseases-from-electronic-health-records-f53c45b3d1c1)         |
| 4.1  | Creating a tokenizer model (huggingface) and embeddings for MetaAnnotations | [Colab](https://colab.research.google.com/drive/1Cql-Hkt-OTK22FmY9tdfoVZSCbFIJAu4) | -         |
| 4.2  | Supervised training and fine-tuning + Meta-annotations                      | [Colab](https://colab.research.google.com/drive/1QpFq55xxzaZjAC5yWMpmWhWldfdkYBW9) | -         |
| 4.3  | Annotating documents with the full MedCAT pipeline with MetaAnnotations     | [Colab](https://colab.research.google.com/drive/1apaFscR1a5shzuhg6nLM4lWxgvVbn8f1) | -         |
| 5    | Analysing the results                                                       | [Colab](https://colab.research.google.com/drive/1WFdpgqzwyWwKGSo0CDkcoMGDNKKqrSwe) | [TDS](https://towardsdatascience.com/prevalence-of-physical-and-mental-diseases-450c0f4f5851)         |


## Specialised tutorials

These tutorials expand upon specific aspects of the topics covered across the introductory tutorials. If there is anything in particular you would like us to cover in the future, let us know!

| Part | Title                                                             | Google Colab                                                                                 |
| ---- |-------------------------------------------------------------------|----------------------------------------------------------------------------------------------|
| -    |Working with SNOMED CT and building a custom Concept Database (CDB)|[Colab](https://colab.research.google.com/drive/1yesqjMQwQH20Kl9w7siRGVaSWU0uI84W?usp=sharing)|