# pydwf

This is the README of *pydwf*, a Python package to control the Digilent Waveforms electronic test and measurement devices made by [Digilent](https://store.digilentinc.com/).

It wraps all functions of *libdwf*, the [low-level C library](https://pydwf.readthedocs.io/en/latest/background/C_Library.html) provided by Digilent, in an easy-to-use, class-based Python API. Like the C library, the pydwf package supports Windows, Linux (Intel and ARM), and macOS.

The current release of pydwf is version 0.7.8.
It is intended to be used with version 3.16.3 of *libdwf*.

The *pydwf* package comes with documentation (sparse, but improving) and a considerable number of ready-to-run [examples](https://pydwf.readthedocs.io/en/latest/background/Examples.html), demonstrating how *pydwf* can be used to perform common and not-so-common measurement tasks.

A [command-line tool](https://pydwf.readthedocs.io/en/latest/background/CommandLineTool.html) is provided that can be used, among other things, to list the available Digilent devices and their configurations.

This README file contains information about the project. Readers who want to learn how to use *pydwf* are referred to the [API documentation](https://pydwf.readthedocs.io/en/latest/pydwf_api/index.html).

## Supported devices

The following devices can be controlled using *pydwf*:

* Electronics Explorer (legacy)
* Analog Discovery (legacy)
* Analog Discovery 2
* Digital Discovery
* Analog Discovery Studio
* Analog Discovery Pro (3250, 3450)

The *pydwf* package has been extensively tested with the Analog Discovery 2 and Digital Discovery devices. It should also work with the other devices listed, but these haven't been tested. If you have such a device and encounter problems, please report an issue on the [Github issue tracker](https://github.com/sidneycadot/pydwf/issues>).

## Dependencies

The *pydwf* package requires Python 3.6 or higher.

In order for *pydwf* to work, recent versions of the the Digilent Adept and Digilent Waveforms packages must be installed. These provide the C libraries that *pydwf* uses to interact with devices. Generally speaking, if the Waveforms GUI application provided by Digilent works on your system, you're good to go.

*pydwf* depends on the *numpy* package to handle the considerable amount of data transferred between the PC and Digilent devices when performing high-speed signal generation or capture operations.

Some of the [examples](https://pydwf.readthedocs.io/en/latest/background/Examples.html) depend on the *matplotlib* package, but *pydwf* itself will work without it.

## Project hosting

The project repository and issue tracker are hosted on *Github*:

https://github.com/sidneycadot/pydwf/

## Installation using *pip*

The installable package is hosted on *PyPI*:

https://pypi.org/project/pydwf/

This allows installation using the standard *pip* (or *pip3*) tool:

```
pip install pydwf
```

After installing *pydwf*, the following command will show the version of *pydwf* and the underlying DWF library:

```
python -m pydwf version
```

The following command will list all Digilent Waveforms devices connected to the system and, for each of them, list the supported configurations:

```
python -m pydwf list -c
```

## Documentation

The project documentation is hosted on *readthedocs* and can be reached via the following link:

https://pydwf.readthedocs.io/en/latest/

If desired, the documentation can also be installed locally after installing the package by executing the following command:

```
python -m pydwf extract-html-docs
```
This will create a local directory called *pydwf-docs-html* containing the project documentation in HTML format.

Alternatively, a PDF version of the manual can be extracted as well:

```
python -m pydwf extract-pdf-manual
```

Please note that the documentation is not yet complete — it's a big API!

## Examples

The Python [examples](https://pydwf.readthedocs.io/en/latest/background/Examples.html) can be installed locally after installing the *pydwf* package by executing the following command:

```
python -m pydwf extract-examples
```

This will create a local directory called *pydwf-examples* containing the Python examples that demonstrate many of the capabilities of the Digilent devices and *pydwf*.

These examples are intended as a useful starting point for your own Python scripts. See the [Examples overview](https://pydwf.readthedocs.io/en/latest/background/Examples.html) for more information.
