# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretBackendIntermediateCertRequestArgs', 'SecretBackendIntermediateCertRequest']

@pulumi.input_type
class SecretBackendIntermediateCertRequestArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 common_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key_bits: Optional[pulumi.Input[int]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ou: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 private_key_format: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 street_address: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SecretBackendIntermediateCertRequest resource.
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] common_name: CN of intermediate to create
        :param pulumi.Input[str] type: Type of intermediate to create. Must be either \"exported\" or \"internal\"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[str] country: The country
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[int] key_bits: The number of bits to use
        :param pulumi.Input[str] key_type: The desired key type
        :param pulumi.Input[str] locality: The locality
        :param pulumi.Input[str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[str] ou: The organization unit
        :param pulumi.Input[str] postal_code: The postal code
        :param pulumi.Input[str] private_key_format: The private key format
        :param pulumi.Input[str] province: The province
        :param pulumi.Input[str] street_address: The street address
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "type", type)
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if ou is not None:
            pulumi.set(__self__, "ou", ou)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if private_key_format is not None:
            pulumi.set(__self__, "private_key_format", private_key_format)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[str]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of intermediate to create. Must be either \"exported\" or \"internal\"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alt_names", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_sans", value)

    @property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[int]]:
        """
        The number of bits to use
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_bits", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The desired key type
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "other_sans", value)

    @property
    @pulumi.getter
    def ou(self) -> Optional[pulumi.Input[str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @ou.setter
    def ou(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ou", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> Optional[pulumi.Input[str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @private_key_format.setter
    def private_key_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_format", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_address", value)

    @property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "uri_sans", value)


@pulumi.input_type
class _SecretBackendIntermediateCertRequestState:
    def __init__(__self__, *,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key_bits: Optional[pulumi.Input[int]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ou: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 private_key_format: Optional[pulumi.Input[str]] = None,
                 private_key_type: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 street_address: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering SecretBackendIntermediateCertRequest resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] common_name: CN of intermediate to create
        :param pulumi.Input[str] country: The country
        :param pulumi.Input[str] csr: The CSR
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[int] key_bits: The number of bits to use
        :param pulumi.Input[str] key_type: The desired key type
        :param pulumi.Input[str] locality: The locality
        :param pulumi.Input[str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[str] ou: The organization unit
        :param pulumi.Input[str] postal_code: The postal code
        :param pulumi.Input[str] private_key: The private key
        :param pulumi.Input[str] private_key_format: The private key format
        :param pulumi.Input[str] private_key_type: The private key type
        :param pulumi.Input[str] province: The province
        :param pulumi.Input[str] street_address: The street address
        :param pulumi.Input[str] type: Type of intermediate to create. Must be either \"exported\" or \"internal\"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        """
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if ou is not None:
            pulumi.set(__self__, "ou", ou)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_format is not None:
            pulumi.set(__self__, "private_key_format", private_key_format)
        if private_key_type is not None:
            pulumi.set(__self__, "private_key_type", private_key_type)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)

    @property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alt_names", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[str]]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_sans", value)

    @property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[int]]:
        """
        The number of bits to use
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_bits", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The desired key type
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "other_sans", value)

    @property
    @pulumi.getter
    def ou(self) -> Optional[pulumi.Input[str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @ou.setter
    def ou(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ou", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> Optional[pulumi.Input[str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @private_key_format.setter
    def private_key_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_format", value)

    @property
    @pulumi.getter(name="privateKeyType")
    def private_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The private key type
        """
        return pulumi.get(self, "private_key_type")

    @private_key_type.setter
    def private_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_type", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_address", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of intermediate to create. Must be either \"exported\" or \"internal\"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "uri_sans", value)


class SecretBackendIntermediateCertRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key_bits: Optional[pulumi.Input[int]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ou: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 private_key_format: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 street_address: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a SecretBackendIntermediateCertRequest resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] common_name: CN of intermediate to create
        :param pulumi.Input[str] country: The country
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[int] key_bits: The number of bits to use
        :param pulumi.Input[str] key_type: The desired key type
        :param pulumi.Input[str] locality: The locality
        :param pulumi.Input[str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[str] ou: The organization unit
        :param pulumi.Input[str] postal_code: The postal code
        :param pulumi.Input[str] private_key_format: The private key format
        :param pulumi.Input[str] province: The province
        :param pulumi.Input[str] street_address: The street address
        :param pulumi.Input[str] type: Type of intermediate to create. Must be either \"exported\" or \"internal\"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendIntermediateCertRequestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SecretBackendIntermediateCertRequest resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SecretBackendIntermediateCertRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendIntermediateCertRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key_bits: Optional[pulumi.Input[int]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ou: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 private_key_format: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 street_address: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendIntermediateCertRequestArgs.__new__(SecretBackendIntermediateCertRequestArgs)

            __props__.__dict__["alt_names"] = alt_names
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            __props__.__dict__["country"] = country
            __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
            __props__.__dict__["format"] = format
            __props__.__dict__["ip_sans"] = ip_sans
            __props__.__dict__["key_bits"] = key_bits
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["locality"] = locality
            __props__.__dict__["organization"] = organization
            __props__.__dict__["other_sans"] = other_sans
            __props__.__dict__["ou"] = ou
            __props__.__dict__["postal_code"] = postal_code
            __props__.__dict__["private_key_format"] = private_key_format
            __props__.__dict__["province"] = province
            __props__.__dict__["street_address"] = street_address
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["uri_sans"] = uri_sans
            __props__.__dict__["csr"] = None
            __props__.__dict__["private_key"] = None
            __props__.__dict__["private_key_type"] = None
        super(SecretBackendIntermediateCertRequest, __self__).__init__(
            'vault:pkiSecret/secretBackendIntermediateCertRequest:SecretBackendIntermediateCertRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            common_name: Optional[pulumi.Input[str]] = None,
            country: Optional[pulumi.Input[str]] = None,
            csr: Optional[pulumi.Input[str]] = None,
            exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
            format: Optional[pulumi.Input[str]] = None,
            ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            key_bits: Optional[pulumi.Input[int]] = None,
            key_type: Optional[pulumi.Input[str]] = None,
            locality: Optional[pulumi.Input[str]] = None,
            organization: Optional[pulumi.Input[str]] = None,
            other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ou: Optional[pulumi.Input[str]] = None,
            postal_code: Optional[pulumi.Input[str]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            private_key_format: Optional[pulumi.Input[str]] = None,
            private_key_type: Optional[pulumi.Input[str]] = None,
            province: Optional[pulumi.Input[str]] = None,
            street_address: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'SecretBackendIntermediateCertRequest':
        """
        Get an existing SecretBackendIntermediateCertRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] common_name: CN of intermediate to create
        :param pulumi.Input[str] country: The country
        :param pulumi.Input[str] csr: The CSR
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[int] key_bits: The number of bits to use
        :param pulumi.Input[str] key_type: The desired key type
        :param pulumi.Input[str] locality: The locality
        :param pulumi.Input[str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[str] ou: The organization unit
        :param pulumi.Input[str] postal_code: The postal code
        :param pulumi.Input[str] private_key: The private key
        :param pulumi.Input[str] private_key_format: The private key format
        :param pulumi.Input[str] private_key_type: The private key type
        :param pulumi.Input[str] province: The province
        :param pulumi.Input[str] street_address: The street address
        :param pulumi.Input[str] type: Type of intermediate to create. Must be either \"exported\" or \"internal\"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendIntermediateCertRequestState.__new__(_SecretBackendIntermediateCertRequestState)

        __props__.__dict__["alt_names"] = alt_names
        __props__.__dict__["backend"] = backend
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["country"] = country
        __props__.__dict__["csr"] = csr
        __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
        __props__.__dict__["format"] = format
        __props__.__dict__["ip_sans"] = ip_sans
        __props__.__dict__["key_bits"] = key_bits
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["locality"] = locality
        __props__.__dict__["organization"] = organization
        __props__.__dict__["other_sans"] = other_sans
        __props__.__dict__["ou"] = ou
        __props__.__dict__["postal_code"] = postal_code
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_format"] = private_key_format
        __props__.__dict__["private_key_type"] = private_key_type
        __props__.__dict__["province"] = province
        __props__.__dict__["street_address"] = street_address
        __props__.__dict__["type"] = type
        __props__.__dict__["uri_sans"] = uri_sans
        return SecretBackendIntermediateCertRequest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[str]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional[str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def csr(self) -> pulumi.Output[str]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> pulumi.Output[Optional[int]]:
        """
        The number of bits to use
        """
        return pulumi.get(self, "key_bits")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[Optional[str]]:
        """
        The desired key type
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def locality(self) -> pulumi.Output[Optional[str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[Optional[str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @property
    @pulumi.getter
    def ou(self) -> pulumi.Output[Optional[str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> pulumi.Output[Optional[str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[str]:
        """
        The private key
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> pulumi.Output[Optional[str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @property
    @pulumi.getter(name="privateKeyType")
    def private_key_type(self) -> pulumi.Output[str]:
        """
        The private key type
        """
        return pulumi.get(self, "private_key_type")

    @property
    @pulumi.getter
    def province(self) -> pulumi.Output[Optional[str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> pulumi.Output[Optional[str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of intermediate to create. Must be either \"exported\" or \"internal\"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

