# Generated by Django 4.0.1 on 2022-02-21 03:34

from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Address',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('canton', models.CharField(blank=True, max_length=100, null=True)),
                ('city', models.CharField(blank=True, max_length=100, null=True)),
                ('country', django_countries.fields.CountryField(max_length=2)),
                ('created_at', models.IntegerField(blank=True, null=True)),
                ('district', models.CharField(blank=True, max_length=100, null=True)),
                ('line_1', models.CharField(blank=True, max_length=255, null=True)),
                ('line_2', models.CharField(blank=True, max_length=255, null=True)),
                ('line_3', models.CharField(blank=True, max_length=255, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('phone_number', models.CharField(blank=True, max_length=15, null=True)),
                ('state', models.CharField(blank=True, max_length=100, null=True)),
                ('updated_at', models.IntegerField(blank=True, null=True)),
                ('zip', models.CharField(blank=True, max_length=10, null=True)),
            ],
            options={
                'verbose_name_plural': 'addresses',
            },
        ),
        migrations.CreateModel(
            name='CheckoutPage',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('cancel_checkout_url', models.CharField(blank=True, max_length=80, null=True)),
                ('capture', models.BooleanField(blank=True, null=True)),
                ('cart_item', models.TextField(blank=True, null=True)),
                ('complete_checkout_url', models.CharField(blank=True, max_length=80, null=True)),
                ('complete_payment_url', models.CharField(blank=True, max_length=80, null=True)),
                ('country', django_countries.fields.CountryField(blank=True, max_length=2, null=True)),
                ('currency', models.CharField(blank=True, max_length=3, null=True)),
                ('custom_elements', models.JSONField(blank=True, null=True)),
                ('customer', models.CharField(blank=True, max_length=50, null=True)),
                ('description', models.CharField(blank=True, max_length=20, null=True)),
                ('error_payment_url', models.CharField(blank=True, max_length=80, null=True)),
                ('escrow', models.BooleanField(blank=True, null=True)),
                ('escrow_release_days', models.IntegerField(blank=True, null=True)),
                ('ewallet', models.CharField(blank=True, max_length=50, null=True)),
                ('ewallets', models.TextField(blank=True, null=True)),
                ('expiration', models.BigIntegerField(blank=True, null=True)),
                ('fixed_side', models.CharField(blank=True, max_length=3, null=True)),
                ('language', models.CharField(blank=True, max_length=20, null=True)),
                ('merchant_alias', models.CharField(blank=True, max_length=20, null=True)),
                ('merchant_color', models.CharField(blank=True, max_length=20, null=True)),
                ('merchant_customer_support', models.JSONField(blank=True, null=True)),
                ('merchant_logo', models.CharField(blank=True, max_length=80, null=True)),
                ('merchant_main_button', models.CharField(blank=True, max_length=20, null=True)),
                ('merchant_privacy_policy', models.CharField(blank=True, max_length=80, null=True)),
                ('merchant_reference_id', models.CharField(blank=True, max_length=40, null=True)),
                ('merchant_terms', models.CharField(blank=True, max_length=80, null=True)),
                ('merchan_website', models.CharField(blank=True, max_length=80, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('page_expiration', models.BigIntegerField(blank=True, null=True)),
                ('payment_expiration', models.IntegerField(blank=True, null=True)),
                ('payment_fees', models.JSONField(blank=True, null=True)),
                ('payment_method', models.JSONField(blank=True, null=True)),
                ('payment_method_type', models.CharField(blank=True, max_length=20, null=True)),
                ('payment_method_type_categories', models.TextField(blank=True, null=True)),
                ('payment_method_types_exclude', models.TextField(blank=True, null=True)),
                ('payment_method_types_include', models.TextField(blank=True, null=True)),
                ('redirect_url', models.CharField(blank=True, max_length=200, null=True)),
                ('requested_currency', models.CharField(blank=True, max_length=3, null=True)),
                ('status', models.CharField(blank=True, max_length=3, null=True)),
                ('timestamp', models.BigIntegerField(blank=True, null=True)),
                ('payment', models.JSONField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ClientDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('accept_header', models.CharField(blank=True, max_length=2048, null=True)),
                ('ip_address', models.CharField(blank=True, max_length=50, null=True)),
                ('java_enabled', models.BooleanField(blank=True, null=True)),
                ('java_script_enabled', models.BooleanField(blank=True, null=True)),
                ('language', models.CharField(blank=True, max_length=50, null=True)),
                ('screen_color_depth', models.IntegerField(blank=True, null=True)),
                ('screen_height', models.IntegerField(blank=True, null=True)),
                ('screen_width', models.IntegerField(blank=True, null=True)),
                ('time_zone_offset', models.IntegerField(blank=True, null=True)),
                ('user_agent', models.CharField(blank=True, max_length=50, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Coupon',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('amount_off', models.IntegerField(blank=True, null=True)),
                ('created', models.IntegerField(blank=True, null=True)),
                ('currency', models.CharField(blank=True, max_length=100, null=True)),
                ('deleted', models.BooleanField(blank=True, default=True, null=True)),
                ('duration', models.CharField(blank=True, max_length=100, null=True)),
                ('duration_in_months', models.IntegerField(blank=True, null=True)),
                ('max_redemptions', models.IntegerField(blank=True, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('percent_off', models.IntegerField(blank=True, null=True)),
                ('redeem_by', models.IntegerField(blank=True, null=True)),
                ('times_redeemed', models.IntegerField(blank=True, null=True)),
                ('valid', models.BooleanField(blank=True, default=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('addresses', models.JSONField(blank=True, null=True)),
                ('business_vat_id', models.CharField(blank=True, max_length=50, null=True)),
                ('category', models.CharField(blank=True, max_length=50, null=True)),
                ('coupon', models.CharField(blank=True, max_length=50, null=True)),
                ('created_at', models.IntegerField(blank=True, null=True)),
                ('customer', models.CharField(blank=True, max_length=100, null=True)),
                ('default_payments_method', models.JSONField(blank=True, null=True)),
                ('delinquent', models.BooleanField(blank=True, default=True, null=True)),
                ('description', models.CharField(blank=True, max_length=200, null=True)),
                ('email', models.CharField(blank=True, max_length=512, null=True)),
                ('ewallet', models.CharField(blank=True, max_length=100, null=True)),
                ('fields', models.JSONField(blank=True, null=True)),
                ('invoice_prefix', models.CharField(blank=True, max_length=50, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('next_action', models.CharField(blank=True, max_length=100, null=True)),
                ('payment_methods', models.JSONField(blank=True, null=True)),
                ('phone_number', models.CharField(blank=True, max_length=15, null=True)),
                ('redirect_url', models.CharField(blank=True, max_length=200, null=True)),
                ('subscriptions', models.JSONField(blank=True, null=True)),
                ('token', models.CharField(blank=True, max_length=100, null=True)),
                ('type', models.CharField(blank=True, max_length=100, null=True)),
                ('address', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.address')),
                ('discount', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.coupon')),
            ],
        ),
        migrations.CreateModel(
            name='Dispute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(max_length=50)),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('central_processing_date', models.CharField(blank=True, max_length=20, null=True)),
                ('created_at', models.BigIntegerField(blank=True, null=True)),
                ('currency', models.CharField(blank=True, max_length=3, null=True)),
                ('dispute_category', models.CharField(blank=True, max_length=20, null=True)),
                ('dispute_reason_descrption', models.CharField(blank=True, max_length=20, null=True)),
                ('due_date', models.CharField(blank=True, max_length=20, null=True)),
                ('ewallet_id', models.CharField(blank=True, max_length=40, null=True)),
                ('fixed_side', models.CharField(blank=True, max_length=5, null=True)),
                ('is_refundable', models.BooleanField(blank=True, null=True)),
                ('is_reversal', models.BooleanField(blank=True, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('original_dispute_currency', models.CharField(blank=True, max_length=3, null=True)),
                ('original_transaction_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('original_transaction_currency', models.CharField(blank=True, max_length=3, null=True)),
                ('original_transaction_id', models.CharField(blank=True, max_length=50, null=True)),
                ('payment_method', models.JSONField(blank=True, null=True)),
                ('rate', models.IntegerField(blank=True, null=True)),
                ('reversal', models.CharField(blank=True, max_length=10, null=True)),
                ('status', models.CharField(blank=True, max_length=3, null=True)),
                ('updated_at', models.BigIntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Escrow',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('amount_on_hold', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('created_at', models.BigIntegerField(blank=True, null=True)),
                ('escrows', models.CharField(blank=True, max_length=50, null=True)),
                ('escrow_release_days', models.IntegerField(blank=True, null=True)),
                ('escrow_releases', models.TextField(blank=True, null=True)),
                ('ewallets', models.TextField(blank=True, null=True)),
                ('last_payment_completion', models.BigIntegerField(blank=True, null=True)),
                ('payment', models.CharField(blank=True, max_length=50, null=True)),
                ('percentage', models.IntegerField(blank=True, null=True)),
                ('status', models.CharField(blank=True, max_length=10, null=True)),
                ('total_amount_released', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('updated_at', models.BigIntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='FxFee',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('calc_type', models.CharField(blank=True, max_length=10, null=True)),
                ('value', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='GroupPayment',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('amount_to_replace', models.CharField(blank=True, max_length=5, null=True)),
                ('cancel_reason', models.CharField(blank=True, max_length=20, null=True)),
                ('country', models.CharField(blank=True, max_length=2, null=True)),
                ('country_code', models.CharField(blank=True, max_length=2, null=True)),
                ('currency', models.CharField(blank=True, max_length=3, null=True)),
                ('currency_code', models.CharField(blank=True, max_length=3, null=True)),
                ('description', models.CharField(blank=True, max_length=20, null=True)),
                ('expiration', models.BigIntegerField(blank=True, null=True)),
                ('merchant_reference_id', models.CharField(blank=True, max_length=255, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('payments', models.TextField(blank=True, null=True)),
                ('reason', models.CharField(blank=True, max_length=20, null=True)),
                ('status', models.CharField(blank=True, max_length=10, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Invoice',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='ID_Invoice')),
                ('attempt_count', models.IntegerField(blank=True, null=True)),
                ('attempted', models.BooleanField(default='pay_automatically')),
                ('billing', models.CharField(max_length=40)),
                ('billing_reason', models.CharField(blank=True, max_length=40, null=True)),
                ('created_at', models.BigIntegerField(blank=True, null=True)),
                ('currency', models.CharField(blank=True, max_length=3, null=True)),
                ('days_until_due', models.IntegerField(blank=True, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('discount', models.TextField(blank=True, null=True)),
                ('due_date', models.IntegerField(blank=True, null=True)),
                ('lines', models.TextField(blank=True, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('next_payment_attempt', models.BigIntegerField(blank=True, null=True)),
                ('number', models.CharField(max_length=40)),
                ('payment', models.JSONField(blank=True, null=True)),
                ('payment_fields', models.JSONField(blank=True, null=True)),
                ('payment_method', models.CharField(blank=True, max_length=40, null=True)),
                ('payout', models.CharField(blank=True, max_length=40, null=True)),
                ('payout_fields', models.JSONField(blank=True, max_length=40, null=True)),
                ('period_end', models.CharField(blank=True, max_length=40, null=True)),
                ('period_start', models.CharField(blank=True, max_length=40, null=True)),
                ('statement_descriptor', models.CharField(blank=True, max_length=100, null=True)),
                ('status', models.CharField(blank=True, max_length=12, null=True)),
                ('subtotal', models.IntegerField()),
                ('tax', models.FloatField()),
                ('tax_percent', models.FloatField(blank=True, null=True)),
                ('total', models.FloatField()),
                ('type', models.CharField(max_length=10)),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.customer')),
            ],
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='ID_ItemOrder')),
                ('amount', models.FloatField()),
                ('amount_returned', models.FloatField()),
                ('created', models.BigIntegerField()),
                ('currency', models.CharField(max_length=3)),
                ('discount', models.CharField(blank=True, max_length=40, null=True)),
                ('email', models.CharField(max_length=50)),
                ('external_coupon_code', models.CharField(blank=True, max_length=40, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('returns', models.TextField(blank=True, null=True)),
                ('shipping_address', models.JSONField(blank=True, null=True)),
                ('status', models.CharField(max_length=12)),
                ('status_transitions', models.JSONField(blank=True, null=True)),
                ('tax_percent', models.FloatField()),
                ('updated', models.BigIntegerField(blank=True, null=True)),
                ('upstream_id', models.CharField(max_length=100)),
                ('payment_method', models.CharField(blank=True, max_length=50, null=True)),
                ('coupon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.coupon')),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.customer')),
            ],
        ),
        migrations.CreateModel(
            name='Outcome',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('network_status', models.CharField(blank=True, max_length=30, null=True)),
                ('risk_level', models.CharField(blank=True, max_length=20, null=True)),
                ('seller_message', models.CharField(blank=True, max_length=50, null=True)),
                ('type', models.CharField(blank=True, max_length=30, null=True)),
                ('reason', models.CharField(blank=True, max_length=50, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('address', models.CharField(blank=True, max_length=50, null=True)),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('cancel_reason', models.CharField(blank=True, max_length=40, null=True)),
                ('capture', models.BooleanField(blank=True, default=True, null=True)),
                ('captured', models.BooleanField(blank=True, null=True)),
                ('complete_payment_url', models.CharField(blank=True, max_length=200, null=True)),
                ('country_code', models.CharField(blank=True, max_length=2, null=True)),
                ('created_at', models.BigIntegerField(blank=True, null=True)),
                ('currency', models.CharField(blank=True, max_length=3, null=True)),
                ('currency_code', models.CharField(blank=True, max_length=3, null=True)),
                ('customer_token', models.CharField(blank=True, max_length=50, null=True)),
                ('destination_card', models.CharField(blank=True, max_length=40, null=True)),
                ('description', models.CharField(blank=True, max_length=40, null=True)),
                ('ending_before', models.CharField(blank=True, max_length=50, null=True)),
                ('error_code', models.CharField(blank=True, max_length=40, null=True)),
                ('error_message', models.CharField(blank=True, max_length=40, null=True)),
                ('error_payment_url', models.CharField(blank=True, max_length=200, null=True)),
                ('escrow_release_days', models.IntegerField(blank=True, null=True)),
                ('ewallet_id', models.CharField(blank=True, max_length=50, null=True)),
                ('ewallets', models.TextField(blank=True, null=True)),
                ('expiration', models.BigIntegerField(blank=True, null=True)),
                ('failure_code', models.CharField(blank=True, max_length=40, null=True)),
                ('failure_message', models.CharField(blank=True, max_length=40, null=True)),
                ('fixed_side', models.CharField(blank=True, max_length=4, null=True)),
                ('flow_type', models.CharField(blank=True, max_length=20, null=True)),
                ('fx_rate', models.CharField(blank=True, max_length=5, null=True)),
                ('group', models.BooleanField(blank=True, default=False, null=True)),
                ('initiation_type', models.CharField(blank=True, max_length=20, null=True)),
                ('instructions', models.TextField(blank=True, null=True)),
                ('invoice', models.CharField(blank=True, max_length=50, null=True)),
                ('is_partial', models.BooleanField(blank=True, null=True)),
                ('limit', models.CharField(blank=True, max_length=3, null=True)),
                ('merchant_defined', models.CharField(blank=True, max_length=20, null=True)),
                ('merchant_reference_id', models.CharField(blank=True, max_length=255, null=True)),
                ('merchant_requested_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('merchant_requested_curency', models.CharField(blank=True, max_length=3, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('mid', models.CharField(blank=True, max_length=3, null=True)),
                ('next_action', models.CharField(blank=True, max_length=20, null=True)),
                ('orders', models.CharField(blank=True, max_length=50, null=True)),
                ('original_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('organization_id', models.CharField(blank=True, max_length=5, null=True)),
                ('paid', models.BooleanField(blank=True, null=True)),
                ('paid_at', models.BigIntegerField(blank=True, null=True)),
                ('payment', models.CharField(blank=True, max_length=50, null=True)),
                ('payment_method', models.CharField(blank=True, max_length=50, null=True)),
                ('payment_method_options', models.JSONField(blank=True, null=True)),
                ('payment_method_type_category', models.CharField(blank=True, max_length=20, null=True)),
                ('receipt_email', models.CharField(blank=True, max_length=50, null=True)),
                ('receipt_number', models.CharField(blank=True, max_length=20, null=True)),
                ('redirect_url', models.CharField(blank=True, max_length=200, null=True)),
                ('refunded', models.BooleanField(blank=True, null=True)),
                ('refund_amount', models.CharField(blank=True, max_length=10, null=True)),
                ('refunded_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('refunds', models.JSONField(blank=True, null=True)),
                ('requested_currency', models.CharField(blank=True, max_length=5, null=True)),
                ('show_intermediate_return_page', models.BooleanField(blank=True, null=True)),
                ('starting_after', models.CharField(blank=True, max_length=5, null=True)),
                ('statement_descriptor', models.CharField(blank=True, max_length=22, null=True)),
                ('status', models.CharField(blank=True, max_length=3, null=True)),
                ('textual_codes', models.JSONField(blank=True, null=True)),
                ('token', models.CharField(blank=True, max_length=50, null=True)),
                ('transaction_id', models.CharField(blank=True, max_length=50, null=True)),
                ('visual_codes', models.JSONField(blank=True, null=True)),
                ('wallets', models.CharField(blank=True, max_length=10, null=True)),
                ('payment_method_type', models.CharField(blank=True, max_length=50, null=True)),
                ('client_details', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.clientdetail')),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.customer')),
                ('dispute', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.dispute')),
                ('escrow', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='escrow', to='collect.escrow')),
                ('group_payment', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.grouppayment')),
                ('outcome', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.outcome')),
            ],
        ),
        migrations.CreateModel(
            name='PaymentMethodData',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False)),
                ('acs_check', models.CharField(blank=True, max_length=15, null=True)),
                ('avs_check', models.CharField(blank=True, max_length=15, null=True)),
                ('authentication_url', models.CharField(blank=True, max_length=80, null=True)),
                ('bit_details', models.JSONField(blank=True, null=True)),
                ('category', models.CharField(blank=True, max_length=20, null=True)),
                ('expiration_month', models.CharField(blank=True, max_length=2, null=True)),
                ('expiration_year', models.CharField(blank=True, max_length=2, null=True)),
                ('fingerprint_token', models.CharField(blank=True, max_length=40, null=True)),
                ('image', models.CharField(blank=True, max_length=80, null=True)),
                ('last4', models.CharField(blank=True, max_length=4, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('network_reference_id', models.CharField(blank=True, max_length=20, null=True)),
                ('next_action', models.CharField(blank=True, max_length=25, null=True)),
                ('type', models.CharField(blank=True, max_length=40, null=True)),
                ('supporting_documentation', models.CharField(blank=True, max_length=20, null=True)),
                ('webhook_url', models.CharField(blank=True, max_length=80, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan',
            fields=[
                ('id', models.CharField(max_length=41, primary_key=True, serialize=False, verbose_name='ID_Plan')),
                ('aggregate_usage', models.CharField(blank=True, max_length=40, null=True)),
                ('amount', models.FloatField(blank=True, null=True)),
                ('billing_scheme', models.CharField(default='per_unit', max_length=40)),
                ('created_at', models.IntegerField()),
                ('currency', models.CharField(max_length=3)),
                ('interval', models.CharField(max_length=40)),
                ('interval_count', models.IntegerField()),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('nickname', models.CharField(max_length=40)),
                ('tiers', models.TextField(blank=True, max_length=40, null=True)),
                ('tiers_mode', models.CharField(max_length=50)),
                ('transform_usage', models.JSONField()),
                ('trial_period_days', models.PositiveIntegerField()),
                ('usage_type', models.CharField(default='licensed', max_length=40)),
            ],
        ),
        migrations.CreateModel(
            name='ProductCollect',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='ID_Product')),
                ('active', models.BooleanField(blank=True, null=True)),
                ('attributes', models.TextField(blank=True, null=True)),
                ('created_at', models.IntegerField(blank=True, null=True)),
                ('description', models.CharField(blank=True, max_length=200, null=True)),
                ('images', models.TextField(blank=True, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('package_dimensions', models.JSONField(blank=True, null=True)),
                ('shippable', models.BooleanField(blank=True, null=True)),
                ('skus', models.TextField(blank=True, null=True)),
                ('statement_descriptor', models.CharField(blank=True, max_length=40, null=True)),
                ('type', models.CharField(blank=True, max_length=10, null=True)),
                ('unit_label', models.CharField(blank=True, max_length=40, null=True)),
                ('updated_at', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Refund',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False)),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('balance_transaction', models.CharField(blank=True, max_length=10, null=True)),
                ('create_at', models.BigIntegerField(blank=True, null=True)),
                ('currency', models.CharField(blank=True, max_length=3, null=True)),
                ('ewallets', models.TextField(blank=True, null=True)),
                ('failure_reason', models.CharField(blank=True, max_length=20, null=True)),
                ('fixed_side', models.CharField(blank=True, max_length=5, null=True)),
                ('fx_rate', models.CharField(blank=True, max_length=20, null=True)),
                ('merchant_reference_id', models.CharField(blank=True, max_length=255, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('merchant_debited_amount', models.CharField(blank=True, max_length=10, null=True)),
                ('merchant_debited_currency', models.CharField(blank=True, max_length=3, null=True)),
                ('payment_created_at', models.BigIntegerField(blank=True, null=True)),
                ('payment_method_type', models.CharField(blank=True, max_length=20, null=True)),
                ('proportional_refund', models.BooleanField(blank=True, null=True)),
                ('reason', models.CharField(blank=True, max_length=40, null=True)),
                ('receipt_number', models.CharField(blank=True, max_length=10, null=True)),
                ('status', models.CharField(blank=True, max_length=10, null=True)),
                ('updated_at', models.BigIntegerField(blank=True, null=True)),
                ('payment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.payment')),
            ],
        ),
        migrations.CreateModel(
            name='ReturnOrder',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='ID_ReturnOrder')),
                ('amount', models.CharField(max_length=15)),
                ('created', models.BigIntegerField()),
                ('currency', models.CharField(blank=True, max_length=3, null=True)),
                ('items', models.JSONField()),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.order')),
                ('refund', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.refund')),
            ],
        ),
        migrations.CreateModel(
            name='SuscriptionCollect',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='ID_Suscription')),
                ('billing', models.CharField(max_length=40)),
                ('billing_cycle_anchor', models.CharField(max_length=40)),
                ('cancel_at_period_end', models.BooleanField(default=False)),
                ('canceled_at', models.IntegerField(blank=True, null=True)),
                ('created_at', models.IntegerField(blank=True, null=True)),
                ('current_period_end', models.IntegerField(blank=True, null=True)),
                ('current_period_start', models.IntegerField(blank=True, null=True)),
                ('customer_token', models.CharField(blank=True, max_length=40, null=True)),
                ('days_until_due', models.IntegerField(blank=True, null=True)),
                ('discount', models.CharField(max_length=40)),
                ('ended_at', models.IntegerField(blank=True, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('payout_fields', models.JSONField(blank=True, null=True)),
                ('payment_fields', models.JSONField(blank=True, null=True)),
                ('payment_method', models.CharField(blank=True, max_length=40, null=True)),
                ('start', models.IntegerField(blank=True, null=True)),
                ('status', models.CharField(max_length=10)),
                ('subscription_items', models.JSONField()),
                ('tax_percent', models.FloatField()),
                ('total_count', models.IntegerField(editable=False)),
                ('trial_end', models.IntegerField(blank=True, null=True)),
                ('trial_from_plan', models.BooleanField(default=False)),
                ('trial_period_days', models.IntegerField(blank=True, null=True)),
                ('trial_start', models.IntegerField(blank=True, null=True)),
                ('type', models.CharField(blank=True, max_length=10, null=True)),
                ('coupon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.coupon')),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.customer')),
            ],
        ),
        migrations.CreateModel(
            name='SuscriptionItem',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='ID_SubscriptionItem')),
                ('created', models.IntegerField(blank=True, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('prorate', models.BooleanField(blank=True, null=True)),
                ('proration_date', models.IntegerField(blank=True, null=True)),
                ('quantity', models.IntegerField(blank=True, null=True)),
                ('plan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.plan')),
                ('subscription', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.suscriptioncollect')),
            ],
        ),
        migrations.CreateModel(
            name='TransactionFee',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('calc_type', models.CharField(blank=True, max_length=10, null=True)),
                ('fee_type', models.CharField(blank=True, max_length=15, null=True)),
                ('value', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='UsageRecord',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='ID_Usage')),
                ('action', models.CharField(blank=True, max_length=10, null=True)),
                ('ending_before', models.IntegerField(blank=True, null=True)),
                ('limit', models.IntegerField(default=10)),
                ('quantity', models.IntegerField()),
                ('starting_after', models.IntegerField(blank=True, null=True)),
                ('timestamp', models.IntegerField(blank=True, null=True)),
                ('subscription_item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.suscriptionitem')),
            ],
        ),
        migrations.CreateModel(
            name='SKU',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='ID_SKU')),
                ('active', models.BooleanField(default=False)),
                ('attributes', models.JSONField(blank=True, null=True)),
                ('created_at', models.IntegerField(blank=True, null=True)),
                ('currency', models.CharField(max_length=3)),
                ('image', models.TextField(blank=True, null=True)),
                ('inventory', models.JSONField()),
                ('metadata', models.JSONField()),
                ('package_dimensions', models.JSONField()),
                ('price', models.FloatField()),
                ('size', models.CharField(blank=True, max_length=50, null=True)),
                ('updated_at', models.IntegerField(blank=True, null=True)),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.productcollect')),
            ],
        ),
        migrations.CreateModel(
            name='ReturnOrderItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(max_length=10)),
                ('amount', models.FloatField()),
                ('currency', models.CharField(max_length=3)),
                ('quantity', models.IntegerField()),
                ('description', models.CharField(max_length=200)),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.sku')),
                ('returnOrder', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.returnorder')),
            ],
        ),
        migrations.AddField(
            model_name='plan',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.productcollect'),
        ),
        migrations.CreateModel(
            name='PaymentMethodType',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('amount_range_per_currency', models.JSONField(blank=True, null=True)),
                ('bin_details', models.JSONField(blank=True, null=True)),
                ('category', models.CharField(blank=True, max_length=100, null=True)),
                ('country', models.CharField(blank=True, max_length=100, null=True)),
                ('currencies', models.JSONField(blank=True, null=True)),
                ('customer', models.CharField(blank=True, max_length=100, null=True)),
                ('fields', models.JSONField(blank=True, null=True)),
                ('fingerprint', models.CharField(blank=True, max_length=100, null=True)),
                ('image', models.CharField(blank=True, max_length=200, null=True)),
                ('is_cancelable', models.BooleanField(blank=True, default=True, null=True)),
                ('is_expirable', models.BooleanField(blank=True, default=True, null=True)),
                ('is_online', models.BooleanField(blank=True, default=True, null=True)),
                ('is_refundable', models.BooleanField(blank=True, default=True, null=True)),
                ('is_tokenizable', models.BooleanField(blank=True, default=True, null=True)),
                ('is_virtual', models.BooleanField(blank=True, default=True, null=True)),
                ('last4', models.CharField(blank=True, max_length=100, null=True)),
                ('maximun_expiration_seconds', models.IntegerField(blank=True, null=True)),
                ('minimun_expiration_seconds', models.IntegerField(blank=True, null=True)),
                ('multiple_overage_allowed', models.BooleanField(blank=True, default=True, null=True)),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('payment_flow_type', models.CharField(blank=True, max_length=100, null=True)),
                ('payment_method_options', models.JSONField(blank=True, null=True)),
                ('payment_options', models.JSONField(blank=True, null=True)),
                ('status', models.IntegerField(blank=True, null=True)),
                ('supported_digital_wallet_providers', models.JSONField(blank=True, null=True)),
                ('type', models.CharField(blank=True, max_length=100, null=True)),
                ('virtual_payment_method_type', models.CharField(blank=True, max_length=100, null=True)),
                ('address', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.address')),
            ],
        ),
        migrations.CreateModel(
            name='PaymentFee',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('gross_fees', models.IntegerField(blank=True, null=True)),
                ('net_fess', models.IntegerField(blank=True, null=True)),
                ('fx_fee', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.fxfee')),
                ('transaction_fee', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.transactionfee')),
            ],
        ),
        migrations.AddField(
            model_name='payment',
            name='payment_fees',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.paymentfee'),
        ),
        migrations.AddField(
            model_name='payment',
            name='payment_method_data',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.paymentmethoddata'),
        ),
        migrations.AddField(
            model_name='order',
            name='payments',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.payment'),
        ),
        migrations.CreateModel(
            name='ItemOrder',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(max_length=10)),
                ('amount', models.FloatField()),
                ('currency', models.CharField(max_length=3)),
                ('quantity', models.IntegerField()),
                ('description', models.CharField(max_length=200)),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.order')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.sku')),
            ],
        ),
        migrations.CreateModel(
            name='InvoiceItem',
            fields=[
                ('id', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='ID_InvoiceItem')),
                ('amount', models.FloatField()),
                ('currency', models.CharField(blank=True, max_length=40, null=True)),
                ('date', models.IntegerField()),
                ('description', models.CharField(blank=True, max_length=200, null=True)),
                ('discountable', models.BooleanField()),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('period', models.JSONField()),
                ('proration', models.BooleanField(blank=True, null=True)),
                ('quantity', models.IntegerField()),
                ('unit_amount', models.FloatField()),
                ('subscription', models.CharField(max_length=40)),
                ('customer', models.CharField(max_length=40)),
                ('invoice', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.invoice')),
                ('plan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.plan')),
            ],
        ),
        migrations.AddField(
            model_name='invoice',
            name='subscription',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='collect.suscriptioncollect'),
        ),
        migrations.CreateModel(
            name='HostedPageCardToken',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('billing_address_collect', models.BooleanField(blank=True, default=True, null=True)),
                ('cancel_url', models.CharField(blank=True, max_length=100, null=True)),
                ('category', models.CharField(blank=True, max_length=100, null=True)),
                ('complete_url', models.CharField(blank=True, max_length=100, null=True)),
                ('country', models.CharField(blank=True, max_length=100, null=True)),
                ('currency', models.CharField(blank=True, max_length=100, null=True)),
                ('error_code', models.CharField(blank=True, max_length=100, null=True)),
                ('language', models.CharField(blank=True, max_length=100, null=True)),
                ('merchant_alias', models.CharField(blank=True, max_length=100, null=True)),
                ('merchant_color', models.CharField(blank=True, max_length=100, null=True)),
                ('merchant_customer_support', models.JSONField(blank=True, null=True)),
                ('merchant_logo', models.CharField(blank=True, max_length=100, null=True)),
                ('merchant_website', models.CharField(blank=True, max_length=100, null=True)),
                ('page_expiration', models.IntegerField(blank=True, null=True)),
                ('payment_method_type', models.CharField(blank=True, max_length=100, null=True)),
                ('payment_params', models.JSONField(blank=True, null=True)),
                ('redirect_url', models.CharField(blank=True, max_length=100, null=True)),
                ('status', models.CharField(blank=True, max_length=100, null=True)),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.customer')),
            ],
        ),
        migrations.CreateModel(
            name='Discount',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('coupon', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.coupon')),
            ],
        ),
        migrations.CreateModel(
            name='CustomerPaymentMethod',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('category', models.CharField(blank=True, max_length=100, null=True)),
                ('customer', models.CharField(blank=True, max_length=200, null=True)),
                ('deleted', models.BooleanField(blank=True, default=True, null=True)),
                ('ending_before', models.CharField(blank=True, max_length=100, null=True)),
                ('error_code', models.CharField(blank=True, max_length=100, null=True)),
                ('fields', models.JSONField(blank=True, null=True)),
                ('image', models.CharField(blank=True, max_length=100, null=True)),
                ('limit', models.CharField(blank=True, max_length=100, null=True)),
                ('metadata', models.JSONField(blank=True, null=True)),
                ('network_referenci_id', models.CharField(blank=True, max_length=100, null=True)),
                ('next_action', models.CharField(blank=True, max_length=100, null=True)),
                ('payment_methods', models.CharField(blank=True, max_length=100, null=True)),
                ('redirect_url', models.CharField(blank=True, max_length=100, null=True)),
                ('starting_after', models.CharField(blank=True, max_length=100, null=True)),
                ('supporting_documentation', models.CharField(blank=True, max_length=100, null=True)),
                ('token', models.CharField(blank=True, max_length=100, null=True)),
                ('types', models.CharField(blank=True, max_length=100, null=True)),
                ('webhook_url', models.CharField(blank=True, max_length=100, null=True)),
                ('address', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.address')),
            ],
        ),
        migrations.CreateModel(
            name='CardToCard',
            fields=[
                ('id', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('billing_address_collect', models.BooleanField(blank=True, null=True)),
                ('cancel_url', models.CharField(blank=True, max_length=80, null=True)),
                ('complete_payment_url', models.CharField(blank=True, max_length=80, null=True)),
                ('complete_url', models.CharField(blank=True, max_length=80, null=True)),
                ('country', django_countries.fields.CountryField(blank=True, max_length=2, null=True)),
                ('currency', models.CharField(blank=True, max_length=3, null=True)),
                ('customer_addresses', models.TextField(blank=True, null=True)),
                ('language', models.CharField(blank=True, max_length=20, null=True)),
                ('merchant_alias', models.CharField(blank=True, max_length=20, null=True)),
                ('merchant_color', models.CharField(blank=True, max_length=10, null=True)),
                ('merchant_customer_support', models.JSONField(blank=True, null=True)),
                ('merchant_logo', models.CharField(blank=True, max_length=80, null=True)),
                ('merchant_website', models.CharField(blank=True, max_length=15, null=True)),
                ('page_expiration', models.BigIntegerField(blank=True, null=True)),
                ('payment_method', models.CharField(blank=True, max_length=20, null=True)),
                ('payment_method_type', models.CharField(blank=True, max_length=20, null=True)),
                ('payment_method_params', models.JSONField(blank=True, null=True)),
                ('redirect_url', models.CharField(blank=True, max_length=80, null=True)),
                ('status', models.CharField(blank=True, max_length=5, null=True)),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='collect.customer')),
            ],
        ),
    ]
