from dataclasses import dataclass, field
from typing import Mapping

@dataclass(frozen=True)
class ProteinDefaults():
    alphabet: frozenset[str] = frozenset("ACDEFGHIKLMNPQRSTVWY")
    classes: Mapping[str, frozenset[str]] = field(default_factory=lambda:{
        "+":frozenset("RHK"),
        "-":frozenset("ED"),
        "polar":frozenset("NSCTQ"),
        "nonpolar":frozenset("MALIVGP"),
        "aromatic":frozenset("FYW"),
        "other":frozenset("")
    })
    flags = dict()

    def get_alphabet(self):
        return self.alphabet

    def get_classes(self):
        return self.classes
