from .residue_generator import ResidueGenerator
from .protein_specs import ProteinClassifier
from .protein_constraints import ProteinConstraints

class ProteinGenerator(ResidueGenerator):
    def __init__(self, classifier:ProteinClassifier|None = None):
        if classifier is None:
            super().__init__(ProteinClassifier())
        else:
            super().__init__(classifier)

    def get_classifier(self):
        return self.classifier

    def generate(self, length:int, k:int=1, constraints:ProteinConstraints=ProteinConstraints()):
        return super().generate(length=length, k=k, constraints=constraints)

