from .polymer_specs import PolymerClassifier
from .defaults.protein_defaults import ProteinDefaults
from dataclasses import dataclass, field
from typing import Mapping

class ProteinClassifier(PolymerClassifier):
    def __init__(self, alphabet: str | list | set = None):
        ab = self.get_default_alphabet() if alphabet is None else alphabet
        # cs = self.get_default_classes() if classes is None else classes
        # fl = self.default_flags() if flags is None else flags
        super().__init__(ab)

    def get_default_alphabet(self):
        return ProteinDefaults().get_alphabet()

    def get_default_classes(self):
        return ProteinDefaults().get_classes()

    def set_default_alphabet(self):
        self.alphabet = ProteinDefaults().get_alphabet()

    def set_default_classes(self):
        self.classes = ProteinDefaults().get_classes()



    # def default_flags(self):
    #     self.flags =ProteinDefaults.flags




