"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake snowflake}
*/
class SnowflakeProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake snowflake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnowflakeProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.41.0',
                providerVersionConstraint: ' ~> 0.40'
            },
            terraformProviderSource: 'Snowflake-Labs/snowflake'
        });
        this._account = config.account;
        this._browserAuth = config.browserAuth;
        this._host = config.host;
        this._oauthAccessToken = config.oauthAccessToken;
        this._oauthClientId = config.oauthClientId;
        this._oauthClientSecret = config.oauthClientSecret;
        this._oauthEndpoint = config.oauthEndpoint;
        this._oauthRedirectUrl = config.oauthRedirectUrl;
        this._oauthRefreshToken = config.oauthRefreshToken;
        this._password = config.password;
        this._privateKey = config.privateKey;
        this._privateKeyPassphrase = config.privateKeyPassphrase;
        this._privateKeyPath = config.privateKeyPath;
        this._region = config.region;
        this._role = config.role;
        this._username = config.username;
        this._warehouse = config.warehouse;
        this._alias = config.alias;
    }
    get account() {
        return this._account;
    }
    set account(value) {
        this._account = value;
    }
    // Temporarily expose input value. Use with caution.
    get accountInput() {
        return this._account;
    }
    get browserAuth() {
        return this._browserAuth;
    }
    set browserAuth(value) {
        this._browserAuth = value;
    }
    resetBrowserAuth() {
        this._browserAuth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get browserAuthInput() {
        return this._browserAuth;
    }
    get host() {
        return this._host;
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get oauthAccessToken() {
        return this._oauthAccessToken;
    }
    set oauthAccessToken(value) {
        this._oauthAccessToken = value;
    }
    resetOauthAccessToken() {
        this._oauthAccessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthAccessTokenInput() {
        return this._oauthAccessToken;
    }
    get oauthClientId() {
        return this._oauthClientId;
    }
    set oauthClientId(value) {
        this._oauthClientId = value;
    }
    resetOauthClientId() {
        this._oauthClientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthClientIdInput() {
        return this._oauthClientId;
    }
    get oauthClientSecret() {
        return this._oauthClientSecret;
    }
    set oauthClientSecret(value) {
        this._oauthClientSecret = value;
    }
    resetOauthClientSecret() {
        this._oauthClientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthClientSecretInput() {
        return this._oauthClientSecret;
    }
    get oauthEndpoint() {
        return this._oauthEndpoint;
    }
    set oauthEndpoint(value) {
        this._oauthEndpoint = value;
    }
    resetOauthEndpoint() {
        this._oauthEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthEndpointInput() {
        return this._oauthEndpoint;
    }
    get oauthRedirectUrl() {
        return this._oauthRedirectUrl;
    }
    set oauthRedirectUrl(value) {
        this._oauthRedirectUrl = value;
    }
    resetOauthRedirectUrl() {
        this._oauthRedirectUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthRedirectUrlInput() {
        return this._oauthRedirectUrl;
    }
    get oauthRefreshToken() {
        return this._oauthRefreshToken;
    }
    set oauthRefreshToken(value) {
        this._oauthRefreshToken = value;
    }
    resetOauthRefreshToken() {
        this._oauthRefreshToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthRefreshTokenInput() {
        return this._oauthRefreshToken;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get privateKey() {
        return this._privateKey;
    }
    set privateKey(value) {
        this._privateKey = value;
    }
    resetPrivateKey() {
        this._privateKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyInput() {
        return this._privateKey;
    }
    get privateKeyPassphrase() {
        return this._privateKeyPassphrase;
    }
    set privateKeyPassphrase(value) {
        this._privateKeyPassphrase = value;
    }
    resetPrivateKeyPassphrase() {
        this._privateKeyPassphrase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyPassphraseInput() {
        return this._privateKeyPassphrase;
    }
    get privateKeyPath() {
        return this._privateKeyPath;
    }
    set privateKeyPath(value) {
        this._privateKeyPath = value;
    }
    resetPrivateKeyPath() {
        this._privateKeyPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyPathInput() {
        return this._privateKeyPath;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get role() {
        return this._role;
    }
    set role(value) {
        this._role = value;
    }
    resetRole() {
        this._role = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    get username() {
        return this._username;
    }
    set username(value) {
        this._username = value;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    get warehouse() {
        return this._warehouse;
    }
    set warehouse(value) {
        this._warehouse = value;
    }
    resetWarehouse() {
        this._warehouse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get warehouseInput() {
        return this._warehouse;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account: cdktf.stringToTerraform(this._account),
            browser_auth: cdktf.booleanToTerraform(this._browserAuth),
            host: cdktf.stringToTerraform(this._host),
            oauth_access_token: cdktf.stringToTerraform(this._oauthAccessToken),
            oauth_client_id: cdktf.stringToTerraform(this._oauthClientId),
            oauth_client_secret: cdktf.stringToTerraform(this._oauthClientSecret),
            oauth_endpoint: cdktf.stringToTerraform(this._oauthEndpoint),
            oauth_redirect_url: cdktf.stringToTerraform(this._oauthRedirectUrl),
            oauth_refresh_token: cdktf.stringToTerraform(this._oauthRefreshToken),
            password: cdktf.stringToTerraform(this._password),
            private_key: cdktf.stringToTerraform(this._privateKey),
            private_key_passphrase: cdktf.stringToTerraform(this._privateKeyPassphrase),
            private_key_path: cdktf.stringToTerraform(this._privateKeyPath),
            region: cdktf.stringToTerraform(this._region),
            role: cdktf.stringToTerraform(this._role),
            username: cdktf.stringToTerraform(this._username),
            warehouse: cdktf.stringToTerraform(this._warehouse),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.SnowflakeProvider = SnowflakeProvider;
_a = JSII_RTTI_SYMBOL_1;
SnowflakeProvider[_a] = { fqn: "@cdktf/provider-snowflake.SnowflakeProvider", version: "2.0.29" };
// =================
// STATIC PROPERTIES
// =================
SnowflakeProvider.tfResourceType = "snowflake";
//# sourceMappingURL=data:application/json;base64,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