# mypy-boto3-databrew

[![PyPI - mypy-boto3-databrew](https://img.shields.io/pypi/v/mypy-boto3-databrew.svg?color=blue)](https://pypi.org/project/mypy-boto3-databrew)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-databrew.svg?color=blue)](https://pypi.org/project/mypy-boto3-databrew)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.GlueDataBrew 1.16.52](https://boto3.amazonaws.com/v1/documentation/api/1.16.52/reference/services/databrew.html#GlueDataBrew) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-databrew](#mypy-boto3-databrew)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `GlueDataBrew` service.

```bash
python -m pip install boto3-stubs[databrew]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[databrew]` in your environment: `python -m pip install 'boto3-stubs[databrew]'`

Both type checking and auto-complete should work for `GlueDataBrew` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[databrew]` in your environment: `python -m pip install 'boto3-stubs[databrew]'`

Both type checking and auto-complete should work for `GlueDataBrew` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[databrew]` in your environment: `python -m pip install 'boto3-stubs[databrew]'`
- Run `mypy` as usual

Type checking should work for `GlueDataBrew` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[databrew]` in your environment: `python -m pip install 'boto3-stubs[databrew]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `GlueDataBrew` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`GlueDataBrewClient` provides annotations for `boto3.client("databrew")`.

```python
import boto3

from mypy_boto3_databrew import GlueDataBrewClient

client: GlueDataBrewClient = boto3.client("databrew")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: GlueDataBrewClient = session.client("databrew")
```

### Paginators annotations

`mypy_boto3_databrew.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_databrew import GlueDataBrewClient
from mypy_boto3_databrew.paginator import (
    ListDatasetsPaginator,
    ListJobRunsPaginator,
    ListJobsPaginator,
    ListProjectsPaginator,
    ListRecipesPaginator,
    ListRecipeVersionsPaginator,
    ListSchedulesPaginator,
)

client: GlueDataBrewClient = boto3.client("databrew")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_datasets_paginator: ListDatasetsPaginator = client.get_paginator("list_datasets")
list_job_runs_paginator: ListJobRunsPaginator = client.get_paginator("list_job_runs")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
list_projects_paginator: ListProjectsPaginator = client.get_paginator("list_projects")
list_recipe_versions_paginator: ListRecipeVersionsPaginator = client.get_paginator("list_recipe_versions")
list_recipes_paginator: ListRecipesPaginator = client.get_paginator("list_recipes")
list_schedules_paginator: ListSchedulesPaginator = client.get_paginator("list_schedules")
```







### Typed dictionations

`mypy_boto3_databrew.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_databrew.type_defs import (
    BatchDeleteRecipeVersionResponseTypeDef,
    ConditionExpressionTypeDef,
    CreateDatasetResponseTypeDef,
    CreateProfileJobResponseTypeDef,
    CreateProjectResponseTypeDef,
    CreateRecipeJobResponseTypeDef,
    CreateRecipeResponseTypeDef,
    CreateScheduleResponseTypeDef,
    DataCatalogInputDefinitionTypeDef,
    DatasetTypeDef,
    DeleteDatasetResponseTypeDef,
    DeleteJobResponseTypeDef,
    DeleteProjectResponseTypeDef,
    DeleteRecipeVersionResponseTypeDef,
    DeleteScheduleResponseTypeDef,
    DescribeDatasetResponseTypeDef,
    DescribeJobResponseTypeDef,
    DescribeProjectResponseTypeDef,
    DescribeRecipeResponseTypeDef,
    DescribeScheduleResponseTypeDef,
    ExcelOptionsTypeDef,
    FormatOptionsTypeDef,
    InputTypeDef,
    JobRunTypeDef,
    JobTypeDef,
    JsonOptionsTypeDef,
    ListDatasetsResponseTypeDef,
    ListJobRunsResponseTypeDef,
    ListJobsResponseTypeDef,
    ListProjectsResponseTypeDef,
    ListRecipesResponseTypeDef,
    ListRecipeVersionsResponseTypeDef,
    ListSchedulesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    OutputTypeDef,
    PaginatorConfigTypeDef,
    ProjectTypeDef,
    PublishRecipeResponseTypeDef,
    RecipeActionTypeDef,
    RecipeReferenceTypeDef,
    RecipeStepTypeDef,
    RecipeTypeDef,
    RecipeVersionErrorDetailTypeDef,
    ResponseMetadata,
    S3LocationTypeDef,
    SampleTypeDef,
    ScheduleTypeDef,
    SendProjectSessionActionResponseTypeDef,
    StartJobRunResponseTypeDef,
    StartProjectSessionResponseTypeDef,
    StopJobRunResponseTypeDef,
    UpdateDatasetResponseTypeDef,
    UpdateProfileJobResponseTypeDef,
    UpdateProjectResponseTypeDef,
    UpdateRecipeJobResponseTypeDef,
    UpdateRecipeResponseTypeDef,
    UpdateScheduleResponseTypeDef,
    ViewFrameTypeDef,
)

def get_structure() -> ConditionExpressionTypeDef:
    return {
      ...
    }
```
