# Generated by Django 2.2.5 on 2019-10-06 13:39

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Backend',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('messenger', models.CharField(choices=[('SimplePrintMessenger', 'SimplePrintMessenger'), ('SimplePrintMessengerTemplateBased', 'SimplePrintMessengerTemplateBased'), ('SMTPEmailMessenger', 'SMTPEmailMessenger'), ('TelegramBotMessenger', 'TelegramBotMessenger'), ('NewMessenger', 'NewMessenger'), ('InsitMessagingMessenger', 'InsitMessagingMessenger')], default='BaseMessanger', max_length=128)),
                ('message_template', models.CharField(choices=[('BaseMessageTemplate', 'BaseMessageTemplate'), ('SimplePrintMessageTemplate', 'SimplePrintMessageTemplate'), ('SimpleEmailMessageTemplate', 'SimpleEmailMessageTemplate'), ('SimpleTelegramMessageTemplate1', 'SimpleTelegramMessageTemplate1'), ('SimpleTelegramMessageTemplate2', 'SimpleTelegramMessageTemplate2'), ('NewMessageTemplate', 'NewMessageTemplate')], default='BaseMessageTemplate', max_length=128)),
            ],
        ),
        migrations.CreateModel(
            name='TestModel1',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('extra_field', models.CharField(blank=True, default='', max_length=20, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TestModel2',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('extra_field', models.CharField(blank=True, default='', max_length=20, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Trigger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('verb', models.CharField(db_index=True, max_length=128)),
                ('action_object_id', models.CharField(blank=True, db_index=True, max_length=255, null=True)),
                ('actor_object_id', models.CharField(blank=True, db_index=True, max_length=255, null=True)),
                ('target', models.CharField(blank=True, db_index=True, max_length=128, null=True)),
                ('action_object_content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='action_object', to='contenttypes.ContentType')),
                ('actor_object_content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='actor_object', to='contenttypes.ContentType')),
            ],
        ),
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enabled', models.BooleanField(default=True, help_text="If It's disabled, Subscription will be ignored")),
                ('backends', models.ManyToManyField(blank=True, help_text='Backend that specified for this subscription.\n Important: Make sure that this backend message_template content can be adaptable to the trigger context', to='django_signal_notifier.Backend', verbose_name='Backend')),
                ('receiver_groups', models.ManyToManyField(blank=True, help_text='Groups that are related to this subscription.', to='auth.Group', verbose_name='Receiver_Groups')),
                ('receiver_users', models.ManyToManyField(blank=True, help_text='Users that are related to this subscription.', to=settings.AUTH_USER_MODEL, verbose_name='Receiver_Users')),
                ('trigger', models.ForeignKey(help_text='A Trigger that is related to this subscription.', on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to='django_signal_notifier.Trigger')),
            ],
        ),
        migrations.CreateModel(
            name='DSN_Profile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('telegram_chat_id', models.CharField(blank=True, max_length=20, null=True)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
