"use strict";
const assert_1 = require("@aws-cdk/assert");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const cpactions = require("../lib");
module.exports = {
    'manual approval Action': {
        'allows passing an SNS Topic when constructing it'(test) {
            const stack = new core_1.Stack();
            const topic = new sns.Topic(stack, 'Topic');
            const manualApprovalAction = new cpactions.ManualApprovalAction({
                actionName: 'Approve',
                notificationTopic: topic,
            });
            const pipeline = new codepipeline.Pipeline(stack, 'pipeline');
            const stage = pipeline.addStage({ stageName: 'stage' });
            stage.addAction(manualApprovalAction);
            test.equal(manualApprovalAction.notificationTopic, topic);
            test.done();
        },
        'renders CustomData and ExternalEntityLink even if notificationTopic was not passed'(test) {
            const stack = new core_1.Stack();
            new codepipeline.Pipeline(stack, 'pipeline', {
                stages: [
                    {
                        stageName: 'Source',
                        actions: [new cpactions.GitHubSourceAction({
                                actionName: 'Source',
                                output: new codepipeline.Artifact(),
                                oauthToken: core_1.SecretValue.plainText('secret'),
                                owner: 'aws',
                                repo: 'aws-cdk',
                            })],
                    },
                    {
                        stageName: 'Approve',
                        actions: [
                            new cpactions.ManualApprovalAction({
                                actionName: 'Approval',
                                additionalInformation: 'extra info',
                                externalEntityLink: 'external link',
                            }),
                        ],
                    },
                ],
            });
            assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::CodePipeline::Pipeline', {
                'Stages': [
                    {
                        'Name': 'Source',
                    },
                    {
                        'Name': 'Approve',
                        'Actions': [
                            {
                                'Name': 'Approval',
                                'Configuration': {
                                    'CustomData': 'extra info',
                                    'ExternalEntityLink': 'external link',
                                },
                            },
                        ],
                    },
                ],
            }));
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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