import * as ec2 from '@aws-cdk/aws-ec2';
import * as eks from '@aws-cdk/aws-eks';
import * as iam from '@aws-cdk/aws-iam';
import { StackProps, Construct, Resource, ResourceProps } from '@aws-cdk/core';
import { ILaunchtemplate } from './launch-template';
/**
 * @experimental
 */
export declare enum BlockDuration {
    /**
     * @experimental
     */
    ONE_HOUR = 60,
    /**
     * @experimental
     */
    TWO_HOURS = 120,
    /**
     * @experimental
     */
    THREE_HOURS = 180,
    /**
     * @experimental
     */
    FOUR_HOURS = 240,
    /**
     * @experimental
     */
    FIVE_HOURS = 300,
    /**
     * @experimental
     */
    SIX_HOURS = 360
}
/**
 * @experimental
 */
export declare enum InstanceInterruptionBehavior {
    /**
     * @experimental
     */
    HIBERNATE = "hibernate",
    /**
     * @experimental
     */
    STOP = "stop",
    /**
     * @experimental
     */
    TERMINATE = "terminate"
}
/**
 * @experimental
 */
export interface EksSpotClusterProps extends StackProps {
    /**
     * @experimental
     */
    readonly clusterAttributes?: eks.ClusterAttributes;
    /**
     * @experimental
     */
    readonly clusterVersion: eks.KubernetesVersion;
    /**
     * @experimental
     */
    readonly instanceRole?: iam.IRole;
    /**
     * @experimental
     */
    readonly instanceInterruptionBehavior?: InstanceInterruptionBehavior;
    /**
     * @experimental
     */
    readonly kubectlEnabled?: boolean;
    /**
     * (experimental) Specify a custom AMI ID for your spot fleet.
     *
     * By default the Amazon EKS-optimized
     * AMI will be selected.
     *
     * @default - none
     * @experimental
     */
    readonly customAmiId?: string;
}
/**
 * @experimental
 */
export declare class EksSpotCluster extends Resource {
    /**
     * @experimental
     */
    readonly cluster: eks.Cluster;
    /**
     * @experimental
     */
    readonly clusterVersion: eks.KubernetesVersion;
    /**
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EksSpotClusterProps);
    /**
     * @experimental
     */
    addSpotFleet(id: string, props: BaseSpotFleetProps): void;
    /**
     * @experimental
     */
    addDays(date: Date, days: number): Date;
    /**
     * @experimental
     */
    addHours(date: Date, hours: number): Date;
    /**
     * @experimental
     */
    addMinutes(date: Date, minutes: number): Date;
}
/**
 * @experimental
 */
export interface BaseSpotFleetProps extends ResourceProps {
    /**
     * @experimental
     */
    readonly defaultInstanceType?: ec2.InstanceType;
    /**
     * @experimental
     */
    readonly blockDuration?: BlockDuration;
    /**
     * @experimental
     */
    readonly instanceInterruptionBehavior?: InstanceInterruptionBehavior;
    /**
     * @experimental
     */
    readonly instanceRole?: iam.Role;
    /**
     * @experimental
     */
    readonly targetCapacity?: number;
    /**
     * @experimental
     */
    readonly mapRole?: boolean;
    /**
     * @experimental
     */
    readonly bootstrapEnabled?: boolean;
    /**
     * @experimental
     */
    readonly validFrom?: string;
    /**
     * @experimental
     */
    readonly validUntil?: string;
    /**
     * @experimental
     */
    readonly terminateInstancesWithExpiration?: boolean;
    /**
     * @experimental
     */
    readonly customAmiId?: string;
}
/**
 * @experimental
 */
export interface SpotFleetProps extends BaseSpotFleetProps {
    /**
     * @experimental
     */
    readonly cluster: EksSpotCluster;
    /**
     * @experimental
     */
    readonly launchTemplate?: ILaunchtemplate;
}
/**
 * @experimental
 */
export declare class SpotFleet extends Resource {
    /**
     * @experimental
     */
    readonly instanceRole: iam.IRole;
    /**
     * @experimental
     */
    readonly clusterStack: EksSpotCluster;
    /**
     * @experimental
     */
    readonly defaultInstanceType: ec2.InstanceType;
    /**
     * @experimental
     */
    readonly targetCapacity?: number;
    /**
     * @experimental
     */
    readonly spotFleetId: string;
    /**
     * @experimental
     */
    readonly launchTemplate: ILaunchtemplate;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SpotFleetProps);
}
