# -*- coding: utf-8 -*-
# 通联数据机密
# --------------------------------------------------------------------
# 通联数据股份公司版权所有 © 2013-2019
#
# 注意：本文所载所有信息均属于通联数据股份公司资产。本文所包含的知识和技术概念均属于
# 通联数据产权，并可能由中国、美国和其他国家专利或申请中的专利所覆盖，并受商业秘密或
# 版权法保护。
# 除非事先获得通联数据股份公司书面许可，严禁传播文中信息或复制本材料。
#
# DataYes CONFIDENTIAL
# --------------------------------------------------------------------
# Copyright © 2013-2019 DataYes, All Rights Reserved.
#
# NOTICE: All information contained herein is the property of DataYes
# Incorporated. The intellectual and technical concepts contained herein are
# proprietary to DataYes Incorporated, and may be covered by China, U.S. and
# Other Countries Patents, patents in process, and are protected by trade
# secret or copyright law.
# Dissemination of this information or reproduction of this material is
# strictly forbidden unless prior written permission is obtained from DataYes.

from . import api_base
try:
    from StringIO import StringIO
except:
    from io import StringIO
import pandas as pd
import sys
from datetime import datetime
from .api_base import get_cache_key, get_data_from_cache, put_data_in_cache, pretty_traceback
import inspect
try:
    unicode
except:
    unicode = str

__doc__="通联数据"
def __SysCodeNewGet(codeTypeID = "", useType = "", valueCD = "", field = "", pandas = "1"):
    """
    各api接口有枚举值特性的输出列，如getSecID输出项exchangeCD值，编码分别代表的是什么市场，所有枚举值都可以在这个接口获取。
    
    :param codeTypeID: 输入获知的参数分类ID，可以查询到这个参数分类下所有枚举值，非必须输入项,可以是列表,可空
    :param useType: 输入获知的参数取用列名,可以查询到有该类编码的所有枚举值,非必须输入项,可以是列表,可空
    :param valueCD: 输入获知的参数下常量值，可以查询到这个常量值的说明，非必须输入项,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSysCodeNew.csv?ispandas=1&') 
    requestString.append("codeTypeID=")
    if hasattr(codeTypeID,'__iter__') and not isinstance(codeTypeID, str):
        if len(codeTypeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = codeTypeID
            requestString.append(None)
        else:
            requestString.append(','.join(codeTypeID))
    else:
        requestString.append(codeTypeID)
    requestString.append("&useType=")
    if hasattr(useType,'__iter__') and not isinstance(useType, str):
        if len(useType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = useType
            requestString.append(None)
        else:
            requestString.append(','.join(useType))
    else:
        requestString.append(useType)
    requestString.append("&valueCD=")
    if hasattr(valueCD,'__iter__') and not isinstance(valueCD, str):
        if len(valueCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = valueCD
            requestString.append(None)
        else:
            requestString.append(','.join(valueCD))
    else:
        requestString.append(valueCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__SysCodeNewGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__SysCodeNewGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'codeTypeID', u'useType', u'valueCD', u'valueName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'useType': 'str','valueCD': 'str','valueName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __TypeDescriptionGet(typeID = "", typeName = "", isNew = "", industry = "", field = "", pandas = "1"):
    """
    获取各级分类的行业简介。
    
    :param typeID: 分类代码,可以是列表,typeID、typeName至少选择一个
    :param typeName: 分类名称,可以是列表,typeID、typeName至少选择一个
    :param isNew: 是否最新,可以是列表,可空
    :param industry: 所属行业分类标准,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getTypeDescription.csv?ispandas=1&') 
    requestString.append("typeID=")
    if hasattr(typeID,'__iter__') and not isinstance(typeID, str):
        if len(typeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeID
            requestString.append(None)
        else:
            requestString.append(','.join(typeID))
    else:
        requestString.append(typeID)
    requestString.append("&typeName=")
    if hasattr(typeName,'__iter__') and not isinstance(typeName, str):
        if len(typeName) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeName
            requestString.append(None)
        else:
            requestString.append(','.join(typeName))
    else:
        requestString.append(typeName)
    requestString.append("&isNew=")
    if hasattr(isNew,'__iter__') and not isinstance(isNew, str):
        if len(isNew) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = isNew
            requestString.append(None)
        else:
            requestString.append(','.join(isNew))
    else:
        requestString.append(isNew)
    requestString.append("&industry=")
    if hasattr(industry,'__iter__') and not isinstance(industry, str):
        if len(industry) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industry
            requestString.append(None)
        else:
            requestString.append(','.join(industry))
    else:
        requestString.append(industry)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__TypeDescriptionGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__TypeDescriptionGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'typeName', u'isNew', u'industry', u'description', u'descriptionEn', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','typeName': 'str','industry': 'str','description': 'str','descriptionEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def PartyIDGet(partyID = "", partyName = "", field = "", pandas = "1"):
    """
    输入一个或多个机构名称，获取机构ID，机构在数据结构中的一个唯一识别的编码（含科创板）。
    
    :param partyID: 通联编制的发行机构代码。,可以是列表,partyID、partyName至少选择一个
    :param partyName: 输入一个机构名称，如"平安银行"。支持模糊查询。,partyID、partyName至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getPartyID.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    if not isinstance(partyName, str) and not isinstance(partyName, unicode):
        partyName = str(partyName)

    requestString.append("&partyName=%s"%(partyName))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'PartyIDGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'PartyIDGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'partyFullNameEn', u'partyShortName', u'partyShortNameEn', u'officeAddr', u'primeOperating', u'partyNatureCD', u'instStatus', u'isIssBond']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','partyFullNameEn': 'str','partyShortName': 'str','partyShortNameEn': 'str','officeAddr': 'str','primeOperating': 'str','partyNatureCD': 'str','isIssBond': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecHaltGet(secID = "", ticker = "", beginDate = "", endDate = "", listStatusCD = "", assetClass = "", field = "", pandas = "1"):
    """
    输入证券ID或证券交易代码，获取证券停牌起始时间、截止时间。也可以根据日期范围查询出在这段时间内持续停牌的证券，例如起始日期、结束日期设置为同一天，可以查询出当天停牌的所有证券。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 证券交易代码，如'000001',可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 按停牌日期查询的起始日期，输入格式“YYYYMMDD”。例：输入‘20190409’，返回在2019年4月9日及之后处于停牌状态的证券。,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 按停牌日期查询的截止日期，输入格式“YYYYMMDD”。例：输入日期‘20190409’，返回在2019年4月9日及之前存在停牌的证券。若无输入值，默认获取从数据开始日期到现在所有存在过的停牌记录。,secID、ticker、beginDate、endDate至少选择一个
    :param listStatusCD: 上市状态。L-上市；S-暂停；DE-终止上市；UN-未上市。,可以是列表,可空
    :param assetClass: 通联编制的证券类别编码。例如，E-股票；B-债券；F-基金；FU-期货等。可以使用DataAPI.SysCodeGet接口获取所有取值，codeTypeID=10001。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecHalt.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&listStatusCD=")
    if hasattr(listStatusCD,'__iter__') and not isinstance(listStatusCD, str):
        if len(listStatusCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = listStatusCD
            requestString.append(None)
        else:
            requestString.append(','.join(listStatusCD))
    else:
        requestString.append(listStatusCD)
    requestString.append("&assetClass=")
    if hasattr(assetClass,'__iter__') and not isinstance(assetClass, str):
        if len(assetClass) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = assetClass
            requestString.append(None)
        else:
            requestString.append(','.join(assetClass))
    else:
        requestString.append(assetClass)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SecHaltGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SecHaltGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'haltBeginTime', u'haltEndTime', u'ticker', u'secShortName', u'exchangeCD', u'listStatusCD', u'delistDate', u'assetClass']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','haltBeginTime': 'str','haltEndTime': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','listStatusCD': 'str','assetClass': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecIDGet(partyID = "", ticker = "", cnSpell = "", assetClass = "", exchangeCD = "", listStatusCD = "", field = "", pandas = "1"):
    """
    输入一个或多个证券交易代码，获取证券ID，证券在数据结构中的一个唯一识别的编码；同时可以获取输入证券的基本上市信息，如交易市场，上市状态，交易币种，ISIN编码等（含科创板）。
    
    :param partyID: 机构ID，assetClass为股票和债券时，是发行人的机构ID；assetClass为基金时，是基金管理人的机构ID；assetClass为指数时，是指数发布机构ID。,可以是列表,partyID、ticker、cnSpell、assetClass至少选择一个
    :param ticker: 证券在交易所的交易代码，可输入一个或多个，用","分隔，如"000001"、"000001,600001"。,可以是列表,partyID、ticker、cnSpell、assetClass至少选择一个
    :param cnSpell: 通过输入证券简称拼音的方式，获取证券交易代码等信息，拼音以使用汉字拼音首位连接，如“平安银行”，即“PAYH”。,可以是列表,partyID、ticker、cnSpell、assetClass至少选择一个
    :param assetClass: 证券类型，可供选择类型：E 股票,B 债券,F 基金,IDX 指数,FU 期货,OP 期权；默认为 E。,partyID、ticker、cnSpell、assetClass至少选择一个
    :param exchangeCD: 交易市场,可以是列表,可空
    :param listStatusCD: 上市状态：L-上市，S-暂停，DE-终止上市，UN-未上市。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecID.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&cnSpell=")
    if hasattr(cnSpell,'__iter__') and not isinstance(cnSpell, str):
        if len(cnSpell) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = cnSpell
            requestString.append(None)
        else:
            requestString.append(','.join(cnSpell))
    else:
        requestString.append(cnSpell)
    if not isinstance(assetClass, str) and not isinstance(assetClass, unicode):
        assetClass = str(assetClass)

    requestString.append("&assetClass=%s"%(assetClass))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&listStatusCD=")
    if hasattr(listStatusCD,'__iter__') and not isinstance(listStatusCD, str):
        if len(listStatusCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = listStatusCD
            requestString.append(None)
        else:
            requestString.append(','.join(listStatusCD))
    else:
        requestString.append(listStatusCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SecIDGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SecIDGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'cnSpell', u'exchangeCD', u'assetClass', u'listStatusCD', u'listDate', u'transCurrCD', u'ISIN', u'partyID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','cnSpell': 'str','exchangeCD': 'str','assetClass': 'str','listStatusCD': 'str','transCurrCD': 'str','ISIN': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTradeTimeGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取期货合约在上市交易场所的交易时间。默认查看过去1年。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 证券交易代码，如'000001',可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，默认当前日期加1年，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecTradeTime.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SecTradeTimeGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SecTradeTimeGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'tradeDate', u'tradeTime', u'ticker', u'secShortName', u'exchangeCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','tradeTime': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def TradeCalGet(exchangeCD, beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    记录了上海证券交易所，深圳证券交易所，中国银行间市场，大连商品交易所，郑州商品交易所，上海期货交易所，中国金融期货交易所和香港交易所等交易所在日历日期当天是否开市的信息，其中上证、深证记录了自成立以来的全部日期是否开始信息。各交易日节假日安排通知发布当天即更新数据。
    
    :param exchangeCD: 证券交易所。可选：XSHG，XSHE，CCFX，XDCE，XSGE，XZCE，XHKG。XSHG表示上海证券交易所，XSHE表示深圳证券交易所，CCFX表示中国金融期货交易所，XDCE表示大连商品交易所，XSGE表示上海期货交易所，XZCE表示郑州商品交易所，XHKG表示香港证券交易所。可同时输入多个证券交易所,可以是列表
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 日期当天是否开市。0表示否，1表示是,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getTradeCal.csv?ispandas=1&') 
    requestString.append("exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'TradeCalGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'TradeCalGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'exchangeCD', u'calendarDate', u'isOpen', u'prevTradeDate', u'isWeekEnd', u'isMonthEnd', u'isQuarterEnd', u'isYearEnd']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IndustryGet(industryVersion = "", industryVersionCD = "", industryLevel = "", isNew = "", prntIndustryID = "", industryName = "", industryID = "", field = "", pandas = "1"):
    """
    获取行业分类目录，包含行业编码、行业代码、行业标准编码、行业层级、上一级行业编码、是否最新等。行业分类标准目前提供：证监会行业；申万行业；中信行业；中证行业；恒生行业；战略性新兴产业。
    
    :param industryVersion: 行业分类标准版本,industryVersion、industryVersionCD至少选择一个
    :param industryVersionCD: 行业分类标准数字编码，010301-证监会行业V2012；010303-申万行业分类；010306-恒生行业；010314-中证行业分类（2016版）；010317-中信行业分类；010319-战略性新兴产业(2018),可以是列表,industryVersion、industryVersionCD至少选择一个
    :param industryLevel: 行业所在层级,可以是列表,可空
    :param isNew: 当前是否有效,可空
    :param prntIndustryID: 上一级行业的数字编码，可使用此参数获取某一个行业的所有子行业,可以是列表,可空
    :param industryName: 行业名称，支持模糊查询,可空
    :param industryID: 通联编制的行业分类编码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getIndustry.csv?ispandas=1&') 
    if not isinstance(industryVersion, str) and not isinstance(industryVersion, unicode):
        industryVersion = str(industryVersion)

    requestString.append("industryVersion=%s"%(industryVersion))
    requestString.append("&industryVersionCD=")
    if hasattr(industryVersionCD,'__iter__') and not isinstance(industryVersionCD, str):
        if len(industryVersionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryVersionCD
            requestString.append(None)
        else:
            requestString.append(','.join(industryVersionCD))
    else:
        requestString.append(industryVersionCD)
    requestString.append("&industryLevel=")
    if hasattr(industryLevel,'__iter__') and not isinstance(industryLevel, str):
        if len(industryLevel) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryLevel
            requestString.append(None)
        else:
            requestString.append(','.join(industryLevel))
    else:
        requestString.append(industryLevel)
    if not isinstance(isNew, str) and not isinstance(isNew, unicode):
        isNew = str(isNew)

    requestString.append("&isNew=%s"%(isNew))
    requestString.append("&prntIndustryID=")
    if hasattr(prntIndustryID,'__iter__') and not isinstance(prntIndustryID, str):
        if len(prntIndustryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = prntIndustryID
            requestString.append(None)
        else:
            requestString.append(','.join(prntIndustryID))
    else:
        requestString.append(prntIndustryID)
    if not isinstance(industryName, str) and not isinstance(industryName, unicode):
        industryName = str(industryName)

    requestString.append("&industryName=%s"%(industryName))
    requestString.append("&industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'IndustryGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'IndustryGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryVersionCD', u'industryVersion', u'industry', u'industryID', u'industrySymbol', u'industryName', u'industryLevel', u'isNew', u'indexSymbol', u'prntIndustryID', u'beginDate', u'endDate', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryVersionCD': 'str','industryVersion': 'str','industry': 'str','industryID': 'str','industrySymbol': 'str','industryName': 'str','indexSymbol': 'str','prntIndustryID': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTypeRelGet(secID = "", ticker = "", typeID = "", field = "", pandas = "1"):
    """
    获取证券板块分类的成分信息，包含沪深股票、指数等。证券分类编码可通过getSecType获取。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取，可查询该证券属于哪些分类的成分，支持输入多个证券ID。,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param typeID: 通联编制的板块分类编码，可获取该分类下全部成分,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecTypeRel.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(typeID, str) and not isinstance(typeID, unicode):
        typeID = str(typeID)

    requestString.append("&typeID=%s"%(typeID))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SecTypeRelGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SecTypeRelGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'typeName', u'secID', u'ticker', u'exchangeCD', u'secShortName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','typeName': 'str','secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquInfoGet(ticker = "", field = "", pandas = "1"):
    """
    根据拼音或股票代码，匹配股票代码、名称。包含正在上市的全部沪深和新三板股票（含科创板）。
    
    :param ticker: 可以输入证券交易代码，如'688001',可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getEquInfo.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'EquInfoGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'EquInfoGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'exchangeCD', u'shortNM']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTypeRegionRelGet(secID = "", ticker = "", typeID = "", typeIDLV1 = "", field = "", pandas = "1"):
    """
    获取沪深股票地域分类，以注册地所在行政区域为标准。详细划分可在商品“地域分类”获取。
    
    :param secID: 输入证券ID，可查询该证券属于哪些分类的成分，支持输入多个证券ID。,可以是列表,可空
    :param ticker: 输入证券交易代码，可查询该证券交易代码属于哪些分类的成分，支持输入多个证券交易代码。,可以是列表,可空
    :param typeID: 输入某个证券分类的15位或18位typeID值（分类的子节点；输入项最细到地级市的typeID），可获取该子节点分类下全部成分。分类可在api如getSecType获取，地域类typeID以101001004开头。,可空
    :param typeIDLV1: 输入某个证券分类的15位typeID值（分类的子节点；输入项为省及直辖市的typeID），可获取该子节点分类下全部成分。分类可在api如getSecType获取，地域类typeID以101001004开头。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecTypeRegionRel.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(typeID, str) and not isinstance(typeID, unicode):
        typeID = str(typeID)

    requestString.append("&typeID=%s"%(typeID))
    if not isinstance(typeIDLV1, str) and not isinstance(typeIDLV1, unicode):
        typeIDLV1 = str(typeIDLV1)

    requestString.append("&typeIDLV1=%s"%(typeIDLV1))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SecTypeRegionRelGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SecTypeRegionRelGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'typeName', u'secID', u'ticker', u'exchangeCD', u'secShortName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','typeName': 'str','secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTypeGet(typeID = "", typeName = "", parentID = "", typeLevel = "", field = "", pandas = "1"):
    """
    获取证券板块分类列表，一级分类包含沪深股票、指数、期权等，每个分类又细分有不同类型；可一次获取全部分类。
    
    :param typeID: 分类ID，通联分类编码，每三位一个层级,可以是列表,可空
    :param typeName: 分类名称，支持模糊查询,可以是列表,可空
    :param parentID: 父节点，只输入该参数可获取该节点下所有子节点,可以是列表,可空
    :param typeLevel: 分类所在级别,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecType.csv?ispandas=1&') 
    requestString.append("typeID=")
    if hasattr(typeID,'__iter__') and not isinstance(typeID, str):
        if len(typeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeID
            requestString.append(None)
        else:
            requestString.append(','.join(typeID))
    else:
        requestString.append(typeID)
    requestString.append("&typeName=")
    if hasattr(typeName,'__iter__') and not isinstance(typeName, str):
        if len(typeName) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeName
            requestString.append(None)
        else:
            requestString.append(','.join(typeName))
    else:
        requestString.append(typeName)
    requestString.append("&parentID=")
    if hasattr(parentID,'__iter__') and not isinstance(parentID, str):
        if len(parentID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = parentID
            requestString.append(None)
        else:
            requestString.append(','.join(parentID))
    else:
        requestString.append(parentID)
    requestString.append("&typeLevel=")
    if hasattr(typeLevel,'__iter__') and not isinstance(typeLevel, str):
        if len(typeLevel) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeLevel
            requestString.append(None)
        else:
            requestString.append(','.join(typeLevel))
    else:
        requestString.append(typeLevel)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SecTypeGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SecTypeGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'typeName', u'parentID', u'typeLevel']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','typeName': 'str','parentID': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTypeRegionGet(typeID = "", typeName = "", parentID = "", typeLevel = "", field = "", pandas = "1"):
    """
    获取中国地域分类，以行政划分为标准。
    
    :param typeID: 分类ID，通联分类编码，每三位一个层级,可以是列表,可空
    :param typeName: 分类名称，支持模糊查询,可以是列表,可空
    :param parentID: 父节点，只输入该参数可获取该节点下所有子节点,可以是列表,可空
    :param typeLevel: 分类所在级别,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecTypeRegion.csv?ispandas=1&') 
    requestString.append("typeID=")
    if hasattr(typeID,'__iter__') and not isinstance(typeID, str):
        if len(typeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeID
            requestString.append(None)
        else:
            requestString.append(','.join(typeID))
    else:
        requestString.append(typeID)
    requestString.append("&typeName=")
    if hasattr(typeName,'__iter__') and not isinstance(typeName, str):
        if len(typeName) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeName
            requestString.append(None)
        else:
            requestString.append(','.join(typeName))
    else:
        requestString.append(typeName)
    requestString.append("&parentID=")
    if hasattr(parentID,'__iter__') and not isinstance(parentID, str):
        if len(parentID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = parentID
            requestString.append(None)
        else:
            requestString.append(','.join(parentID))
    else:
        requestString.append(parentID)
    requestString.append("&typeLevel=")
    if hasattr(typeLevel,'__iter__') and not isinstance(typeLevel, str):
        if len(typeLevel) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeLevel
            requestString.append(None)
        else:
            requestString.append(','.join(typeLevel))
    else:
        requestString.append(typeLevel)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SecTypeRegionGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SecTypeRegionGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'typeName', u'parentID', u'typeLevel']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','typeName': 'str','parentID': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SysCodeGet(codeTypeID = "", valueCD = "", field = "", pandas = "1"):
    """
    各api接口有枚举值特性的输出列，如getSecID输出项exchangeCD值，编码分别代表的是什么市场，所有枚举值都可以在这个接口获取。
    
    :param codeTypeID: 输入获知的参数分类ID，可以查询到这个参数分类下所有枚举值，非必须输入项,可以是列表,可空
    :param valueCD: 输入获知的参数下常量值，可以查询到这个常量值的说明，非必须输入项,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSysCode.csv?ispandas=1&') 
    requestString.append("codeTypeID=")
    if hasattr(codeTypeID,'__iter__') and not isinstance(codeTypeID, str):
        if len(codeTypeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = codeTypeID
            requestString.append(None)
        else:
            requestString.append(','.join(codeTypeID))
    else:
        requestString.append(codeTypeID)
    requestString.append("&valueCD=")
    if hasattr(valueCD,'__iter__') and not isinstance(valueCD, str):
        if len(valueCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = valueCD
            requestString.append(None)
        else:
            requestString.append(','.join(valueCD))
    else:
        requestString.append(valueCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SysCodeGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SysCodeGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'codeTypeID', u'valueCD', u'valueName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'valueCD': 'str','valueName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def WorkingCalGet(beginDate = "", endDate = "", isWork = "", prevWorkDate = "", field = "", pandas = "1"):
    """
    记录节假日安排数据。
    
    :param beginDate: 起始查询日期，输入格式“YYYYMMDD”,beginDate、endDate、isWork、prevWorkDate至少选择一个
    :param endDate: 截止查询日期，输入格式“YYYYMMDD”,beginDate、endDate、isWork、prevWorkDate至少选择一个
    :param isWork: 是否为工作日，1-是，0-否,可以是列表,beginDate、endDate、isWork、prevWorkDate至少选择一个
    :param prevWorkDate: 前一工作日,可以是列表,beginDate、endDate、isWork、prevWorkDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getWorkingCal.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&isWork=")
    if hasattr(isWork,'__iter__') and not isinstance(isWork, str):
        if len(isWork) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = isWork
            requestString.append(None)
        else:
            requestString.append(','.join(isWork))
    else:
        requestString.append(isWork)
    requestString.append("&prevWorkDate=")
    if hasattr(prevWorkDate,'__iter__') and not isinstance(prevWorkDate, str):
        if len(prevWorkDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = prevWorkDate
            requestString.append(None)
        else:
            requestString.append(','.join(prevWorkDate))
    else:
        requestString.append(prevWorkDate)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'WorkingCalGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'WorkingCalGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'calendarDate', u'isWork', u'prevWorkDate', u'weekStartDate', u'weekEndDate', u'monthStartDate', u'monthEndDate', u'quarterStartDate', u'quarterEndDate', u'yearStartDate', u'yearEndDate', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecChgHistoryGet(secID = "", ticker = "", endDate = "", chgTypeCD = "", history = "", field = "", pandas = "1"):
    """
    记录股票简称及代码变更历史，包括变更起始时间等（含科创板）。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000002.XSHE。可传入证券交易代码使用DataAPI.SecIDGet接口获取到。输入可查询该证券的历史变更情况。,可以是列表,secID、ticker、endDate、chgTypeCD、history至少选择一个
    :param ticker: 证券在证券市场通用的交易代码（目前的最新代码）。输入可查询该证券的历史变更情况。,可以是列表,secID、ticker、endDate、chgTypeCD、history至少选择一个
    :param endDate: 历史简称/代码的最后使用日期，输入可查询到变更前的历史简称/代码。,可以是列表,secID、ticker、endDate、chgTypeCD、history至少选择一个
    :param chgTypeCD: 变更类型代码，0101-简称变更，0111-代码变更,可以是列表,secID、ticker、endDate、chgTypeCD、history至少选择一个
    :param history: 历史证券代码或简称，输入可查询到目前的最新代码与简称以及变更日期,可以是列表,secID、ticker、endDate、chgTypeCD、history至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecChgHistory.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&endDate=")
    if hasattr(endDate,'__iter__') and not isinstance(endDate, str):
        if len(endDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = endDate
            requestString.append(None)
        else:
            requestString.append(','.join(endDate))
    else:
        requestString.append(endDate)
    requestString.append("&chgTypeCD=")
    if hasattr(chgTypeCD,'__iter__') and not isinstance(chgTypeCD, str):
        if len(chgTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = chgTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(chgTypeCD))
    else:
        requestString.append(chgTypeCD)
    requestString.append("&history=")
    if hasattr(history,'__iter__') and not isinstance(history, str):
        if len(history) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = history
            requestString.append(None)
        else:
            requestString.append(','.join(history))
    else:
        requestString.append(history)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SecChgHistoryGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SecChgHistoryGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'changType', u'value', u'beginDate', u'endDate', u'secShortName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','changType': 'str','value': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def InstNameChgGet(partyID = "", secID = "", secShortName = "", ticker = "", newName = "", oldName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取公司名称变更的日期以及变更前后的名称。
    
    :param partyID: 机构内部ID,可以是列表,partyID、secID、secShortName、ticker至少选择一个
    :param secID: 证券内部ID,可以是列表,partyID、secID、secShortName、ticker至少选择一个
    :param secShortName: 证券简称,partyID、secID、secShortName、ticker至少选择一个
    :param ticker: 交易代码,可以是列表,partyID、secID、secShortName、ticker至少选择一个
    :param newName: 更名后名称,可空
    :param oldName: 更名前名称,可空
    :param beginDate: 变更开始时间,可空
    :param endDate: 变更结束时间,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getInstNameChg.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    if not isinstance(secShortName, str) and not isinstance(secShortName, unicode):
        secShortName = str(secShortName)

    requestString.append("&secShortName=%s"%(secShortName))
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(newName, str) and not isinstance(newName, unicode):
        newName = str(newName)

    requestString.append("&newName=%s"%(newName))
    if not isinstance(oldName, str) and not isinstance(oldName, unicode):
        oldName = str(oldName)

    requestString.append("&oldName=%s"%(oldName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'InstNameChgGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'InstNameChgGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'secID', u'secShortName', u'ticker', u'newName', u'oledName', u'chgDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','newName': 'str','oledName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecSymbolGet(mapTypeCD = "", secID = "", ticker = "", secMapTicker = "", secMapID = "", field = "", pandas = "1"):
    """
    获取证券在市场上相关代码信息。
    
    :param mapTypeCD: 对应代码类型,0151-港股转板股份代码映射,0150-港股临时交易代码,0152-港股双币双股代码关联,0601-期货主力合约与月合约映射,0151-港股转板上市对应,0407-通联商品指数代码关联,可以是列表,mapTypeCD至少选择一个
    :param secID: 证券内部ID,可以是列表,可空
    :param ticker: 交易代码,可以是列表,可空
    :param secMapTicker: 对应交易代码,可以是列表,可空
    :param secMapID: 对应证券ID,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecSymbol.csv?ispandas=1&') 
    requestString.append("mapTypeCD=")
    if hasattr(mapTypeCD,'__iter__') and not isinstance(mapTypeCD, str):
        if len(mapTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = mapTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(mapTypeCD))
    else:
        requestString.append(mapTypeCD)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secMapTicker=")
    if hasattr(secMapTicker,'__iter__') and not isinstance(secMapTicker, str):
        if len(secMapTicker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secMapTicker
            requestString.append(None)
        else:
            requestString.append(','.join(secMapTicker))
    else:
        requestString.append(secMapTicker)
    requestString.append("&secMapID=")
    if hasattr(secMapID,'__iter__') and not isinstance(secMapID, str):
        if len(secMapID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secMapID
            requestString.append(None)
        else:
            requestString.append(','.join(secMapID))
    else:
        requestString.append(secMapID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SecSymbolGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SecSymbolGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'mapTypeCD', u'mapType', u'mapSymbolEXCD', u'secTicker', u'secMapID', u'secMapSecName', u'beginDate', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','mapTypeCD': 'str','mapType': 'str','mapSymbolEXCD': 'str','secTicker': 'str','secMapID': 'str','secMapSecName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def TypeListGet(industry = "", typeID = "", typeSymbol = "", typeName = "", typeParentID = "", industryLevel = "", industryVersion = "", isNew = "", field = "", pandas = "1"):
    """
    获取针对机构、证券的行业分类说明，覆盖证监会行业2012、申万行业、中证行业、GICS行业、沪深市场板块等分类体系。
    
    :param industry: 所属行业分类标准,可以是列表,industry至少选择一个
    :param typeID: 分类ID,可以是列表,可空
    :param typeSymbol: 分类代码,可以是列表,可空
    :param typeName: 分类名称,可以是列表,可空
    :param typeParentID: 父节点,可以是列表,可空
    :param industryLevel: 行业级别,可以是列表,可空
    :param industryVersion: 所属行业分类版本,可空
    :param isNew: 是否最新,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getTypeList.csv?ispandas=1&') 
    requestString.append("industry=")
    if hasattr(industry,'__iter__') and not isinstance(industry, str):
        if len(industry) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industry
            requestString.append(None)
        else:
            requestString.append(','.join(industry))
    else:
        requestString.append(industry)
    requestString.append("&typeID=")
    if hasattr(typeID,'__iter__') and not isinstance(typeID, str):
        if len(typeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeID
            requestString.append(None)
        else:
            requestString.append(','.join(typeID))
    else:
        requestString.append(typeID)
    requestString.append("&typeSymbol=")
    if hasattr(typeSymbol,'__iter__') and not isinstance(typeSymbol, str):
        if len(typeSymbol) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeSymbol
            requestString.append(None)
        else:
            requestString.append(','.join(typeSymbol))
    else:
        requestString.append(typeSymbol)
    requestString.append("&typeName=")
    if hasattr(typeName,'__iter__') and not isinstance(typeName, str):
        if len(typeName) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeName
            requestString.append(None)
        else:
            requestString.append(','.join(typeName))
    else:
        requestString.append(typeName)
    requestString.append("&typeParentID=")
    if hasattr(typeParentID,'__iter__') and not isinstance(typeParentID, str):
        if len(typeParentID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeParentID
            requestString.append(None)
        else:
            requestString.append(','.join(typeParentID))
    else:
        requestString.append(typeParentID)
    requestString.append("&industryLevel=")
    if hasattr(industryLevel,'__iter__') and not isinstance(industryLevel, str):
        if len(industryLevel) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryLevel
            requestString.append(None)
        else:
            requestString.append(','.join(industryLevel))
    else:
        requestString.append(industryLevel)
    if not isinstance(industryVersion, str) and not isinstance(industryVersion, unicode):
        industryVersion = str(industryVersion)

    requestString.append("&industryVersion=%s"%(industryVersion))
    if not isinstance(isNew, str) and not isinstance(isNew, unicode):
        isNew = str(isNew)

    requestString.append("&isNew=%s"%(isNew))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'TypeListGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'TypeListGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'typeSymbol', u'typeName', u'typeParentID', u'position', u'begDate', u'endDate', u'isNew', u'industry', u'industryVersion', u'industryLevel']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','typeSymbol': 'str','typeName': 'str','typeParentID': 'str','industry': 'str','industryVersion': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def CountryGet(CounCD2 = "", CounCD3 = "", CounNum = "", CounShortNameCN = "", field = "", pandas = "1"):
    """
    获取采用ISO标准（ISO 3166-1）国家代码记录的国家地区信息，信息包含二位字母、三位字母、数字三种形式。
    
    :param CounCD2: 两位国家代码,可以是列表,可空
    :param CounCD3: 三位国家代码,可以是列表,可空
    :param CounNum: 国家数字编号,可以是列表,可空
    :param CounShortNameCN: 国家简称,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getCountry.csv?ispandas=1&') 
    requestString.append("CounCD2=")
    if hasattr(CounCD2,'__iter__') and not isinstance(CounCD2, str):
        if len(CounCD2) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = CounCD2
            requestString.append(None)
        else:
            requestString.append(','.join(CounCD2))
    else:
        requestString.append(CounCD2)
    requestString.append("&CounCD3=")
    if hasattr(CounCD3,'__iter__') and not isinstance(CounCD3, str):
        if len(CounCD3) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = CounCD3
            requestString.append(None)
        else:
            requestString.append(','.join(CounCD3))
    else:
        requestString.append(CounCD3)
    requestString.append("&CounNum=")
    if hasattr(CounNum,'__iter__') and not isinstance(CounNum, str):
        if len(CounNum) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = CounNum
            requestString.append(None)
        else:
            requestString.append(','.join(CounNum))
    else:
        requestString.append(CounNum)
    requestString.append("&CounShortNameCN=")
    if hasattr(CounShortNameCN,'__iter__') and not isinstance(CounShortNameCN, str):
        if len(CounShortNameCN) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = CounShortNameCN
            requestString.append(None)
        else:
            requestString.append(','.join(CounShortNameCN))
    else:
        requestString.append(CounShortNameCN)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'CountryGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'CountryGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'CounCD2', u'CounCD3', u'CounNum', u'CounFullNameCN', u'CounShortNameCN', u'CounFullNameEN', u'CounShortNameEN']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'CounCD2': 'str','CounCD3': 'str','CounNum': 'str','CounFullNameCN': 'str','CounShortNameCN': 'str','CounFullNameEN': 'str','CounShortNameEN': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def PeopleGet(personID = "", name = "", field = "", pandas = "1"):
    """
    获取人物主表，姓名、学历、性别等。
    
    :param personID: 人员ID,可以是列表,personID、name至少选择一个
    :param name: 姓名,personID、name至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getPeople.csv?ispandas=1&') 
    requestString.append("personID=")
    if hasattr(personID,'__iter__') and not isinstance(personID, str):
        if len(personID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = personID
            requestString.append(None)
        else:
            requestString.append(','.join(personID))
    else:
        requestString.append(personID)
    if not isinstance(name, str) and not isinstance(name, unicode):
        name = str(name)

    requestString.append("&name=%s"%(name))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'PeopleGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'PeopleGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'personID', u'name', u'genderCD', u'gender', u'birthCD', u'eduCD', u'edu', u'backgroundDesc']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'name': 'str','genderCD': 'str','gender': 'str','birthCD': 'str','eduCD': 'str','edu': 'str','backgroundDesc': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __MktEqudLatelyGet(secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票个股最近一次日行情，当日数据更新返回当日数据，当日数据为更新之前返回上一个交易日数据，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 通用交易代码，如'000001'(可多值输入),可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudLately.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__MktEqudLatelyGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__MktEqudLatelyGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'turnoverRate', u'accumAdjFactor', u'exDivDate', u'negMarketValue', u'marketValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __MktQuoteInfoGet(secID = "", ticker = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取沪深交易所可交易证券的行情报价基本要素，包含申报价格最小变动单位、申报数量下限、交易币种等。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktQuoteInfo.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__MktQuoteInfoGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__MktQuoteInfoGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'quoteVolMin', u'quoteVolMinUnit', u'quotePriceMin', u'quotePriceMinUnit', u'transCurrCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','quoteVolMin': 'str','quoteVolMinUnit': 'str','quotePriceMin': 'str','quotePriceMinUnit': 'str','transCurrCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __HSIIdMapGet(field = "", pandas = "1"):
    """
    
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHSIIdMap.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__HSIIdMapGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__HSIIdMapGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exCountryCD', u'ticker', u'secShortName', u'exchangeCD', u'secFullName', u'srcName', u'srcFullName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exCountryCD': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','secFullName': 'str','srcFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __MktIdxdLatelyGet(field = "", pandas = "1"):
    """
    获取指数基本信息及最新一个交易日的收盘行情。
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxdLately.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__MktIdxdLatelyGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__MktIdxdLatelyGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'publishDate', u'secShortName', u'indexTypeCD', u'indexType', u'pubOrgCD', u'porgFullName', u'baseDate', u'basePoint', u'endDate', u'isValid', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'CHG', u'CHGPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','indexTypeCD': 'str','indexType': 'str','porgFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __MktAdjfAf2006Get(secID = "", ticker = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取沪深股票用来调整历史行情的后复权因子数据（以2006-01-01价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及对应的生效日期区间。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。只在发生分红、配股、股改事件的除权除息日才有复权因子记录。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAf2006.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__MktAdjfAf2006Get')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__MktAdjfAf2006Get')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'adjFactor', u'accumAdjFactor', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __MktEqudAdjAf2006Get(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取获取沪深股票后复权收盘日行情（后复权基准起始日期为2006-01-01），包含后复权调整的昨收价、开盘价、最高价、最低价、收盘价等（含科创板）。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 输入股票代码，如000001。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部沪深股票复权行情数据，输入格式“YYYYMMDD”,secID、ticker、tradeDate至少选择一个
    :param beginDate: 开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 结束日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudAdjAf2006.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__MktEqudAdjAf2006Get')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__MktEqudAdjAf2006Get')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __IRATransLossGet(beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    记录沪市、深市及创业板的交易量及交易损耗（不包括B股）
    
    :param beginDate: 交易日，查询开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 交易日，查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getIRATransLoss.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__IRATransLossGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__IRATransLossGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'shTurnoverValue', u'shTransLoss', u'szTurnoverValue', u'szTransLoss', u'cyTurnoverValue', u'cyTransLoss']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RrpMktRLStkNrGet(secID = "", ticker = "", beginDate = "", endDate = "", uniqID = "", abnormalTypeCD = "", field = "", pandas = "1"):
    """
    晚报-龙虎榜列表
    
    :param secID: 证券ID,可以是列表,可空
    :param ticker: 交易代码,可以是列表,可空
    :param beginDate: 根据交易日期范围查询的开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 根据交易日期范围查询的结束日期，输入格式“YYYYMMDD”,可空
    :param uniqID: 龙虎榜单编码,可以是列表,可空
    :param abnormalTypeCD: 异动类型代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getRrpMktRLStkNr.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&uniqID=")
    if hasattr(uniqID,'__iter__') and not isinstance(uniqID, str):
        if len(uniqID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = uniqID
            requestString.append(None)
        else:
            requestString.append(','.join(uniqID))
    else:
        requestString.append(uniqID)
    requestString.append("&abnormalTypeCD=")
    if hasattr(abnormalTypeCD,'__iter__') and not isinstance(abnormalTypeCD, str):
        if len(abnormalTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = abnormalTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(abnormalTypeCD))
    else:
        requestString.append(abnormalTypeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RrpMktRLStkNrGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RrpMktRLStkNrGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'exchangeName', u'secShortName', u'tradeDate', u'abnormalDisplay', u'abnormalTypeCD', u'abnormalType', u'uniqID', u'deviation', u'turnoverVol', u'turnoverValue', u'abnormalBeginDate', u'abnormalEndDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','exchangeName': 'str','secShortName': 'str','abnormalDisplay': 'str','abnormalTypeCD': 'str','abnormalType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RrpMktRLStatNrGet(secID = "", ticker = "", beginDate = "", endDate = "", side = "", uniqID = "", abnormalTypeCD = "", field = "", pandas = "1"):
    """
    晚报-龙虎榜分类型统计
    
    :param secID: 证券ID,可以是列表,可空
    :param ticker: 交易代码,可以是列表,可空
    :param beginDate: 根据交易日期范围查询的开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 根据交易日期范围查询的结束日期，输入格式“YYYYMMDD”,可空
    :param side: 买卖方向,可以是列表,可空
    :param uniqID: 龙虎榜单编码,可以是列表,可空
    :param abnormalTypeCD: 异动类型代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getRrpMktRLStatNr.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&side=")
    if hasattr(side,'__iter__') and not isinstance(side, str):
        if len(side) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = side
            requestString.append(None)
        else:
            requestString.append(','.join(side))
    else:
        requestString.append(side)
    requestString.append("&uniqID=")
    if hasattr(uniqID,'__iter__') and not isinstance(uniqID, str):
        if len(uniqID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = uniqID
            requestString.append(None)
        else:
            requestString.append(','.join(uniqID))
    else:
        requestString.append(uniqID)
    requestString.append("&abnormalTypeCD=")
    if hasattr(abnormalTypeCD,'__iter__') and not isinstance(abnormalTypeCD, str):
        if len(abnormalTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = abnormalTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(abnormalTypeCD))
    else:
        requestString.append(abnormalTypeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RrpMktRLStatNrGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RrpMktRLStatNrGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'exchangeName', u'secShortName', u'tradeDate', u'abnormalTypeCD', u'uniqID', u'side', u'rank', u'buyValue', u'sellValue', u'netValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','exchangeName': 'str','secShortName': 'str','abnormalTypeCD': 'str','side': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RrpMktRLSalesNrGet(secID = "", ticker = "", beginDate = "", endDate = "", side = "", uniqID = "", abnormalTypeCD = "", field = "", pandas = "1"):
    """
    晚报-龙虎榜成交明细
    
    :param secID: 证券ID,可以是列表,可空
    :param ticker: 交易代码,可以是列表,可空
    :param beginDate: 根据交易日期范围查询的开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 根据交易日期范围查询的结束日期，输入格式“YYYYMMDD”,可空
    :param side: 买卖方向,可以是列表,可空
    :param uniqID: 龙虎榜单编码,可以是列表,可空
    :param abnormalTypeCD: 异动类型代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getRrpMktRLSalesNr.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&side=")
    if hasattr(side,'__iter__') and not isinstance(side, str):
        if len(side) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = side
            requestString.append(None)
        else:
            requestString.append(','.join(side))
    else:
        requestString.append(side)
    requestString.append("&uniqID=")
    if hasattr(uniqID,'__iter__') and not isinstance(uniqID, str):
        if len(uniqID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = uniqID
            requestString.append(None)
        else:
            requestString.append(','.join(uniqID))
    else:
        requestString.append(uniqID)
    requestString.append("&abnormalTypeCD=")
    if hasattr(abnormalTypeCD,'__iter__') and not isinstance(abnormalTypeCD, str):
        if len(abnormalTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = abnormalTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(abnormalTypeCD))
    else:
        requestString.append(abnormalTypeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RrpMktRLSalesNrGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RrpMktRLSalesNrGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'exchangeName', u'secShortName', u'tradeDate', u'abnormalTypeCD', u'abnormalType', u'uniqID', u'side', u'rank', u'sales', u'buyValue', u'sellValue', u'totalValue', u'netValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','exchangeName': 'str','secShortName': 'str','abnormalTypeCD': 'str','abnormalType': 'str','side': 'str','sales': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __MktAdjfAfKunhongGet(secID = "", ticker = "", exchangeCD = "", exDivDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深股票用来调整历史行情的后复权因子数据（以上市价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及对应的生效日期区间。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。只在发生分红、配股、股改事件的除权除息日才有复权因子记录。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param exDivDate: 除权除息日,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param beginDate: 除权除息日的起始查询日期,可空
    :param endDate: 除权除息日的截止查询日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAfKunhong.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        exDivDate = exDivDate.strftime('%Y%m%d')
    except:
        exDivDate = exDivDate.replace('-', '')
    requestString.append("&exDivDate=%s"%(exDivDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__MktAdjfAfKunhongGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__MktAdjfAfKunhongGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'splitsRatio', u'adjFactor', u'accumAdjFactor', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __MktAdjfAfKunhongV2Get(secID = "", ticker = "", exchangeCD = "", exDivDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深股票用来调整历史行情的后复权因子数据（以上市价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及对应的生效日期区间。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。只在发生分红、配股、股改事件的除权除息日才有复权因子记录。相比getMktAdjfAfKunhong，增加当日收盘前用前复权因子估算的后复权因子。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet接口获取到,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,可空
    :param exDivDate: 除权除息日,可空
    :param beginDate: 除权除息日的起始查询日期,可空
    :param endDate: 除权除息日的截止查询日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAfKunhongV2.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        exDivDate = exDivDate.strftime('%Y%m%d')
    except:
        exDivDate = exDivDate.replace('-', '')
    requestString.append("&exDivDate=%s"%(exDivDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__MktAdjfAfKunhongV2Get')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__MktAdjfAfKunhongV2Get')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'splitsRatio', u'adjFactor', u'accumAdjFactor', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __StockTagsGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    根据股票因子数据，对股票进行分类，比如根据市值分为超级大盘股、大盘股、小盘股，根据PE分为高PE股，低PE股等。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'E',输入'000001'，可获取到ID'000001.XSHE'后，在此输入'000001.XSHE',可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期，输入格式“YYYYMMDD”,secID、ticker、tradeDate至少选择一个
    :param beginDate: 根据交易日期范围查询的开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 根据交易日期范围查询的结束日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getStockTags.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(beginDate, str) and not isinstance(beginDate, unicode):
        beginDate = str(beginDate)

    requestString.append("&beginDate=%s"%(beginDate))
    if not isinstance(endDate, str) and not isinstance(endDate, unicode):
        endDate = str(endDate)

    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__StockTagsGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__StockTagsGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'secID', u'tradeDate', u'marketValueStyle', u'growth', u'worth', u'price', u'leverage', u'pe', u'roe', u'mobility', u'profitability', u'momentum', u'volatility', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','secID': 'str','marketValueStyle': 'str','growth': 'str','worth': 'str','price': 'str','leverage': 'str','pe': 'str','roe': 'str','mobility': 'str','profitability': 'str','momentum': 'str','volatility': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __MktEquLatestTraddayGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取某只股票在某一交易日的最近交易日，若当日不停牌，最近交易日即当日，若停牌，为上一个有成交的交易日（含科创板）。
    
    :param tradeDate: 交易日期
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquLatestTradday.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__MktEquLatestTraddayGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__MktEquLatestTraddayGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'latestTradday']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __IdxReturnRateZAGet(secID = "", ticker = "", beginDate = "", endDate = "", returnRateType = "", field = "", pandas = "1"):
    """
    获取（定制）港股基金相关指数回报
    
    :param secID: 输入多个证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入多个基金代码，如"000001"。,可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param returnRateType: 输入一种或两种回报率类型，用","分隔，如"OTC"、"OTC,EXCH"。当RETURN_RATE_TYPE为OTC时为场外基金的回报率数据，以净值计算；当RETURN_RATE_TYPE为EXCH时为场内基金的回报率数据，以收盘价计算；不选默认为普通开放式基金场外交易的净值回报率。对应DataAPI.SysCodeGet.codeTypeID=40029。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getIdxReturnRateZA.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&returnRateType=")
    if hasattr(returnRateType,'__iter__') and not isinstance(returnRateType, str):
        if len(returnRateType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = returnRateType
            requestString.append(None)
        else:
            requestString.append(','.join(returnRateType))
    else:
        requestString.append(returnRateType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__IdxReturnRateZAGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__IdxReturnRateZAGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'assetClass', u'endDate', u'returnRateDaily', u'returnRateType']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','assetClass': 'str','returnRateType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __MktIfFutPerfGet(tradeDate = "", uaTicker = "", uaShortName = "", field = "", pandas = "1"):
    """
    获取每日股指期货套利表现情况，包含标的收盘价、期指价格、期指涨跌幅、升贴水、套利收益率、年化套利收益率、 剩余天数等。
    
    :param tradeDate: 交易日期,tradeDate、uaTicker、uaShortName至少选择一个
    :param uaTicker: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,tradeDate、uaTicker、uaShortName至少选择一个
    :param uaShortName: 标的指数简称,tradeDate、uaTicker、uaShortName至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIfFutPerf.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    if not isinstance(uaTicker, str) and not isinstance(uaTicker, unicode):
        uaTicker = str(uaTicker)

    requestString.append("&uaTicker=%s"%(uaTicker))
    if not isinstance(uaShortName, str) and not isinstance(uaShortName, unicode):
        uaShortName = str(uaShortName)

    requestString.append("&uaShortName=%s"%(uaShortName))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__MktIfFutPerfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__MktIfFutPerfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'contractObject', u'tradeDate', u'closePrice', u'settlePrice', u'chgPct', u'uaTicker', u'uaShortName', u'uaClosePrice', u'uaChgPct', u'basis', u'returnRate', u'returnRateY', u'daysRemaining', u'mainCon']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','contractObject': 'str','uaTicker': 'str','uaShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __MktHKAdjfGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取港股用来调整历史行情的前复权因子数据，包含除权除息日、本次复权因子、累积复权因子以及对应的生效日期区间。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。只在除权除息日才有复权因子记录。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 除权除息日开始日期,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 除权除息日结束日期,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktHKAdjf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__MktHKAdjfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__MktHKAdjfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exDivDate', u'adjFactor', u'accumAdjFactor', u'endDate', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    获取沪深股票未复权日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码，如'000001'(可多值输入),可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期，只输入一个日期，可获取到一天全部沪深股票日行情数据,secID、ticker、tradeDate至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 股票今日是否开盘标记：0-未开盘，1-交易日,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqud.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqudGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqudGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'turnoverRate', u'accumAdjFactor', u'negMarketValue', u'marketValue', u'chgPct', u'PE', u'PE1', u'PB', u'isOpen', u'vwap']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutdGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取国内期货日行情信息，包含昨收盘、昨结算、开盘价、最高价、最低价、收盘价、结算价、成交量、成交金额、持仓量、主力合约标记、连续合约标记等。 其中主力合约按持仓量计算，完整的主力连续标记可从getMktFutPre获取。中金所结算价的更新时间为16:20，上期所无成交合约的结算价有可能在16:00左右有修正。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'tradeDate', u'contractObject', u'contractMark', u'preSettlePrice', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverValue', u'openInt', u'CHG', u'CHG1', u'CHGPct', u'mainCon', u'smainCon']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','contractObject': 'str','contractMark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxdGet(indexID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取指数的日度收盘信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。沪深重要指数的更新时间为15:30，其他指数因发布机构不同会陆续更新。
    
    :param indexID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,indexID、ticker、tradeDate至少选择一个
    :param ticker: 指数通用代码,可以是列表,indexID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,indexID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxd.csv?ispandas=1&') 
    requestString.append("indexID=")
    if hasattr(indexID,'__iter__') and not isinstance(indexID, str):
        if len(indexID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indexID
            requestString.append(None)
        else:
            requestString.append(','.join(indexID))
    else:
        requestString.append(indexID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'porgFullName', u'secShortName', u'exchangeCD', u'tradeDate', u'preCloseIndex', u'openIndex', u'lowestIndex', u'highestIndex', u'closeIndex', u'turnoverVol', u'turnoverValue', u'CHG', u'CHGPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','porgFullName': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktBlockdGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", assetClass = "", field = "", pandas = "1"):
    """
    获取沪深股票、债券、基金的大宗交易信息，包含成交价、成交量、成交额、营业部等。交易所公布数据，更新时间可能会有延迟。
    
    :param secID: 通联编制的证券编码， 可通过DataAPI.SecIDGet获取。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 起始查询日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止查询日期，输入格式“YYYYMMDD”,可空
    :param assetClass: 通联编制的证券类型编码,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktBlockd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(assetClass, str) and not isinstance(assetClass, unicode):
        assetClass = str(assetClass)

    requestString.append("&assetClass=%s"%(assetClass))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktBlockdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktBlockdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'secID', u'ticker', u'assetClass', u'exchangeCD', u'secFullName', u'currencyCD', u'tradePrice', u'tradeVal', u'tradeVol', u'buyerBD', u'sellerBD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','assetClass': 'str','exchangeCD': 'str','secFullName': 'str','currencyCD': 'str','buyerBD': 'str','sellerBD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRepodGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取债券回购交易日行情信息，包含开盘利率、最高利率、最低利率、收盘利率、成交量、成交金额、成交笔数等。沪深交易所15:50更新，银行间市场21:00更新。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRepod.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktRepodGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktRepodGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preCloseRate', u'openRate', u'highestRate', u'lowestRate', u'closeRate', u'turnoverVol', u'turnoverValue', u'dealAmount']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktBonddGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深债券日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等。除深交所可转换公司债券及可交换公司债券为全价交易，其余品种为净价交易。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktBondd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktBonddGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktBonddGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'accrInterest', u'YTM', u'VWAP', u'grossClosePrice']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktHKEqudGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取港交所股票未复权日行情信息，包含昨收盘价、开盘价、最高价、最低价、收盘价、成交量、成交金额等。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktHKEqud.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktHKEqudGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktHKEqudGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'SMA10', u'SMA20', u'SMA50', u'SMA250', u'chg', u'chgPct', u'marketValue', u'negMarketValue', u'PE', u'PE1', u'PB', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktStockFactorsOneDayGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取多只股票历史上某一天的因子数据
    
    :param tradeDate: 日期
    :param secID: 多只股票ID，用逗号隔开,可以是列表,可空
    :param ticker: 多只股票交易代码，用逗号隔开,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getStockFactorsOneDay.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktStockFactorsOneDayGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktStockFactorsOneDayGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'AccountsPayablesTDays', u'AccountsPayablesTRate', u'AdminiExpenseRate', u'ARTDays', u'ARTRate', u'ASSI', u'BLEV', u'BondsPayableToAsset', u'CashRateOfSales', u'CashToCurrentLiability', u'CMRA', u'CTOP', u'CTP5', u'CurrentAssetsRatio', u'CurrentAssetsTRate', u'CurrentRatio', u'DAVOL10', u'DAVOL20', u'DAVOL5', u'DDNBT', u'DDNCR', u'DDNSR', u'DebtEquityRatio', u'DebtsAssetRatio', u'DHILO', u'DilutedEPS', u'DVRAT', u'EBITToTOR', u'EGRO', u'EMA10', u'EMA120', u'EMA20', u'EMA5', u'EMA60', u'EPS', u'EquityFixedAssetRatio', u'EquityToAsset', u'EquityTRate', u'ETOP', u'ETP5', u'FinancialExpenseRate', u'FinancingCashGrowRate', u'FixAssetRatio', u'FixedAssetsTRate', u'GrossIncomeRatio', u'HBETA', u'HSIGMA', u'IntangibleAssetRatio', u'InventoryTDays', u'InventoryTRate', u'InvestCashGrowRate', u'LCAP', u'LFLO', u'LongDebtToAsset', u'LongDebtToWorkingCapital', u'LongTermDebtToAsset', u'MA10', u'MA120', u'MA20', u'MA5', u'MA60', u'MAWVAD', u'MFI', u'MLEV', u'NetAssetGrowRate', u'NetProfitGrowRate', u'NetProfitRatio', u'NOCFToOperatingNI', u'NonCurrentAssetsRatio', u'NPParentCompanyGrowRate', u'NPToTOR', u'OperatingExpenseRate', u'OperatingProfitGrowRate', u'OperatingProfitRatio', u'OperatingProfitToTOR', u'OperatingRevenueGrowRate', u'OperCashGrowRate', u'OperCashInToCurrentLiability', u'PB', u'PCF', u'PE', u'PS', u'PSY', u'QuickRatio', u'REVS10', u'REVS20', u'REVS5', u'ROA', u'ROA5', u'ROE', u'ROE5', u'RSI', u'RSTR12', u'RSTR24', u'SalesCostRatio', u'SaleServiceCashToOR', u'SUE', u'TaxRatio', u'TOBT', u'TotalAssetGrowRate', u'TotalAssetsTRate', u'TotalProfitCostRatio', u'TotalProfitGrowRate', u'VOL10', u'VOL120', u'VOL20', u'VOL240', u'VOL5', u'VOL60', u'WVAD', u'REC', u'DAREC', u'GREC', u'FY12P', u'DAREV', u'GREV', u'SFY12P', u'DASREV', u'GSREV', u'FEARNG', u'FSALESG', u'TA2EV', u'CFO2EV', u'ACCA', u'DEGM', u'SUOI', u'EARNMOM', u'FiftyTwoWeekHigh', u'Volatility', u'Skewness', u'ILLIQUIDITY', u'BackwardADJ', u'MACD', u'ADTM', u'ATR14', u'ATR6', u'BIAS10', u'BIAS20', u'BIAS5', u'BIAS60', u'BollDown', u'BollUp', u'CCI10', u'CCI20', u'CCI5', u'CCI88', u'KDJ_K', u'KDJ_D', u'KDJ_J', u'ROC6', u'ROC20', u'SBM', u'STM', u'UpRVI', u'DownRVI', u'RVI', u'SRMI', u'ChandeSD', u'ChandeSU', u'CMO', u'DBCD', u'ARC', u'OBV', u'OBV6', u'OBV20', u'TVMA20', u'TVMA6', u'TVSTD20', u'TVSTD6', u'VDEA', u'VDIFF', u'VEMA10', u'VEMA12', u'VEMA26', u'VEMA5', u'VMACD', u'VOSC', u'VR', u'VROC12', u'VROC6', u'VSTD10', u'VSTD20', u'KlingerOscillator', u'MoneyFlow20', u'AD', u'AD20', u'AD6', u'CoppockCurve', u'ASI', u'ChaikinOscillator', u'ChaikinVolatility', u'EMV14', u'EMV6', u'plusDI', u'minusDI', u'ADX', u'ADXR', u'Aroon', u'AroonDown', u'AroonUp', u'DEA', u'DIFF', u'DDI', u'DIZ', u'DIF', u'MTM', u'MTMMA', u'PVT', u'PVT6', u'PVT12', u'TRIX5', u'TRIX10', u'UOS', u'MA10RegressCoeff12', u'MA10RegressCoeff6', u'PLRC6', u'PLRC12', u'SwingIndex', u'Ulcer10', u'Ulcer5', u'Hurst', u'ACD6', u'ACD20', u'EMA12', u'EMA26', u'APBMA', u'BBI', u'BBIC', u'TEMA10', u'TEMA5', u'MA10Close', u'AR', u'BR', u'ARBR', u'CR20', u'MassIndex', u'BearPower', u'BullPower', u'Elder', u'NVI', u'PVI', u'RC12', u'RC24', u'JDQS20']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktStockFactorsDateRangeGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取一只股票历史上某一时间段的因子数据
    
    :param secID: 一只股票ID,secID、ticker至少选择一个
    :param ticker: 一只股票交易代码,secID、ticker至少选择一个
    :param beginDate: 开始日期,可空
    :param endDate: 结束日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getStockFactorsDateRange.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktStockFactorsDateRangeGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktStockFactorsDateRangeGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'AccountsPayablesTDays', u'AccountsPayablesTRate', u'AdminiExpenseRate', u'ARTDays', u'ARTRate', u'ASSI', u'BLEV', u'BondsPayableToAsset', u'CashRateOfSales', u'CashToCurrentLiability', u'CMRA', u'CTOP', u'CTP5', u'CurrentAssetsRatio', u'CurrentAssetsTRate', u'CurrentRatio', u'DAVOL10', u'DAVOL20', u'DAVOL5', u'DDNBT', u'DDNCR', u'DDNSR', u'DebtEquityRatio', u'DebtsAssetRatio', u'DHILO', u'DilutedEPS', u'DVRAT', u'EBITToTOR', u'EGRO', u'EMA10', u'EMA120', u'EMA20', u'EMA5', u'EMA60', u'EPS', u'EquityFixedAssetRatio', u'EquityToAsset', u'EquityTRate', u'ETOP', u'ETP5', u'FinancialExpenseRate', u'FinancingCashGrowRate', u'FixAssetRatio', u'FixedAssetsTRate', u'GrossIncomeRatio', u'HBETA', u'HSIGMA', u'IntangibleAssetRatio', u'InventoryTDays', u'InventoryTRate', u'InvestCashGrowRate', u'LCAP', u'LFLO', u'LongDebtToAsset', u'LongDebtToWorkingCapital', u'LongTermDebtToAsset', u'MA10', u'MA120', u'MA20', u'MA5', u'MA60', u'MAWVAD', u'MFI', u'MLEV', u'NetAssetGrowRate', u'NetProfitGrowRate', u'NetProfitRatio', u'NOCFToOperatingNI', u'NonCurrentAssetsRatio', u'NPParentCompanyGrowRate', u'NPToTOR', u'OperatingExpenseRate', u'OperatingProfitGrowRate', u'OperatingProfitRatio', u'OperatingProfitToTOR', u'OperatingRevenueGrowRate', u'OperCashGrowRate', u'OperCashInToCurrentLiability', u'PB', u'PCF', u'PE', u'PS', u'PSY', u'QuickRatio', u'REVS10', u'REVS20', u'REVS5', u'ROA', u'ROA5', u'ROE', u'ROE5', u'RSI', u'RSTR12', u'RSTR24', u'SalesCostRatio', u'SaleServiceCashToOR', u'SUE', u'TaxRatio', u'TOBT', u'TotalAssetGrowRate', u'TotalAssetsTRate', u'TotalProfitCostRatio', u'TotalProfitGrowRate', u'VOL10', u'VOL120', u'VOL20', u'VOL240', u'VOL5', u'VOL60', u'WVAD', u'REC', u'DAREC', u'GREC', u'FY12P', u'DAREV', u'GREV', u'SFY12P', u'DASREV', u'GSREV', u'FEARNG', u'FSALESG', u'TA2EV', u'CFO2EV', u'ACCA', u'DEGM', u'SUOI', u'EARNMOM', u'FiftyTwoWeekHigh', u'Volatility', u'Skewness', u'ILLIQUIDITY', u'BackwardADJ', u'MACD', u'ADTM', u'ATR14', u'ATR6', u'BIAS10', u'BIAS20', u'BIAS5', u'BIAS60', u'BollDown', u'BollUp', u'CCI10', u'CCI20', u'CCI5', u'CCI88', u'KDJ_K', u'KDJ_D', u'KDJ_J', u'ROC6', u'ROC20', u'SBM', u'STM', u'UpRVI', u'DownRVI', u'RVI', u'SRMI', u'ChandeSD', u'ChandeSU', u'CMO', u'DBCD', u'ARC', u'OBV', u'OBV6', u'OBV20', u'TVMA20', u'TVMA6', u'TVSTD20', u'TVSTD6', u'VDEA', u'VDIFF', u'VEMA10', u'VEMA12', u'VEMA26', u'VEMA5', u'VMACD', u'VOSC', u'VR', u'VROC12', u'VROC6', u'VSTD10', u'VSTD20', u'KlingerOscillator', u'MoneyFlow20', u'AD', u'AD20', u'AD6', u'CoppockCurve', u'ASI', u'ChaikinOscillator', u'ChaikinVolatility', u'EMV14', u'EMV6', u'plusDI', u'minusDI', u'ADX', u'ADXR', u'Aroon', u'AroonDown', u'AroonUp', u'DEA', u'DIFF', u'DDI', u'DIZ', u'DIF', u'MTM', u'MTMMA', u'PVT', u'PVT6', u'PVT12', u'TRIX5', u'TRIX10', u'UOS', u'MA10RegressCoeff12', u'MA10RegressCoeff6', u'PLRC6', u'PLRC12', u'SwingIndex', u'Ulcer10', u'Ulcer5', u'Hurst', u'ACD6', u'ACD20', u'EMA12', u'EMA26', u'APBMA', u'BBI', u'BBIC', u'TEMA10', u'TEMA5', u'MA10Close', u'AR', u'BR', u'ARBR', u'CR20', u'MassIndex', u'BearPower', u'BullPower', u'Elder', u'NVI', u'PVI', u'RC12', u'RC24', u'JDQS20']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFunddGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深基金未复权日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFundd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFunddGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFunddGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'CHG', u'CHGPct', u'turnoverVol', u'turnoverValue', u'discount', u'discountRatio', u'circulationShares', u'accumAdjFactor']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutMTRGet(beginDate = "", endDate = "", secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取每日期货会员成交量排名信息，包含合约代码、期货会员简称、成交量、成交量增减、当日排名等。交易所只公布当日总持仓量达到一定标准的合约，详见交易所相关规则。因各交易所发布时间有差异，更新可能会有延迟。
    
    :param beginDate: 查询tradeDate起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询tradeDate截止日期，输入格式“YYYYMMDD”,可空
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutMTR.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutMTRGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutMTRGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'partyShortName', u'exchangeCD', u'tradeDate', u'turnoverVol', u'CHG', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutMSRGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日期货会员持卖仓排名信息，包含合约代码、期货会员简称、持卖仓量、持卖仓量增减、当日排名等。交易所只公布当日总持仓量达到一定标准的合约，详见交易所相关规则。因各交易所发布时间有差异，更新可能会有延迟。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 查询tradeDate起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询tradeDate截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutMSR.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutMSRGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutMSRGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'partyShortName', u'exchangeCD', u'tradeDate', u'shortVol', u'CHG', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutMLRGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日期货会员持买仓排名信息，包含合约代码、期货会员简称、持买仓量、持买仓量增减、当日排名等。交易所只公布当日总持仓量达到一定标准的合约，详见交易所相关规则。因各交易所发布时间有差异，更新可能会有延迟。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 查询tradeDate起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询tradeDate截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutMLR.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutMLRGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutMLRGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'partyShortName', u'exchangeCD', u'tradeDate', u'longVol', u'CHG', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutWRdGet(beginDate, endDate, contractObject = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取商品期货每日仓单库存信息，包括品种代码、交易市场、仓库名称、上期仓单量、本期仓单量等。因不同交易所发布时间不同，更新时间会有差异。
    
    :param beginDate: 查询tradeDate起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询tradeDate截止日期，输入格式“YYYYMMDD”
    :param contractObject: 品种代码,可以是列表,可空
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutWRd.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&contractObject=")
    if hasattr(contractObject,'__iter__') and not isinstance(contractObject, str):
        if len(contractObject) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = contractObject
            requestString.append(None)
        else:
            requestString.append(','.join(contractObject))
    else:
        requestString.append(contractObject)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutWRdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutWRdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'contractObject', u'exchangeCD', u'unit', u'warehouse', u'preWrVOL', u'wrVOL', u'chg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'contractObject': 'str','exchangeCD': 'str','unit': 'str','warehouse': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktMFutdGet(mainCon = "", contractMark = "", contractObject = "", tradeDate = "", startDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取国内期货日行情信息（底层数据与期货日行情一致，区别是此接口可从主力连续合约角度获取连续行情），包含昨收盘、昨结算、开盘价、最高价、最低价、收盘价、结算价、成交量、成交金额、持仓量、主力合约标记、连续合约标记等。 其中主力合约按持仓量计算，完整的主力连续标记可从getMktFutPre获取。中金所结算价的更新时间为16:20，上期所无成交合约的结算价有可能在16:00左右修正。
    
    :param mainCon: 是否主力（持仓量），1-是；0-否,mainCon、contractMark、contractObject、tradeDate至少选择一个
    :param contractMark: 连续合约标志,mainCon、contractMark、contractObject、tradeDate至少选择一个
    :param contractObject: 期货合约标的代码,mainCon、contractMark、contractObject、tradeDate至少选择一个
    :param tradeDate: 交易日期,mainCon、contractMark、contractObject、tradeDate至少选择一个
    :param startDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktMFutd.csv?ispandas=1&') 
    if not isinstance(mainCon, str) and not isinstance(mainCon, unicode):
        mainCon = str(mainCon)

    requestString.append("mainCon=%s"%(mainCon))
    if not isinstance(contractMark, str) and not isinstance(contractMark, unicode):
        contractMark = str(contractMark)

    requestString.append("&contractMark=%s"%(contractMark))
    if not isinstance(contractObject, str) and not isinstance(contractObject, unicode):
        contractObject = str(contractObject)

    requestString.append("&contractObject=%s"%(contractObject))
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktMFutdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktMFutdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEN', u'tradeDate', u'contractObject', u'contractMark', u'preSettlePrice', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'settlePrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'openInt', u'chg', u'chg1', u'chgPct', u'mainCon', u'smainCon']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEN': 'str','contractObject': 'str','contractMark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktOptdGet(secID = "", optID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取国内期权日行情信息，主要为商品期权及50ETF期权，包含昨结算、昨收盘、开盘价、最高价、最低价、收盘价、结算价、成交量、成交金额、持仓量等。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,secID、optID、ticker、tradeDate至少选择一个
    :param optID: 上交所指定的8位期权编码，商品期权无此字段,secID、optID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,secID、optID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、optID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param exchangeCD: 通联编制的交易市场编码,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktOptd.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(optID, str) and not isinstance(optID, unicode):
        optID = str(optID)

    requestString.append("&optID=%s"%(optID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(exchangeCD, str) and not isinstance(exchangeCD, unicode):
        exchangeCD = str(exchangeCD)

    requestString.append("&exchangeCD=%s"%(exchangeCD))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktOptdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktOptdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'optID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preSettlePrice', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlPrice', u'turnoverVol', u'turnoverValue', u'openInt']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','optID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktOptExerGet(exerDate, secID = "", ticker = "", contractType = "", field = "", pandas = "1"):
    """
    获取上交所50ETF期权标的行权交收信息，50期权为欧式期权，行权交收日固定为到期月份的第四个星期三，每月更新。
    
    :param exerDate: 行权日期，合约到期月份的第四个星期三（遇法定节假日顺延）
    :param secID: 期权标的对应的通联编制的证券编码，可使用DataAPI.SecIDGet获取。目前只有50ETF一种标的，secID为"510050.XSHG",可以是列表,secID、ticker至少选择一个
    :param ticker: 期权标的对应的通联编制的交易市场编码,可以是列表,secID、ticker至少选择一个
    :param contractType: 期权合约类型，CO-认购期权，PO-认沽期权。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktOptExer.csv?ispandas=1&') 
    try:
        exerDate = exerDate.strftime('%Y%m%d')
    except:
        exerDate = exerDate.replace('-', '')
    requestString.append("exerDate=%s"%(exerDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(contractType, str) and not isinstance(contractType, unicode):
        contractType = str(contractType)

    requestString.append("&contractType=%s"%(contractType))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktOptExerGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktOptExerGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exerDate', u'contractType', u'exerVol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','contractType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudAdjGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    获取沪深股票前复权收盘日行情，包含前复权调整后的昨收价、开盘价、最高价、最低价、收盘价等。于除权除息日对历史行情的调整，更新时间为9:00前（含科创板）。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码，如'000001'（可多值输入）,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期，输入格式“YYYYMMDD”,secID、ticker、tradeDate至少选择一个
    :param beginDate: 开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 结束日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 股票今日是否开盘标记：0-未开盘，1-交易日,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudAdj.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqudAdjGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqudAdjGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'negMarketValue', u'dealAmount', u'turnoverRate', u'accumAdjFactor', u'turnoverValue', u'marketValue', u'isOpen']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfGet(secID = "", ticker = "", exDivDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深股票用来调整历史行情的前复权因子数据，包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及对应的生效日期区间。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。只在发生分红、配股、股改事件的除权除息日才有复权因子记录。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、exDivDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、exDivDate至少选择一个
    :param exDivDate: 除权除息日，股改对应股改后首个交易日，输入格式：YYYYMMDD,secID、ticker、exDivDate至少选择一个
    :param beginDate: 除权除息日的起始查询日期,可空
    :param endDate: 除权除息日的截止查询日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        exDivDate = exDivDate.strftime('%Y%m%d')
    except:
        exDivDate = exDivDate.replace('-', '')
    requestString.append("&exDivDate=%s"%(exDivDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktAdjfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktAdjfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'adjFactor', u'accumAdjFactor', u'endDate', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutdVolGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取国内期货日行情信息，包含昨收盘、昨结算、开盘价、最高价、最低价、收盘价、结算价、成交量、成交金额、持仓量、主力合约标记、连续合约标记等。 其中主力合约按成交量计算，完整的主力连续标记可从getMktFutPre获取。中金所结算价的更新时间为16:20，上期所无成交合约的结算价有可能在16:00左右有修正。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutdVol.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutdVolGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutdVolGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'tradeDate', u'contractObject', u'contractMark', u'preSettlePrice', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverValue', u'openInt', u'CHG', u'CHG1', u'CHGPct', u'mainCon', u'smainCon']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','contractObject': 'str','contractMark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktLimitGet(secID = "", ticker = "", tradeDate = "", exchangeCD = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深交易所股票及基金的涨跌停限制信息，包含涨停价、跌停价、达到涨停次数、达到跌停次数（含科创板）。
    
    :param secID: 通联编制的证券编码， 可通过DataAPI.SecIDGet获取。,可以是列表,secID、ticker、tradeDate、exchangeCD至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate、exchangeCD至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate、exchangeCD至少选择一个
    :param exchangeCD: 通联编制的证券市场编码,可以是列表,secID、ticker、tradeDate、exchangeCD至少选择一个
    :param beginDate: 起始查询日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止查询日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktLimit.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktLimitGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktLimitGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEn', u'exchangeCD', u'tradeDate', u'limitUpPrice', u'limitDownPrice', u'upLimitReachedTimes', u'downLimitReachedTimes']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEn': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTipsGet(tipsTypeCD = "", tipsType = "", field = "", pandas = "1"):
    """
    上海证券交易所、深圳证券交易所今日停复牌股票列表。数据更新频率：日。
    
    :param tipsTypeCD: 交易提示类型。H-停牌，R-复牌,可空
    :param tipsType: 交易提示类型中文，可输入中文：“停牌”；“复牌”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getSecTips.csv?ispandas=1&') 
    if not isinstance(tipsTypeCD, str) and not isinstance(tipsTypeCD, unicode):
        tipsTypeCD = str(tipsTypeCD)

    requestString.append("tipsTypeCD=%s"%(tipsTypeCD))
    if not isinstance(tipsType, str) and not isinstance(tipsType, unicode):
        tipsType = str(tipsType)

    requestString.append("&tipsType=%s"%(tipsType))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'SecTipsGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'SecTipsGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'tipsDesc', u'tipsTypeCD', u'tipsType']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','tipsDesc': 'str','tipsTypeCD': 'str','tipsType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFunddAdjGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深基金后复权日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFunddAdj.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFunddAdjGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFunddAdjGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'secShortNameEn', u'ticker', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','secShortNameEn': 'str','ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFunddAdjBfGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深基金前复权日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFunddAdjBf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFunddAdjBfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFunddAdjBfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEn', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEn': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquFlowGet(tradeDate = "", secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深股票日度资金流向数据，包含资金流入、资金流出、资金净流入、开盘净流入、尾盘净流入等（含科创板）。
    
    :param tradeDate: 交易日期,tradeDate、secID、ticker至少选择一个
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,tradeDate、secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquFlow.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquFlowGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquFlowGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEn', u'exchangeCD', u'tradeDate', u'moneyInflow', u'moneyOutflow', u'netMoneyInflow', u'netInflowRate', u'netInflowOpen', u'netInflowClose', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEn': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIndustryFlowGet(tradeDate = "", industryID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深股票每日行业资金流向数据，包含行业资金流入、资金流出、资金净流入、开盘净流入、尾盘净流入等。行业分类标准包含申万一二三级行业及证监会二级行业。
    
    :param tradeDate: 交易日期,tradeDate、industryID至少选择一个
    :param industryID: 通联编制的行业分类编码，可以通过getIndustry获取。证监会二级行业：industryVersionCD=010301，industryLevel=2；申万一二三级行业分类：industryVersionCD=010303,可以是列表,tradeDate、industryID至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIndustryFlow.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIndustryFlowGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIndustryFlowGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryID', u'industryName', u'tradeDate', u'moneyInflow', u'moneyOutflow', u'netMoneyInflow', u'netInflowRate', u'netInflowOpen', u'netInflowClose', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryID': 'str','industryName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfAfGet(secID = "", ticker = "", exchangeCD = "", exDivDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深股票用来调整历史行情的后复权因子数据（以上市价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及对应的生效日期区间。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。只在发生分红、配股、股改事件的除权除息日才有复权因子记录。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param exDivDate: 除权除息日,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param beginDate: 除权除息日的起始查询日期,可空
    :param endDate: 除权除息日的截止查询日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        exDivDate = exDivDate.strftime('%Y%m%d')
    except:
        exDivDate = exDivDate.replace('-', '')
    requestString.append("&exDivDate=%s"%(exDivDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktAdjfAfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktAdjfAfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'splitsRatio', u'adjFactor', u'accumAdjFactor', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudAdjAfGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    获取获取沪深股票后复权收盘日行情，包含后复权调整的昨收价、开盘价、最高价、最低价、收盘价等（含科创板）。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 结束日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 股票今日是否开盘标记：0-未开盘，1-交易日,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudAdjAf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqudAdjAfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqudAdjAfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'turnoverRate', u'accumAdjFactor', u'negMarketValue', u'marketValue', u'isOpen']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquFlowOrderGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深股票日度资金流向的单类大小明细数据，包含小/中/大/超大四种单类的流入、流出、净流入等（含科创板）。其中单类大小定义为：（单位：元）无-N：0小-S:(0，100万]中-M:(100万，500万]大-L:(500万，1000万]超大-XL:1000万以上
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 截止日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquFlowOrder.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquFlowOrderGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquFlowOrderGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'tradeDate', u'inflowS', u'inflowM', u'inflowL', u'inflowXl', u'outflowS', u'outflowM', u'outflowL', u'outflowXl', u'netInflowS', u'netInflowM', u'netInflowL', u'netInflowXl', u'netRateS', u'netRateM', u'netRateL', u'netRateXL', u'mainInflow', u'mainRate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIndustryFlowOrderGet(tradeDate = "", beginDate = "", endDate = "", industryID = "", field = "", pandas = "1"):
    """
    获取沪深股票每日行业资金流向数据，包含小、中、大、超大单及主力的资金流入、资金流出、资金净流入等。行业分类标准包含申万一二三级行业及证监会二级行业。其中单类大小定义为：（单位：元）N：0S:(0，100万]M:(100万，500万]L:(500万，1000万]XL:1000万以上
    
    :param tradeDate: 交易日期,可空
    :param beginDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 截止日期，输入格式为yyyymmdd,可空
    :param industryID: 通联编制的行业分类编码，可以通过getIndustry获取。证监会二级行业：industryVersionCD=010301，industryLevel=2；申万一二三级行业分类：industryVersionCD=010303,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIndustryFlowOrder.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIndustryFlowOrderGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIndustryFlowOrderGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryID', u'industryName', u'tradeDate', u'inflowS', u'inflowM', u'inflowL', u'inflowXl', u'outflowS', u'outflowM', u'outflowL', u'outflowXl', u'netInflowS', u'netInflowM', u'netInflowL', u'netInflowXl', u'netRateS', u'netRateM', u'netRateL', u'netRateXL', u'mainInflow', u'mainRate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryID': 'str','industryName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def InvestorsStatsGet(beginDate, endDate, statCycle = "", field = "", pandas = "1"):
    """
    记录周期内，如一周内新增投资者数量、期末投资者数量、期末持仓投资者数量、期间参与交易的投资者数量的统计数据。周频数据已与2019年2月停止发布，最后一期为20190222。
    
    :param beginDate: 统计周期起始日期为基准，查询起始日，输入格式“YYYYMMDD”
    :param endDate: 统计周期起始日期为基准，查询截止日，输入格式“YYYYMMDD”
    :param statCycle: 统计周期，W-每周,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getInvestorsStats.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(statCycle, str) and not isinstance(statCycle, unicode):
        statCycle = str(statCycle)

    requestString.append("&statCycle=%s"%(statCycle))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'InvestorsStatsGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'InvestorsStatsGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'statsBeginDate', u'statsEnddate', u'newlyIncreased', u'newlyIncreasedNatural', u'newlyIncreasedNonnatural', u'endingNumber', u'endingNatural', u'endingNaturalA', u'endingNaturalB', u'endingNonnatural', u'endingNonnaturalA', u'endingNonnaturalB', u'endingHolding', u'endingHoldingA', u'endingHoldingB', u'endingTrading', u'endingTradingA', u'endingTradingB', u'statCycle']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'statCycle': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktSpotdGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取现货日度收盘行情，包含开盘价、最高价、最低价、收盘价、成交量、持仓量、成交金额等。目前覆盖上海黄金交易所。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用交易代码，输入符号需使用%ASCII码，如Au(T+D)对应Au(T%2bD),可以是列表,secID、ticker至少选择一个
    :param tradeDate: 交易日期,可空
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktSpotd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktSpotdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktSpotdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'chg', u'chgPct', u'wPrice', u'turnoverVolume', u'turnoverValue', u'openInt', u'deliverySide', u'deliveryVol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def InvestorCapitalChgGet(beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    证券及股票期权投资者的资金余额及变动情况
    
    :param beginDate: 统计起始日期为基准，查询起始日，输入格式“YYYYMMDD”,可空
    :param endDate: 统计起始日期为基准，查询截止日，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getInvestorCapitalChg.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'InvestorCapitalChgGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'InvestorCapitalChgGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'statsBeginDate', u'statsEnddate', u'capitalType', u'endingBalance', u'dailyAverage', u'transIn', u'transOut', u'netTransIn', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFxRefRateGet(currencyPair, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取外汇交易中心发布的人民币汇率中间价，包含货币对，中间价等。
    
    :param currencyPair: 货币对，例如100JPY/CNY、AUD/CNY、CAD/CNY、CNY/MYR、CNY/RUB、EUR/CNY、GBP/CNY、HKD/CNY、NZD/CNY、USD/CNY
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFxRefRate.csv?ispandas=1&') 
    if not isinstance(currencyPair, str) and not isinstance(currencyPair, unicode):
        currencyPair = str(currencyPair)

    requestString.append("currencyPair=%s"%(currencyPair))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFxRefRateGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFxRefRateGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'currencyPair', u'midRate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'currencyPair': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktOptStatsGet(tradeDate = "", secID = "", ticker = "", beginDate = "", endDate = "", statsInterval = "", field = "", pandas = "1"):
    """
    获取上交所50ETF期权日度及月度交易统计信息，包含总成交量、认购成交量、认沽成交量、认沽认购比、未平仓合约总数、未平仓认购合约数、未平仓认沽合约数等。
    
    :param tradeDate: 交易日期,tradeDate、secID、ticker至少选择一个
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,tradeDate、secID、ticker至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param statsInterval: 数据统计区间，2-月；4-日,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktOptStats.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&statsInterval=")
    if hasattr(statsInterval,'__iter__') and not isinstance(statsInterval, str):
        if len(statsInterval) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsInterval
            requestString.append(None)
        else:
            requestString.append(','.join(statsInterval))
    else:
        requestString.append(statsInterval)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktOptStatsGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktOptStatsGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'statsInterval', u'tradeDate', u'turnoverVol', u'cVol', u'pVol', u'pcRate', u'openInt', u'cOpenInt', u'pOpenInt']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktOptTdRankGet(ticker = "", secID = "", tradeDate = "", beginDate = "", endDate = "", statsType = "", rank = "", field = "", pandas = "1"):
    """
    获取上交所50ETF期权每日最活跃合约的成交及持仓排名信息，包含统计类型、经营机构名称、排名、标的代码、成交量或持仓量等。统计范围为持仓量排名前三、成交量排名前三的认沽、认购合约，总计四种统计类型。
    
    :param ticker: 期权标的对应的通用交易代码,ticker、secID、tradeDate至少选择一个
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,ticker、secID、tradeDate至少选择一个
    :param tradeDate: 交易日期,ticker、secID、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param statsType: 统计项目类型，0101-成交最大3个合约的认购交易情况;0102-成交最大3个合约的认沽交易情况;0201-持仓最大3个合约的认购交易情况;0202-持仓最大3个合约的认沽交易情况,可空
    :param rank: 排名，根据统计类型排的名次,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktOptTdRank.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(statsType, str) and not isinstance(statsType, unicode):
        statsType = str(statsType)

    requestString.append("&statsType=%s"%(statsType))
    if not isinstance(rank, str) and not isinstance(rank, unicode):
        rank = str(rank)

    requestString.append("&rank=%s"%(rank))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktOptTdRankGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktOptTdRankGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'rank', u'volume', u'partyID', u'partyShortName', u'statsType']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','partyShortName': 'str','statsType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquwGet(secID = "", ticker = "", weekEndDate = "", beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    获取沪深股票未复权周行情，在未复权日行情基础上计算，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param weekEndDate: 当周最后一个交易日，输入格式“YYYYMMDD”,secID、ticker、weekEndDate至少选择一个
    :param beginDate: 查询weekEndDate的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询weekEndDate的截止日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 股票当周是否开盘标记位：0-未开盘，1-有交易。 当周交易天数为0时属于未开盘。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquw.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        weekEndDate = weekEndDate.strftime('%Y%m%d')
    except:
        weekEndDate = weekEndDate.replace('-', '')
    requestString.append("&weekEndDate=%s"%(weekEndDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquwGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquwGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'weekBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn100', u'sdReturn100', u'avgReturn100']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquwAdjGet(secID = "", ticker = "", weekEndDate = "", beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    获取沪深股票前复权周行情，在前复权日行情基础上计算，包含经前复权调整的昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。于除权除息日对历史行情的调整，更新时间为9:00前（含科创板）。
    
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param weekEndDate: 当周最后一个交易日，输入格式“YYYYMMDD”,secID、ticker、weekEndDate至少选择一个
    :param beginDate: 查询weekEndDate的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询weekEndDate的截止日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 股票当周是否开盘标记位：0-未开盘，1-有交易。 当周交易天数为0时属于未开盘。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquwAdj.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        weekEndDate = weekEndDate.strftime('%Y%m%d')
    except:
        weekEndDate = weekEndDate.replace('-', '')
    requestString.append("&weekEndDate=%s"%(weekEndDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquwAdjGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquwAdjGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'weekBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn100', u'sdReturn100', u'avgReturn100']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquwAdjAfGet(secID = "", ticker = "", weekEndDate = "", beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    获取沪深股票后复权周行情，在后复权日行情基础上计算，包含经后复权调整的昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param weekEndDate: 当周最后一个交易日，输入格式“YYYYMMDD”,secID、ticker、weekEndDate至少选择一个
    :param beginDate: 查询weekEndDate的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询weekEndDate的截止日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 股票当周是否开盘标记位：0-未开盘，1-有交易。 当周交易天数为0时属于未开盘。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquwAdjAf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        weekEndDate = weekEndDate.strftime('%Y%m%d')
    except:
        weekEndDate = weekEndDate.replace('-', '')
    requestString.append("&weekEndDate=%s"%(weekEndDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquwAdjAfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquwAdjAfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'weekBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn100', u'sdReturn100', u'avgReturn100']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqumGet(secID = "", ticker = "", monthEndDate = "", beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    获取沪深股票未复权月行情，在未复权日行情基础上计算，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param monthEndDate: 当月最后一个交易日，输入格式“YYYYMMDD”,secID、ticker、monthEndDate至少选择一个
    :param beginDate: 查询monthEndDate的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询monthEndDate的截止日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 股票当月是否开盘标记位：0-未开盘，1-有交易。 当月交易天数为0时属于未开盘。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqum.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        monthEndDate = monthEndDate.strftime('%Y%m%d')
    except:
        monthEndDate = monthEndDate.replace('-', '')
    requestString.append("&monthEndDate=%s"%(monthEndDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqumGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqumGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'monthBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn24', u'sdReturn24', u'avgReturn24', u'varReturn60', u'sdReturn60', u'avgReturn60']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqumAdjGet(secID = "", ticker = "", monthEndDate = "", beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    获取沪深股票前复权月行情，在前复权日行情基础上计算，包含经前复权调整的昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。于除权除息日对历史行情的调整，更新时间为9:00前（含科创板）。
    
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param monthEndDate: 当月最后一个交易日，输入格式“YYYYMMDD”,secID、ticker、monthEndDate至少选择一个
    :param beginDate: 查询monthEndDate的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询monthEndDate的截止日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 股票当月是否开盘标记位：0-未开盘，1-有交易。 当月交易天数为0时属于未开盘。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqumAdj.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        monthEndDate = monthEndDate.strftime('%Y%m%d')
    except:
        monthEndDate = monthEndDate.replace('-', '')
    requestString.append("&monthEndDate=%s"%(monthEndDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqumAdjGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqumAdjGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'monthBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn24', u'sdReturn24', u'avgReturn24', u'varReturn60', u'sdReturn60', u'avgReturn60']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqumAdjAfGet(secID = "", ticker = "", monthEndDate = "", beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    获取沪深股票后复权月行情，在后复权日行情基础上计算，包含经后复权调整的昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param monthEndDate: 当月最后一个交易日，输入格式“YYYYMMDD”,secID、ticker、monthEndDate至少选择一个
    :param beginDate: 查询monthEndDate的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询monthEndDate的截止日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 股票当月是否开盘标记位：0-未开盘，1-有交易。 当月交易天数为0时属于未开盘。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqumAdjAf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        monthEndDate = monthEndDate.strftime('%Y%m%d')
    except:
        monthEndDate = monthEndDate.replace('-', '')
    requestString.append("&monthEndDate=%s"%(monthEndDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqumAdjAfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqumAdjAfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'monthBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn24', u'sdReturn24', u'avgReturn24', u'varReturn60', u'sdReturn60', u'avgReturn60']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIborGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", currency = "", field = "", pandas = "1"):
    """
    获取每日银行间同业拆借利率，覆盖SHIBOR、LIBOR、HIBOR，包含拆借品种的证券编码、拆借日期、拆借币种、拆借利率等。SHIBOR、HIBOR更新时间为11:30，LIBOR更新时间为21:00。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param currency: 拆借币种代码，对应DataAPI.SysCodeGet.codeTypeID=10004,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIbor.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&currency=")
    if hasattr(currency,'__iter__') and not isinstance(currency, str):
        if len(currency) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = currency
            requestString.append(None)
        else:
            requestString.append(','.join(currency))
    else:
        requestString.append(currency)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIborGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIborGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'currency', u'rate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','currency': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIBBonddGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取银行间现券交易日行情，包含开盘、最高、最低、收盘对应的净价及收益率等。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIBBondd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIBBonddGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIBBonddGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'preWAVGPrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'wAvgPrice', u'chgPct', u'turnoverVol', u'preCloseYield', u'preWAVGYield', u'openYield', u'highestYield', u'lowestYield', u'closeYield', u'wAvgYield', u'grossClosePrice', u'accrInterest', u'YTM']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktCBOMOGet(omoType, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取央行公开市场操作信息，包含正回购、逆回购、短期流动性调节工具交易等信息。数据更新时间随央行发布时间而变动。
    
    :param omoType: 公开市场操作交易方式,可以是列表
    :param beginDate: 查询operateDate起始日期，输入格式：YYYYMMDD,可空
    :param endDate: 查询operateDate截止日期，输入格式：YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktCBOMO.csv?ispandas=1&') 
    requestString.append("omoType=")
    if hasattr(omoType,'__iter__') and not isinstance(omoType, str):
        if len(omoType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = omoType
            requestString.append(None)
        else:
            requestString.append(','.join(omoType))
    else:
        requestString.append(omoType)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktCBOMOGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktCBOMOGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'omoTerm', u'operateDate', u'operateDueDate', u'publishDate', u'turnoverVol', u'tenderRate', u'omoType', u'tenderType', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'omoTerm': 'str','remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFxQtRateGet(currencyPair, beginTime = "", endTime = "", field = "", pandas = "1"):
    """
    获取中国银行发布的人民币实时外汇牌价，包含现钞、现汇的买入价/卖出价等。
    
    :param currencyPair: 货币代码
    :param beginTime: 查询publishTime起始时间，格式为YYYYMMDDHHMMSS，如20160222093000,可空
    :param endTime: 查询publishTime截止时间，格式为YYYYMMDDHHMMSS，如20160222113000,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFxQtRate.csv?ispandas=1&') 
    if not isinstance(currencyPair, str) and not isinstance(currencyPair, unicode):
        currencyPair = str(currencyPair)

    requestString.append("currencyPair=%s"%(currencyPair))
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFxQtRateGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFxQtRateGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'currencyPair', u'currencyPairCn', u'publishTime', u'currencyBid', u'cashBid', u'currencyAsk', u'cashAsk', u'conversionPrice', u'partyID', u'partyFullName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'currencyPair': 'str','currencyPairCn': 'str','partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktChiborGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取存款类机构间同业拆借行情，包含开、高、低、收、加权利率等。只统计通过同业拆借中心交易系统达成的交易，若当日无成交，则无记录。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktChibor.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktChiborGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktChiborGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'preCloseRate', u'preCloseWRate', u'openRate', u'highestRate', u'lowestRate', u'closeRate', u'wRate', u'bpChg', u'dealAmount', u'turnoverValue', u'turnoverChg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRankListStocksGet(secID = "", ticker = "", abnormalTypeCD = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深交易所每日交易公开信息中的个股异动情况(龙虎榜)，包括证券代码、异动类型，异动日期、异动偏离值等。沪深公布时间可能会有差异（含科创板）。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、abnormalTypeCD、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、abnormalTypeCD、tradeDate至少选择一个
    :param abnormalTypeCD: 异动类型代码，可从参数集合获取DataAPI.SysCodeGet.codeTypeID=12006,可以是列表,secID、ticker、abnormalTypeCD、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、abnormalTypeCD、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRankListStocks.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&abnormalTypeCD=")
    if hasattr(abnormalTypeCD,'__iter__') and not isinstance(abnormalTypeCD, str):
        if len(abnormalTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = abnormalTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(abnormalTypeCD))
    else:
        requestString.append(abnormalTypeCD)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktRankListStocksGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktRankListStocksGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'abnormalTypeCD', u'abnormalType', u'deviation', u'turnoverVol', u'turnoverValue', u'abnormalBeginDate', u'abnormalEndDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','abnormalType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRankListSalesGet(secID = "", ticker = "", side = "", rank = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深交易所每日交易公开信息中的营业部买卖排名情况，包括证券代码、营业部名称、买卖方向、排名、买入金额、卖出金额等（含科创板）。沪深公布时间可能会有差异。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、side、rank、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、side、rank、tradeDate至少选择一个
    :param side: 买卖方向，B-买入；S-卖出,可以是列表,secID、ticker、side、rank、tradeDate至少选择一个
    :param rank: 排名，提供第1~5名的排名。以对应买卖方向的买入/卖出金额排名,可以是列表,secID、ticker、side、rank、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、side、rank、tradeDate至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRankListSales.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&side=")
    if hasattr(side,'__iter__') and not isinstance(side, str):
        if len(side) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = side
            requestString.append(None)
        else:
            requestString.append(','.join(side))
    else:
        requestString.append(side)
    requestString.append("&rank=")
    if hasattr(rank,'__iter__') and not isinstance(rank, str):
        if len(rank) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = rank
            requestString.append(None)
        else:
            requestString.append(','.join(rank))
    else:
        requestString.append(rank)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktRankListSalesGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktRankListSalesGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'side', u'rank', u'sales', u'buyValue', u'sellValue', u'totalValue', u'abnormalTypeCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','side': 'str','sales': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRefIrGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取货币市场参考利率指标，包含利率指标、利率项、指标代码、利率值等。内容覆盖上海证券交易所债券质押式回购定盘利率和中国外汇交易中心回购定盘利率、七天回购移动平均利率。其中，七天回购移动平均利率于2018年4月9日停止更新。上交所次日盘前更新，银行间T日中午更新。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截至日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRefIr.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktRefIrGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktRefIrGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'sec_ID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'rateType', u'rate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'sec_ID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str','rateType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktExTdShszGet(statsTypeCD = "", statsTypeClassCD = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深交易所股票、基金、债券成交概况，其中深交所股票提供行业的统计情况，包含总市值、总成交金额、上涨下跌数、总成交笔数等。交易所发布数据，更新可能会随发布时间有延迟。
    
    :param statsTypeCD: 统计角度编码,可以是列表,可空
    :param statsTypeClassCD: 角度类型细分编码,可以是列表,可空
    :param beginDate: 起始日期，格式为yyyymmdd,可空
    :param endDate: 截止日期，格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktExTdShsz.csv?ispandas=1&') 
    requestString.append("statsTypeCD=")
    if hasattr(statsTypeCD,'__iter__') and not isinstance(statsTypeCD, str):
        if len(statsTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(statsTypeCD))
    else:
        requestString.append(statsTypeCD)
    requestString.append("&statsTypeClassCD=")
    if hasattr(statsTypeClassCD,'__iter__') and not isinstance(statsTypeClassCD, str):
        if len(statsTypeClassCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsTypeClassCD
            requestString.append(None)
        else:
            requestString.append(','.join(statsTypeClassCD))
    else:
        requestString.append(statsTypeClassCD)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktExTdShszGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktExTdShszGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'statsTypeCD', u'statsType', u'statsTypeClassCD', u'statsTypeClass', u'exchangeCD', u'tradeDate', u'marketValue', u'negMarketValue', u'totalShares', u'floatShares', u'turnoverVol', u'turnoverValue', u'dealAmount', u'avgPE', u'turnoverRate', u'listSecNum', u'tradeSecNum', u'upSecNum', u'flatSecNum', u'downSecNum']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'statsTypeCD': 'str','statsType': 'str','statsTypeClassCD': 'str','statsTypeClass': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktExTdIbGet(tradeTypeCD = "", statsTypeClassCD = "", statsTypeCD = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取中国外汇交易中心同业拆借日报、质押式回购日报、买断式回购日报、现券买卖日报的市场成交情况。该日报数据只统计通过同业拆借中心交易系统达成的交易。
    
    :param tradeTypeCD: 交易类型，同业拆借日报- chibor  质押式回购日报- repo买断式回购日报- orepo现券买卖日报- bond,可以是列表,可空
    :param statsTypeClassCD: 角度类型细分编码，可在DataAPI.SysCodeGet获得，令codeTypeID=12005,选择其中4~6位编码,可以是列表,可空
    :param statsTypeCD: 统计角度编码，可在DataAPI.SysCodeGet获得，令codeTypeID=12005,选择其中2~4位编码,可以是列表,可空
    :param beginDate: 起始日期，格式为yyyymmdd,可空
    :param endDate: 截止日期，格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktExTdIb.csv?ispandas=1&') 
    requestString.append("tradeTypeCD=")
    if hasattr(tradeTypeCD,'__iter__') and not isinstance(tradeTypeCD, str):
        if len(tradeTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tradeTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(tradeTypeCD))
    else:
        requestString.append(tradeTypeCD)
    requestString.append("&statsTypeClassCD=")
    if hasattr(statsTypeClassCD,'__iter__') and not isinstance(statsTypeClassCD, str):
        if len(statsTypeClassCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsTypeClassCD
            requestString.append(None)
        else:
            requestString.append(','.join(statsTypeClassCD))
    else:
        requestString.append(statsTypeClassCD)
    requestString.append("&statsTypeCD=")
    if hasattr(statsTypeCD,'__iter__') and not isinstance(statsTypeCD, str):
        if len(statsTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(statsTypeCD))
    else:
        requestString.append(statsTypeCD)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktExTdIbGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktExTdIbGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeTypeCD', u'statsTypeCD', u'statsType', u'statsTypeClassCD', u'statsTypeClass', u'tradeDate', u'dealAmount', u'dealChg', u'turnoverVol', u'turnoverVolChg', u'wRate', u'bpChg', u'tradableNum', u'tradingNum', u'involvedNum']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'tradeTypeCD': 'str','statsTypeCD': 'str','statsType': 'str','statsTypeClassCD': 'str','statsTypeClass': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktUsequdGet(ticker = "", tradeDate = "", beginDate = "", endDate = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取美股未复权日行情信息，包含开盘价、最高价、最低价、收盘价、成交量等。更新时间为次日11:00（北京时间）。
    
    :param ticker: 通用交易代码,可以是列表,ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,ticker、tradeDate至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktUsequd.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktUsequdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktUsequdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'exchangeCD', u'tradeDate', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfAfIntraDayGet(secID = "", ticker = "", exDivDate = "", field = "", pandas = "1"):
    """
    获取沪深股票用来调整历史行情的后复权因子数据（以上市价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及对应的生效日期区间。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。只在发生分红、配股、股改事件的除权除息日才有复权因子记录。因在盘前更新，收盘价尚未生成时，当日的后复权因子是用前复权因子计算的近似值。与getMktAdjfAfM的区别：提供成交量复权因子。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,可空
    :param exDivDate: 除权除息日,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAfIntraDay.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exDivDate=")
    if hasattr(exDivDate,'__iter__') and not isinstance(exDivDate, str):
        if len(exDivDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exDivDate
            requestString.append(None)
        else:
            requestString.append(','.join(exDivDate))
    else:
        requestString.append(exDivDate)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktAdjfAfIntraDayGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktAdjfAfIntraDayGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'adjFactor', u'accumAdjFactor', u'adjFactor3', u'accumAdjFactor3', u'adjFactor4', u'accumAdjFactor4']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRANKInstTrGet(tradeDate = "", industryID = "", secID = "", industryName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深股票在申万一级行业中的换手率排名信息，每个行业取排名前三的个股，包含行业标准、行业代码、行业名称、证券代码、换手率、排名等（含科创板）。
    
    :param tradeDate: 交易日期,tradeDate、industryID、secID至少选择一个
    :param industryID: 通联编制的行业分类编码，可以通过getIndustry获取。申万一二三级行业分类：industryVersionCD=010303,可以是列表,tradeDate、industryID、secID至少选择一个
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,tradeDate、industryID、secID至少选择一个
    :param industryName: 行业名称，目前可输入申万一级行业名称,可空
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRANKInstTr.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    if not isinstance(industryName, str) and not isinstance(industryName, unicode):
        industryName = str(industryName)

    requestString.append("&industryName=%s"%(industryName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktRANKInstTrGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktRANKInstTrGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'turnoverRate', u'closePrice', u'industryID', u'industryName', u'industry', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','industryID': 'str','industryName': 'str','industry': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxwGet(beginDate = "", endDate = "", indexID = "", ticker = "", field = "", pandas = "1"):
    """
    获取指数周线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。沪深重要指数的更新时间为16:30，其他指数因发布机构不同会陆续更新。
    
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,beginDate、endDate、indexID、ticker至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,beginDate、endDate、indexID、ticker至少选择一个
    :param indexID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,beginDate、endDate、indexID、ticker至少选择一个
    :param ticker: 指数通用代码,可以是列表,beginDate、endDate、indexID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxw.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&indexID=")
    if hasattr(indexID,'__iter__') and not isinstance(indexID, str):
        if len(indexID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indexID
            requestString.append(None)
        else:
            requestString.append(','.join(indexID))
    else:
        requestString.append(indexID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxwGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxwGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'avgPrice', u'wAvgReturn', u'yReturn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxmGet(beginDate = "", endDate = "", indexID = "", ticker = "", field = "", pandas = "1"):
    """
    获取指数月线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。沪深重要指数的更新时间为16:30，其他指数因发布机构不同会陆续更新。
    
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,beginDate、endDate、indexID、ticker至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,beginDate、endDate、indexID、ticker至少选择一个
    :param indexID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,beginDate、endDate、indexID、ticker至少选择一个
    :param ticker: 指数通用代码,可以是列表,beginDate、endDate、indexID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxm.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&indexID=")
    if hasattr(indexID,'__iter__') and not isinstance(indexID, str):
        if len(indexID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indexID
            requestString.append(None)
        else:
            requestString.append(','.join(indexID))
    else:
        requestString.append(indexID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxmGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxmGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'avgPrice', u'mAvgReyurn', u'yReturn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktVolAdjfGet(secID = "", ticker = "", beginDate = "", endDate = "", exchangeCD = "", exDivDate = "", field = "", pandas = "1"):
    """
    获取沪深股票用来调整历史行情的成交量复权因子，包含单次和累积成交量前/后复权因子。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。只在发生分红、配股、股改事件的除权除息日才有复权因子记录。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param beginDate: 除权除息日的起始查询日期,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param endDate: 除权除息日的截止查询日期,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param exDivDate: 除权除息日，股改对应股改后首个交易日，输入格式：YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktVolAdjf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        exDivDate = exDivDate.strftime('%Y%m%d')
    except:
        exDivDate = exDivDate.replace('-', '')
    requestString.append("&exDivDate=%s"%(exDivDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktVolAdjfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktVolAdjfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'exDivDate', u'preShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'splitsRatio', u'adjFactor3', u'accumAdjFactor3', u'adjFactor4', u'accumAdjFactor4', u'endDateAdjf', u'endDateAf', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutwGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取国内期货周行情，在期货日行情基础上计算，包含前收价、前结算、开盘价、最高价、最低价、收盘价、结算价、持仓量、成交量、成交金额等字段。当日无成交的合约不计算。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 查询endDate起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 查询endDate截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutw.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutwGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutwGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverVolChg', u'turnoverValue', u'turnoverValueChg', u'openInt', u'openIntChg', u'chg', u'chg1']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutmGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取国内期货月行情，在期货日行情基础上计算，包含前收价、前结算、开盘价、最高价、最低价、收盘价、结算价、持仓量、成交量、成交金额等字段。当日无成交的合约不计算。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 查询endDate起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 查询endDate截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutm.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutmGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutmGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverVolChg', u'turnoverValue', u'turnoverValueChg', u'openInt', u'openIntChg', u'chg', u'chg1']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfAfMGet(secID = "", ticker = "", exDivDate = "", field = "", pandas = "1"):
    """
    获取沪深股票用来调整历史行情的后复权因子数据（以上市价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及对应的生效日期区间。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。只在发生分红、配股、股改事件的除权除息日才有复权因子记录。因在盘前更新，收盘价尚未生成时，当日的后复权因子是用前复权因子计算的近似值。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、exDivDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、exDivDate至少选择一个
    :param exDivDate: 除权除息日，股改对应股改后首个交易日，输入格式：YYYYMMDD,可以是列表,secID、ticker、exDivDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAfM.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exDivDate=")
    if hasattr(exDivDate,'__iter__') and not isinstance(exDivDate, str):
        if len(exDivDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exDivDate
            requestString.append(None)
        else:
            requestString.append(','.join(exDivDate))
    else:
        requestString.append(exDivDate)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktAdjfAfMGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktAdjfAfMGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'adjFactor', u'accumAdjFactor']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktCmeFutdGet(ticker = "", tradeDate = "", beginDate = "", endDate = "", contractObject = "", field = "", pandas = "1"):
    """
    获取CME Group所有期货合约日行情信息，包含芝加哥商业交易所 (CME)、 芝加哥期货交易所(CBOT)、纽约商业交易所 (NYMEX)、纽约商品交易所 (COMEX)。
    
    :param ticker: 通用交易代码,可以是列表,ticker、tradeDate、beginDate、endDate、contractObject至少选择一个
    :param tradeDate: 交易日期,可以是列表,ticker、tradeDate、beginDate、endDate、contractObject至少选择一个
    :param beginDate: 查询起始交易日期，格式为yyyymmdd,ticker、tradeDate、beginDate、endDate、contractObject至少选择一个
    :param endDate: 查询截止交易日期，格式为yyyymmdd,ticker、tradeDate、beginDate、endDate、contractObject至少选择一个
    :param contractObject: 期货品种代码，其中TAS表示Trade at Settlement,可以是列表,ticker、tradeDate、beginDate、endDate、contractObject至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktCmeFutd.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&tradeDate=")
    if hasattr(tradeDate,'__iter__') and not isinstance(tradeDate, str):
        if len(tradeDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tradeDate
            requestString.append(None)
        else:
            requestString.append(','.join(tradeDate))
    else:
        requestString.append(tradeDate)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&contractObject=")
    if hasattr(contractObject,'__iter__') and not isinstance(contractObject, str):
        if len(contractObject) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = contractObject
            requestString.append(None)
        else:
            requestString.append(','.join(contractObject))
    else:
        requestString.append(contractObject)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktCmeFutdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktCmeFutdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'tradeDate', u'deliYear', u'deliMonth', u'deliDate', u'secFullName', u'contractObject', u'preSettlePrice', u'preOpenInt', u'openPrice', u'highestPrice', u'highestPriceSide', u'lowestPrice', u'lowestPriceSide', u'closePrice', u'closePriceSide', u'settlePrice', u'chg', u'turnoverVol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','secFullName': 'str','contractObject': 'str','highestPriceSide': 'str','lowestPriceSide': 'str','closePriceSide': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutLimitGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取期货合约每个交易日的涨停价和跌停价信息，商品交易所T-1日21:00更新，中金所T日9:00更新。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutLimit.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutLimitGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutLimitGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDATE', u'limitUpPrice', u'limitDownPrice']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIpoConTraddaysGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深股票在新股阶段的连板信息，包含2010年以后上市的股票，包括连板天数及连板收益率等。每只新股一条记录，自上市首日起持续更新，直至收盘时未收获连板（含科创板）。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIpoConTraddays.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIpoConTraddaysGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIpoConTraddaysGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'listDate', u'issuePrice', u'firstDayClosePrice', u'firstDayChgPct', u'breakConClosePrice', u'continiousTradDays', u'conReturn', u'isContinue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxFactorOneDayGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取多个指数历史上某一天的因子数据
    
    :param tradeDate: 交易日期
    :param secID: 多个指数ID，用逗号隔开,可以是列表,可空
    :param ticker: 多个指数代码，用逗号隔开,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxFactorOneDay.csv?ispandas=1&') 
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxFactorOneDayGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxFactorOneDayGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'tradeDate', u'ticker', u'ChgPct', u'Close', u'DownPct', u'LimitDownPct', u'LimitUpPct', u'MA5', u'MA10', u'MA20', u'MA60', u'MA120', u'MACD', u'DIFF', u'DEA', u'PB1', u'PB2', u'PE1', u'PE2', u'RSI12', u'TurnoverValue', u'TurnoverVol', u'UpPct', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxFactorDateRangeGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取一个指数历史上某一时间段的因子数据
    
    :param secID: 一个指数ID,secID、ticker至少选择一个
    :param ticker: 一个指数代码,secID、ticker至少选择一个
    :param beginDate: 开始日期,可空
    :param endDate: 结束日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxFactorDateRange.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    if not isinstance(beginDate, str) and not isinstance(beginDate, unicode):
        beginDate = str(beginDate)

    requestString.append("&beginDate=%s"%(beginDate))
    if not isinstance(endDate, str) and not isinstance(endDate, unicode):
        endDate = str(endDate)

    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxFactorDateRangeGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxFactorDateRangeGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'tradeDate', u'ticker', u'ChgPct', u'Close', u'DownPct', u'LimitDownPct', u'LimitUpPct', u'MA5', u'MA10', u'MA20', u'MA60', u'MA120', u'MACD', u'DIFF', u'DEA', u'PB1', u'PB2', u'PE1', u'PE2', u'RSI12', u'TurnoverValue', u'TurnoverVol', u'UpPct', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktGEMEvaluateGet(beginDate, endDate, field = "", pandas = "1"):
    """
    获取每日创业板估值信息，即每日动态市盈率处于不同水平的股票数量，包含四种标准：50以下（含）、100以下（含）、200以下（含）、200以上（不含）。动态市盈率的逻辑为：总市值/归属于母公司所有者的净利润（最新一期财报年化）。
    
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktGEMEvaluate.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktGEMEvaluateGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktGEMEvaluateGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'numUnder50', u'numUnder100', u'numUnder150', u'numUnder200', u'numOver200']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutOiRatioGet(contractObject, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取期货品种每日多空持仓占比情况，包含每个品种的持买量、持卖量及持卖量比持买量。基于合约持仓排名计算，更新时间可能因发布情况而延迟。
    
    :param contractObject: 查询tradeDate截止日期，输入格式“YYYYMMDD”,可以是列表
    :param beginDate: 查询tradeDate起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutOiRatio.csv?ispandas=1&') 
    requestString.append("contractObject=")
    if hasattr(contractObject,'__iter__') and not isinstance(contractObject, str):
        if len(contractObject) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = contractObject
            requestString.append(None)
        else:
            requestString.append(','.join(contractObject))
    else:
        requestString.append(contractObject)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutOiRatioGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutOiRatioGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'contractObject', u'contractObjectCn', u'tradeDate', u'longOpenInt', u'shortOpenInt', u'ratio']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'contractObject': 'str','contractObjectCn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutIdxBasisGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取中金所股指期货每日升贴水信息，包含期货价格、对应股指点位及升贴水等。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 期货通用交易代码,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutIdxBasis.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutIdxBasisGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutIdxBasisGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'indexID', u'indexSymbol', u'closeIndex', u'basis']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str','indexSymbol': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxdEvalGet(secID = "", ticker = "", beginDate = "", endDate = "", PEType = "", field = "", pandas = "1"):
    """
    获取指数估值信息，包含指数总市值、流通市值、指数市盈率、指数市净率、ROE、成分股涨跌数等信息。请注意：净利润与市值不含PE为负或大于1000的成分股；成分中含B股的，换算为CNY。
    
    :param secID: 指数的证券编码，可使用DataAPI.SecIDGet接口获取到,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 指数的通用代码，目前涵盖47个指数：DY0001-通联全A,000001-上证综指,000009-上证380,000010-上证180,000016-上证50,000068-上证资源,000300-沪深300,000807-中证食品饮料,000827-中证环保,000852-中证1000,000903-中证100,000905-中证500,000906-中证800,000922-中证红利,000925-中证基本面50,000928-中证能源,000932-中证消费,000933-中证医药,000934-中证金融,000944-中证内地资源,000986-中证全指能源,000987-中证全指材料,000988-中证全指工业,000989-中证全指可选,000990-中证全指消费,000991-中证全指医药,000992-中证全指金融,000993-中证全指信息,000998-中证TMT,399001-深证成指,399005-深证中小板指,399006-深证创业板指,399101-深证中小板综,399102-深证创业板综,399324-深证红利,399330-深证100,399396-国证食品,399550-国证央视50,399606-深证创业板R,399610-深证TMT50,399812-中证养老产业,399814-中证大农业,399959-中证军工指数,399971-中证传媒,399983-中证地产等权,399997-中证白酒,399998-中证煤炭。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param PEType: PE类型，1--市盈率ttm；2--动态市盈率,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxdEval.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&PEType=")
    if hasattr(PEType,'__iter__') and not isinstance(PEType, str):
        if len(PEType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = PEType
            requestString.append(None)
        else:
            requestString.append(','.join(PEType))
    else:
        requestString.append(PEType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxdEvalGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxdEvalGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'progFullName', u'secShortName', u'exchangeCD', u'tradeDate', u'indexMarketValue', u'indexIncome', u'indexAttrP', u'PEValue', u'PEType', u'PB', u'ROE', u'indexValue', u'negIndexValue', u'turnoverRate', u'upNum', u'downNum', u'equalNum', u'divYield']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','progFullName': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIndustryEvalGet(beginDate, endDate, industryID = "", PEType = "", field = "", pandas = "1"):
    """
    获取申万一二三级行业估值信息，包含市值、市盈率、市净率等信息。市盈率的算法包含行业成分去极值与负值的条件。
    
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”
    :param industryID: 通联编制的行业分类编码，可以通过getIndustry获取,可以是列表,可空
    :param PEType: PE类型，1-市盈率TTM；2-动态市盈率,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIndustryEval.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    requestString.append("&PEType=")
    if hasattr(PEType,'__iter__') and not isinstance(PEType, str):
        if len(PEType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = PEType
            requestString.append(None)
        else:
            requestString.append(','.join(PEType))
    else:
        requestString.append(PEType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIndustryEvalGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIndustryEvalGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryID', u'industryName', u'tradeDate', u'industryMarketValue', u'industryIncome', u'industryAttrP', u'PEValue', u'PEType', u'PB']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryID': 'str','industryName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRankDivYieldGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深A股的股息率排名信息，包含近一年总分红、股息率、当日排名等，不含近一年无分红的股票。
    
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRankDivYield.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktRankDivYieldGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktRankDivYieldGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'closePrice', u'sumDivTTM', u'divRate', u'rank', u'marketVlalue', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktConsBondPremiumGet(SecID = "", tickerBond = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取可转债折溢价信息，包含每日可转债价格、正股价格、可转债折溢价等。
    
    :param SecID: 可转债的通联编制证券编码，可通过DataAPI.SecIDGet获取,可以是列表,SecID、tickerBond、beginDate、endDate至少选择一个
    :param tickerBond: 可转债通用交易代码,可以是列表,SecID、tickerBond、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,SecID、tickerBond、beginDate、endDate至少选择一个
    :param endDate: 查询起始日期，格式为YYYYMMDD,SecID、tickerBond、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktConsBondPremium.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&tickerBond=")
    if hasattr(tickerBond,'__iter__') and not isinstance(tickerBond, str):
        if len(tickerBond) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tickerBond
            requestString.append(None)
        else:
            requestString.append(','.join(tickerBond))
    else:
        requestString.append(tickerBond)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktConsBondPremiumGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktConsBondPremiumGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'SecID', u'tickerBond', u'secShortNameBond', u'tradeDate', u'closePriceBond', u'tickerEqu', u'secShortNameEqu', u'closePriceEqu', u'convPrice', u'bondPremDisc']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SecID': 'str','tickerBond': 'str','secShortNameBond': 'str','tickerEqu': 'str','secShortNameEqu': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktNeeqEqudGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取新三板股票未复权日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktNeeqEqud.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktNeeqEqudGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktNeeqEqudGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'marketValue', u'negMarketValue', u'chgPct', u'rangePct', u'turnoverRate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktNeeqDpoGet(SecID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日新三板盘前静态信息，包含每只证券当日的基本信息，如证券代码、证券简称、挂牌日期、每股收益、总股本、无限售股份、买卖数量单位、最小价格变动单位、涨跌停价格、除权除息标识等。
    
    :param SecID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,SecID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,SecID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,SecID、ticker、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,SecID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktNeeqDpo.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktNeeqDpoGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktNeeqDpoGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'SecID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'transUnit', u'industryCategory', u'par', u'baseTicker', u'totalShares', u'nonrestFloatShares', u'EPSLy', u'listDate', u'firstAccrDate', u'perDealLimit', u'bidUnit', u'askUnit', u'fdTransLimitCd', u'dTransLimitCd', u'transLimitCdType', u'limitUpPrice', u'limitDownPrice', u'blockLimitUpPrice', u'blockLimitDownPrice', u'divRatio', u'transStatus', u'equType', u'transType', u'marketMakerVol', u'haltSymbol', u'divSymbol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SecID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str','industryCategory': 'str','baseTicker': 'str','transStatus': 'str','equType': 'str','transType': 'str','haltSymbol': 'str','divSymbol': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktSubnewEqudGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深次新股日行情信息，包含证券编码、所属板块、昨收盘、开盘价、最高价、最低价、收盘价、成交量、成交金额、成交笔数、涨跌幅、市盈率、换手率等。次新股定义：上市时间已满两个月但未满一年，并且还没有分红的上市公司。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktSubnewEqud.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktSubnewEqudGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktSubnewEqudGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'boardID', u'boardName', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'PE', u'PE1', u'PB', u'negMarketValue', u'marketValue', u'chgPct', u'turnoverRate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','boardID': 'str','boardName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAHCompdGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日AH同时上市的股票比价信息，包含A股收盘价、H股收盘价以及H股占A股比例等。
    
    :param secID: 通联编制的A股证券编码， 可通过DataAPI.SecIDGet获取。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: A股通用交易代码,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAHCompd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktAHCompdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktAHCompdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'secIDA', u'tradeDate', u'tickerA', u'tickerH', u'secShortNameA', u'secShortNameH', u'closePriceA', u'closePriceH', u'closePriceHA', u'chgPctA', u'chgPctH', u'ahRatio', u'turnoverVolA', u'turnoverVolH']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secIDA': 'str','tickerA': 'str','tickerH': 'str','secShortNameA': 'str','secShortNameH': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxPerformanceGet(SecID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取指数在一段日期内的收益率统计数据，包含近一个月/季/年/N年的平均收益率，收益率标准差和夏普比率等。沪深重要指数的更新时间为17:00，其他指数因发布机构不同会陆续更新。
    
    :param SecID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,SecID、ticker至少选择一个
    :param ticker: 指数通用代码,SecID、ticker至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxPerformance.csv?ispandas=1&') 
    if not isinstance(SecID, str) and not isinstance(SecID, unicode):
        SecID = str(SecID)

    requestString.append("SecID=%s"%(SecID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxPerformanceGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxPerformanceGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'SecID', u'ticker', u'tradeDate', u'avgReturn1M', u'avgReturn3M', u'avgReturn6M', u'avgReturn1Y', u'avgReturn2Y', u'avgReturn3Y', u'avgReturn4Y', u'avgReturn5Y', u'avgReturn6Y', u'avgReturnShis', u'stdDev6M', u'stdDev1Y', u'stdDev2Y', u'stdDev3Y', u'sharpRatio6M', u'sharpRatio1Y', u'sharpRatio2Y', u'sharpRatio3Y']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SecID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktNeeqEquwGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取新三板股票周行情信息，由日行情衍生，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktNeeqEquw.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktNeeqEquwGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktNeeqEquwGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'weekBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'wReturn', u'wVarReturn100', u'wSdReturn100', u'wAvgReturn100']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktNeeqEqumGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取新三板股票月行情信息，由日行情衍生，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktNeeqEqum.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktNeeqEqumGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktNeeqEqumGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'monthBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'mReturn', u'mVarReturn24', u'mSdReturn24', u'mAvgReturn24', u'mVarReturn60', u'mSdReturn60', u'mAvgReturn60']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIndustryQuoteGet(tradeDate = "", beginDate = "", endDate = "", industryID = "", statsFreq = "", field = "", pandas = "1"):
    """
    获取申万三级行业板块区间行情信息，区间维度包含1日、5日、10日、30日、60日、90日、180日、360日、720日、1080日，区间行情的计算方式主要包含算数平均、总市值加权、流通市值加权等。
    
    :param tradeDate: 交易日期,tradeDate、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,tradeDate、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,tradeDate、beginDate、endDate至少选择一个
    :param industryID: 通联编制的行业分类编码，可以通过getIndustry获取。申万三级行业分类：industryVersionCD=010303,industryLevel=2,可以是列表,可空
    :param statsFreq: 统计周期，可输入1、5、10、30、60、90、180、360、720、1080,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIndustryQuote.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    if not isinstance(statsFreq, str) and not isinstance(statsFreq, unicode):
        statsFreq = str(statsFreq)

    requestString.append("&statsFreq=%s"%(statsFreq))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIndustryQuoteGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIndustryQuoteGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryID', u'industryName', u'tradeDate', u'statsFreq', u'varVol', u'openPriceAvg', u'hightestPriceAvg', u'lowestPriceAvg', u'closePriceAvg', u'openPriceTsW', u'highestPriceTsW', u'lowestPriceTsW', u'closePriceTsW', u'openPriceNfaW', u'highestPriceNfaW', u'lowestPriceNfaW', u'closePriceNfaW', u'turnoverVol', u'turnoverValue', u'chgPctAvg', u'chgPctMvW', u'chgPctNmvW', u'turnoverRateAvg', u'turnoverRateMvW', u'turnoverRateNmvW', u'totalMarketValue', u'marketValueAvg', u'totalNegMarketValue', u'negMarketValueAvg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryID': 'str','industryName': 'str','statsFreq': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktConOptMSRGet(tradeDate = "", beginDate = "", endDate = "", secID = "", ticker = "", contractType = "", field = "", pandas = "1"):
    """
    获取每日商品期权会员持卖仓排名信息，覆盖大商所及郑商所，包含标的代码、期权合约类型、持卖仓量、持卖仓量增减、当日排名等。只公布标的期货总持仓量达到一定标准的活跃合约对应的期权系列，详见交易所相关规则。
    
    :param tradeDate: 交易日期,tradeDate、beginDate、endDate至少选择一个
    :param beginDate: 查询tradeDate起始日期，输入格式“YYYYMMDD”,tradeDate、beginDate、endDate至少选择一个
    :param endDate: 查询tradeDate截止日期，输入格式“YYYYMMDD”,tradeDate、beginDate、endDate至少选择一个
    :param secID: 标的合约对应通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 标的合约对应通用交易代码,可以是列表,可空
    :param contractType: 期权合约类型，CO-看涨期权；PO-看跌期权,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktConOptMSR.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&contractType=")
    if hasattr(contractType,'__iter__') and not isinstance(contractType, str):
        if len(contractType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = contractType
            requestString.append(None)
        else:
            requestString.append(','.join(contractType))
    else:
        requestString.append(contractType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktConOptMSRGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktConOptMSRGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'contractType', u'partyShortName', u'exchangeCD', u'tradeDate', u'shortOpenInt', u'chg', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','contractType': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktConOptMLRGet(tradeDate = "", beginDate = "", endDate = "", secID = "", ticker = "", contractType = "", field = "", pandas = "1"):
    """
    获取每日商品期权会员持买仓排名信息，覆盖大商所及郑商所，包含标的代码、期权合约类型、持买仓量、持买仓量增减、当日排名等。只公布标的期货总持仓量达到一定标准的活跃合约对应的期权系列，详见交易所相关规则。
    
    :param tradeDate: 交易日期,tradeDate、beginDate、endDate至少选择一个
    :param beginDate: 查询tradeDate起始日期，输入格式“YYYYMMDD”,tradeDate、beginDate、endDate至少选择一个
    :param endDate: 查询tradeDate截止日期，输入格式“YYYYMMDD”,tradeDate、beginDate、endDate至少选择一个
    :param secID: 标的合约对应通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 标的合约对应通用交易代码,可以是列表,可空
    :param contractType: 期权合约类型，CO-看涨期权；PO-看跌期权,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktConOptMLR.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&contractType=")
    if hasattr(contractType,'__iter__') and not isinstance(contractType, str):
        if len(contractType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = contractType
            requestString.append(None)
        else:
            requestString.append(','.join(contractType))
    else:
        requestString.append(contractType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktConOptMLRGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktConOptMLRGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'contractType', u'partyShortName', u'exchangeCD', u'tradeDate', u'longOpenInt', u'chg', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','contractType': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktConOptMTRGet(tradeDate = "", beginDate = "", endDate = "", secID = "", ticker = "", contractType = "", field = "", pandas = "1"):
    """
    获取每日商品期权会员成交量排名信息，覆盖大商所及郑商所，包含标的代码、期权合约类型、成交量、成交量增减、当日排名等。只公布标的期货总持仓量达到一定标准的活跃合约对应的期权系列，详见交易所相关规则。
    
    :param tradeDate: 交易日期,tradeDate、beginDate、endDate至少选择一个
    :param beginDate: 查询tradeDate起始日期，输入格式“YYYYMMDD”,tradeDate、beginDate、endDate至少选择一个
    :param endDate: 查询tradeDate截止日期，输入格式“YYYYMMDD”,tradeDate、beginDate、endDate至少选择一个
    :param secID: 标的合约对应通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 标的合约对应通用交易代码,可以是列表,可空
    :param contractType: 期权合约类型，CO-看涨期权；PO-看跌期权,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktConOptMTR.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&contractType=")
    if hasattr(contractType,'__iter__') and not isinstance(contractType, str):
        if len(contractType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = contractType
            requestString.append(None)
        else:
            requestString.append(','.join(contractType))
    else:
        requestString.append(contractType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktConOptMTRGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktConOptMTRGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'contractType', u'partyShortName', u'exchangeCD', u'tradeDate', u'turnoverVol', u'chg', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','contractType': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxqGet(secID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取指数季线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。沪深重要指数的更新时间为16:30，其他指数因发布机构不同会陆续更新。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxq.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxqGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxqGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'avgPrice', u'qAvgReyurn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxsGet(secID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取指数半年线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。沪深重要指数的更新时间为16:30，其他指数因发布机构不同会陆续更新。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxs.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxsGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxsGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'avgPrice', u'sAvgReyurn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxaGet(secID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取指数年线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。沪深重要指数的更新时间为16:30，其他指数因发布机构不同会陆续更新。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxa.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxaGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxaGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'avgPrice', u'aAvgReyurn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquqGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票未复权季行情，在未复权日行情基础上计算，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param beginDate: 查询endDate的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquq.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquqGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquqGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquqAdjGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票前复权季行情，在前复权日行情基础上计算，包含经前复权调整的昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。于除权除息日对历史行情的调整，更新时间为9:30前（含科创板）。
    
    :param beginDate: 查询endDate的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquqAdj.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquqAdjGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquqAdjGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquqAdjAfGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票后复权季行情，在后复权日行情基础上计算，包含经后复权调整的昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param beginDate: 查询endDate的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquqAdjAf.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquqAdjAfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquqAdjAfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqusGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票未复权半年行情，在未复权日行情基础上计算，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param beginDate: 查询endDate的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqus.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqusGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqusGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqusAdjGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票前复权半年行情，在前复权日行情基础上计算，包含经前复权调整的昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。于除权除息日对历史行情的调整，更新时间为9:30前（含科创板）。
    
    :param beginDate: 查询endDate的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqusAdj.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqusAdjGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqusAdjGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqusAdjAfGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票后复权半年行情，在后复权日行情基础上计算，包含经后复权调整的昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param beginDate: 查询endDate的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqusAdjAf.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqusAdjAfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqusAdjAfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquaGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票未复权年行情，在未复权日行情基础上计算，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param beginDate: 查询endDate的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqua.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquaGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquaGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquaAdjGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票前复权年行情，在前复权日行情基础上计算，包含经前复权调整的昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。于除权除息日对历史行情的调整，更新时间为9:30前（含科创板）。
    
    :param beginDate: 查询endDate的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquaAdj.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquaAdjGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquaAdjGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquaAdjAfGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票后复权年行情，在后复权日行情基础上计算，包含经后复权调整的昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段（含科创板）。
    
    :param beginDate: 查询endDate的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码， 可使用DataAPI.SecIDGet接口获取到,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquaAdjAf.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquaAdjAfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquaAdjAfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutqGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取国内期货季行情，在期货日行情基础上计算，包含前收价、前结算、开盘价、最高价、最低价、收盘价、结算价、持仓量、成交量、成交金额等字段。当日无成交的合约不计算。
    
    :param beginDate: 查询endDate起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutq.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutqGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutqGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverVolChg', u'turnoverValue', u'turnoverValueChg', u'openInt', u'openIntChg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutsGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取国内期货半年行情，在期货日行情基础上计算，包含前收价、前结算、开盘价、最高价、最低价、收盘价、结算价、持仓量、成交量、成交金额等字段。当日无成交的合约不计算。
    
    :param beginDate: 查询endDate起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFuts.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutsGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutsGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverVolChg', u'turnoverValue', u'turnoverValueChg', u'openInt', u'openIntChg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutaGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取国内期货年行情，在期货日行情基础上计算，包含前收价、前结算、开盘价、最高价、最低价、收盘价、结算价、持仓量、成交量、成交金额等字段。当日无成交的合约不计算。
    
    :param beginDate: 查询endDate起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询endDate截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFuta.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutaGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutaGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverVolChg', u'turnoverValue', u'turnoverValueChg', u'openInt', u'openIntChg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktHKCbbcdGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取港交所牛熊证日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。
    
    :param tradeDate: 交易日期
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktHKCbbcd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktHKCbbcdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktHKCbbcdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktHKDwdGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取港交所权证日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等。
    
    :param tradeDate: 交易日期
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktHKDwd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktHKDwdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktHKDwdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquPerfGet(adjType, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取股票每日最新表现，只提供最新交易日的数据，包含股票一段日期内的涨跌幅，如周、月、季、年等。两种复权类型中推荐使用前复权以更准确的跟踪长期收益率，未复权仅供参考（含科创板）。
    
    :param adjType: 复权类型：1-未复权，2-前复权
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,可空
    :param ticker: 通用交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquPerf.csv?ispandas=1&') 
    if not isinstance(adjType, str) and not isinstance(adjType, unicode):
        adjType = str(adjType)

    requestString.append("adjType=%s"%(adjType))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEquPerfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEquPerfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'adjType', u'chgPct', u'chgPct1W', u'chgPctFw', u'chgPct1M', u'chgPctFm', u'chgPct3M', u'chgPct6M', u'chgPct1Y', u'chgPctFy', u'chgPctFl', u'chgPctSm', u'chgPctTm']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktComIdxdGet(secID = "", ticker = "", beginDate = "", endDate = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取商品指数日行情，涵盖大连商品交易所、上海期货交易所、郑州商品交易所及通联数据自主计算的商品指数日行情信息，包含前收盘价、前结算价、开盘价、最高价、最低价、收盘价、结算价、均价、成交量、成交金额、涨跌、涨跌幅等。更新时间因发布机构不同，大商所及郑商所-16:40，通联-17:20，上期所18:00。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param exchangeCD: 通联编制的交易市场编码,可以是列表,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktComIdxd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktComIdxdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktComIdxdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCd', u'tradeDate', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'averagePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCd': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktBondVwapdGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深交易所债券每日VWAP价格
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 开始日期，格式为YYYYMMDD,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 截止日期，格式为YYYYMMDD,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktBondVwapd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktBondVwapdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktBondVwapdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'VWAP']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktHKEqudAdjGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取港交所股票前复权日行情信息，包含昨收盘价、开盘价、最高价、最低价、收盘价、成交量、成交金额等。有除权除息事件的股票，会在除权除息日对历史行情进行前复权调整。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktHKEqudAdj.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktHKEqudAdjGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktHKEqudAdjGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktInstEqudGet(industrySymbol = "", secID = "", indexSymbol = "", tradeDate = "", industryID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    行业板块行情信息，根据申万一级、二级、三级行业成分计算，包含当日开盘价、最高价、最低价、收盘价、成交量、领涨股、涨股数、达到涨停股数、资金净流入、主力资金净流入额等信息。
    
    :param industrySymbol: 申万行业代码，可从接口getIndustry获取,可以是列表,industrySymbol、secID、indexSymbol、tradeDate、industryID至少选择一个
    :param secID: 行业对应的申万指数内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,industrySymbol、secID、indexSymbol、tradeDate、industryID至少选择一个
    :param indexSymbol: 申万行业对应的指数代码,可以是列表,industrySymbol、secID、indexSymbol、tradeDate、industryID至少选择一个
    :param tradeDate: 交易日期,industrySymbol、secID、indexSymbol、tradeDate、industryID至少选择一个
    :param industryID: 通联编制的行业分类编码，可以通过getIndustry获取。申万一二三级行业分类：industryVersionCD=010303,可以是列表,industrySymbol、secID、indexSymbol、tradeDate、industryID至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktInstEqud.csv?ispandas=1&') 
    requestString.append("industrySymbol=")
    if hasattr(industrySymbol,'__iter__') and not isinstance(industrySymbol, str):
        if len(industrySymbol) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industrySymbol
            requestString.append(None)
        else:
            requestString.append(','.join(industrySymbol))
    else:
        requestString.append(industrySymbol)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&indexSymbol=")
    if hasattr(indexSymbol,'__iter__') and not isinstance(indexSymbol, str):
        if len(indexSymbol) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indexSymbol
            requestString.append(None)
        else:
            requestString.append(','.join(indexSymbol))
    else:
        requestString.append(indexSymbol)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    requestString.append("&industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktInstEqudGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktInstEqudGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industrySymbol', u'industryName', u'secID', u'indexSymbol', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chgPct', u'ticker', u'upNum', u'downNum', u'equalNum', u'upLimitNum', u'downLimitNum', u'turnoverRate', u'netInflow', u'netMainInflow', u'industryID', u'chgPct5', u'chgPct10', u'chgPct20', u'chgPctFY', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industrySymbol': 'str','industryName': 'str','secID': 'str','indexSymbol': 'str','ticker': 'str','industryID': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktInstConsRatioGet(typeID = "", industrySymbol = "", indexSymbol = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取申万一级行业对上证综指及创业板指的贡献度及权重信息，包含行业对指数涨跌的贡献度及行业占板块的权重等。更新时间可能随指数权重而延迟。
    
    :param typeID: 通联编制的行业分类编码，可以通过getIndustry获取。申万一级行业分类：industryVersionCD=010303，industryLevel=1,可以是列表,typeID、industrySymbol、indexSymbol、ticker、tradeDate至少选择一个
    :param industrySymbol: 申万行业代码,可以是列表,typeID、industrySymbol、indexSymbol、ticker、tradeDate至少选择一个
    :param indexSymbol: 申万行业对应的指数代码,可以是列表,typeID、industrySymbol、indexSymbol、ticker、tradeDate至少选择一个
    :param ticker: 指数交易代码，目前支持上证综指000001和创业板指399006,typeID、industrySymbol、indexSymbol、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,typeID、industrySymbol、indexSymbol、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktInstConsRatio.csv?ispandas=1&') 
    requestString.append("typeID=")
    if hasattr(typeID,'__iter__') and not isinstance(typeID, str):
        if len(typeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = typeID
            requestString.append(None)
        else:
            requestString.append(','.join(typeID))
    else:
        requestString.append(typeID)
    requestString.append("&industrySymbol=")
    if hasattr(industrySymbol,'__iter__') and not isinstance(industrySymbol, str):
        if len(industrySymbol) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industrySymbol
            requestString.append(None)
        else:
            requestString.append(','.join(industrySymbol))
    else:
        requestString.append(industrySymbol)
    requestString.append("&indexSymbol=")
    if hasattr(indexSymbol,'__iter__') and not isinstance(indexSymbol, str):
        if len(indexSymbol) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indexSymbol
            requestString.append(None)
        else:
            requestString.append(','.join(indexSymbol))
    else:
        requestString.append(indexSymbol)
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktInstConsRatioGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktInstConsRatioGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'industryName', u'industrySymbol', u'indexSymbol', u'tradeDate', u'indexID', u'ticker', u'consRatio', u'weight']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','industryName': 'str','industrySymbol': 'str','indexSymbol': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktConsBondPerfGet(beginDate, endDate, secID = "", tickerBond = "", tickerEqu = "", field = "", pandas = "1"):
    """
    获取可转换债券每日市场表现数据，包含正股代码、正股名称、发行额(亿元)、剩余规模(亿元)、转债价格、转股价格、正股价格、赎回触发价格、今日涨跌、转债过去一周涨幅、平价/转股溢价率(%)、债底/纯债价值、纯债溢价率等。
    
    :param beginDate: 查询起始日期，格式为YYYYMMDD
    :param endDate: 查询起始日期，格式为YYYYMMDD
    :param secID: 可转债的通联编制证券编码，可通过DataAPI.SecIDGet获取,可以是列表,secID、tickerBond、tickerEqu至少选择一个
    :param tickerBond: 可转债通用交易代码,可以是列表,secID、tickerBond、tickerEqu至少选择一个
    :param tickerEqu: 正股通用交易代码,可以是列表,secID、tickerBond、tickerEqu至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktConsBondPerf.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&tickerBond=")
    if hasattr(tickerBond,'__iter__') and not isinstance(tickerBond, str):
        if len(tickerBond) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tickerBond
            requestString.append(None)
        else:
            requestString.append(','.join(tickerBond))
    else:
        requestString.append(tickerBond)
    requestString.append("&tickerEqu=")
    if hasattr(tickerEqu,'__iter__') and not isinstance(tickerEqu, str):
        if len(tickerEqu) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tickerEqu
            requestString.append(None)
        else:
            requestString.append(','.join(tickerEqu))
    else:
        requestString.append(tickerEqu)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktConsBondPerfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktConsBondPerfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'tickerBond', u'secShortNameBond', u'tickerEqu', u'secShortNameEqu', u'tradeDate', u'totalSize', u'remainSize', u'closePriceBond', u'convPrice', u'closePriceEqu', u'exerPar', u'chgPct', u'chgPct7', u'bondPremRatio', u'debtPuredebtRatio', u'puredebtPremRatio', u'reviseItem', u'triggerItem', u'triggerCondItem']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','tickerBond': 'str','secShortNameBond': 'str','tickerEqu': 'str','secShortNameEqu': 'str','reviseItem': 'str','triggerItem': 'str','triggerCondItem': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktThemedGet(themeID = "", isIndustry = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取主题板块日度行情信息，包含主题的当日开、高、低、收价，成交量、成交金额、涨家数、涨停家数、领涨股等信息
    
    :param themeID: 主题ID，可根据getTkgThemes获取,可以是列表,themeID、isIndustry至少选择一个
    :param isIndustry: 0--否；1--是,themeID、isIndustry至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktThemed.csv?ispandas=1&') 
    requestString.append("themeID=")
    if hasattr(themeID,'__iter__') and not isinstance(themeID, str):
        if len(themeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = themeID
            requestString.append(None)
        else:
            requestString.append(','.join(themeID))
    else:
        requestString.append(themeID)
    if not isinstance(isIndustry, str) and not isinstance(isIndustry, unicode):
        isIndustry = str(isIndustry)

    requestString.append("&isIndustry=%s"%(isIndustry))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktThemedGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktThemedGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'themeID', u'themeName', u'tradeDate', u'preClsoePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chgPct', u'ticker', u'upCount', u'downCount', u'uplimitCount', u'downlimitCount', u'turnoverRate', u'netInflow', u'netMainInflow', u'isIndustry']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'themeName': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktThemewGet(themeID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取主题板块周度行情信息，包含主题的周度开、高、低、收价，成交量、成交金额、资金流入额等信息
    
    :param themeID: 主题ID，可根据getTkgThemes获取,可以是列表,themeID至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktThemew.csv?ispandas=1&') 
    requestString.append("themeID=")
    if hasattr(themeID,'__iter__') and not isinstance(themeID, str):
        if len(themeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = themeID
            requestString.append(None)
        else:
            requestString.append(','.join(themeID))
    else:
        requestString.append(themeID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktThemewGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktThemewGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'themeID', u'themeName', u'endDate', u'preClsoePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'rangePct', u'netInflow', u'netMainInflow']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'themeName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktThememGet(themeID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取主题板块月度行情信息，包含主题的月度开、高、低、收价，成交量、成交金额、资金流入额等信息
    
    :param themeID: 主题ID，可根据getTkgThemes获取,可以是列表,themeID至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktThemem.csv?ispandas=1&') 
    requestString.append("themeID=")
    if hasattr(themeID,'__iter__') and not isinstance(themeID, str):
        if len(themeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = themeID
            requestString.append(None)
        else:
            requestString.append(','.join(themeID))
    else:
        requestString.append(themeID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktThememGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktThememGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'themeID', u'themeName', u'endDate', u'preClsoePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'rangePct', u'netInflow', u'netMainInflow']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'themeName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudStatsGet(beginDate = "", endDate = "", statsTypeClass = "", field = "", pandas = "1"):
    """
    获取股票市场统计信息，包含沪市主板、深市主板、深市创业板、深市中小板成交量、成交金额、市值等汇总信息。
    
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,beginDate、endDate至少选择一个
    :param endDate: 截止日期，输入格式“YYYYMMDD”,beginDate、endDate至少选择一个
    :param statsTypeClass: 统计角度，包括“股票”、“A股”、“B股”、“中小板”、“创业板”。可多值输入，用英文半角,分隔。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudStats.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&statsTypeClass=")
    if hasattr(statsTypeClass,'__iter__') and not isinstance(statsTypeClass, str):
        if len(statsTypeClass) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsTypeClass
            requestString.append(None)
        else:
            requestString.append(','.join(statsTypeClass))
    else:
        requestString.append(statsTypeClass)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqudStatsGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqudStatsGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'statsTypeClass', u'marketValue', u'negMarketValue', u'turnoverVol', u'turnoverValue', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'statsTypeClass': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktThemeMonthGet(themeID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取主题板块月度行情信息，包含主题的月度开、高、低、收价，成交量、成交金额、资金流入额等信息
    
    :param themeID: 主题ID，可根据getTkgThemes获取,可以是列表,themeID至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktThemeMonth.csv?ispandas=1&') 
    requestString.append("themeID=")
    if hasattr(themeID,'__iter__') and not isinstance(themeID, str):
        if len(themeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = themeID
            requestString.append(None)
        else:
            requestString.append(','.join(themeID))
    else:
        requestString.append(themeID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktThemeMonthGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktThemeMonthGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'themeID', u'themeName', u'endDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'rangePct', u'netInflow', u'netMainInflow']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'themeName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktThemeDayGet(themeID = "", tradeDate = "", isIndustry = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取主题板块日度行情信息，包含主题的当日开、高、低、收价，成交量、成交金额、涨家数、涨停家数、领涨股等信息
    
    :param themeID: 主题ID，可根据getTkgThemes获取,可以是列表,themeID、tradeDate、isIndustry至少选择一个
    :param tradeDate: 交易日期，格式为YYYYMMDD,themeID、tradeDate、isIndustry至少选择一个
    :param isIndustry: 是否为行业主题，0--否；1--是,themeID、tradeDate、isIndustry至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktThemeDay.csv?ispandas=1&') 
    requestString.append("themeID=")
    if hasattr(themeID,'__iter__') and not isinstance(themeID, str):
        if len(themeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = themeID
            requestString.append(None)
        else:
            requestString.append(','.join(themeID))
    else:
        requestString.append(themeID)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(isIndustry, str) and not isinstance(isIndustry, unicode):
        isIndustry = str(isIndustry)

    requestString.append("&isIndustry=%s"%(isIndustry))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktThemeDayGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktThemeDayGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'themeID', u'themeName', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chgPct', u'ticker', u'upCount', u'downCount', u'uplimitCount', u'downlimitCount', u'turnoverRate', u'netInflow', u'netMainInflow', u'isIndustry', u'chgPct5', u'chgPct10', u'chgPct20', u'chgPctFY', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'themeName': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktThemeWeekGet(themeID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取主题板块周度行情信息，包含主题的周度开、高、低、收价，成交量、成交金额、资金流入额等信息
    
    :param themeID: 主题ID，可根据getTkgThemes获取,可以是列表,themeID至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktThemeWeek.csv?ispandas=1&') 
    requestString.append("themeID=")
    if hasattr(themeID,'__iter__') and not isinstance(themeID, str):
        if len(themeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = themeID
            requestString.append(None)
        else:
            requestString.append(','.join(themeID))
    else:
        requestString.append(themeID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktThemeWeekGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktThemeWeekGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'themeID', u'themeName', u'endDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'rangePct', u'netInflow', u'netMainInflow']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'themeName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxPerfGet(secID = "", ticker = "", tradeDate = "", progFullName = "", partyID = "", field = "", pandas = "1"):
    """
    获取指数每日最新表现，包含最近一个交易日的周、月、季、半年、年等区间涨跌幅情况。沪深重要指数的更新时间为15:30，其他指数因发布机构不同会陆续更新。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate、progFullName、partyID至少选择一个
    :param ticker: 指数通用代码,可以是列表,secID、ticker、tradeDate、progFullName、partyID至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate、progFullName、partyID至少选择一个
    :param progFullName: 发布机构全称，可模糊搜索。如中证指数有限公司，上海证券交易所等,secID、ticker、tradeDate、progFullName、partyID至少选择一个
    :param partyID: 通联编制的机构编码，可从DataAPI.PartyIDGet查找,可以是列表,secID、ticker、tradeDate、progFullName、partyID至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxPerf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(progFullName, str) and not isinstance(progFullName, unicode):
        progFullName = str(progFullName)

    requestString.append("&progFullName=%s"%(progFullName))
    requestString.append("&partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxPerfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxPerfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'progFullName', u'secShortName', u'exchangeCD', u'tradeDate', u'chgPct', u'chgPct1W', u'chgPctFW', u'chgPct1M', u'chgPctFM', u'chgPct3M', u'chgPctTM', u'chgPct6M', u'chgPctSM', u'chgPct1Y', u'chgPctFY', u'chgPctFL', u'amplitude', u'VR', u'updateTime', u'partyID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','progFullName': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudEvalGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深股票每日估值信息，包含总市值、流通市值、市盈率、市净率、市现率、企业价值倍数等信息（含科创板）。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期，只输入一个日期，可获取到对应日期全部沪深股票的估值信息,secID、ticker、tradeDate至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudEval.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqudEvalGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqudEvalGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'marketValue', u'negMarketValue', u'PE', u'PE1', u'PE2', u'PB', u'PS', u'PS1', u'PCF', u'PCF1', u'PCF2', u'PCF3', u'EV', u'EVEBITDA', u'EVSales', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutPreGet(secID = "", ticker = "", contractObject = "", tradeDate = "", exchangeCD = "", contractMark = "", mainOI = "", mainVol = "", sMainOI = "", sMainVol = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取期货盘前信息，包含主力合约、连续合约、涨跌停限制、保证金率等。持仓量主力为前三个交易日平均持仓量最大的合约，且一月内不反复；成交量主力为前三个交易日平均成交量最大的合约，且一月内不反复。T-1日收盘后更新主力/连续标记，T-1日夜盘开始前更新商品期货的涨跌停价。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、contractObject、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、contractObject、tradeDate至少选择一个
    :param contractObject: 期货品种代码,可以是列表,secID、ticker、contractObject、tradeDate至少选择一个
    :param tradeDate: 交易日期，主力、涨跌停及保证金对应的生效日期,secID、ticker、contractObject、tradeDate至少选择一个
    :param exchangeCD: 通联编制的交易市场编码,可空
    :param contractMark: 连续合约标志，如当月连续L0在每个交易日只对应一个月合约。配合contractObject使用，可提取连续合约全量历史。商品期货：L0-L4；股指期货：L0/L1/L3/L6；国债期货：L3/L6/L9。,可空
    :param mainOI: 是否持仓主力，1-是；0-否。配合contractObject使用，可提取主力全量历史。持仓量判断主力：前三个交易日平均持仓量最大的合约，且一个月内不反复，最后交易日不做为主力。,可空
    :param mainVol: 是否成交主力，1-是；0-否。成交量判断主力：前三个交易日平均成交量最大的合约，且一个月内不反复，最后交易日不做为主力。,可空
    :param sMainOI: 是否持仓次主力，1-是；0-否。配合contractObject使用，可提取主力全量历史。持仓量判断主力：前三个交易日平均持仓量最大的合约，且一个月内不反复，最后交易日不做为主力。,可空
    :param sMainVol: 是否成交次主力，1-是；0-否。成交量判断主力：前三个交易日平均成交量最大的合约，且一个月内不反复，最后交易日不做为主力。,可空
    :param beginDate: 查询tradeDate起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询tradeDate截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutPre.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&contractObject=")
    if hasattr(contractObject,'__iter__') and not isinstance(contractObject, str):
        if len(contractObject) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = contractObject
            requestString.append(None)
        else:
            requestString.append(','.join(contractObject))
    else:
        requestString.append(contractObject)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(exchangeCD, str) and not isinstance(exchangeCD, unicode):
        exchangeCD = str(exchangeCD)

    requestString.append("&exchangeCD=%s"%(exchangeCD))
    if not isinstance(contractMark, str) and not isinstance(contractMark, unicode):
        contractMark = str(contractMark)

    requestString.append("&contractMark=%s"%(contractMark))
    if not isinstance(mainOI, str) and not isinstance(mainOI, unicode):
        mainOI = str(mainOI)

    requestString.append("&mainOI=%s"%(mainOI))
    if not isinstance(mainVol, str) and not isinstance(mainVol, unicode):
        mainVol = str(mainVol)

    requestString.append("&mainVol=%s"%(mainVol))
    if not isinstance(sMainOI, str) and not isinstance(sMainOI, unicode):
        sMainOI = str(sMainOI)

    requestString.append("&sMainOI=%s"%(sMainOI))
    if not isinstance(sMainVol, str) and not isinstance(sMainVol, unicode):
        sMainVol = str(sMainVol)

    requestString.append("&sMainVol=%s"%(sMainVol))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktFutPreGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktFutPreGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'contractObject', u'exchangeCD', u'contractMonth', u'tradeDate', u'contractMark', u'mainOI', u'mainVol', u'sMainOI', u'sMainVol', u'limitUpPrice', u'limitDownPrice', u'tradeMarginRatio', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','contractObject': 'str','exchangeCD': 'str','contractMonth': 'str','contractMark': 'str','mainOI': 'str','mainVol': 'str','sMainOI': 'str','sMainVol': 'str','tradeMarginRatio': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktStockFactorsOneDayProGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取多只股票历史上某一天的因子数据（专业版）。股票因子分三个时间段生产，分别是T日17点00分、T日21点30分和T+1日04点00分生产完成。如果调用的因子中包含还未生产完成的因子会导致所有因子都不会返回。具体每个因子的生产时间在文档中有标注，请在调用因子时确认清楚。
    
    :param tradeDate: 日期
    :param secID: 多只股票ID，用逗号隔开,可以是列表,可空
    :param ticker: 多只股票交易代码，用逗号隔开,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktStockFactorsOneDayPro.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktStockFactorsOneDayProGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktStockFactorsOneDayProGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'AccountsPayablesTDays', u'AccountsPayablesTRate', u'AdminiExpenseRate', u'ARTDays', u'ARTRate', u'ASSI', u'BLEV', u'BondsPayableToAsset', u'CashRateOfSales', u'CashToCurrentLiability', u'CMRA', u'CTOP', u'CTP5', u'CurrentAssetsRatio', u'CurrentAssetsTRate', u'CurrentRatio', u'DAVOL10', u'DAVOL20', u'DAVOL5', u'DDNBT', u'DDNCR', u'DDNSR', u'DebtEquityRatio', u'DebtsAssetRatio', u'DHILO', u'DilutedEPS', u'DVRAT', u'EBITToTOR', u'EGRO', u'EMA10', u'EMA120', u'EMA20', u'EMA5', u'EMA60', u'EPS', u'EquityFixedAssetRatio', u'EquityToAsset', u'EquityTRate', u'ETOP', u'ETP5', u'FinancialExpenseRate', u'FinancingCashGrowRate', u'FixAssetRatio', u'FixedAssetsTRate', u'GrossIncomeRatio', u'HBETA', u'HSIGMA', u'IntangibleAssetRatio', u'InventoryTDays', u'InventoryTRate', u'InvestCashGrowRate', u'LCAP', u'LFLO', u'LongDebtToAsset', u'LongDebtToWorkingCapital', u'LongTermDebtToAsset', u'MA10', u'MA120', u'MA20', u'MA5', u'MA60', u'MAWVAD', u'MFI', u'MLEV', u'NetAssetGrowRate', u'NetProfitGrowRate', u'NetProfitRatio', u'NOCFToOperatingNI', u'NonCurrentAssetsRatio', u'NPParentCompanyGrowRate', u'NPToTOR', u'OperatingExpenseRate', u'OperatingProfitGrowRate', u'OperatingProfitRatio', u'OperatingProfitToTOR', u'OperatingRevenueGrowRate', u'OperCashGrowRate', u'OperCashInToCurrentLiability', u'PB', u'PCF', u'PE', u'PS', u'PSY', u'QuickRatio', u'REVS10', u'REVS20', u'REVS5', u'ROA', u'ROA5', u'ROE', u'ROE5', u'RSI', u'RSTR12', u'RSTR24', u'SalesCostRatio', u'SaleServiceCashToOR', u'SUE', u'TaxRatio', u'TOBT', u'TotalAssetGrowRate', u'TotalAssetsTRate', u'TotalProfitCostRatio', u'TotalProfitGrowRate', u'VOL10', u'VOL120', u'VOL20', u'VOL240', u'VOL5', u'VOL60', u'WVAD', u'REC', u'DAREC', u'GREC', u'FY12P', u'DAREV', u'GREV', u'SFY12P', u'DASREV', u'GSREV', u'FEARNG', u'FSALESG', u'TA2EV', u'CFO2EV', u'ACCA', u'DEGM', u'SUOI', u'EARNMOM', u'FiftyTwoWeekHigh', u'Volatility', u'Skewness', u'ILLIQUIDITY', u'BackwardADJ', u'MACD', u'ADTM', u'ATR14', u'ATR6', u'BIAS10', u'BIAS20', u'BIAS5', u'BIAS60', u'BollDown', u'BollUp', u'CCI10', u'CCI20', u'CCI5', u'CCI88', u'KDJ_K', u'KDJ_D', u'KDJ_J', u'ROC6', u'ROC20', u'SBM', u'STM', u'UpRVI', u'DownRVI', u'RVI', u'SRMI', u'ChandeSD', u'ChandeSU', u'CMO', u'DBCD', u'ARC', u'OBV', u'OBV6', u'OBV20', u'TVMA20', u'TVMA6', u'TVSTD20', u'TVSTD6', u'VDEA', u'VDIFF', u'VEMA10', u'VEMA12', u'VEMA26', u'VEMA5', u'VMACD', u'VOSC', u'VR', u'VROC12', u'VROC6', u'VSTD10', u'VSTD20', u'KlingerOscillator', u'MoneyFlow20', u'AD', u'AD20', u'AD6', u'CoppockCurve', u'ASI', u'ChaikinOscillator', u'ChaikinVolatility', u'EMV14', u'EMV6', u'plusDI', u'minusDI', u'ADX', u'ADXR', u'Aroon', u'AroonDown', u'AroonUp', u'DEA', u'DIFF', u'DDI', u'DIZ', u'DIF', u'MTM', u'MTMMA', u'PVT', u'PVT6', u'PVT12', u'TRIX5', u'TRIX10', u'UOS', u'MA10RegressCoeff12', u'MA10RegressCoeff6', u'PLRC6', u'PLRC12', u'SwingIndex', u'Ulcer10', u'Ulcer5', u'Hurst', u'ACD6', u'ACD20', u'EMA12', u'EMA26', u'APBMA', u'BBI', u'BBIC', u'TEMA10', u'TEMA5', u'MA10Close', u'AR', u'BR', u'ARBR', u'CR20', u'MassIndex', u'BearPower', u'BullPower', u'Elder', u'NVI', u'PVI', u'RC12', u'RC24', u'JDQS20', u'Variance20', u'Variance60', u'Variance120', u'Kurtosis20', u'Kurtosis60', u'Kurtosis120', u'Alpha20', u'Alpha60', u'Alpha120', u'Beta20', u'Beta60', u'Beta120', u'SharpeRatio20', u'SharpeRatio60', u'SharpeRatio120', u'TreynorRatio20', u'TreynorRatio60', u'TreynorRatio120', u'InformationRatio20', u'InformationRatio60', u'InformationRatio120', u'GainVariance20', u'GainVariance60', u'GainVariance120', u'LossVariance20', u'LossVariance60', u'LossVariance120', u'GainLossVarianceRatio20', u'GainLossVarianceRatio60', u'GainLossVarianceRatio120', u'RealizedVolatility', u'REVS60', u'REVS120', u'REVS250', u'REVS750', u'REVS5m20', u'REVS5m60', u'REVS5Indu1', u'REVS20Indu1', u'Volumn1M', u'Volumn3M', u'Price1M', u'Price3M', u'Price1Y', u'Rank1M', u'CashDividendCover', u'DividendCover', u'DividendPaidRatio', u'RetainedEarningRatio', u'CashEquivalentPS', u'DividendPS', u'EPSTTM', u'NetAssetPS', u'TORPS', u'TORPSLatest', u'OperatingRevenuePS', u'OperatingRevenuePSLatest', u'OperatingProfitPS', u'OperatingProfitPSLatest', u'CapitalSurplusFundPS', u'SurplusReserveFundPS', u'UndividedProfitPS', u'RetainedEarningsPS', u'OperCashFlowPS', u'CashFlowPS', u'NetNonOIToTP', u'NetNonOIToTPLatest', u'PeriodCostsRate', u'InterestCover', u'NetProfitGrowRate3Y', u'NetProfitGrowRate5Y', u'OperatingRevenueGrowRate3Y', u'OperatingRevenueGrowRate5Y', u'NetCashFlowGrowRate', u'NetProfitCashCover', u'OperCashInToAsset', u'CashConversionCycle', u'OperatingCycle', u'PEG3Y', u'PEG5Y', u'PEIndu', u'PBIndu', u'PSIndu', u'PCFIndu', u'PEHist20', u'PEHist60', u'PEHist120', u'PEHist250', u'StaticPE', u'ForwardPE', u'EnterpriseFCFPS', u'ShareholderFCFPS', u'ROEDiluted', u'ROEAvg', u'ROEWeighted', u'ROECut', u'ROECutWeighted', u'ROIC', u'ROAEBIT', u'ROAEBITTTM', u'OperatingNIToTP', u'OperatingNIToTPLatest', u'InvestRAssociatesToTP', u'InvestRAssociatesToTPLatest', u'NPCutToNP', u'SuperQuickRatio', u'TSEPToInterestBearDebt', u'DebtTangibleEquityRatio', u'TangibleAToInteBearDebt', u'TangibleAToNetDebt', u'NOCFToTLiability', u'NOCFToInterestBearDebt', u'NOCFToNetDebt', u'TSEPToTotalCapital', u'InteBearDebtToTotalCapital', u'NPParentCompanyCutYOY', u'SalesServiceCashToORLatest', u'CashRateOfSalesLatest', u'NOCFToOperatingNILatest', u'TotalAssets', u'MktValue', u'NegMktValue', u'TEAP', u'NIAP', u'TotalFixedAssets', u'IntFreeCL', u'IntFreeNCL', u'IntCL', u'IntDebt', u'NetDebt', u'NetTangibleAssets', u'WorkingCapital', u'NetWorkingCapital', u'TotalPaidinCapital', u'RetainedEarnings', u'OperateNetIncome', u'ValueChgProfit', u'NetIntExpense', u'EBIT', u'EBITDA', u'EBIAT', u'NRProfitLoss', u'NIAPCut', u'FCFF', u'FCFE', u'DA', u'TRevenueTTM', u'TCostTTM', u'RevenueTTM', u'CostTTM', u'GrossProfitTTM', u'SalesExpenseTTM', u'AdminExpenseTTM', u'FinanExpenseTTM', u'AssetImpairLossTTM', u'NPFromOperatingTTM', u'NPFromValueChgTTM', u'OperateProfitTTM', u'NonOperatingNPTTM', u'TProfitTTM', u'NetProfitTTM', u'NetProfitAPTTM', u'SaleServiceRenderCashTTM', u'NetOperateCFTTM', u'NetInvestCFTTM', u'NetFinanceCFTTM', u'GrossProfit', u'Beta252', u'RSTR504', u'EPIBS', u'CETOP', u'DASTD', u'CmraCNE5', u'HsigmaCNE5', u'SGRO', u'EgibsLong', u'STOM', u'STOQ', u'STOA', u'NLSIZE']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktStockFactorsDateRangeProGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取一只股票历史上某一时间段的因子数据（专业版）。股票因子分三个时间段生产，分别是T日17点00分、T日21点30分和T+1日04点00分生产完成。如果调用的因子中包含还未生产完成的因子会导致所有因子都不会返回。具体每个因子的生产时间在文档中有标注，请在调用因子时确认清楚。
    
    :param secID: 一只股票ID,secID、ticker至少选择一个
    :param ticker: 一只股票交易代码,secID、ticker至少选择一个
    :param beginDate: 开始日期,可空
    :param endDate: 结束日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktStockFactorsDateRangePro.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktStockFactorsDateRangeProGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktStockFactorsDateRangeProGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'AccountsPayablesTDays', u'AccountsPayablesTRate', u'AdminiExpenseRate', u'ARTDays', u'ARTRate', u'ASSI', u'BLEV', u'BondsPayableToAsset', u'CashRateOfSales', u'CashToCurrentLiability', u'CMRA', u'CTOP', u'CTP5', u'CurrentAssetsRatio', u'CurrentAssetsTRate', u'CurrentRatio', u'DAVOL10', u'DAVOL20', u'DAVOL5', u'DDNBT', u'DDNCR', u'DDNSR', u'DebtEquityRatio', u'DebtsAssetRatio', u'DHILO', u'DilutedEPS', u'DVRAT', u'EBITToTOR', u'EGRO', u'EMA10', u'EMA120', u'EMA20', u'EMA5', u'EMA60', u'EPS', u'EquityFixedAssetRatio', u'EquityToAsset', u'EquityTRate', u'ETOP', u'ETP5', u'FinancialExpenseRate', u'FinancingCashGrowRate', u'FixAssetRatio', u'FixedAssetsTRate', u'GrossIncomeRatio', u'HBETA', u'HSIGMA', u'IntangibleAssetRatio', u'InventoryTDays', u'InventoryTRate', u'InvestCashGrowRate', u'LCAP', u'LFLO', u'LongDebtToAsset', u'LongDebtToWorkingCapital', u'LongTermDebtToAsset', u'MA10', u'MA120', u'MA20', u'MA5', u'MA60', u'MAWVAD', u'MFI', u'MLEV', u'NetAssetGrowRate', u'NetProfitGrowRate', u'NetProfitRatio', u'NOCFToOperatingNI', u'NonCurrentAssetsRatio', u'NPParentCompanyGrowRate', u'NPToTOR', u'OperatingExpenseRate', u'OperatingProfitGrowRate', u'OperatingProfitRatio', u'OperatingProfitToTOR', u'OperatingRevenueGrowRate', u'OperCashGrowRate', u'OperCashInToCurrentLiability', u'PB', u'PCF', u'PE', u'PS', u'PSY', u'QuickRatio', u'REVS10', u'REVS20', u'REVS5', u'ROA', u'ROA5', u'ROE', u'ROE5', u'RSI', u'RSTR12', u'RSTR24', u'SalesCostRatio', u'SaleServiceCashToOR', u'SUE', u'TaxRatio', u'TOBT', u'TotalAssetGrowRate', u'TotalAssetsTRate', u'TotalProfitCostRatio', u'TotalProfitGrowRate', u'VOL10', u'VOL120', u'VOL20', u'VOL240', u'VOL5', u'VOL60', u'WVAD', u'REC', u'DAREC', u'GREC', u'FY12P', u'DAREV', u'GREV', u'SFY12P', u'DASREV', u'GSREV', u'FEARNG', u'FSALESG', u'TA2EV', u'CFO2EV', u'ACCA', u'DEGM', u'SUOI', u'EARNMOM', u'FiftyTwoWeekHigh', u'Volatility', u'Skewness', u'ILLIQUIDITY', u'BackwardADJ', u'MACD', u'ADTM', u'ATR14', u'ATR6', u'BIAS10', u'BIAS20', u'BIAS5', u'BIAS60', u'BollDown', u'BollUp', u'CCI10', u'CCI20', u'CCI5', u'CCI88', u'KDJ_K', u'KDJ_D', u'KDJ_J', u'ROC6', u'ROC20', u'SBM', u'STM', u'UpRVI', u'DownRVI', u'RVI', u'SRMI', u'ChandeSD', u'ChandeSU', u'CMO', u'DBCD', u'ARC', u'OBV', u'OBV6', u'OBV20', u'TVMA20', u'TVMA6', u'TVSTD20', u'TVSTD6', u'VDEA', u'VDIFF', u'VEMA10', u'VEMA12', u'VEMA26', u'VEMA5', u'VMACD', u'VOSC', u'VR', u'VROC12', u'VROC6', u'VSTD10', u'VSTD20', u'KlingerOscillator', u'MoneyFlow20', u'AD', u'AD20', u'AD6', u'CoppockCurve', u'ASI', u'ChaikinOscillator', u'ChaikinVolatility', u'EMV14', u'EMV6', u'plusDI', u'minusDI', u'ADX', u'ADXR', u'Aroon', u'AroonDown', u'AroonUp', u'DEA', u'DIFF', u'DDI', u'DIZ', u'DIF', u'MTM', u'MTMMA', u'PVT', u'PVT6', u'PVT12', u'TRIX5', u'TRIX10', u'UOS', u'MA10RegressCoeff12', u'MA10RegressCoeff6', u'PLRC6', u'PLRC12', u'SwingIndex', u'Ulcer10', u'Ulcer5', u'Hurst', u'ACD6', u'ACD20', u'EMA12', u'EMA26', u'APBMA', u'BBI', u'BBIC', u'TEMA10', u'TEMA5', u'MA10Close', u'AR', u'BR', u'ARBR', u'CR20', u'MassIndex', u'BearPower', u'BullPower', u'Elder', u'NVI', u'PVI', u'RC12', u'RC24', u'JDQS20', u'Variance20', u'Variance60', u'Variance120', u'Kurtosis20', u'Kurtosis60', u'Kurtosis120', u'Alpha20', u'Alpha60', u'Alpha120', u'Beta20', u'Beta60', u'Beta120', u'SharpeRatio20', u'SharpeRatio60', u'SharpeRatio120', u'TreynorRatio20', u'TreynorRatio60', u'TreynorRatio120', u'InformationRatio20', u'InformationRatio60', u'InformationRatio120', u'GainVariance20', u'GainVariance60', u'GainVariance120', u'LossVariance20', u'LossVariance60', u'LossVariance120', u'GainLossVarianceRatio20', u'GainLossVarianceRatio60', u'GainLossVarianceRatio120', u'RealizedVolatility', u'REVS60', u'REVS120', u'REVS250', u'REVS750', u'REVS5m20', u'REVS5m60', u'REVS5Indu1', u'REVS20Indu1', u'Volumn1M', u'Volumn3M', u'Price1M', u'Price3M', u'Price1Y', u'Rank1M', u'CashDividendCover', u'DividendCover', u'DividendPaidRatio', u'RetainedEarningRatio', u'CashEquivalentPS', u'DividendPS', u'EPSTTM', u'NetAssetPS', u'TORPS', u'TORPSLatest', u'OperatingRevenuePS', u'OperatingRevenuePSLatest', u'OperatingProfitPS', u'OperatingProfitPSLatest', u'CapitalSurplusFundPS', u'SurplusReserveFundPS', u'UndividedProfitPS', u'RetainedEarningsPS', u'OperCashFlowPS', u'CashFlowPS', u'NetNonOIToTP', u'NetNonOIToTPLatest', u'PeriodCostsRate', u'InterestCover', u'NetProfitGrowRate3Y', u'NetProfitGrowRate5Y', u'OperatingRevenueGrowRate3Y', u'OperatingRevenueGrowRate5Y', u'NetCashFlowGrowRate', u'NetProfitCashCover', u'OperCashInToAsset', u'CashConversionCycle', u'OperatingCycle', u'PEG3Y', u'PEG5Y', u'PEIndu', u'PBIndu', u'PSIndu', u'PCFIndu', u'PEHist20', u'PEHist60', u'PEHist120', u'PEHist250', u'StaticPE', u'ForwardPE', u'EnterpriseFCFPS', u'ShareholderFCFPS', u'ROEDiluted', u'ROEAvg', u'ROEWeighted', u'ROECut', u'ROECutWeighted', u'ROIC', u'ROAEBIT', u'ROAEBITTTM', u'OperatingNIToTP', u'OperatingNIToTPLatest', u'InvestRAssociatesToTP', u'InvestRAssociatesToTPLatest', u'NPCutToNP', u'SuperQuickRatio', u'TSEPToInterestBearDebt', u'DebtTangibleEquityRatio', u'TangibleAToInteBearDebt', u'TangibleAToNetDebt', u'NOCFToTLiability', u'NOCFToInterestBearDebt', u'NOCFToNetDebt', u'TSEPToTotalCapital', u'InteBearDebtToTotalCapital', u'NPParentCompanyCutYOY', u'SalesServiceCashToORLatest', u'CashRateOfSalesLatest', u'NOCFToOperatingNILatest', u'TotalAssets', u'MktValue', u'NegMktValue', u'TEAP', u'NIAP', u'TotalFixedAssets', u'IntFreeCL', u'IntFreeNCL', u'IntCL', u'IntDebt', u'NetDebt', u'NetTangibleAssets', u'WorkingCapital', u'NetWorkingCapital', u'TotalPaidinCapital', u'RetainedEarnings', u'OperateNetIncome', u'ValueChgProfit', u'NetIntExpense', u'EBIT', u'EBITDA', u'EBIAT', u'NRProfitLoss', u'NIAPCut', u'FCFF', u'FCFE', u'DA', u'TRevenueTTM', u'TCostTTM', u'RevenueTTM', u'CostTTM', u'GrossProfitTTM', u'SalesExpenseTTM', u'AdminExpenseTTM', u'FinanExpenseTTM', u'AssetImpairLossTTM', u'NPFromOperatingTTM', u'NPFromValueChgTTM', u'OperateProfitTTM', u'NonOperatingNPTTM', u'TProfitTTM', u'NetProfitTTM', u'NetProfitAPTTM', u'SaleServiceRenderCashTTM', u'NetOperateCFTTM', u'NetInvestCFTTM', u'NetFinanceCFTTM', u'GrossProfit', u'Beta252', u'RSTR504', u'EPIBS', u'CETOP', u'DASTD', u'CmraCNE5', u'HsigmaCNE5', u'SGRO', u'EgibsLong', u'STOM', u'STOQ', u'STOA', u'NLSIZE']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktCryptoCurrdGet(secID = "", currencyPair = "", beginDate = "", endDate = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取数字货币现货日行情信息，包含开盘价、最高价、最低价、收盘价、成交量等，T+1日更新。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、currencyPair、beginDate、endDate、exchangeCD至少选择一个
    :param currencyPair: 货币对通用交易代码，特殊字符需转义，如'|'需转换为'%7c',可以是列表,secID、currencyPair、beginDate、endDate、exchangeCD至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、currencyPair、beginDate、endDate、exchangeCD至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、currencyPair、beginDate、endDate、exchangeCD至少选择一个
    :param exchangeCD: 通联编制的交易市场编码,secID、currencyPair、beginDate、endDate、exchangeCD至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktCryptoCurrd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&currencyPair=")
    if hasattr(currencyPair,'__iter__') and not isinstance(currencyPair, str):
        if len(currencyPair) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = currencyPair
            requestString.append(None)
        else:
            requestString.append(','.join(currencyPair))
    else:
        requestString.append(currencyPair)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(exchangeCD, str) and not isinstance(exchangeCD, unicode):
        exchangeCD = str(exchangeCD)

    requestString.append("&exchangeCD=%s"%(exchangeCD))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktCryptoCurrdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktCryptoCurrdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'currencyPair', u'exchangeCD', u'tradeDate', u'openPrice', u'highPrice', u'lowPrice', u'closePrice', u'turnoverVol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','currencyPair': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktCryptoFutdGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取数字货币期货日行情信息，包含前结算价、开盘价、最高价、最低价、收盘价、结算价等。注：CBOE已于2019年06月停止比特币期货交易。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通用交易代码,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktCryptoFutd.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktCryptoFutdGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktCryptoFutdGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preSettlePrice', u'openPrice', u'highPrice', u'lowPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chg1', u'efp', u'openInt']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','efp': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def StockFctIndicOneDayGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取多只股票历史上某一天的指标数据
    
    :param tradeDate: 日期
    :param secID: 多只股票ID，用逗号隔开,可以是列表,可空
    :param ticker: 多只股票交易代码，用逗号隔开,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getStockFctIndicOneDay.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'StockFctIndicOneDayGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'StockFctIndicOneDayGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'EBITPS', u'RESERPS', u'dividendPS', u'invCFNetInc', u'finCFNetInc', u'finCFps', u'invCFps', u'revenueC3', u'revenueC5', u'netProfitC3', u'netProfitC5', u'roe5', u'CEps', u'TAps', u'chgPct', u'totalShares', u'nonrestFloat', u'dealAmount', u'priceAmp', u'daysOnMkt', u'tradeDays', u'inflowT', u'outflowT', u'netInflowT', u'inflowS', u'inflowM', u'inflowL', u'inflowXl', u'outflowS', u'outflowM', u'outflowL', u'outflowXl', u'netInflowS', u'netInflowS5', u'netInflowS20', u'netInflowM', u'netInflowM5', u'netInflowM20', u'netInflowL', u'netInflowL5', u'netInflowL20', u'netInflowXl', u'netInflowXl5', u'netInflowXl20', u'upLimitTimes', u'upLimitOpen', u'upLimitDay', u'udLimitTimes', u'dnLimitTimes', u'dnLimitOpen', u'dnLimitDay', u'top5NetIn', u'top5NetOut', u'tWorth', u'tROE', u'tProfit', u'tPrice', u'tPE', u'tMobility', u'tMVStyle', u'tLeverage', u'tHbeta', u'tGrowth', u'bulkFundNum', u'bulkFundPct', u'bollUpBreak', u'bollDnBreak', u'rsiGoldCross', u'rsiDeathCross', u'rsiTopDiver', u'rsiBtmDiver', u'rsiShort', u'rsiLong', u'volGoldCross', u'volDeathCross', u'volLong', u'volShort', u'maLong', u'maShort', u'maDeathCross', u'maGoldCross', u'emaLong', u'emaShort', u'emaGoldCross', u'emaDeathCross', u'macdLong', u'macdShort', u'macdTopDiver', u'macdBtmDiver', u'macdGoldCross', u'macdDeathCross', u'macdTopDiverW', u'macdBtmDiverW', u'macdGoldCrossW', u'macdDeathCrossW', u'mfiOB', u'mfiOS', u'crOB', u'crOS', u'cciOB', u'cciOS', u'kdjLong', u'kdjShort', u'kdjLGoldCross', u'kdjHDeathCross', u'kdjBtmDiver', u'kdjTopDiver', u'volatility20', u'volatility60', u'volatility120', u'boldHead', u'boldBottom', u'longUpShadow', u'midUpShadow', u'longLowShadow', u'midLowShadow', u'openLow', u'jumpOpenLow', u'sunK', u'microSun', u'shortSun', u'midSun', u'longSun', u'lunarK', u'microLunar', u'shortLunar', u'midLunar', u'longLunar', u'longT', u'revLongT', u'oneFlag', u'cross', u'shootStar', u'crossDying', u'longCross', u'bearishEngulf', u'shrinkVol', u'enlargeVol', u'above20High', u'above60High', u'below20Low', u'below60Low', u'openHigh', u'multiLongMark', u'jumpOpenHigh', u'mgrHIncNum', u'mgrHIncAmt', u'mgrHIncTimes', u'mgrHIncPct', u'mgrHIncNum5', u'mgrHIncAmt5', u'mgrHIncTimes5', u'mgrHIncPct5', u'mgrHIncNum20', u'mgrHIncAmt20', u'mgrHIncTimes20', u'mgrHIncPct20', u'rFloatNum', u'rFloatPct', u'rFloatNum20', u'rFloatPct20', u'rFloatNum60', u'rFloatPct60', u'accuPFloor', u'accuPCeil', u'preAccuPFloor', u'preAccuPCeil', u'preDays', u'preSTIn', u'preSTSpd', u'punishMark', u'holderNum', u'avgHoldings', u'holderChgPct60', u'instHoldPct', u'instHoldLrr', u'stateHoldPct', u'stateHoldLrr', u'socialHoldPct', u'socialHoldLrr', u'top10HoldPct', u'top10HoldLrr']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def StockFctIndicDateRangeGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取一只股票历史上某一段时间的指标数据
    
    :param secID: 多只股票ID，用逗号隔开,可以是列表,secID、ticker至少选择一个
    :param ticker: 多只股票交易代码，用逗号隔开,可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期,可空
    :param endDate: 截止日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getStockFctIndicDateRange.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'StockFctIndicDateRangeGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'StockFctIndicDateRangeGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'EBITPS', u'RESERPS', u'dividendPS', u'invCFNetInc', u'finCFNetInc', u'finCFps', u'invCFps', u'revenueC3', u'revenueC5', u'netProfitC3', u'netProfitC5', u'roe5', u'CEps', u'TAps', u'chgPct', u'totalShares', u'nonrestFloat', u'dealAmount', u'priceAmp', u'daysOnMkt', u'tradeDays', u'inflowT', u'outflowT', u'netInflowT', u'inflowS', u'inflowM', u'inflowL', u'inflowXl', u'outflowS', u'outflowM', u'outflowL', u'outflowXl', u'netInflowS', u'netInflowS5', u'netInflowS20', u'netInflowM', u'netInflowM5', u'netInflowM20', u'netInflowL', u'netInflowL5', u'netInflowL20', u'netInflowXl', u'netInflowXl5', u'netInflowXl20', u'upLimitTimes', u'upLimitOpen', u'upLimitDay', u'udLimitTimes', u'dnLimitTimes', u'dnLimitOpen', u'dnLimitDay', u'top5NetIn', u'top5NetOut', u'tWorth', u'tROE', u'tProfit', u'tPrice', u'tPE', u'tMobility', u'tMVStyle', u'tLeverage', u'tHbeta', u'tGrowth', u'bulkFundNum', u'bulkFundPct', u'bollUpBreak', u'bollDnBreak', u'rsiGoldCross', u'rsiDeathCross', u'rsiTopDiver', u'rsiBtmDiver', u'rsiShort', u'rsiLong', u'volGoldCross', u'volDeathCross', u'volLong', u'volShort', u'maLong', u'maShort', u'maDeathCross', u'maGoldCross', u'emaLong', u'emaShort', u'emaGoldCross', u'emaDeathCross', u'macdLong', u'macdShort', u'macdTopDiver', u'macdBtmDiver', u'macdGoldCross', u'macdDeathCross', u'macdTopDiverW', u'macdBtmDiverW', u'macdGoldCrossW', u'macdDeathCrossW', u'mfiOB', u'mfiOS', u'crOB', u'crOS', u'cciOB', u'cciOS', u'kdjLong', u'kdjShort', u'kdjLGoldCross', u'kdjHDeathCross', u'kdjBtmDiver', u'kdjTopDiver', u'volatility20', u'volatility60', u'volatility120', u'boldHead', u'boldBottom', u'longUpShadow', u'midUpShadow', u'longLowShadow', u'midLowShadow', u'openLow', u'jumpOpenLow', u'sunK', u'microSun', u'shortSun', u'midSun', u'longSun', u'lunarK', u'microLunar', u'shortLunar', u'midLunar', u'longLunar', u'longT', u'revLongT', u'oneFlag', u'cross', u'shootStar', u'crossDying', u'longCross', u'bearishEngulf', u'shrinkVol', u'enlargeVol', u'above20High', u'above60High', u'below20Low', u'below60Low', u'openHigh', u'multiLongMark', u'jumpOpenHigh', u'mgrHIncNum', u'mgrHIncAmt', u'mgrHIncTimes', u'mgrHIncPct', u'mgrHIncNum5', u'mgrHIncAmt5', u'mgrHIncTimes5', u'mgrHIncPct5', u'mgrHIncNum20', u'mgrHIncAmt20', u'mgrHIncTimes20', u'mgrHIncPct20', u'rFloatNum', u'rFloatPct', u'rFloatNum20', u'rFloatPct20', u'rFloatNum60', u'rFloatPct60', u'accuPFloor', u'accuPCeil', u'preAccuPFloor', u'preAccuPCeil', u'preDays', u'preSTIn', u'preSTSpd', u'punishMark', u'holderNum', u'avgHoldings', u'holderChgPct60', u'instHoldPct', u'instHoldLrr', u'stateHoldPct', u'stateHoldLrr', u'socialHoldPct', u'socialHoldLrr', u'top10HoldPct', u'top10HoldLrr']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxMfGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取指数日度资金流向，提供大小单类明细，包含资金净流入、资金流入、资金流出、小单资金流入、小单资金流出、小单资金净流入等，其中单类大小定义为：（单位：元）N：0；S：(0，100万]；M：(100万，500万]；L：(500万，1000万]；XL：1000万以上。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 指数通用代码,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxMf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIdxMfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIdxMfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'tradeDate', u'netInflow', u'netInflowS', u'netInflowM', u'netInflowL', u'netInflowXl', u'inflow', u'inflowS', u'inflowM', u'inflowL', u'inflowXl', u'outflow', u'outflowS', u'outflowM', u'outflowL', u'outflowXl', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqunMfGet(secID = "", ticker = "", statsFreq = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取近N个交易日的沪深股票资金流向统计数据，包括统计周期，净流入，净流入占比，主力净流入，主力净流入占比，资金流入，资金流出，及小/中/大/超大单类明细等（含科创板）。
    
    :param secID: 通联编制的证券编码，可使用DataAPI.SecIDGet获取,可以是列表,secID、ticker、statsFreq、tradeDate至少选择一个
    :param ticker: 通用交易代码,可以是列表,secID、ticker、statsFreq、tradeDate至少选择一个
    :param statsFreq: 统计周期，交易所近N个交易日，提供三个维度：5、10、20,可以是列表,secID、ticker、statsFreq、tradeDate至少选择一个
    :param tradeDate: 交易日期,secID、ticker、statsFreq、tradeDate至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqunMf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&statsFreq=")
    if hasattr(statsFreq,'__iter__') and not isinstance(statsFreq, str):
        if len(statsFreq) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsFreq
            requestString.append(None)
        else:
            requestString.append(','.join(statsFreq))
    else:
        requestString.append(statsFreq)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktEqunMfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktEqunMfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'statsFreq', u'netInflow', u'netRate', u'mainInflow', u'mainRate', u'netInS', u'netRateS', u'netInM', u'netRateM', u'netInL', u'netRateL', u'netInXL', u'netRateXL', u'inflow', u'inflowS', u'inflowM', u'inflowL', u'inflowXL', u'outflow', u'outflowS', u'outflowM', u'outflowL', u'outflowXL', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','statsFreq': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIndnMfGet(industryID = "", industrySymbol = "", statsFreq = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取一二三级申万行业在不同周期内的资金流向统计数据，包括统计周期，净流入，净流入占比，主力净流入，主力净流入占比，资金流入，资金流出，及各单类明细等。
    
    :param industryID: 通联编制的行业编码，如010303010101。可以使用getIndustry接口获取所有最新industryID，申万一二三级行业分类，industryVersionCD=010303，industryLevel=3，isNew=1。,可以是列表,industryID、industrySymbol、statsFreq、tradeDate至少选择一个
    :param industrySymbol: 申万行业代码，如110101。可以使用getIndustry接口获取所有最新industrySymbol，申万一二三级行业分类，industryVersionCD=010303，industryLevel=3，isNew=1。,可以是列表,industryID、industrySymbol、statsFreq、tradeDate至少选择一个
    :param statsFreq: 统计周期，交易所近N个交易日，目前提供5、10、20三种周期,可以是列表,industryID、industrySymbol、statsFreq、tradeDate至少选择一个
    :param tradeDate: 交易日期,industryID、industrySymbol、statsFreq、tradeDate至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIndnMf.csv?ispandas=1&') 
    requestString.append("industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    requestString.append("&industrySymbol=")
    if hasattr(industrySymbol,'__iter__') and not isinstance(industrySymbol, str):
        if len(industrySymbol) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industrySymbol
            requestString.append(None)
        else:
            requestString.append(','.join(industrySymbol))
    else:
        requestString.append(industrySymbol)
    requestString.append("&statsFreq=")
    if hasattr(statsFreq,'__iter__') and not isinstance(statsFreq, str):
        if len(statsFreq) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsFreq
            requestString.append(None)
        else:
            requestString.append(','.join(statsFreq))
    else:
        requestString.append(statsFreq)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 'MktIndnMfGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 'MktIndnMfGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryID', u'industrySymbol', u'industryName', u'tradeDate', u'statsFreq', u'netInflow', u'netRate', u'mainInflow', u'mainRate', u'netInS', u'netRateS', u'netInM', u'netRateM', u'netInL', u'netRateL', u'netInXL', u'netRateXL', u'inflow', u'inflowS', u'inflowM', u'inflowL', u'inflowXL', u'outflow', u'outflowS', u'outflowM', u'outflowL', u'outflowXL', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryID': 'str','industrySymbol': 'str','industryName': 'str','statsFreq': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtISLatelyGet(field = "", pandas = "1"):
    """
    1、可获取上市公司最近一次数据，根据2007年新会计准则制定的合并利润表模板，仅收集合并报表数据；2、本表中单位为人民币元；4、每季更新（含科创板）。
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtISLately.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtISLatelyGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtISLatelyGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'tRevenue', u'revenue', u'intIncome', u'intExp', u'premEarned', u'commisIncome', u'commisExp', u'TCogs', u'COGS', u'premRefund', u'NCompensPayout', u'reserInsurContr', u'policyDivPayt', u'reinsurExp', u'bizTaxSurchg', u'sellExp', u'adminExp', u'finanExp', u'assetsImpairLoss', u'fValueChgGain', u'investIncome', u'AJInvestIncome', u'forexGain', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'NCADisploss', u'TProfit', u'incomeTax', u'NIncome', u'NIncomeAttrP', u'minorityGain', u'basicEPS', u'dilutedEPS', u'othComprIncome', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'totalShares']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtMainIndiGet(ticker = "", secID = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", field = "", pandas = "1"):
    """
    A股上市公司披露的主要财务指标及数据
    
    :param ticker: 股票交易代码，如'600000',可以是列表,ticker、secID至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'600000.XSHG',可以是列表,ticker、secID至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtMainIndi.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtMainIndiGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtMainIndiGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'fiscalPeriod', u'revenue', u'grossProfit', u'nIncomeAttrP', u'NIncomeCut', u'basicEPS', u'dilutedEPS', u'basicEPSCut', u'dilutedEPSCut', u'ROEW', u'ROECutW', u'NCFOperAPS', u'NAssetPS', u'AssetLiabRatio', u'grossProfitRatio', u'operateProfitRatio', u'nIncomeRatio', u'revenueYOY', u'grossProfitYOY', u'nIncomeAttrPYOY', u'nIncomeCutYOY']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','fiscalPeriod': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtMIndiGet(ticker = "", secID = "", endDate = "", beginDate = "", field = "", pandas = "1"):
    """
    A股上市公司根据利润表计算的财务指标及数据
    
    :param ticker: 股票交易代码，如'600000',可以是列表,ticker、secID至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'600000.XSHG',可以是列表,ticker、secID至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtMIndi.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtMIndiGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtMIndiGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'endDate', u'fiscalPeriod', u'revenue', u'revenueYOY', u'grossProfit', u'grossProfitYOY', u'nIncomeAttrP', u'nIncomeAttrPYOY', u'grossProfitRatio', u'operateProfitRatio', u'nIncomeRatio']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','fiscalPeriod': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtBSInduAlGet(ticker, beginYear = "", endYear = "", field = "", pandas = "1"):
    """
    一般工商业资产负债表，最新一次报表发布的年度数据（含科创板）。
    
    :param ticker: 交易代码,如'000002',可以是列表
    :param beginYear: 会计年度，起始时间，输入格式“YYYY”,可空
    :param endYear: 会计年度，结束时间，输入格式“YYYY”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSInduAl.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtBSInduAlGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtBSInduAlGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'ticker', u'endYear', u'cashCEquiv', u'settProv', u'loanToOthBankFI', u'tradingFA', u'notesReceiv', u'AR', u'prepayment', u'premiumReceiv', u'reinsurReceiv', u'reinsurReserReceiv', u'intReceiv', u'divReceiv', u'othReceiv', u'purResaleFA', u'inventories', u'NCAWithin1Y', u'othCA', u'CAE', u'CAA', u'TCA', u'disburLA', u'availForSaleFA', u'htmInvest', u'LTReceiv', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'CIP', u'constMaterials', u'fixedAssetsDisp', u'producBiolAssets', u'oilAndGasAssets', u'intanAssets', u'RD', u'goodwill', u'LTAmorExp', u'deferTaxAssets', u'othNCA', u'NCAE', u'NCAA', u'TNCA', u'AE', u'AA', u'TAssets', u'STBorr', u'CBBorr', u'depos', u'loanFrOthBankFI', u'tradingFL', u'notesPayable', u'AP', u'advanceReceipts', u'soldForRepurFA', u'commisPayable', u'payrollPayable', u'taxesPayable', u'intPayable', u'divPayable', u'othPayable', u'reinsurPayable', u'insurReser', u'fundsSecTradAgen', u'fundsSecUndwAgen', u'NCLWithin1Y', u'accruedExp', u'othCl', u'CLE', u'CLA', u'TCL', u'LTBorr', u'bondPayable', u'LTPayable', u'specificPayables', u'estimatedLiab', u'deferRevenue', u'deferTaxLiab', u'othNCL', u'NCLE', u'NCLA', u'TNCL', u'LE', u'LA', u'TLiab', u'paidInCapital', u'capitalReser', u'treasuryShare', u'specialReser', u'surplusReser', u'ordinRiskReser', u'retainedEarnings', u'forexDiffer', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSe', u'othEffectSa', u'TShEquity', u'LEE', u'LEA', u'TLiabEquity']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtISInduAlGet(ticker, beginYear = "", endYear = "", field = "", pandas = "1"):
    """
    一般工商业利润表，最新一次报表发布的年度数据（含科创板）。
    
    :param ticker: 交易代码,如'000002',可以是列表
    :param beginYear: 会计年度，起始时间，输入格式“YYYY”,可空
    :param endYear: 会计年度，结束时间，输入格式“YYYY”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtISInduAl.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtISInduAlGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtISInduAlGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'ticker', u'endDate', u'tRevenue', u'revenue', u'intIncome', u'premEarned', u'commisIncome', u'specOr', u'AOR', u'TCogs', u'COGS', u'intExp', u'commisExp', u'premRefund', u'NCompensPayout', u'reserInsurContr', u'policyDivPayt', u'reinsurExp', u'bizTaxSurchg', u'sellExp', u'adminExp', u'finanExp', u'assetsImpairLoss', u'specToc', u'atoc', u'fValueChgGain', u'investIncome', u'AJInvestIncome', u'forexGain', u'assetsDispGain', u'othGain', u'othEffectOp', u'aeEffectOp', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'NCADisploss', u'othEffectTp', u'aeEffectTp', u'TProfit', u'incomeTax', u'othEffectNp', u'aeEffectNp', u'NIncome', u'goingConcernNI', u'quitConcernNI', u'NIncomeBma', u'NIncomeAttrP', u'minorityGain', u'othEffectNpp', u'aeEffectNpp', u'basicEPS', u'dilutedEPS', u'othComprIncome', u'othEffectCi', u'aeEffectCi', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'othEffectPci', u'aeEffectPci']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtCFsAlGet(ticker, beginYear = "", endYear = "", field = "", pandas = "1"):
    """
    上市公司披露根据间接法编制经营活动现金流的现金流量表补充资料（仅有合并报表数据）
    
    :param ticker: 股票代码,可以是列表
    :param beginYear: 会计年度，起始时间，输入格式“YYYY”,可空
    :param endYear: 会计年度，结束时间，输入格式“YYYY”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtCFsAl.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtCFsAlGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtCFsAlGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'publishDate', u'endDate', u'endDateRep', u'reportType', u'fiscalPeriod', u'mergedFlag', u'accoutingStandards', u'currencyCD', u'NIncome', u'assetsImpairLoss', u'FAOGPBDepr', u'intanAssetsAmor', u'LTAmorExpAmor', u'amorExpDecr', u'accrExpIncr', u'dispFaOthLoss', u'FAWritOff', u'FValueChgLoss', u'finanExp', u'invLoss', u'deferTaDecr', u'deferTlIncr', u'invenDecr', u'operReceiDecr', u'operPayaIncr', u'other', u'specNOCF1', u'ANOCF1', u'NCFOperateANotes', u'contrANOCF', u'convDebtCapi', u'convBonds1Y', u'finanLeaFA', u'CEndBal', u'CBegBal', u'CEEndBal', u'CEBegBal', u'specC', u'AC', u'NChangeInCash', u'contrANC']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','reportType': 'str','mergedFlag': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtISFinexpPsAlGet(ticker = "", beginYear = "", endYear = "", field = "", pandas = "1"):
    """
    上市公司财务费用附注明细（每年度最新，含科创板）。
    
    :param ticker: 股票代码，如'000002',可以是列表,ticker、beginYear、endYear至少选择一个
    :param beginYear: 会计年度，起始时间，输入格式“YYYY”,ticker、beginYear、endYear至少选择一个
    :param endYear: 会计年度，结束时间，输入格式“YYYY”,ticker、beginYear、endYear至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtISFinexpPsAl.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtISFinexpPsAlGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtISFinexpPsAlGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'infoSource', u'intExp', u'intExpCapital', u'intIncome', u'intExpDisc', u'intIncomeDisc', u'NIntExp', u'FOccuExp', u'FOccuIncome', u'forexLoss', u'forexLossCapital', u'forexGain', u'forexNLoss', u'CDiscount', u'commission', u'secuExp', u'othFinExp', u'othFinIncome', u'finExp']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtISBankAlGet(ticker, beginYear = "", endYear = "", field = "", pandas = "1"):
    """
    银行业利润表，最新一次报表发布的年度数据
    
    :param ticker: 交易代码,如'000002',可以是列表
    :param beginYear: 会计年度，起始时间，输入格式“YYYY”,可空
    :param endYear: 会计年度，结束时间，输入格式“YYYY”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtISBankAl.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtISBankAlGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtISBankAlGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'ticker', u'endDate', u'revenue', u'NIntIncome', u'intIncome', u'intExp', u'NCommisIncome', u'commisIncome', u'commisExp', u'investIncome', u'AJInvestIncome', u'fValueChgGain', u'forexGain', u'assetsDispGain', u'othGain', u'othOperRev', u'specOr', u'AOR', u'COGS', u'bizTaxSurchg', u'genlAdminExp', u'assetsImpairLoss', u'othOperCosts', u'specOP', u'AOP', u'othEffectOp', u'aeEffectOp', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'othEffectTp', u'aeEffectTp', u'TProfit', u'incomeTax', u'othEffectNp', u'aeEffectNp', u'NIncome', u'goingConcernNI', u'quitConcernNI', u'NIncomeAttrP', u'minorityGain', u'othEffectNpp', u'aeEffectNpp', u'basicEPS', u'dilutedEPS', u'othComprIncome', u'othEffectCi', u'aeEffectCi', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'othEffectPci', u'aeEffectPci']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyID': 'str','ticker': 'str','endDate': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtBSBankAlGet(ticker, beginYear = "", endYear = "", field = "", pandas = "1"):
    """
    银行业资产负债表，最新一次报表发布的年度数据
    
    :param ticker: 交易代码,如'000002',可以是列表
    :param beginYear: 会计年度，起始时间，输入格式“YYYY”,可空
    :param endYear: 会计年度，结束时间，输入格式“YYYY”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSBankAl.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtBSBankAlGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtBSBankAlGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'ticker', u'endYear', u'cReserCB', u'deposInOthBFI', u'preciMetals', u'loanToOthBankFI', u'tradingFA', u'derivAssets', u'purResaleFA', u'intReceiv', u'disburLA', u'finanLeaseReceiv', u'availForSaleFA', u'htmInvest', u'investAsReceiv', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'CIP', u'intanAssets', u'goodwill', u'deferTaxAssets', u'othAssets', u'AE', u'AA', u'TAssets', u'CBBorr', u'deposFrOthBFI', u'loanFrOthBankFI', u'tradingFL', u'derivLiab', u'soldForRepurFA', u'depos', u'payrollPayable', u'taxesPayable', u'intPayable', u'estimatedLiab', u'bondPayable', u'deferTaxLiab', u'othLiab', u'LE', u'LA', u'TLiab', u'paidInCapital', u'capitalReser', u'treasuryShare', u'surplusReser', u'ordinRiskReser', u'retainedEarnings', u'forexDiffer', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSe', u'othEffectSa', u'TShEquity', u'LEE', u'LEA', u'TLiabEquity']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyID': 'str','ticker': 'str','endYear': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtBankTLoanGet(ticker, beginYear = "", endYear = "", field = "", pandas = "1"):
    """
    获取银行业上市公司在扣除贷款减值准备前的贷款总额
    
    :param ticker: 交易代码,如'000002',可以是列表
    :param beginYear: 会计年度，起始时间，输入格式“YYYY”,可空
    :param endYear: 会计年度，结束时间，输入格式“YYYY”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBankTLoan.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtBankTLoanGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtBankTLoanGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'ticker', u'endYear', u'tLoan']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyID': 'str','ticker': 'str','endYear': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtMIndiCalcQGet(secID = "", ticker = "", year = "", reportType = "", field = "", pandas = "1"):
    """
    单季度主要财务指标及数据（季度值），包含营业收入，摊薄每股收益，每股净资产，净资产收益率的单季度数据，通过财务报表数据计算所得（含科创板）。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker至少选择一个
    :param year: 所需调用数据所在年度,可以是列表,可空
    :param reportType: 报告类型。Q1-第一季度，Q2-第二季度，Q3-第三季度，Q4-第四季度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtMIndiCalcQ.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtMIndiCalcQGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtMIndiCalcQGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'year', u'reportType', u'revenue', u'nIncomeAttrP', u'EPS', u'nAssetsPS', u'ROE']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtISSgaPsMYGet(ticker = "", beginYear = "", endYear = "", itemCD = "", field = "", pandas = "1"):
    """
    上市公司业务及管理费附注（每年度主要明细科目），包含职工薪酬及福利，折旧及摊销情况
    
    :param ticker: 交易代码,如'000002',可以是列表,ticker、beginYear、endYear至少选择一个
    :param beginYear: 会计年度，起始时间，输入格式“YYYY”,ticker、beginYear、endYear至少选择一个
    :param endYear: 会计年度，结束时间，输入格式“YYYY”,ticker、beginYear、endYear至少选择一个
    :param itemCD: 科目代码。2037-业务及管理费合计，203701-职工薪酬及福利，203702-折旧及摊销，203703-其他。对应DataAPI.SysCodeGet.codeTypeID=70014。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtISSgaPsMY.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&itemCD=")
    if hasattr(itemCD,'__iter__') and not isinstance(itemCD, str):
        if len(itemCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = itemCD
            requestString.append(None)
        else:
            requestString.append(','.join(itemCD))
    else:
        requestString.append(itemCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtISSgaPsMYGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtISSgaPsMYGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'year', u'itemCD', u'itemName', u'val']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','year': 'str','itemCD': 'str','itemName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtMainOperGet(secID = "", ticker = "", beginDate = "", endDate = "", ifSum = "", classifCD = "", itemTypeCD = "", field = "", pandas = "1"):
    """
    获取上市公司主营业务构成，收集2010年至现在的主营业务构成情况（年度数据）
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,可空
    :param ticker: 交易代码,可以是列表,可空
    :param beginDate: 会计期间截止日期,起始时间,如‘20121231’,可空
    :param endDate: 会计期间截止日期,结束时间,如‘20131231’,可空
    :param ifSum: 是否合计：1-是，2-否,可以是列表,可空
    :param classifCD: 主营业务分类方式。101-按行业，102-按产品，103-按地区。对应DataAPI.SysCodeGet.codeTypeID=70016。,可以是列表,可空
    :param itemTypeCD: 经营项目类别代码。对应DataAPI.SysCodeGet.codeTypeID=70018。对金融行业按产品分类（classifCD=102）经营项目进行分级,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtMainOper.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&ifSum=")
    if hasattr(ifSum,'__iter__') and not isinstance(ifSum, str):
        if len(ifSum) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifSum
            requestString.append(None)
        else:
            requestString.append(','.join(ifSum))
    else:
        requestString.append(ifSum)
    requestString.append("&classifCD=")
    if hasattr(classifCD,'__iter__') and not isinstance(classifCD, str):
        if len(classifCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = classifCD
            requestString.append(None)
        else:
            requestString.append(','.join(classifCD))
    else:
        requestString.append(classifCD)
    requestString.append("&itemTypeCD=")
    if hasattr(itemTypeCD,'__iter__') and not isinstance(itemTypeCD, str):
        if len(itemTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = itemTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(itemTypeCD))
    else:
        requestString.append(itemTypeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtMainOperGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtMainOperGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'endDate', u'industryCategory', u'classifCD', u'classif', u'itemTypeCD', u'itemType', u'itemName', u'ifSum', u'MORevenue', u'MOCost', u'MOIncome', u'MORevenueLY', u'MOCostLY', u'MOIncomeLY', u'MORevenueYOY', u'MOCostYOY', u'MOIncomeYOY']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','industryCategory': 'str','classifCD': 'str','classif': 'str','itemTypeCD': 'str','itemType': 'str','itemName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtBSInsuAlGet(ticker, beginYear = "", endYear = "", field = "", pandas = "1"):
    """
    保险业资产负债表，最新一次报表发布的年度数据
    
    :param ticker: 交易代码,如'000002',可以是列表
    :param beginYear: 会计年度，起始时间，输入格式“YYYY”,可空
    :param endYear: 会计年度，结束时间，输入格式“YYYY”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSInsuAl.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtBSInsuAlGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtBSInsuAlGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'ticker', u'endYear', u'cashCEquiv', u'loanToOthBankFi', u'tradingFA', u'derivAssets', u'purResaleFa', u'intReceiv', u'premiumReceiv', u'subrogRecoReceiv', u'reinsurReceiv', u'RRReinsUnePrem', u'RRReinsOutstdCla', u'RRReinsLinsLiab', u'RRReinsLThinsLiab', u'PHPledgeLoans', u'fixedTermDepos', u'availForSaleFa', u'htmInvest', u'LTEquityInvest', u'refundCapDepos', u'investRealEstate', u'fixedAssets', u'intanAssets', u'indepAccAssets', u'deferTaxAssets', u'othAssets', u'AE', u'AA', u'TAssets', u'STBorr', u'loanFrOthBankFi', u'tradingFL', u'derivLiab', u'soldForRepurFa', u'premReceivAdva', u'commisPayable', u'reinsurPayable', u'payrollPayable', u'taxesPayable', u'indemAccPayable', u'policyDivPayable', u'PHInvest', u'reserUnePrem', u'reserOutstdClaims', u'reserLinsLiab', u'reserLthinsLiab', u'LTBorr', u'bondPayable', u'indeptAccLiab', u'deferTaxLiab', u'othLiab', u'LE', u'LA', u'TLiab', u'paidInCapital', u'capitalReser', u'treasuryShare', u'surplusReser', u'ordinRiskReser', u'retainedEarnings', u'forexDiffer', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSe', u'othEffectSa', u'TShEquity', u'LEE', u'LEA', u'TLiabEquity']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __FdmtISInsuAlGet(ticker, beginYear = "", endYear = "", field = "", pandas = "1"):
    """
    保险业利润表，最新一次报表发布的年度数据
    
    :param ticker: 交易代码,如'000002',可以是列表
    :param beginYear: 会计年度，起始时间，输入格式“YYYY”,可空
    :param endYear: 会计年度，结束时间，输入格式“YYYY”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtISInsuAl.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__FdmtISInsuAlGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__FdmtISInsuAlGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'ticker', u'endYear', u'revenue', u'premEarned', u'grossPremWrit', u'reinsIncome', u'reinsur', u'unePremReser', u'fValueChgGain', u'investIncome', u'AJInvestIncome', u'forexGain', u'assetsDispGain', u'othGain', u'othOperRev', u'specOr', u'AOR', u'COGS', u'premRefund', u'compensPayout', u'compensPayoutRefu', u'reserInsurLiab', u'insurLiabReserRefu', u'policyDivPayt', u'reinsurExp', u'bizTaxSurchg', u'commisExp', u'genlAdminExp', u'reinsCostRefund', u'othOperCosts', u'assetsImpairLoss', u'specOP', u'AOP', u'othEffectOp', u'aeEffectOp', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'othEffectTp', u'aeEffectTp', u'TProfit', u'incomeTax', u'othEffectNp', u'aeEffectNp', u'NIncome', u'goingConcernNI', u'quitConcernNI', u'NIncomeAttrP', u'minorityGain', u'othEffectNpp', u'aeEffectNpp', u'basicEPS', u'dilutedEPS', u'othComprIncome', u'othEffectCi', u'aeEffectCi', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'othEffectPci', u'aeEffectPci']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtIndustryGet(ticker = "", field = "", pandas = "1"):
    """
    所有上市公司最新披露一期数据资产负债表所属行业分类
    
    :param ticker: 交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtIndustry.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtIndustryGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtIndustryGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'industryCategory']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','industryCategory': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __PartyFdmtIndiBSGet(partyID = "", beginDate = "", endDate = "", isLatest = "", field = "", pandas = "1"):
    """
    根据资产负债表中科目计算的财务指标，例如：流动比率、速动比率。
    
    :param partyID: 机构内部ID,可以是列表,partyID、beginDate、endDate、isLatest至少选择一个
    :param beginDate: 会计期末，起始时间，输入格式“YYYYMMDD”,partyID、beginDate、endDate、isLatest至少选择一个
    :param endDate: 会计期末，结束时间，输入格式“YYYYMMDD”,partyID、beginDate、endDate、isLatest至少选择一个
    :param isLatest: 是否最新会计期间，1-是，0-否,可以是列表,partyID、beginDate、endDate、isLatest至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getPartyFdmtIndiBS.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&isLatest=")
    if hasattr(isLatest,'__iter__') and not isinstance(isLatest, str):
        if len(isLatest) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = isLatest
            requestString.append(None)
        else:
            requestString.append(','.join(isLatest))
    else:
        requestString.append(isLatest)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__PartyFdmtIndiBSGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__PartyFdmtIndiBSGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'endDate', u'isLatest', u'currentRatio', u'quickRatio']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtISSecuAllFiscalTGet(ticker = "", secID = "", reportType = "", year = "", beginYear = "", endYear = "", endDate = "", beginDate = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的证券业利润表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的利润表数据（主要是证券业上市公司）；2、仅收集合并报表数据，包括本期和上期数据；3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；4、本表中单位为人民币元；5、每季更新；6、收录每一会计期间最新披露的财务数据；7、整合了单季度和累计的报表。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType、year至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType、year至少选择一个
    :param reportType: 报告类型。Q1-第一季报，Q2-第二季报，Q3-第三季报，Q4-第四季报，S1-半年报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType、year至少选择一个
    :param year: 年度,可以是列表,ticker、secID、reportType、year至少选择一个
    :param beginYear: 年度，开始时间，输入格式“YYYY”,可空
    :param endYear: 年度，结束时间，输入格式“YYYY”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtISSecuAllFiscalT.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtISSecuAllFiscalTGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtISSecuAllFiscalTGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'year', u'reportType', u'revenue', u'NIntIncome', u'NCommisIncome', u'NSecTaIncome', u'NUndwrtSecIncome', u'NTrustIncome', u'investIncome', u'AJInvestIncome', u'fValueChgGain', u'forexGain', u'assetsDispGain', u'othGain', u'othOperRev', u'effectOR', u'COGS', u'bizTaxSurchg', u'genlAdminExp', u'assetsImpairLoss', u'othOperCosts', u'effectOC', u'effectOP', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'effectTP', u'TProfit', u'incomeTax', u'effectNP', u'NIncome', u'goingConcernNI', u'quitConcernNI', u'NIncomeAttrP', u'minorityGain', u'effectNPP', u'basicEPS', u'dilutedEPS', u'othComprIncome', u'effectCI', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'effectPCI']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','year': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtISInsuAllFiscalTGet(ticker = "", secID = "", reportType = "", year = "", beginYear = "", endYear = "", endDate = "", beginDate = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的保险业利润表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的利润表数据（主要是保险业上市公司）；2、仅收集合并报表数据，包括本期和上期数据；3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；4、本表中单位为人民币元；5、每季更新；6、收录每一会计期间最新披露的财务数据；7、整合了单季度和累计的报表。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType、year至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType、year至少选择一个
    :param reportType: 报告类型。Q1-第一季报，Q2-第二季报，Q3-第三季报，Q4-第四季报，S1-半年报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType、year至少选择一个
    :param year: 年度,可以是列表,ticker、secID、reportType、year至少选择一个
    :param beginYear: 年度，开始时间，输入格式“YYYY”,可空
    :param endYear: 年度，结束时间，输入格式“YYYY”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtISInsuAllFiscalT.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtISInsuAllFiscalTGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtISInsuAllFiscalTGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'year', u'reportType', u'revenue', u'premEarned', u'grossPremWrit', u'reinsIncome', u'reinsur', u'unePremReser', u'fValueChgGain', u'investIncome', u'AJInvestIncome', u'forexGain', u'assetsDispGain', u'othGain', u'othOperRev', u'effectOR', u'COGS', u'premRefund', u'compensPayout', u'compensPayoutRefu', u'reserInsurLiab', u'insurLiabReserRefu', u'policyDivPayt', u'reinsurExp', u'commisExp', u'bizTaxSurchg', u'genlAdminExp', u'reinsCostRefund', u'assetsImpairLoss', u'othOperCosts', u'effectOC', u'effectOP', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'effectTP', u'TProfit', u'incomeTax', u'effectNP', u'NIncome', u'goingConcernNI', u'quitConcernNI', u'NIncomeAttrP', u'minorityGain', u'effectNPP', u'basicEPS', u'dilutedEPS', u'othComprIncome', u'effectCI', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'effectPCI']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','year': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtISInduAllFiscalTGet(ticker = "", secID = "", reportType = "", year = "", beginYear = "", endYear = "", endDate = "", beginDate = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的一般工商业利润表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的利润表数据（主要是一般工商业上市公司）；2、仅收集合并报表数据，包括本期和上期数据；3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；4、本表中单位为人民币元；5、每季更新；6、收录每一会计期间最新披露的财务数据；7、整合了单季度和累计的报表。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType、year至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType、year至少选择一个
    :param reportType: 报告类型。Q1-第一季报，Q2-第二季报，Q3-第三季报，Q4-第四季报，S1-半年报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType、year至少选择一个
    :param year: 年度,可以是列表,ticker、secID、reportType、year至少选择一个
    :param beginYear: 年度，开始时间，输入格式“YYYY”,可空
    :param endYear: 年度，结束时间，输入格式“YYYY”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtISInduAllFiscalT.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtISInduAllFiscalTGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtISInduAllFiscalTGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'year', u'reportType', u'tRevenue', u'revenue', u'intIncome', u'premEarned', u'commisIncome', u'effectTOR', u'TCogs', u'COGS', u'intExp', u'commisExp', u'premRefund', u'NCompensPayout', u'reserInsurContr', u'policyDivPayt', u'reinsurExp', u'bizTaxSurchg', u'sellExp', u'adminExp', u'finanExp', u'assetsImpairLoss', u'effectTOC', u'fValueChgGain', u'investIncome', u'AJInvestIncome', u'forexGain', u'assetsDispGain', u'othGain', u'effectOP', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'NCADisploss', u'effectTP', u'TProfit', u'incomeTax', u'effectNP', u'NIncome', u'goingConcernNI', u'quitConcernNI', u'NIncomeAttrP', u'minorityGain', u'effectNPP', u'basicEPS', u'dilutedEPS', u'othComprIncome', u'effectCI', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'effectPCI']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','year': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtISBankAllFiscalTGet(ticker = "", secID = "", reportType = "", year = "", beginYear = "", endYear = "", endDate = "", beginDate = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的银行业利润表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的利润表数据（主要是银行业上市公司）；2、仅收集合并报表数据，包括本期和上期数据；3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；4、本表中单位为人民币元；5、每季更新；6、收录每一会计期间最新披露的财务数据；7、整合了单季度和累计的报表。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType、year至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType、year至少选择一个
    :param reportType: 报告类型。Q1-第一季报，Q2-第二季报，Q3-第三季报，Q4-第四季报，S1-半年报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType、year至少选择一个
    :param year: 年度,可以是列表,ticker、secID、reportType、year至少选择一个
    :param beginYear: 年度，开始时间，输入格式“YYYY”,可空
    :param endYear: 年度，结束时间，输入格式“YYYY”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtISBankAllFiscalT.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtISBankAllFiscalTGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtISBankAllFiscalTGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'year', u'reportType', u'revenue', u'NIntIncome', u'intIncome', u'intExp', u'NCommisIncome', u'commisIncome', u'commisExp', u'investIncome', u'AJInvestIncome', u'fValueChgGain', u'forexGain', u'assetsDispGain', u'othGain', u'othOperRev', u'effectOR', u'COGS', u'bizTaxSurchg', u'genlAdminExp', u'assetsImpairLoss', u'othOperCosts', u'effectOC', u'effectOP', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'effectTP', u'TProfit', u'incomeTax', u'effectNP', u'NIncome', u'goingConcernNI', u'quitConcernNI', u'NIncomeAttrP', u'minorityGain', u'effectNPP', u'basicEPS', u'dilutedEPS', u'othComprIncome', u'effectCI', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'effectPCI']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','year': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtCFSecuAllFiscalTGet(ticker = "", secID = "", reportType = "", year = "", beginYear = "", endYear = "", endDate = "", beginDate = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的证券业现金流量表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的现金流量表数据（主要是证券业上市公司）；2、仅收集合并报表数据，包括本期和上期数据；3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；4、本表中单位为人民币元；5、每季更新；6、收录每一会计期间最新披露的财务数据；7、整合了单季度和累计的报表。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType、year至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType、year至少选择一个
    :param reportType: 报告类型。Q1-第一季报，Q2-第二季报，Q3-第三季报，Q4-第四季报，S1-半年报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType、year至少选择一个
    :param year: 年度,可以是列表,ticker、secID、reportType、year至少选择一个
    :param beginYear: 年度，开始时间，输入格式“YYYY”,可空
    :param endYear: 年度，结束时间，输入格式“YYYY”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtCFSecuAllFiscalT.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtCFSecuAllFiscalTGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtCFSecuAllFiscalTGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'year', u'reportType', u'NIncBorrOthFI', u'NIncDispTradFA', u'NIncDispFaFS', u'IFCCashIncr', u'NIncFrBorr', u'NCApIncrRepur', u'refundOfTax', u'CFrOthOperateA', u'effectOCIF', u'CInfFrOperateA', u'CPaidIFC', u'CPaidToForEmpl', u'CPaidForTaxes', u'CPaidForOthOpA', u'effectOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'effect_CIF', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NCPaidAcquis', u'CPaidOthInvestA', u'effectCOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrBorr', u'CFrIssueBond', u'CFrOthFinanA', u'effectFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'effectFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'effectCE', u'NChangeInCash', u'NCEBegBal', u'effectCEI', u'NCEEndBal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','year': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtCFInsuAllFiscalTGet(ticker = "", secID = "", reportType = "", year = "", beginYear = "", endYear = "", endDate = "", beginDate = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的保险业现金流量表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的现金流量表数据（主要是保险业上市公司）；2、仅收集合并报表数据，包括本期和上期数据；3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；4、本表中单位为人民币元；5、每季更新；6、收录每一会计期间最新披露的财务数据；7、整合了单季度和累计的报表。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType、year至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType、year至少选择一个
    :param reportType: 报告类型。Q1-第一季报，Q2-第二季报，Q3-第三季报，Q4-第四季报，S1-半年报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType、year至少选择一个
    :param year: 年度,可以是列表,ticker、secID、reportType、year至少选择一个
    :param beginYear: 年度，开始时间，输入格式“YYYY”,可空
    :param endYear: 年度，结束时间，输入格式“YYYY”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtCFInsuAllFiscalT.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtCFInsuAllFiscalTGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtCFInsuAllFiscalTGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'year', u'reportType', u'NDeposIncrCFI', u'NIncrBorrFrCB', u'premFrOrigContr', u'NReinsurPrem', u'NIncPhDeposInv', u'IFCCashIncr', u'refundOfTax', u'CFrOthOperateA', u'effectOCIF', u'CInfFrOperateA', u'NIncDisburOfLA', u'NIncrDeposInFI', u'origContrCIndem', u'CPaidIFC', u'CPaidPolDiv', u'CPaidToForEmpl', u'CPaidForTaxes', u'CPaidForOthOpA', u'effectOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'effect_CIF', u'CInfFrInvestA', u'PurFixAssetsOth', u'CPaidInvest', u'NIncrPledgeLoan', u'NCPaidAcquis', u'CPaidOthInvestA', u'effectCOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrBorr', u'CFrIssueBond', u'CFrOthFinanA', u'effectFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'effectFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'effectCE', u'NChangeInCash', u'NCEBegBal', u'effectCEI', u'NCEEndBal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','year': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtCFInduAllFiscalTGet(ticker = "", secID = "", reportType = "", year = "", beginYear = "", endYear = "", endDate = "", beginDate = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的一般工商业现金流量表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的现金流量表数据（主要是一般工商业上市公司）；2、仅收集合并报表数据，包括本期和上期数据；3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；4、本表中单位为人民币元；5、每季更新；6、收录每一会计期间最新披露的财务数据；7、整合了单季度和累计的报表。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType、year至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType、year至少选择一个
    :param reportType: 报告类型。Q1-第一季报，Q2-第二季报，Q3-第三季报，Q4-第四季报，S1-半年报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType、year至少选择一个
    :param year: 年度,可以是列表,ticker、secID、reportType、year至少选择一个
    :param beginYear: 年度，开始时间，输入格式“YYYY”,可空
    :param endYear: 年度，结束时间，输入格式“YYYY”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtCFInduAllFiscalT.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtCFInduAllFiscalTGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtCFInduAllFiscalTGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'year', u'reportType', u'CFrSaleGS', u'NDeposIncrCFI', u'NIncrBorrFrCB', u'NIncBorrOthFI', u'premFrOrigContr', u'NReinsurPrem', u'NIncPhDeposInv', u'NIncDispTradFA', u'IFCCashIncr', u'NIncFrBorr', u'NCApIncrRepur', u'refundOfTax', u'CFrOthOperateA', u'effectOCIF', u'CInfFrOperateA', u'CPaidGS', u'NIncDisburOfLA', u'NIncrDeposInFI', u'origContrCIndem', u'CPaidIFC', u'CPaidPolDiv', u'CPaidToForEmpl', u'CPaidForTaxes', u'CPaidForOthOpA', u'effectOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'effect_CIF', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NIncrPledgeLoan', u'NCPaidAcquis', u'CPaidOthInvestA', u'effectCOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrBorr', u'CFrIssueBond', u'CFrOthFinanA', u'effectFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'effectFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'effectCE', u'NChangeInCash', u'NCEBegBal', u'effectCEI', u'NCEEndBal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','year': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtCFBankAllFiscalTGet(ticker = "", secID = "", reportType = "", year = "", beginYear = "", endYear = "", endDate = "", beginDate = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的银行业现金流量表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的现金流量表数据（主要是银行业上市公司）；2、仅收集合并报表数据，包括本期和上期数据；3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；4、本表中单位为人民币元；5、每季更新；6、收录每一会计期间最新披露的财务数据；7、整合了单季度和累计的报表。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType、year至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType、year至少选择一个
    :param reportType: 报告类型。Q1-第一季报，Q2-第二季报，Q3-第三季报，Q4-第四季报，S1-半年报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType、year至少选择一个
    :param year: 年度,可以是列表,ticker、secID、reportType、year至少选择一个
    :param beginYear: 年度，开始时间，输入格式“YYYY”,可空
    :param endYear: 年度，结束时间，输入格式“YYYY”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtCFBankAllFiscalT.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtCFBankAllFiscalTGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtCFBankAllFiscalTGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'year', u'reportType', u'NDeposIncrCFI', u'NIncrBorrFrCB', u'NIncBorrOthFI', u'NDecrInDisburOfLa', u'NDecrInDeposInFI', u'NDecrLoanToOthFI', u'IFCCashIncr', u'CFrOthOperateA', u'effectOCIF', u'CInfFrOperateA', u'NDeposDecrFrFI', u'NDecrBorrFrCB', u'NDecrBorrFrOthFI', u'NIncDisburOfLA', u'NIncrDeposInFI', u'NIncrLoansToOthFi', u'CPaidIFC', u'CPaidToForEmpl', u'CPaidForTaxes', u'CPaidForOthOpA', u'effectOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'effect_CIF', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NCPaidAcquis', u'CPaidOthInvestA', u'effectCOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrIssueBond', u'CFrOthFinanA', u'effectFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'effectFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'effectCE', u'NChangeInCash', u'NCEBegBal', u'effectCEI', u'NCEEndBal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','year': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPEquFdmtRptPreGet(secID = "", ticker = "", year = "", reportType = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    定期公告预披露(RRP展示专用）
    
    :param secID: 证券ID,可以是列表,可空
    :param ticker: 交易代码,可以是列表,可空
    :param year: 报告年份,可以是列表,可空
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,可空
    :param beginDate: 最新预约披露日开始时间,可空
    :param endDate: 最新预约披露日结束时间,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPEquFdmtRptPre.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPEquFdmtRptPreGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPEquFdmtRptPreGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'year', u'reportType', u'actDate', u'preDate', u'updateDate1', u'updateDate2', u'updateDate3', u'preDateUpdate', u'tAssets', u'tAssetsLY', u'tAssetsOpen', u'tEquityAttrP', u'tEquityAttrPLY', u'tEquityAttrPOpen', u'revenue', u'revenueLY', u'nIncomeAttrP', u'nIncomeAttrPLY', u'niAttrPCut', u'niAttrPCutLY', u'nCFOperateA', u'nCFOperateALY', u'ROEW', u'ROEWLY', u'basicEPS', u'basicEPSLY', u'dilutedEPS', u'dilutedEPSLY', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtSmmryGet(secID = "", ticker = "", year = "", beginYear = "", endYear = "", reportType = "", field = "", pandas = "1"):
    """
    财务摘要（rrp展示）
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,可空
    :param ticker: 股票代码，如'000002',可以是列表,可空
    :param year: 年度，会计期间所在年度,可以是列表,可空
    :param beginYear: 根据会计期间截止日期范围查询的起始年份，输入格式"YYYY",可空
    :param endYear: 根据会计期间截止日期范围查询的结束年份，输入格式"YYYY",可空
    :param reportType: 报告类型。Q1-第一季报，Q2-第二季报，S1-半年报，Q3-第三季报，CQ3-三季报（累计1-9月），Q4-第四季报，A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtSmmry.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&year=")
    if hasattr(year,'__iter__') and not isinstance(year, str):
        if len(year) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = year
            requestString.append(None)
        else:
            requestString.append(','.join(year))
    else:
        requestString.append(year)
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtSmmryGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtSmmryGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'endDate', u'fiscalPeriod', u'reportType', u'revenue', u'revenueYOY', u'revenueCAGR3', u'COGS', u'operateProfit', u'operProfitYOY', u'TProfit', u'tProfitYOY', u'NIncome', u'NIYOY', u'NICAGR3', u'NIncomeAttrP', u'niAttrPYOY', u'nrProfitLoss', u'niAttrPCut', u'niAttrPCutYOY', u'EBIT', u'EBITDA', u'TCA', u'fixedAssets', u'LTEquityInvest', u'TAssets', u'taYTD', u'taYOY', u'TCL', u'TNCL', u'TLiab', u'tlYOY', u'TShEquity', u'naYOY', u'TEquityAttrP', u'teAttrPYTD', u'teAttrPYOY', u'capitalReser', u'surplusReser', u'retainedEarnings', u'CFrSaleGS', u'NCFOperateANotes', u'purFixAssetsOth', u'CPaidInvest', u'NCFFrInvestA', u'CFrCapContr', u'CFrBorr', u'NCFFrFinanA', u'NChangeInCash', u'NCEEndBal', u'DA', u'CFsgsR', u'grossMARgin', u'sellExpTR', u'adminExpTR', u'finanExpTR', u'itTp', u'npMARgin', u'EBITMARgin', u'EBITDAMARgin', u'ROE', u'ROEW', u'ROA', u'ROIC', u'asseTLiabRatio', u'taTurnover', u'EPS', u'basicEPS', u'dilutedEPS', u'nCFOperAPS', u'divRatio', u'operateProfitRatio', u'equityRatio', u'ARTurnover', u'invenTurnover', u'currentRatio', u'quickRatio', u'nAssetsPS', u'nCInCashPS', u'naYTD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPMainOperIncomeGet(CompanyCode = "", EndDate = "", Classification = "", IfMerged = "", IfAdjusted = "", IfSum = "", secID = "", ticker = "", field = "", pandas = "1"):
    """
    主营业务构成（聚源同步RRP展示用）
    
    :param CompanyCode: 公司代码,可以是列表,可空
    :param EndDate: 截止日期,可以是列表,可空
    :param Classification: 分类方式。10-按行业，20-按产品，30-按地区。,可以是列表,可空
    :param IfMerged: 合并标志。1-合并，2-母公司,可空
    :param IfAdjusted: 调整标志。1-调整，2-未调整,可空
    :param IfSum: 是否合计。1-是，0-否。,可以是列表,可空
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,可空
    :param ticker: 股票代码，如'000002',可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPMainOperIncome.csv?ispandas=1&') 
    requestString.append("CompanyCode=")
    if hasattr(CompanyCode,'__iter__') and not isinstance(CompanyCode, str):
        if len(CompanyCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = CompanyCode
            requestString.append(None)
        else:
            requestString.append(','.join(CompanyCode))
    else:
        requestString.append(CompanyCode)
    requestString.append("&EndDate=")
    if hasattr(EndDate,'__iter__') and not isinstance(EndDate, str):
        if len(EndDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = EndDate
            requestString.append(None)
        else:
            requestString.append(','.join(EndDate))
    else:
        requestString.append(EndDate)
    requestString.append("&Classification=")
    if hasattr(Classification,'__iter__') and not isinstance(Classification, str):
        if len(Classification) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = Classification
            requestString.append(None)
        else:
            requestString.append(','.join(Classification))
    else:
        requestString.append(Classification)
    if not isinstance(IfMerged, str) and not isinstance(IfMerged, unicode):
        IfMerged = str(IfMerged)

    requestString.append("&IfMerged=%s"%(IfMerged))
    if not isinstance(IfAdjusted, str) and not isinstance(IfAdjusted, unicode):
        IfAdjusted = str(IfAdjusted)

    requestString.append("&IfAdjusted=%s"%(IfAdjusted))
    requestString.append("&IfSum=")
    if hasattr(IfSum,'__iter__') and not isinstance(IfSum, str):
        if len(IfSum) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = IfSum
            requestString.append(None)
        else:
            requestString.append(','.join(IfSum))
    else:
        requestString.append(IfSum)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPMainOperIncomeGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPMainOperIncomeGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'CompanyCode', u'secID', u'EndDate', u'ticker', u'DateType', u'InfoSource', u'IfMerged', u'IfAdjusted', u'Classification', u'itemParentNO', u'SN', u'Project', u'Industry', u'IfSum', u'MainOperIncome', u'MainOperCost', u'MainOperProfit', u'GrossProfit', u'tRevenuePctge', u'tCOGSPctge', u'MainOperIncomeFormerYear', u'MainOperCostFormerYear', u'MainOperProfitFormerYear', u'MainIncomeGrowRateYOY', u'MainICostGrowRateYOY', u'MainProfitGrowRateYOY']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','InfoSource': 'str','Project': 'str','Industry': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtEEGet(ticker = "", secID = "", equTypeCD = "", listStatusCD = "", endDate = "", beginDate = "", beginYear = "", endYear = "", reportType = "", field = "", pandas = "1"):
    """
    获取2007年及以后年度上市公司披露的业绩快报中的主要财务指标等其他数据，包括本期，去年同期，及本期与期初数值同比数据。每季证券交易所披露相关公告时更新数据，公司ipo时发布相关信息也会同时更新。
    
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000002.XSHE。可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param equTypeCD: 股票分类代码，输入A或B可查询获取到A股或B股,可以是列表,可空
    :param listStatusCD: 上市状态。L-上市；S-暂停；DE-终止上市；UN-未上市；O-其他。对应DataAPI.SysCodeGet.codeTypeID=10005。,可以是列表,可空
    :param endDate: 根据发布日期范围查询的结束日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 根据发布日期范围查询的起始日期，输入格式“YYYYMMDD”,可空
    :param beginYear: 根据会计期间截止日期范围查询的起始年份，输入格式"YYYY",可空
    :param endYear: 根据会计期间截止日期范围查询的结束年份，输入格式"YYYY",可空
    :param reportType: 报告类型。Q1-第一季报，S1-半年报，Q3-第三季报（7-9月），CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtEE.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&equTypeCD=")
    if hasattr(equTypeCD,'__iter__') and not isinstance(equTypeCD, str):
        if len(equTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = equTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(equTypeCD))
    else:
        requestString.append(equTypeCD)
    requestString.append("&listStatusCD=")
    if hasattr(listStatusCD,'__iter__') and not isinstance(listStatusCD, str):
        if len(listStatusCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = listStatusCD
            requestString.append(None)
        else:
            requestString.append(','.join(listStatusCD))
    else:
        requestString.append(listStatusCD)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtEEGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtEEGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'equTypeCD', u'listStatusCD', u'publishDate', u'year', u'reportType', u'revenue', u'primeOperRev', u'grossProfit', u'operateProfit', u'TProfit', u'NIncomeAttrP', u'NIncomeCut', u'NCfOperA', u'basicEPS', u'EPSW', u'EPSCut', u'EPSCutW', u'ROE', u'ROEW', u'ROECut', u'ROECutW', u'NCfOperAPs', u'TAssets', u'TEquityAttrP', u'paidInCapital', u'NAssetPS', u'revenueLY', u'primeOperRevLY', u'grossProfitLY', u'operProfitLY', u'TProfitLY', u'NIncomeAttrPLY', u'NIncomeCutLY', u'NCfOperALY', u'basicEPSLY', u'EPSWLY', u'EPSCutLY', u'EPSCutWLY', u'ROELY', u'ROEWLY', u'ROECutLY', u'ROECutWLY', u'NCfOperAPsLY', u'TAssetsLY', u'TEquityAttrPLY', u'NAssetPsLY', u'revenueYOY', u'primeOperRevYOY', u'grossProfitYOY', u'operProfitYOY', u'TProfitYOY', u'NIncomeAttrPYOY', u'NIncomeCutYOY', u'NCFOperAYOY', u'basicEPSYOY', u'EPSWYOY', u'EPSCutYOY', u'EPSCutWYOY', u'ROEYOY', u'ROEWYOY', u'ROECutYOY', u'ROECutWYOY', u'NCfOperAPsYOY', u'TAssetsYOY', u'TEquityAttrPYOY', u'NAssetPsYOY']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','equTypeCD': 'str','listStatusCD': 'str','year': 'str','reportType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __RRPFdmtEFGet(ticker = "", secID = "", equTypeCD = "", listStatusCD = "", endDate = "", beginDate = "", beginYear = "", endYear = "", reportType = "", forecastTypeCD = "", field = "", pandas = "1"):
    """
    1、获取2007年及以后年度上市公司披露的公告中的预期下一报告期收入、净利润、归属于母公司净利润、基本每股收益及其幅度变化数据。 2、上市公司对经营成果科目的预计情况数据一般为其上限与下限，上限取值为公告中披露该科目中绝对值较大值，下限取值为公告中披露该科目中绝对值较小值。 3、数值为"正"代表该公司预计盈利，数值为"负"代表该公司预计亏损。若上下限"正"、"负"符号不同，代表该公司盈利亏损情况尚不确定。 4、业绩预期类型以公告中文字披露预期类型为准，若公告中未有文字披露预期类型，则根据数据情况判断预期类型。 5、每季证券交易所披露相关公告时更新数据，公司ipo时发布相关信息也会同时更新。
    
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000002.XSHE。可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param equTypeCD: 股票分类代码，输入A或B可查询获取到A股或B股,可以是列表,可空
    :param listStatusCD: 上市状态。L-上市；S-暂停；DE-终止上市；UN-未上市；O-其他。对应DataAPI.SysCodeGet.codeTypeID=10005。,可以是列表,可空
    :param endDate: 根据发布日期范围查询的结束日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 根据会计期间截止日期范围查询的起始日期，输入格式“YYYYMMDD”,可空
    :param beginYear: 根据会计期间截止日期范围查询的起始年份，输入格式"YYYY",可空
    :param endYear: 根据会计期间截止日期范围查询的结束年份，输入格式"YYYY",可空
    :param reportType: 报告类型。Q1-第一季报，S1-半年报，Q3-第三季报（7-9月），CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,可空
    :param forecastTypeCD: 业绩预期类型。对应DataAPI.SysCodeGet.codeTypeID=70006。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getRRPFdmtEF.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&equTypeCD=")
    if hasattr(equTypeCD,'__iter__') and not isinstance(equTypeCD, str):
        if len(equTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = equTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(equTypeCD))
    else:
        requestString.append(equTypeCD)
    requestString.append("&listStatusCD=")
    if hasattr(listStatusCD,'__iter__') and not isinstance(listStatusCD, str):
        if len(listStatusCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = listStatusCD
            requestString.append(None)
        else:
            requestString.append(','.join(listStatusCD))
    else:
        requestString.append(listStatusCD)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&forecastTypeCD=")
    if hasattr(forecastTypeCD,'__iter__') and not isinstance(forecastTypeCD, str):
        if len(forecastTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = forecastTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(forecastTypeCD))
    else:
        requestString.append(forecastTypeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__RRPFdmtEFGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__RRPFdmtEFGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'equTypeCD', u'listStatusCD', u'publishDate', u'year', u'reportType', u'forecastTypeCD', u'forecastType', u'revChgrLL', u'revChgrUPL', u'expRevLL', u'expRevUPL', u'NIncomeChgrLL', u'NIncomeChgrUPL', u'expnIncomeLL', u'expnIncomeUPL', u'forecastContent', u'createTime', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','equTypeCD': 'str','listStatusCD': 'str','year': 'str','reportType': 'str','forecastTypeCD': 'str','forecastType': 'str','forecastContent': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __NeeqFdmtBSGet(ticker = "", secID = "", reportType = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的合并资产负债表模板，收集了2007年以来新三板挂牌公司定期报告中各个会计期间的资产负债表数据；  2、仅收集合并报表数据，包括期末和期初数据；  3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；  4、本表中单位为人民币元；  5、大多公司半年更新一次，少部分公司每季更新。
    
    :param ticker: 股票代码，如'000002',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getNeeqFdmtBS.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__NeeqFdmtBSGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__NeeqFdmtBSGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'cashCEquiv', u'settProv', u'loanToOthBankFi', u'tradingFA', u'NotesReceiv', u'AR', u'prepayment', u'premiumReceiv', u'reinsurReceiv', u'reinsurReserReceiv', u'intReceiv', u'divReceiv', u'othReceiv', u'purResaleFa', u'inventories', u'NCAWithin1Y', u'othCA', u'TCA', u'disburLA', u'availForSaleFa', u'htmInvest', u'LTReceive', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'CIP', u'constMaterials', u'fixedAssetsDisp', u'producBiolAssets', u'oilAndGasAssets', u'intanAssets', u'RD', u'goodwill', u'LTAmorExp', u'deferTaxAssets', u'othNCA', u'TNCA', u'TAssets', u'STBorr', u'CBBorr', u'depos', u'loanFrOthBankFi', u'tradingFL', u'NotesPayable', u'AP', u'advanceReceipts', u'soldForRepurFa', u'commisPayable', u'payrollPayable', u'taxesPayable', u'intPayable', u'divPayable', u'othPayable', u'reinsurPayable', u'insurReser', u'fundsSecTradAgen', u'fundsSecUndwAgen', u'NCLWithin1Y', u'othCL', u'TCL', u'LTBorr', u'bondPayable', u'preferredStockL', u'perpetualBondL', u'LTPayable', u'specificPayables', u'estimatedLiab', u'deferTaxLiab', u'othNCL', u'TNCL', u'TLiab', u'paidInCapital', u'othEquityInstr', u'preferredStockE', u'perpetualBondE', u'capitalReser', u'treasuryShare', u'othCompreIncome', u'specialReser', u'surplusReser', u'ordinRiskReser', u'retainedEarnings', u'forexDiffer', u'TEquityAttrP', u'minorityInt', u'TShEquity', u'TLiabEquity', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __NeeqFdmtBSBankGet(ticker = "", secID = "", reportType = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的银行业资产负债表模板，收集了2007年以来新三板挂牌公司定期报告中所有以此模板披露的资产负债表数据；（主要是银行业上市公司）  2、仅收集合并报表数据，包括期末和期初数据；  3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；  4、本表中单位为人民币元；  5、大多公司半年更新一次，少部分公司每季更新。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getNeeqFdmtBSBank.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__NeeqFdmtBSBankGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__NeeqFdmtBSBankGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'loanToOthBankFi', u'tradingFA', u'intReceiv', u'purResaleFa', u'disburLA', u'availForSaleFA', u'htmInvest', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'CIP', u'intanAssets', u'goodwill', u'deferTaxAssets', u'CReserCB', u'deposInOthBfi', u'preciMetals', u'derivAssets', u'finanLeaseReceiv', u'investAsReceiv', u'othAssets', u'AE', u'AA', u'TAssets', u'CBBorr', u'depos', u'loanFrOthBankFi', u'tradingFL', u'soldForRepurFa', u'payrollPayable', u'taxesPayable', u'intPayable', u'bondPayable', u'preferredStockL', u'perpetualBondL', u'estimatedLiab', u'deferTaxLiab', u'deposFrOthBfi', u'derivLiab', u'othLiab', u'LE', u'LA', u'TLiab', u'paidInCapital', u'othEquityInstr', u'preferredStockE', u'perpetualBondE', u'capitalReser', u'treasuryShare', u'othCompreIncome', u'surplusReser', u'ordinRiskReser', u'retainedEarnings', u'forexDiffer', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSE', u'othEffectSA', u'TShEquity', u'LEE', u'LEA', u'TLiabEquity', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __NeeqFdmtBSSecuGet(ticker = "", secID = "", reportType = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的证券业资产负债表模板，收集了2007年以来新三板挂牌公司定期报告中所有以此模板披露的资产负债表数据；（主要是证券业上市公司）  2、仅收集合并报表数据，包括期末和期初数据；  3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；  4、本表中单位为人民币元；  5、大多公司半年更新一次，少部分公司每季更新。
    
    :param ticker: 股票代码，如'600369',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'600369.XSHG',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getNeeqFdmtBSSecu.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, '__NeeqFdmtBSSecuGet')
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, '__NeeqFdmtBSSecuGet')
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)
    
    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'cashCEquiv', u'clientDepos', u'settProv', u'clientProv', u'loanToOthBankFi', u'tradingFA', u'intReceiv', u'purResaleFa', u'availForSaleFa', u'htmInvest', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'intanAssets', u'transacSeatFee', u'deferTaxAssets', u'derivAssets', u'refundDepos', u'othAssets', u'AE', u'AA', u'TAssets', u'STBorr', u'pledgeBorr', u'loanFrOthBankFi', u'tradingFL', u'soldForRepurFa', u'payrollPayable', u'taxesPayable', u'intPayable', u'fundsSecTradAgen', u'fundsSecUndwAgen', u'LTBorr', u'bondPayable', u'preferredStockL', u'perpetualBondL', u'estimatedLiab', u'deferTaxLiab', u'derivLiab', u'othLiab', u'LE', u'LA', u'TLiab', u'paidInCapital', u'othEquityInstr', u'preferredStockE', u'perpetualBondE', u'capitalReser', u'treasuryShare', u'othCompreIncome', u'surplusReser', u'ordinRiskReser', u'transacRiskReser', u'retainedEarnings', u'forexDiffer', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSE', u'othEffectSA', u'TShEquity', u'TLiabEquity', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def __NeeqFdmtBSInduGet(ticker = "", secID = "", reportType = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的一般工商业资产负债表模板，收集了2007年以来新三板挂牌公司定期报告中所有以此模板披露的资产负债表数据；（主要是一般工商业上市公司）  2、仅收集合并报表数据，包括期末和期初数据；  3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示；  4、本表中单位为人民币元；  5、大多公司半年更新一次，少部分公司每季更新。
    
    :param ticker: 股票代码，如'000002',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getNeeqFdmtBSIndu.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.repla