<br />
<div align="center">
   <img style="margin: 0 auto; padding-bottom: 15px; padding-top: 30px" width=70%" src="https://firebasestorage.googleapis.com/v0/b/blankly-6ada5.appspot.com/o/blankly-github-logo.png?alt=media&token=8f436cd2-3d28-432c-867a-afef780f4260">
</div>
<br />
<div align="center">
  <b>💨  Rapidly build and deploy quantitative models for stocks and crypto  🚀</b>
</div>
<br />

<p align="center">
   <a target="_blank" href="https://sonarcloud.io/dashboard?id=Blankly-Finance_Blankly"><img src="https://sonarcloud.io/api/project_badges/measure?project=Blankly-Finance_Blankly&metric=sqale_rating"></a>
   <a target="_blank" href="https://sonarcloud.io/dashboard?id=Blankly-Finance_Blankly"><img src="https://sonarcloud.io/api/project_badges/measure?project=Blankly-Finance_Blankly&metric=security_rating"></a>
   <a target="_blank" href="https://sonarcloud.io/dashboard?id=Blankly-Finance_Blankly"><img src="https://sonarcloud.io/api/project_badges/measure?project=Blankly-Finance_Blankly&metric=alert_status"></a>
   <a target="_blank" href="https://github.com/Blankly-Finance/Blankly/actions/workflows/test.yml"><img src="https://github.com/Blankly-Finance/Blankly/actions/workflows/test.yml/badge.svg?branch=main"></a> <br>
   <a target="_blank" href="https://pepy.tech/project/blankly"><img src="https://pepy.tech/badge/blankly/month"></a>

</p>

<p align="center">
</p>

<p align="center">
   <a target="_blank" href="https://pepy.tech/project/blankly"><img src="https://forthebadge.com/images/badges/open-source.svg"></a>
   <a target="_blank" href="https://pepy.tech/project/blankly"><img src="https://forthebadge.com/images/badges/for-you.svg"></a>
   <a target="_blank" href="https://pepy.tech/project/blankly"><img src="https://forthebadge.com/images/badges/gluten-free.svg"></a>
   <a target="_blank" href="https://pepy.tech/project/blankly"><img src="https://forthebadge.com/images/badges/check-it-out.svg"></a>
   <br><a target="_blank" href="https://docs.blankly.finance"><img src="https://img.shields.io/badge/Check%20our%20-docs-<COLOR>.svg?style=for-the-badge&logo=data:image/svg%2bxml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4bWxuczpzZXJpZj0iaHR0cDovL3d3dy5zZXJpZi5jb20vIiB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiB2aWV3Qm94PSIwIDAgNDEzNCA0MTM0IiB2ZXJzaW9uPSIxLjEiIHhtbDpzcGFjZT0icHJlc2VydmUiIHN0eWxlPSJmaWxsLXJ1bGU6ZXZlbm9kZDtjbGlwLXJ1bGU6ZXZlbm9kZDtzdHJva2UtbGluZWpvaW46cm91bmQ7c3Ryb2tlLW1pdGVybGltaXQ6MjsiPgogICAgPHBhdGggZD0iTTQxMzMuODYsNzE0Ljk3OUM0MTMzLjg2LDMyMC4zNzEgMzgxMy40OSwwIDM0MTguODgsMEw3MTQuOTc5LDBDMzIwLjM3MSwwIDAsMzIwLjM3MSAwLDcxNC45NzlMMCwzNDE4Ljg4QzAsMzgxMy40OSAzMjAuMzcxLDQxMzMuODYgNzE0Ljk3OSw0MTMzLjg2TDM0MTguODgsNDEzMy44NkMzODEzLjQ5LDQxMzMuODYgNDEzMy44NiwzODEzLjQ5IDQxMzMuODYsMzQxOC44OEw0MTMzLjg2LDcxNC45NzlaIiBzdHlsZT0iZmlsbDp3aGl0ZTsiLz4KICAgIDxnIHRyYW5zZm9ybT0ibWF0cml4KDIwMy42NDYsMCwwLDIwMy42NDYsLTM2MDU2LC0yNTAzLjQzKSI+CiAgICAgICAgPHBhdGggZD0iTTE4OC40MzQsMTQuOTk0TDE4NS45NywxNC45OTRMMTc5LjQ2MiwyOS44OTJMMTgxLjE1NiwyOS44OTJDMTgxLjM0NCwyOS44OTIgMTgxLjUyOSwyOS44NjQgMTgxLjcxMiwyOS44MDhDMTgxLjg5NiwyOS43NTMgMTgyLjA2OCwyOS42NzUgMTgyLjIyOCwyOS41NzVDMTgyLjM4NywyOS40NzQgMTgyLjUyOSwyOS4zNTQgMTgyLjY1NCwyOS4yMTZDMTgyLjc3OSwyOS4wNzcgMTgyLjg3NSwyOC45MjUgMTgyLjk0NSwyOC43NThMMTgzLjgxOCwyNi43NDJMMTgzLjgyLDI2Ljc0MkwxODUuMzk1LDIzLjExNUwxODUuNDA5LDIzLjExNUwxODcuMjAyLDE4Ljk1M0wxODkuMzgsMjQuMDA3TDE4OC4xNDMsMjQuMDA3QzE4Ny4yMTcsMjQuMDA3IDE4Ni4zNzksMjQuNTU3IDE4Ni4wMTEsMjUuNDA2TDE4NS40MzEsMjYuNzQyTDE5MC41ODYsMjYuNzQyTDE5MS40NywyOC43NThDMTkxLjYyOSwyOS4xMTIgMTkxLjg2OCwyOS4zODkgMTkyLjE4NywyOS41OUMxOTIuNTA2LDI5Ljc5MSAxOTIuODU5LDI5Ljg5MiAxOTMuMjQ3LDI5Ljg5MkwxOTQuOTQyLDI5Ljg5MkwxODguNDM0LDE0Ljk5NFoiIHN0eWxlPSJmaWxsLXJ1bGU6bm9uemVybzsiLz4KICAgIDwvZz4KPC9zdmc+"></a>
   <a target="_blank" href="https://blankly.finance"><img src="https://img.shields.io/badge/Brandon%20made%20the-website-<COLOR>.svg?style=for-the-badge&logo=data:image/svg%2bxml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4bWxuczpzZXJpZj0iaHR0cDovL3d3dy5zZXJpZi5jb20vIiB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiB2aWV3Qm94PSIwIDAgNDEzNCA0MTM0IiB2ZXJzaW9uPSIxLjEiIHhtbDpzcGFjZT0icHJlc2VydmUiIHN0eWxlPSJmaWxsLXJ1bGU6ZXZlbm9kZDtjbGlwLXJ1bGU6ZXZlbm9kZDtzdHJva2UtbGluZWpvaW46cm91bmQ7c3Ryb2tlLW1pdGVybGltaXQ6MjsiPgogICAgPHBhdGggZD0iTTQxMzMuODYsNzE0Ljk3OUM0MTMzLjg2LDMyMC4zNzEgMzgxMy40OSwwIDM0MTguODgsMEw3MTQuOTc5LDBDMzIwLjM3MSwwIDAsMzIwLjM3MSAwLDcxNC45NzlMMCwzNDE4Ljg4QzAsMzgxMy40OSAzMjAuMzcxLDQxMzMuODYgNzE0Ljk3OSw0MTMzLjg2TDM0MTguODgsNDEzMy44NkMzODEzLjQ5LDQxMzMuODYgNDEzMy44NiwzODEzLjQ5IDQxMzMuODYsMzQxOC44OEw0MTMzLjg2LDcxNC45NzlaIiBzdHlsZT0iZmlsbDp3aGl0ZTsiLz4KICAgIDxnIHRyYW5zZm9ybT0ibWF0cml4KDIwMy42NDYsMCwwLDIwMy42NDYsLTM2MDU2LC0yNTAzLjQzKSI+CiAgICAgICAgPHBhdGggZD0iTTE4OC40MzQsMTQuOTk0TDE4NS45NywxNC45OTRMMTc5LjQ2MiwyOS44OTJMMTgxLjE1NiwyOS44OTJDMTgxLjM0NCwyOS44OTIgMTgxLjUyOSwyOS44NjQgMTgxLjcxMiwyOS44MDhDMTgxLjg5NiwyOS43NTMgMTgyLjA2OCwyOS42NzUgMTgyLjIyOCwyOS41NzVDMTgyLjM4NywyOS40NzQgMTgyLjUyOSwyOS4zNTQgMTgyLjY1NCwyOS4yMTZDMTgyLjc3OSwyOS4wNzcgMTgyLjg3NSwyOC45MjUgMTgyLjk0NSwyOC43NThMMTgzLjgxOCwyNi43NDJMMTgzLjgyLDI2Ljc0MkwxODUuMzk1LDIzLjExNUwxODUuNDA5LDIzLjExNUwxODcuMjAyLDE4Ljk1M0wxODkuMzgsMjQuMDA3TDE4OC4xNDMsMjQuMDA3QzE4Ny4yMTcsMjQuMDA3IDE4Ni4zNzksMjQuNTU3IDE4Ni4wMTEsMjUuNDA2TDE4NS40MzEsMjYuNzQyTDE5MC41ODYsMjYuNzQyTDE5MS40NywyOC43NThDMTkxLjYyOSwyOS4xMTIgMTkxLjg2OCwyOS4zODkgMTkyLjE4NywyOS41OUMxOTIuNTA2LDI5Ljc5MSAxOTIuODU5LDI5Ljg5MiAxOTMuMjQ3LDI5Ljg5MkwxOTQuOTQyLDI5Ljg5MkwxODguNDM0LDE0Ljk5NFoiIHN0eWxlPSJmaWxsLXJ1bGU6bm9uemVybzsiLz4KICAgIDwvZz4KPC9zdmc+"></a>
</p>

---

Blankly is an elegant python library for interacting with many crypto and stock exchanges for automated portfolios in a consistent way. Blankly offers a powerful feature-set, optimized for speed and ease of use. 

We're bridging the gap between local development systems & live APIs by building a framework which allows backtesting, 
paper trading, sandbox testing, and live cross-exchange deployment without modifying a single line of trading logic.

Check out our [website](https://blankly.finance) and our [docs](https://docs.blankly.finance).

## Getting Started

### Installation

1. First install Blankly using `pip`. Blankly is hosted on [PyPi](https://pypi.org/project/Blankly/).

```bash
$ pip install blankly
```

2. Next, just run:
```bash
$ blankly init
```
This will run our setup script in the current terminal working directory.
The command will create the files `keys.json`, `settings.json`, `backtest.json`, `deploy.json` and an example script called `bot.py`.

3. From there, **insert your API keys** from your exchange into the generated `keys.json` file.

More information can be found on our [docs](https://docs.blankly.finance)

### Directory format
The working directory format should have at least these files:
```
Project
   |-bot.py
   |-keys.json
   |-settings.json
```

If you don't want to use our `init` command, you can find the same files in the `examples` folder under [`settings.json`](https://github.com/Blankly-Finance/Blankly/blob/main/examples/settings.json) and [`keys.json`](https://github.com/Blankly-Finance/Blankly/blob/main/examples/keys_example.json)

### Additional Info
Make sure you're using a supported version of python. The module is currently tested on these versions:

- Python 3.7+

For more info, and ways to do more advanced things, check out our [getting started docs](https://docs.blankly.finance).

## Example Use
We have a pre-built cookbook examples that implement strategies such as RSI, MACD, and the Golden Cross found in our [examples](https://docs.blankly.finance/examples/golden-cross).

We have made Blankly extremely easy to integrate with any existing models and price events to make it super easy to switch.

```python
import blankly
from blankly import StrategyState


def price_event(price, symbol, state: StrategyState):
    """ This function will give an updated price every 15 seconds from our definition below """
    state.variables['history'].append(price)
    rsi = blankly.indicators.rsi(state.variables['history'])
    if rsi[-1] < 30:
        # Dollar cost average buy
        state.interface.market_order(symbol, side='buy', funds=10)
    elif rsi[-1] > 70:
        # Dollar cost average sell
        state.interface.market_order(symbol, side='sell', funds=10)


def init(symbol, state: StrategyState):
    # Download price data to give context to the algo
    state.variables['history'] = state.interface.history(symbol, to='1y', return_as='list')['open']


if __name__ == "__main__":
    # Authenticate coinbase pro strategy
    coinbase_pro = blankly.CoinbasePro()

    # Use our strategy helper on coinbase pro
    coinbase_strategy = blankly.Strategy(coinbase_pro)

    # Run the price event function every time we check for a new price - by default that is 15 seconds
    coinbase_strategy.add_price_event(price_event, symbol='BTC-USD', resolution='30m', init=init)

    # Start the strategy. This will begin each of the price event ticks
    coinbase_strategy.start()
    # Or backtest using this
    # coinbase_strategy.backtest(to='1y', initial_values={'USD': 100000, 'BTC': 2})
```

## Supported Exchanges

| Exchange     | REST Support | Ticker Websocket | Order Book | Interface |
| ------------ | ------------ | ---------------- | ---------- | --------- |
| Coinbase Pro | 🟢           | 🟢               | 🟢        | 🟢        |
| Binance      | 🟢           | 🟢               | 🟢        | 🟢       |
| Alpaca       | 🟢         | 🟢             | 🟢      | 🟢        |
| OANDA | 🟡 | 🟡 | 🟡 | 🟡 |

🟢  = working

🟡  = in development, some or most features are working

🔴  = planned but not yet in development

* Interface calls take ~300 µs extra to homogenize the exchange data.

## Bugs

Please report any bugs or issues on the Github's Issues page.

## Disclaimer 

Trading is risky. We are not responsible for losses incurred using this software, software fitness for any particular purpose, or responsibility for any issues or bugs.
This is free software.

## Contributing

If you would like to support the project, pull requests are welcome.
You can also contribute just by telling us what you think of Blankly: https://forms.gle/4oAjG9MKRTYKX2hP9

## Licensing 

**Blankly** is distributed under the [**LGPL License**](https://www.gnu.org/licenses/lgpl-3.0.en.html). See the [LICENSE](/LICENSE) for more details.

New updates every day 💪.
