# SVGpy

This is a basic library written in python for creating simple svgs with python scripts.

## Table of Contents:

[[_TOC_]]

## Files:

|                  File | Description |
|----------------------:|:------------|
| `savager/__init__.py` | imports library |
| `savager/file.py`     | file class used to write svg files  |
| `savager/element.py`  | used by file class to generate elements in svg |
| `flower.py`           | example of use, generates flower.svg |
| `flower.svg`          | example svg generated by flower.py |
| `setup.py`            | this enables import as a python library |
| `LICENSE`             | You have full permission to use and modify this library, just please pass on that privilege. |
| `README.md`           | this file |

## Importing this library:

pip:
```bash
$ pip install git+https://gitlab.com/pyrogue6/savager.git
```
pip for development while in repo:
```bash
$ pip install -e .
```
coming soon to PyPI:
```bash
$ pip install savager
```

## Notes
* Resource heavily used: https://developer.mozilla.org/en-US/docs/Web/SVG/Tutorial
* This library uses xlink:href instead of the href standard in <use> blocks to maintain compatability with eog (EyeOfGnome)
* path parameters use underscores instead of dashes, and are converted back to dashes when writing to svg files  
this could be solved by unpacking a dictionary every time you want to add parameters that use dashes, but that's pretty ugly
* we believe in tabs here, sorry.

## TODO

### Key
[**+**] feature to be added  
[**x**] change in code  
[**-**] bug to be removed  
[**?**] uncertain how to proceed  

### Tasks
[**+**] manipulate paths within SVG class  
[**+**] easily add function-defined paths  
[**+**] circles and elipses  
[**+**] error handling especially in writing to files!  
[**+**] css stylesheets for reducing file sizes?
`└──`   https://developer.mozilla.org/en-US/docs/Web/SVG/Tutorial/Fills_and_Strokes  
[**+**] need way to add controls easily  
`├──`   optional arg for a control gen?  
`└──`   incorporated into coord gen? tuple for all paired controls?  
[**x**] Split path and SVG classes into seperate files?  
[**x**] make demo or doctest directory for extraneous files  
[**+**] test_suite for setup to enhance unittests  
`├──`   https://setuptools.readthedocs.io/en/latest/setuptools.html  
`└──`   also write unittests, woops  
[**x**] use scm metadata to setup  
`└──`   https://pypi.org/project/setuptools-scm/  
[**+**] upload to PyPI  
`└──`   update badges!  
[**?**] change project name to match library name?  

![Example Image](flower.svg "Flower")
