neoscr
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

``` sh
pip install neoscr
```

## How to use

Fill me in please! Don’t forget code examples:

``` python
from neoscr.core import ConsultaSCR
```

``` python
import os

scr = ConsultaSCR(
    user=os.environ["SCR_USER"],
    password=os.environ["SCR_PASSWORD"],
    code=os.environ["SCR_CODE"],
    api_key=os.environ["SCR_API_KEY"]
)
```

``` python
cpf = "000.000.000-00"
ano_mes = "12_2022"

# retorna dois dataframes
df_cpf_traduzido, df_cpf_modalidade = scr.get_cpf_data(cpf, ano_mes)
```

``` python
cnpj = "00.000.000/0001-00"
ano_mes = "12_2022"

# retorna dois dataframes
df_cnpj_traduzido, df_cnpj_modalidade = scr.get_cnpj_data(cnpj, ano_mes)
```

# CLI Interface

There is also a CLI interface to query SCR api from the command line.

``` sh
neoscr $SCR_USER $SCR_PASSWORD $SCR_CODE $SCR_API_KEY 000.000.000-00 12_2022 
```

# Batch Query

Execute the code below to query a list of cpfs or cnpjs (under
modification) and download the data

``` python
import os
import logging
import pandas as pd
from tqdm import tqdm

from neoscr.utils import let_only_digits

# carregando a lista de cpfs
df = pd.read_csv("dataset.csv")
lista_de_cpfs = df['cpf'].tolist()

# instanciando o objeto ConsultaSCR
scr = ConsultaSCR(
    user=os.environ["SCR_USER"],
    password=os.environ["SCR_PASSWORD"],
    code=os.environ["SCR_CODE"],
    api_key=os.environ["SCR_API_KEY"]
)

# instanciando o objeto logger
logger = logging.getLogger('database_updater')
logger.setLevel(logging.DEBUG)

# criando o file handler
file_handler = logging.FileHandler('querylog.log')
file_handler.setLevel(logging.DEBUG)

# adicionando o file handler ao logger
logger.addHandler(file_handler)

# iterando sobre a lista de cpfs e enriquecendo
ano_mes = "12_2022"
for cpf in tqdm(lista_de_cpfs):
    try:
        df_traduzido, df_modalidade = scr.get_cpf_data(cpf, ano_mes)                               
        cpf_only_digits = let_only_digits(cpf)
        df_traduzido.to_csv(f"data/scr/raw/{cpf_only_digits}_traduzido.csv", index=False)
        df_modalidade.to_csv(f"data/scr/raw/{cpf_only_digits}_modalidade.csv", index=False)
    except:
        logger.error(f"Erro no CPF {cpf}")
        continue
```

After download the data, you may want to get all the raw data together
in one big table:

``` python
# carregandos os dados de todos os arquivos salvos
df_traduzido_full = pd.DataFrame()
for file in os.listdir("data/scr/raw/"):
    if file.endswith("_traduzido.csv"):
        df_traduzido = pd.read_csv(f"data/scr/raw/{file}")
        df_traduzido_full = pd.concat([df_traduzido_full, df_traduzido])

df_modalidade_full = pd.DataFrame()
for file in os.listdir(".data/scr/raw"):
    if file.endswith("_modalidade.csv"):
        df_modalidade = pd.read_csv(f"data/scr/raw/{file}")
        df_modalidade_full = pd.concat([df_modalidade_full, df_modalidade])
```
