# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['eve_client']

package_data = \
{'': ['*']}

install_requires = \
['PyNaCl==1.4.0', 'python-dateutil==2.8.2', 'requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'eve-client',
    'version': '2.0.6',
    'description': 'EVE Client API Library from Exodus Intelligence LLC.',
    'long_description': 'The EVE API Client is a python class that allows interaction with the [Exodus Vulnerability Enrichment (EVE):](<https://eve.exodusintel.com>) platform.\n\nWelcome to the EVE API Client\'s documentation. Please get started by reading about how to use it and add it to your projects.\n\nWhat\'s new\n==========\n\n- Access to EVE API version 2.\n    - Search endpoint.\n    - Simplified data structure.\n- Access to EVE API Anonymous endpoint.\n\nPre-requisites\n==============\n- An Exodus Intelligence account is required if you want to take advantage of the ful EVE platform.\n- [Python](https://www.python.org/downloads/) 3.8 or newer is required.\n- The EVE platform provides an endpoint to deliver essential information about Common Vulnerabilities and Exposures CVE anonymously.\n\nGetting started\n===============\n**Install EVE Client using pip:**\n\n``` bash\n   $ pip install eve-client\n```\n\n**Using EVE Client Anonymously:**\n\n```python\n\n   import json\n   from eve_client import eve\n   exodus_api = eve.EVEClientAnonymous()\n   cve = exodus_api.get_cve("CVE-2021-44228")\n   print(json.dumps(cve, indent=3))\n```\n\n**Output:**\n\n```json\n\n   {\n      "data": {\n         "attack_vector": "network",\n         "product": "Apache Log4j2,Log4j2",\n         ...\n         "vendor": "Apache Software Foundation,Apache"\n      },\n      "ok": true\n   }\n```\n\n**Using EVE Client with Authentication:**\n\n```python\n   import json\n   from eve_client import eve\n   exodus_api = eve.EVEClient(\'abc@def.com\', \'MyPassword\', \'MYPRIVATEKEY\')\n   cve = exodus_api.get_vuln("CVE-2021-44228")\n   print(json.dumps(cve, indent=3))\n```\n\n**Output:**\n```json\n\n   {\n      "data": {\n         "attack_vector": "network",\n         "product": "Apache Log4j2,Log4j2",\n         ...\n         "vendor": "Apache Software Foundation,Apache"\n      },\n      "ok": true\n   }\n```\n\n*You receive the anonymous fields, plus the fields in your account tier.*\n\n\nClasses and Methods Available\n=============================\n\n### _class_ eve.EVEClient(email, password, key, url, api_version, proxy_protocol, proxy_address, proxy_port)\nBases: `object`\n\nClass EVEClient allows communication with the Exodus API.\n\nModule to connect and interact with the Exodus Intelligence API.\n\n\n* **Parameters**\n    * **email** (*str*) -- Email address registered with Exodus Intelligence.\n    * **password** (*str*) -- User password\n    * **key** (*str**, **optional*) -- Exodus Intelligence API key, defaults to None\n    * **url** (*_type_**, **optional*) -- Exodus Intelligence API domain, defaults to "[https://eve.exodusintel.com](https://eve.exodusintel.com)"\n    * **api_version** (*str**, **optional*) -- Version number ie: v1 or v2, defaults to "v1"\n    * **proxy_protocol** (*str**, **optional*) -- Proxy protocol type, defaults to "http"\n    * **proxy_url** (*str**, **optional*) -- Proxy Url, defaults to None\n    * **proxy_port** (*int**, **optional*) -- Proxy Port, defaults to 3128\n\n\n#### decrypt_bronco_in_report(report, bronco_public_key)\nDecrypt the content of a report using a private and public key.\n* **Parameters**\n    * **report** (*object*) -- The encrypted message.\n    * **bronco_public_key** (*str*) -- The public key\n* **Raises**\n    **KeyError** -- When Bronco Key is wrong.\n* **Returns**\n    A dictionary object representing the report.\n* **Return type**\n    dict\n\n\n\n#### generate_key_pair()\nGenerate a public key pair .\n* **Raises**\n    * **exceptions.InvalidStateError** -- Could not set the public key.\n    * **exceptions.InvalidStateError** -- Could not confirm the public key.\n* **Returns**\n    A key pair (sk, pk)\n* **Return type**\n    tuple\n\n#### get_access_token()\nObtain access token.\n* **Raises**\n    **requests.exceptions.ConnectionError** -- API is Unavailable.\n* **Returns**\n    A token\n* **Return type**\n    str\n\n#### get_bronco_public_key()\nGet server public key.\n* **Returns**\n    A string representation of a public key.\n* **Return type**\n    str\n\n\n\n#### get_recent_reports(reset: Optional[Union[int, datetime]] = None)\nGet recent reports.\n* **Parameters**\n    **reset** (*int**, **datetime**, **optional*) -- A number of days in the past to reset, defaults to 0\n* **Returns**\n    Recent reports.\n* **Return type**\n    dict\n\n\n#### get_recent_vulns(reset: int = 0)\nGet all vulnerabilities within 60 days of the user\'s stream marker;             limit of 500 vulnerabilities can be returned.\n* **Parameters**\n    **reset** (*int**, **optional*) -- Reset the stream maker to a number of days in the\n    past, defaults to 0\n* **Returns**\n    Returns recent vulnerabilities.\n* **Return type**\n    dict\n\n#### get_report(identifier: str)\nGet a report by identifier .\n* **Parameters**\n    **identifier** (*str*) -- String representation of report id.\n* **Returns**\n    Returns report\n* **Return type**\n    dict\n\n#### get_vuln(identifier: str)\nGet a Vulnerability by identifier or cve.\n\n* **Parameters**\n    **identifier** (*str*) -- String representation of vulnerability id.\n* **Returns**\n    A Vulnerability\n* **Return type**\n\n    dict\n\n#### get_vulns_by_day()\nGet vulnerabilities by day .\n* **Returns**\n    The number of vulnerabilities by day.\n* **Return type**\n    dict\n\n#### handle_reset_option(reset: Optional[Union[int, datetime]] = None)\nReset number of days.\n* **Parameters**\n    **reset** (*int*) -- Number of days in the past to reset\n* **Returns**\n    A date in ISO8601\n* **Return type**\n    datetime\n\n#### search(search_term: str)\nSearch specific term\n* **Parameters**\n    **search_term** (*str*) -- Term to search for.\n* **Returns**\n    Vulnerabilities containing search term\n* **Return type**\n    dict\n\n### _class_ eve.EVEClientAnonymous()\nBases: `object`\nThis class allows to retrieve cve information anonymously from\nExodus Intelligence API.\n* **Returns:**\n    JSON Object: CVE information available to the anonymous user.\n\n#### get_cve(identifier: str)\nRetrieve a Common Vulnerabilities and Exposures identifier.\n* **Parameters**\n    **identifier** (*str*) -- CVE identifier\n* **Returns**\n    A dictionary containing fields for the anonymous tier.\n* **Return type**\n    dict\n',
    'author': 'DevTeam',
    'author_email': 'dev@exodusintel.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
