LANGUAGE_TAGS = {
    "ABA ": {"name": "Abaza", "iso639": ["abq"]},
    "ABK ": {"name": "Abkhazian", "iso639": ["abk"]},
    "ACH ": {"name": "Acholi", "iso639": ["ach"]},
    "ACR ": {"name": "Achi", "iso639": ["acr"]},
    "ADY ": {"name": "Adyghe", "iso639": ["ady"]},
    "AFK ": {"name": "Afrikaans", "iso639": ["afr"]},
    "AFR ": {"name": "Afar", "iso639": ["aar"]},
    "AGW ": {"name": "Agaw", "iso639": ["ahg"]},
    "AIO ": {"name": "Aiton", "iso639": ["aio"]},
    "AKA ": {"name": "Akan", "iso639": ["aka", "fat", "twi"]},
    "AKB ": {"name": "Batak Angkola", "iso639": ["akb"]},
    "ALS ": {"name": "Alsatian", "iso639": ["gsw"]},
    "ALT ": {"name": "Altai", "iso639": ["atv", "alt"]},
    "AMH ": {"name": "Amharic", "iso639": ["amh"]},
    "ANG ": {"name": "Anglo-Saxon", "iso639": ["ang"]},
    "APPH": {"name": "Phonetic transcription—Americanist conventions", "iso639": []},
    "ARA ": {"name": "Arabic", "iso639": ["ara"]},
    "ARG ": {"name": "Aragonese", "iso639": ["arg"]},
    "ARI ": {"name": "Aari", "iso639": ["aiw"]},
    "ARK ": {"name": "Rakhine", "iso639": ["mhv", "rmz", "rki"]},
    "ASM ": {"name": "Assamese", "iso639": ["asm"]},
    "AST ": {"name": "Asturian", "iso639": ["ast"]},
    "ATH ": {
        "name": "Athapaskan languages",
        "iso639": [
            "aht",
            "apa",
            "apk",
            "apj",
            "apl",
            "apm",
            "apw",
            "ath",
            "bea",
            "sek",
            "bcr",
            "caf",
            "chp",
            "clc",
            "coq",
            "crx",
            "ctc",
            "den",
            "dgr",
            "gce",
            "gwi",
            "haa",
            "hoi",
            "hup",
            "ing",
            "kkz",
            "koy",
            "ktw",
            "kuu",
            "mvb",
            "nav",
            "qwt",
            "scs",
            "srs",
            "taa",
            "tau",
            "tcb",
            "tce",
            "tfn",
            "tgx",
            "tht",
            "tol",
            "ttm",
            "tuu",
            "txc",
            "wlk",
            "xup",
            "xsl",
        ],
    },
    "AVR ": {"name": "Avar", "iso639": ["ava"]},
    "AWA ": {"name": "Awadhi", "iso639": ["awa"]},
    "AYM ": {"name": "Aymara", "iso639": ["aym"]},
    "AZB ": {"name": "Torki", "iso639": ["azb"]},
    "AZE ": {"name": "Azerbaijani", "iso639": ["aze"]},
    "BAD ": {"name": "Badaga", "iso639": ["bfq"]},
    "BAD0": {
        "name": "Banda",
        "iso639": [
            "bad",
            "bbp",
            "bfl",
            "bjo",
            "bpd",
            "bqk",
            "gox",
            "kuw",
            "liy",
            "lna",
            "lnl",
            "mnh",
            "nue",
            "nuu",
            "tor",
            "yaj",
            "zmz",
        ],
    },
    "BAG ": {"name": "Baghelkhandi", "iso639": ["bfy"]},
    "BAL ": {"name": "Balkar", "iso639": ["krc"]},
    "BAN ": {"name": "Balinese", "iso639": ["ban"]},
    "BAR ": {"name": "Bavarian", "iso639": ["bar"]},
    "BAU ": {"name": "Baulé", "iso639": ["bci"]},
    "BBC ": {"name": "Batak Toba", "iso639": ["bbc"]},
    "BBR ": {
        "name": "Berber",
        "iso639": [
            "auj",
            "ber",
            "cnu",
            "gha",
            "gho",
            "grr",
            "jbe",
            "jbn",
            "kab",
            "mzb",
            "oua",
            "rif",
            "sds",
            "shi",
            "shy",
            "siz",
            "sjs",
            "swn",
            "taq",
            "tez",
            "thv",
            "thz",
            "tia",
            "tjo",
            "tmh",
            "ttq",
            "tzm",
            "zen",
            "zgh",
        ],
    },
    "BCH ": {"name": "Bench", "iso639": ["bcq"]},
    "BCR ": {"name": "Bible Cree", "iso639": []},
    "BDY ": {"name": "Bandjalang", "iso639": ["bdy"]},
    "BEL ": {"name": "Belarussian", "iso639": ["bel"]},
    "BEM ": {"name": "Bemba", "iso639": ["bem"]},
    "BEN ": {"name": "Bengali", "iso639": ["ben"]},
    "BGC ": {"name": "Haryanvi", "iso639": ["bgc"]},
    "BGQ ": {"name": "Bagri", "iso639": ["bgq"]},
    "BGR ": {"name": "Bulgarian", "iso639": ["bul"]},
    "BHI ": {"name": "Bhili", "iso639": ["bhi", "bhb"]},
    "BHO ": {"name": "Bhojpuri", "iso639": ["bho"]},
    "BIK ": {
        "name": "Bikol",
        "iso639": [
            "bik",
            "bhk",
            "bcl",
            "bto",
            "cts",
            "bln",
            "fbl",
            "lbl",
            "rbl",
            "ubl",
        ],
    },
    "BIL ": {"name": "Bilen", "iso639": ["byn"]},
    "BIS ": {"name": "Bislama", "iso639": ["bis"]},
    "BJJ ": {"name": "Kanauji", "iso639": ["bjj"]},
    "BKF ": {"name": "Blackfoot", "iso639": ["bla"]},
    "BLI ": {"name": "Baluchi", "iso639": ["bal"]},
    "BLK ": {"name": "Pa’o Karen", "iso639": ["blk"]},
    "BLN ": {"name": "Balante", "iso639": ["bjt", "ble"]},
    "BLT ": {"name": "Balti", "iso639": ["bft"]},
    "BMB ": {"name": "Bambara (Bamanankan)", "iso639": ["bam"]},
    "BML ": {
        "name": "Bamileke",
        "iso639": [
            "bai",
            "bbj",
            "bko",
            "byv",
            "fmp",
            "jgo",
            "nla",
            "nnh",
            "nnz",
            "nwe",
            "xmg",
            "ybb",
        ],
    },
    "BOS ": {"name": "Bosnian", "iso639": ["bos"]},
    "BPY ": {"name": "Bishnupriya Manipuri", "iso639": ["bpy"]},
    "BRE ": {"name": "Breton", "iso639": ["bre"]},
    "BRH ": {"name": "Brahui", "iso639": ["brh"]},
    "BRI ": {"name": "Braj Bhasha", "iso639": ["bra"]},
    "BRM ": {"name": "Burmese", "iso639": ["mya"]},
    "BRX ": {"name": "Bodo", "iso639": ["brx"]},
    "BSH ": {"name": "Bashkir", "iso639": ["bak"]},
    "BSK ": {"name": "Burushaski", "iso639": ["bsk"]},
    "BTD ": {"name": "Batak Dairi (Pakpak)", "iso639": ["btd"]},
    "BTI ": {
        "name": "Beti",
        "iso639": ["btb", "beb", "bum", "bxp", "eto", "ewo", "mct"],
    },
    "BTK ": {
        "name": "Batak languages",
        "iso639": ["akb", "bbc", "btd", "btk", "btm", "bts", "btx", "btz"],
    },
    "BTM ": {"name": "Batak Mandailing", "iso639": ["btm"]},
    "BTS ": {"name": "Batak Simalungun", "iso639": ["bts"]},
    "BTX ": {"name": "Batak Karo", "iso639": ["btx"]},
    "BTZ ": {"name": "Batak Alas-Kluet", "iso639": ["btz"]},
    "BUG ": {"name": "Bugis", "iso639": ["bug"]},
    "BYV ": {"name": "Medumba", "iso639": ["byv"]},
    "CAK ": {"name": "Kaqchikel", "iso639": ["cak"]},
    "CAT ": {"name": "Catalan", "iso639": ["cat"]},
    "CBK ": {"name": "Zamboanga Chavacano", "iso639": ["cbk"]},
    "CCHN": {
        "name": "Chinantec",
        "iso639": [
            "cco",
            "chj",
            "chq",
            "chz",
            "cle",
            "cnl",
            "cnt",
            "cpa",
            "csa",
            "cso",
            "cte",
            "ctl",
            "cuc",
            "cvn",
        ],
    },
    "CEB ": {"name": "Cebuano", "iso639": ["ceb"]},
    "CGG ": {"name": "Chiga", "iso639": ["cgg"]},
    "CHA ": {"name": "Chamorro", "iso639": ["cha"]},
    "CHE ": {"name": "Chechen", "iso639": ["che"]},
    "CHG ": {"name": "Chaha Gurage", "iso639": ["sgw"]},
    "CHH ": {"name": "Chattisgarhi", "iso639": ["hne"]},
    "CHI ": {"name": "Chichewa (Chewa, Nyanja)", "iso639": ["nya"]},
    "CHK ": {"name": "Chukchi", "iso639": ["ckt"]},
    "CHK0": {"name": "Chuukese", "iso639": ["chk"]},
    "CHO ": {"name": "Choctaw", "iso639": ["cho"]},
    "CHP ": {"name": "Chipewyan", "iso639": ["chp"]},
    "CHR ": {"name": "Cherokee", "iso639": ["chr"]},
    "CHU ": {"name": "Chuvash", "iso639": ["chv"]},
    "CHY ": {"name": "Cheyenne", "iso639": ["chy"]},
    "CJA ": {"name": "Western Cham", "iso639": ["cja"]},
    "CJM ": {"name": "Eastern Cham", "iso639": ["cjm"]},
    "CMR ": {"name": "Comorian", "iso639": ["swb", "wlc", "wni", "zdj"]},
    "COP ": {"name": "Coptic", "iso639": ["cop"]},
    "COR ": {"name": "Cornish", "iso639": ["cor"]},
    "COS ": {"name": "Corsican", "iso639": ["cos"]},
    "CPP ": {
        "name": "Creoles",
        "iso639": [
            "abs",
            "acf",
            "afs",
            "aig",
            "aoa",
            "bah",
            "bew",
            "bis",
            "bjs",
            "bpl",
            "bpq",
            "brc",
            "bxo",
            "bzj",
            "bzk",
            "cbk",
            "ccl",
            "ccm",
            "chn",
            "cks",
            "cpe",
            "cpf",
            "cpi",
            "cpp",
            "cri",
            "crp",
            "crs",
            "dcr",
            "dep",
            "djk",
            "fab",
            "fng",
            "fpe",
            "gac",
            "gcf",
            "gcl",
            "gcr",
            "gib",
            "goq",
            "gpe",
            "gul",
            "gyn",
            "hat",
            "hca",
            "hmo",
            "hwc",
            "icr",
            "idb",
            "ihb",
            "jam",
            "jvd",
            "kcn",
            "kea",
            "kmv",
            "kri",
            "kww",
            "lir",
            "lou",
            "lrt",
            "max",
            "mbf",
            "mcm",
            "mfe",
            "mfp",
            "mkn",
            "mod",
            "msi",
            "mud",
            "mzs",
            "nag",
            "nef",
            "ngm",
            "njt",
            "onx",
            "oor",
            "pap",
            "pcm",
            "pea",
            "pey",
            "pga",
            "pih",
            "pis",
            "pln",
            "pml",
            "pmy",
            "pov",
            "pre",
            "rcf",
            "rop",
            "scf",
            "sci",
            "skw",
            "srm",
            "srn",
            "sta",
            "svc",
            "tas",
            "tch",
            "tcs",
            "tgh",
            "tmg",
            "tpi",
            "trf",
            "tvy",
            "uln",
            "vic",
            "vkp",
            "wes",
            "xmm",
        ],
    },
    "CRE ": {"name": "Cree", "iso639": ["cre"]},
    "CRR ": {"name": "Carrier", "iso639": ["crx", "caf"]},
    "CRT ": {"name": "Crimean Tatar", "iso639": ["crh"]},
    "CSB ": {"name": "Kashubian", "iso639": ["csb"]},
    "CSL ": {"name": "Church Slavonic", "iso639": ["chu"]},
    "CSY ": {"name": "Czech", "iso639": ["ces"]},
    "CTG ": {"name": "Chittagonian", "iso639": ["ctg"]},
    "CUK ": {"name": "San Blas Kuna", "iso639": ["cuk"]},
    "DAG ": {"name": "Dagbani", "iso639": ["dag"]},
    "DAN ": {"name": "Danish", "iso639": ["dan"]},
    "DAR ": {"name": "Dargwa", "iso639": ["dar"]},
    "DAX ": {"name": "Dayi", "iso639": ["dax"]},
    "DCR ": {"name": "Woods Cree", "iso639": ["cwd"]},
    "DEU ": {"name": "German", "iso639": ["deu"]},
    "DGO ": {"name": "Dogri (individual language)", "iso639": ["dgo"]},
    "DGR ": {"name": "Dogri (macrolanguage)", "iso639": ["doi"]},
    "DHG ": {"name": "Dhangu", "iso639": ["dhg"]},
    "DHV ": {
        "name": "Divehi (Dhivehi, Maldivian)",
        "iso639": ["div"],
        "deprecated": True,
    },
    "DIQ ": {"name": "Dimli", "iso639": ["diq"]},
    "DIV ": {"name": "Divehi (Dhivehi, Maldivian)", "iso639": ["div"]},
    "DJR ": {"name": "Zarma", "iso639": ["dje"]},
    "DJR0": {"name": "Djambarrpuyngu", "iso639": ["djr"]},
    "DNG ": {"name": "Dangme", "iso639": ["ada"]},
    "DNJ ": {"name": "Dan", "iso639": ["dnj"]},
    "DNK ": {"name": "Dinka", "iso639": ["din"]},
    "DRI ": {"name": "Dari", "iso639": ["prs"]},
    "DUJ ": {"name": "Dhuwal", "iso639": ["duj", "dwu", "dwy"]},
    "DUN ": {"name": "Dungan", "iso639": ["dng"]},
    "DZN ": {"name": "Dzongkha", "iso639": ["dzo"]},
    "EBI ": {"name": "Ebira", "iso639": ["igb"]},
    "ECR ": {"name": "Eastern Cree", "iso639": ["crj", "crl"]},
    "EDO ": {"name": "Edo", "iso639": ["bin"]},
    "EFI ": {"name": "Efik", "iso639": ["efi"]},
    "ELL ": {"name": "Greek", "iso639": ["ell"]},
    "EMK ": {"name": "Eastern Maninkakan", "iso639": ["emk"]},
    "ENG ": {"name": "English", "iso639": ["eng"]},
    "ERZ ": {"name": "Erzya", "iso639": ["myv"]},
    "ESP ": {"name": "Spanish", "iso639": ["spa"]},
    "ESU ": {"name": "Central Yupik", "iso639": ["esu"]},
    "ETI ": {"name": "Estonian", "iso639": ["est"]},
    "EUQ ": {"name": "Basque", "iso639": ["eus"]},
    "EVK ": {"name": "Evenki", "iso639": ["evn"]},
    "EVN ": {"name": "Even", "iso639": ["eve"]},
    "EWE ": {"name": "Ewe", "iso639": ["ewe"]},
    "FAN ": {"name": "French Antillean", "iso639": ["acf"]},
    "FAN0": {"name": "Fang", "iso639": ["fan"]},
    "FAR ": {"name": "Persian", "iso639": ["fas"]},
    "FAT ": {"name": "Fanti", "iso639": ["fat"]},
    "FIN ": {"name": "Finnish", "iso639": ["fin"]},
    "FJI ": {"name": "Fijian", "iso639": ["fij"]},
    "FLE ": {"name": "Dutch (Flemish)", "iso639": ["vls"]},
    "FMP ": {"name": "Fe’fe’", "iso639": ["fmp"]},
    "FNE ": {"name": "Forest Enets", "iso639": ["enf"]},
    "FON ": {"name": "Fon", "iso639": ["fon"]},
    "FOS ": {"name": "Faroese", "iso639": ["fao"]},
    "FRA ": {"name": "French", "iso639": ["fra"]},
    "FRC ": {"name": "Cajun French", "iso639": ["frc"]},
    "FRI ": {"name": "Frisian", "iso639": ["fry"]},
    "FRL ": {"name": "Friulian", "iso639": ["fur"]},
    "FRP ": {"name": "Arpitan", "iso639": ["frp"]},
    "FTA ": {"name": "Futa", "iso639": ["fuf"]},
    "FUL ": {"name": "Fulah", "iso639": ["ful"]},
    "FUV ": {"name": "Nigerian Fulfulde", "iso639": ["fuv"]},
    "GAD ": {"name": "Ga", "iso639": ["gaa"]},
    "GAE ": {"name": "Scottish Gaelic (Gaelic)", "iso639": ["gla"]},
    "GAG ": {"name": "Gagauz", "iso639": ["gag"]},
    "GAL ": {"name": "Galician", "iso639": ["glg"]},
    "GAR ": {"name": "Garshuni", "iso639": []},
    "GAW ": {"name": "Garhwali", "iso639": ["gbm"]},
    "GEZ ": {"name": "Geez", "iso639": ["gez"]},
    "GIH ": {"name": "Githabul", "iso639": ["gih"]},
    "GIL ": {"name": "Gilyak", "iso639": ["niv"]},
    "GIL0": {"name": "Kiribati (Gilbertese)", "iso639": ["gil"]},
    "GKP ": {"name": "Kpelle (Guinea)", "iso639": ["gkp"]},
    "GLK ": {"name": "Gilaki", "iso639": ["glk"]},
    "GMZ ": {"name": "Gumuz", "iso639": ["guk"]},
    "GNN ": {"name": "Gumatj", "iso639": ["gnn"]},
    "GOG ": {"name": "Gogo", "iso639": ["gog"]},
    "GON ": {"name": "Gondi", "iso639": ["gon"]},
    "GRN ": {"name": "Greenlandic", "iso639": ["kal"]},
    "GRO ": {"name": "Garo", "iso639": ["grt"]},
    "GUA ": {"name": "Guarani", "iso639": ["grn"]},
    "GUC ": {"name": "Wayuu", "iso639": ["guc"]},
    "GUF ": {"name": "Gupapuyngu", "iso639": ["guf"]},
    "GUJ ": {"name": "Gujarati", "iso639": ["guj"]},
    "GUZ ": {"name": "Gusii", "iso639": ["guz"]},
    "HAI ": {"name": "Haitian (Haitian Creole)", "iso639": ["hat"]},
    "HAL ": {"name": "Halam (Falam Chin)", "iso639": ["cfm"]},
    "HAR ": {"name": "Harauti", "iso639": ["hoj"]},
    "HAU ": {"name": "Hausa", "iso639": ["hau"]},
    "HAW ": {"name": "Hawaiian", "iso639": ["haw"]},
    "HAY ": {"name": "Haya", "iso639": ["hay"]},
    "HAZ ": {"name": "Hazaragi", "iso639": ["haz"]},
    "HBN ": {"name": "Hammer-Banna", "iso639": ["amf"]},
    "HER ": {"name": "Herero", "iso639": ["her"]},
    "HIL ": {"name": "Hiligaynon", "iso639": ["hil"]},
    "HIN ": {"name": "Hindi", "iso639": ["hin"]},
    "HMA ": {"name": "High Mari", "iso639": ["mrj"]},
    "HMN ": {"name": "Hmong", "iso639": ["hmn"]},
    "HMO ": {"name": "Hiri Motu", "iso639": ["hmo"]},
    "HND ": {"name": "Hindko", "iso639": ["hno", "hnd"]},
    "HO  ": {"name": "Ho", "iso639": ["hoc"]},
    "HRI ": {"name": "Harari", "iso639": ["har"]},
    "HRV ": {"name": "Croatian", "iso639": ["hrv"]},
    "HUN ": {"name": "Hungarian", "iso639": ["hun"]},
    "HYE ": {"name": "Armenian", "iso639": ["hye", "hyw"]},
    "HYE0": {"name": "Armenian East", "iso639": ["hye"]},
    "IBA ": {"name": "Iban", "iso639": ["iba"]},
    "IBB ": {"name": "Ibibio", "iso639": ["ibb"]},
    "IBO ": {"name": "Igbo", "iso639": ["ibo"]},
    "IDO ": {"name": "Ido", "iso639": ["ido"]},
    "IJO ": {
        "name": "Ijo languages",
        "iso639": [
            "iby",
            "ijc",
            "ije",
            "ijn",
            "ijo",
            "ijs",
            "nkx",
            "okd",
            "okr",
            "orr",
        ],
    },
    "ILE ": {"name": "Interlingue", "iso639": ["ile"]},
    "ILO ": {"name": "Ilokano", "iso639": ["ilo"]},
    "INA ": {"name": "Interlingua", "iso639": ["ina"]},
    "IND ": {"name": "Indonesian", "iso639": ["ind"]},
    "ING ": {"name": "Ingush", "iso639": ["inh"]},
    "INU ": {"name": "Inuktitut", "iso639": ["iku"]},
    "IPK ": {"name": "Inupiat", "iso639": ["ipk"]},
    "IPPH": {"name": "Phonetic transcription—IPA conventions", "iso639": []},
    "IRI ": {"name": "Irish", "iso639": ["gle"]},
    "IRT ": {"name": "Irish Traditional", "iso639": ["gle"]},
    "ISL ": {"name": "Icelandic", "iso639": ["isl"]},
    "ISM ": {"name": "Inari Sami", "iso639": ["smn"]},
    "ITA ": {"name": "Italian", "iso639": ["ita"]},
    "IWR ": {"name": "Hebrew", "iso639": ["heb"]},
    "JAM ": {"name": "Jamaican Creole", "iso639": ["jam"]},
    "JAN ": {"name": "Japanese", "iso639": ["jpn"]},
    "JAV ": {"name": "Javanese", "iso639": ["jav"]},
    "JBO ": {"name": "Lojban", "iso639": ["jbo"]},
    "JCT ": {"name": "Krymchak", "iso639": ["jct"]},
    "JII ": {"name": "Yiddish", "iso639": ["yid"]},
    "JUD ": {"name": "Ladino", "iso639": ["lad"]},
    "JUL ": {"name": "Jula", "iso639": ["dyu"]},
    "KAB ": {"name": "Kabardian", "iso639": ["kbd"]},
    "KAB0": {"name": "Kabyle", "iso639": ["kab"]},
    "KAC ": {"name": "Kachchi", "iso639": ["kfr"]},
    "KAL ": {"name": "Kalenjin", "iso639": ["kln"]},
    "KAN ": {"name": "Kannada", "iso639": ["kan"]},
    "KAR ": {"name": "Karachay", "iso639": ["krc"]},
    "KAT ": {"name": "Georgian", "iso639": ["kat"]},
    "KAZ ": {"name": "Kazakh", "iso639": ["kaz"]},
    "KDE ": {"name": "Makonde", "iso639": ["kde"]},
    "KEA ": {"name": "Kabuverdianu (Crioulo)", "iso639": ["kea"]},
    "KEB ": {"name": "Kebena", "iso639": ["ktb"]},
    "KEK ": {"name": "Kekchi", "iso639": ["kek"]},
    "KGE ": {"name": "Khutsuri Georgian", "iso639": ["kat"]},
    "KHA ": {"name": "Khakass", "iso639": ["kjh"]},
    "KHK ": {"name": "Khanty-Kazim", "iso639": ["kca"]},
    "KHM ": {"name": "Khmer", "iso639": ["khm"]},
    "KHS ": {"name": "Khanty-Shurishkar", "iso639": ["kca"]},
    "KHT ": {"name": "Khamti Shan", "iso639": ["kht"]},
    "KHV ": {"name": "Khanty-Vakhi", "iso639": ["kca"]},
    "KHW ": {"name": "Khowar", "iso639": ["khw"]},
    "KIK ": {"name": "Kikuyu (Gikuyu)", "iso639": ["kik"]},
    "KIR ": {"name": "Kirghiz (Kyrgyz)", "iso639": ["kir"]},
    "KIS ": {"name": "Kisii", "iso639": ["kqs", "kss"]},
    "KIU ": {"name": "Kirmanjki", "iso639": ["kiu"]},
    "KJD ": {"name": "Southern Kiwai", "iso639": ["kjd"]},
    "KJP ": {"name": "Eastern Pwo Karen", "iso639": ["kjp"]},
    "KJZ ": {"name": "Bumthangkha", "iso639": ["kjz"]},
    "KKN ": {"name": "Kokni", "iso639": ["kex"]},
    "KLM ": {"name": "Kalmyk", "iso639": ["xal"]},
    "KMB ": {"name": "Kamba", "iso639": ["kam"]},
    "KMN ": {"name": "Kumaoni", "iso639": ["kfy"]},
    "KMO ": {"name": "Komo", "iso639": ["kmw"]},
    "KMS ": {"name": "Komso", "iso639": ["kxc"]},
    "KMZ ": {"name": "Khorasani Turkic", "iso639": ["kmz"]},
    "KNR ": {"name": "Kanuri", "iso639": ["kau"]},
    "KOD ": {"name": "Kodagu", "iso639": ["kfa"]},
    "KOH ": {"name": "Korean Old Hangul", "iso639": ["kor", "okm"]},
    "KOK ": {"name": "Konkani", "iso639": ["kok"]},
    "KOM ": {"name": "Komi", "iso639": ["kom"]},
    "KON ": {"name": "Kikongo", "iso639": ["ktu"]},
    "KON0": {"name": "Kongo", "iso639": ["kon"]},
    "KOP ": {"name": "Komi-Permyak", "iso639": ["koi"]},
    "KOR ": {"name": "Korean", "iso639": ["kor"]},
    "KOS ": {"name": "Kosraean", "iso639": ["kos"]},
    "KOZ ": {"name": "Komi-Zyrian", "iso639": ["kpv"]},
    "KPL ": {"name": "Kpelle", "iso639": ["kpe"]},
    "KRI ": {"name": "Krio", "iso639": ["kri"]},
    "KRK ": {"name": "Karakalpak", "iso639": ["kaa"]},
    "KRL ": {"name": "Karelian", "iso639": ["krl"]},
    "KRM ": {"name": "Karaim", "iso639": ["kdr"]},
    "KRN ": {
        "name": "Karen",
        "iso639": [
            "blk",
            "bwe",
            "eky",
            "ghk",
            "jkm",
            "jkp",
            "kar",
            "kjp",
            "kjt",
            "ksw",
            "kvl",
            "kvq",
            "kvt",
            "kvu",
            "kvy",
            "kxf",
            "kxk",
            "kyu",
            "pdu",
            "pwo",
            "pww",
            "wea",
        ],
    },
    "KRT ": {"name": "Koorete", "iso639": ["kqy"]},
    "KSH ": {"name": "Kashmiri", "iso639": ["kas"]},
    "KSH0": {"name": "Ripuarian", "iso639": ["ksh"]},
    "KSI ": {"name": "Khasi", "iso639": ["kha"]},
    "KSM ": {"name": "Kildin Sami", "iso639": ["sjd"]},
    "KSW ": {"name": "S’gaw Karen", "iso639": ["ksw"]},
    "KUA ": {"name": "Kuanyama", "iso639": ["kua"]},
    "KUI ": {"name": "Kui", "iso639": ["kxu"]},
    "KUL ": {"name": "Kulvi", "iso639": ["kfx"]},
    "KUM ": {"name": "Kumyk", "iso639": ["kum"]},
    "KUR ": {"name": "Kurdish", "iso639": ["kur"]},
    "KUU ": {"name": "Kurukh", "iso639": ["kru"]},
    "KUY ": {"name": "Kuy", "iso639": ["kdt"]},
    "KYK ": {"name": "Koryak", "iso639": ["kpy"]},
    "KYU ": {"name": "Western Kayah", "iso639": ["kyu"]},
    "LAD ": {"name": "Ladin", "iso639": ["lld"]},
    "LAH ": {"name": "Lahuli", "iso639": ["bfu"]},
    "LAK ": {"name": "Lak", "iso639": ["lbe"]},
    "LAM ": {"name": "Lambani", "iso639": ["lmn"]},
    "LAO ": {"name": "Lao", "iso639": ["lao"]},
    "LAT ": {"name": "Latin", "iso639": ["lat"]},
    "LAZ ": {"name": "Laz", "iso639": ["lzz"]},
    "LCR ": {"name": "L-Cree", "iso639": ["crm"]},
    "LDK ": {"name": "Ladakhi", "iso639": ["lbj"]},
    "LEZ ": {"name": "Lezgi", "iso639": ["lez"]},
    "LIJ ": {"name": "Ligurian", "iso639": ["lij"]},
    "LIM ": {"name": "Limburgish", "iso639": ["lim"]},
    "LIN ": {"name": "Lingala", "iso639": ["lin"]},
    "LIS ": {"name": "Lisu", "iso639": ["lis"]},
    "LJP ": {"name": "Lampung", "iso639": ["ljp"]},
    "LKI ": {"name": "Laki", "iso639": ["lki"]},
    "LMA ": {"name": "Low Mari", "iso639": ["mhr"]},
    "LMB ": {"name": "Limbu", "iso639": ["lif"]},
    "LMO ": {"name": "Lombard", "iso639": ["lmo"]},
    "LMW ": {"name": "Lomwe", "iso639": ["ngl"]},
    "LOM ": {"name": "Loma", "iso639": ["lom"]},
    "LRC ": {"name": "Luri", "iso639": ["lrc", "luz", "bqi", "zum"]},
    "LSB ": {"name": "Lower Sorbian", "iso639": ["dsb"]},
    "LSM ": {"name": "Lule Sami", "iso639": ["smj"]},
    "LTH ": {"name": "Lithuanian", "iso639": ["lit"]},
    "LTZ ": {"name": "Luxembourgish", "iso639": ["ltz"]},
    "LUA ": {"name": "Luba-Lulua", "iso639": ["lua"]},
    "LUB ": {"name": "Luba-Katanga", "iso639": ["lub"]},
    "LUG ": {"name": "Ganda", "iso639": ["lug"]},
    "LUH ": {"name": "Luyia", "iso639": ["luy"]},
    "LUO ": {"name": "Luo", "iso639": ["luo"]},
    "LVI ": {"name": "Latvian", "iso639": ["lav"]},
    "MAD ": {"name": "Madura", "iso639": ["mad"]},
    "MAG ": {"name": "Magahi", "iso639": ["mag"]},
    "MAH ": {"name": "Marshallese", "iso639": ["mah"]},
    "MAJ ": {"name": "Majang", "iso639": ["mpe"]},
    "MAK ": {"name": "Makhuwa", "iso639": ["vmw"]},
    "MAL ": {"name": "Malayalam", "iso639": ["mal"]},
    "MAM ": {"name": "Mam", "iso639": ["mam"]},
    "MAN ": {"name": "Mansi", "iso639": ["mns"]},
    "MAP ": {"name": "Mapudungun", "iso639": ["arn"]},
    "MAR ": {"name": "Marathi", "iso639": ["mar"]},
    "MAW ": {
        "name": "Marwari",
        "iso639": ["mwr", "dhd", "rwr", "mve", "wry", "mtr", "swv"],
    },
    "MBN ": {"name": "Mbundu", "iso639": ["kmb"]},
    "MBO ": {"name": "Mbo", "iso639": ["mbo"]},
    "MCH ": {"name": "Manchu", "iso639": ["mnc"]},
    "MCR ": {"name": "Moose Cree", "iso639": ["crm"]},
    "MDE ": {"name": "Mende", "iso639": ["men"]},
    "MDR ": {"name": "Mandar", "iso639": ["mdr"]},
    "MEN ": {"name": "Me’en", "iso639": ["mym"]},
    "MER ": {"name": "Meru", "iso639": ["mer"]},
    "MFA ": {"name": "Pattani Malay", "iso639": ["mfa"]},
    "MFE ": {"name": "Morisyen", "iso639": ["mfe"]},
    "MIN ": {"name": "Minangkabau", "iso639": ["min"]},
    "MIZ ": {"name": "Mizo", "iso639": ["lus"]},
    "MKD ": {"name": "Macedonian", "iso639": ["mkd"]},
    "MKR ": {"name": "Makasar", "iso639": ["mak"]},
    "MKW ": {"name": "Kituba", "iso639": ["mkw"]},
    "MLE ": {"name": "Male", "iso639": ["mdy"]},
    "MLG ": {"name": "Malagasy", "iso639": ["mlg"]},
    "MLN ": {"name": "Malinke", "iso639": ["mlq"]},
    "MLR ": {"name": "Malayalam Reformed", "iso639": ["mal"]},
    "MLY ": {"name": "Malay", "iso639": ["msa"]},
    "MND ": {"name": "Mandinka", "iso639": ["mnk"]},
    "MNG ": {"name": "Mongolian", "iso639": ["mon"]},
    "MNI ": {"name": "Manipuri", "iso639": ["mni"]},
    "MNK ": {
        "name": "Maninka",
        "iso639": ["man", "mnk", "myq", "mku", "msc", "emk", "mwk", "mlq"],
    },
    "MNX ": {"name": "Manx", "iso639": ["glv"]},
    "MOH ": {"name": "Mohawk", "iso639": ["moh"]},
    "MOK ": {"name": "Moksha", "iso639": ["mdf"]},
    "MOL ": {"name": "Moldavian", "iso639": ["mol"]},
    "MON ": {"name": "Mon", "iso639": ["mnw"]},
    "MOR ": {"name": "Moroccan", "iso639": []},
    "MOS ": {"name": "Mossi", "iso639": ["mos"]},
    "MRI ": {"name": "Maori", "iso639": ["mri"]},
    "MTH ": {"name": "Maithili", "iso639": ["mai"]},
    "MTS ": {"name": "Maltese", "iso639": ["mlt"]},
    "MUN ": {"name": "Mundari", "iso639": ["unr"]},
    "MUS ": {"name": "Muscogee", "iso639": ["mus"]},
    "MWL ": {"name": "Mirandese", "iso639": ["mwl"]},
    "MWW ": {"name": "Hmong Daw", "iso639": ["mww"]},
    "MYN ": {
        "name": "Mayan",
        "iso639": [
            "acr",
            "agu",
            "caa",
            "cac",
            "cak",
            "chf",
            "ckz",
            "cob",
            "ctu",
            "emy",
            "hus",
            "itz",
            "ixl",
            "jac",
            "kek",
            "kjb",
            "knj",
            "lac",
            "mam",
            "mhc",
            "mop",
            "myn",
            "poc",
            "poh",
            "quc",
            "qum",
            "quv",
            "toj",
            "ttc",
            "tzh",
            "tzj",
            "tzo",
            "usp",
            "yua",
        ],
    },
    "MZN ": {"name": "Mazanderani", "iso639": ["mzn"]},
    "NAG ": {"name": "Naga-Assamese", "iso639": ["nag"]},
    "NAH ": {
        "name": "Nahuatl",
        "iso639": [
            "azd",
            "azn",
            "azz",
            "nah",
            "naz",
            "nch",
            "nci",
            "ncj",
            "ncl",
            "ncx",
            "ngu",
            "nhc",
            "nhe",
            "nhg",
            "nhi",
            "nhk",
            "nhm",
            "nhn",
            "nhp",
            "nhq",
            "nht",
            "nhv",
            "nhw",
            "nhx",
            "nhy",
            "nhz",
            "nlv",
            "npl",
            "nsu",
            "nuz",
        ],
    },
    "NAN ": {"name": "Nanai", "iso639": ["gld"]},
    "NAP ": {"name": "Neapolitan", "iso639": ["nap"]},
    "NAS ": {"name": "Naskapi", "iso639": ["nsk"]},
    "NAU ": {"name": "Nauruan", "iso639": ["nau"]},
    "NAV ": {"name": "Navajo", "iso639": ["nav"]},
    "NCR ": {"name": "N-Cree", "iso639": ["csw"]},
    "NDB ": {"name": "Ndebele", "iso639": ["nbl", "nde"]},
    "NDC ": {"name": "Ndau", "iso639": ["ndc"]},
    "NDG ": {"name": "Ndonga", "iso639": ["ndo"]},
    "NDS ": {"name": "Low Saxon", "iso639": ["nds"]},
    "NEP ": {"name": "Nepali", "iso639": ["nep"]},
    "NEW ": {"name": "Newari", "iso639": ["new"]},
    "NGA ": {"name": "Ngbaka", "iso639": ["nga"]},
    "NGR ": {"name": "Nagari", "iso639": []},
    "NHC ": {"name": "Norway House Cree", "iso639": ["csw"]},
    "NIS ": {"name": "Nisi", "iso639": ["dap", "njz", "tgj"]},
    "NIU ": {"name": "Niuean", "iso639": ["niu"]},
    "NKL ": {"name": "Nyankole", "iso639": ["nyn"]},
    "NKO ": {"name": "N’Ko", "iso639": ["nqo"]},
    "NLD ": {"name": "Dutch", "iso639": ["nld"]},
    "NOE ": {"name": "Nimadi", "iso639": ["noe"]},
    "NOG ": {"name": "Nogai", "iso639": ["nog"]},
    "NOR ": {"name": "Norwegian", "iso639": ["nob"]},
    "NOV ": {"name": "Novial", "iso639": ["nov"]},
    "NSM ": {"name": "Northern Sami", "iso639": ["sme"]},
    "NSO ": {"name": "Northern Sotho", "iso639": ["nso"]},
    "NTA ": {"name": "Northern Tai", "iso639": ["nod"]},
    "NTO ": {"name": "Esperanto", "iso639": ["epo"]},
    "NYM ": {"name": "Nyamwezi", "iso639": ["nym"]},
    "NYN ": {"name": "Norwegian Nynorsk (Nynorsk, Norwegian)", "iso639": ["nno"]},
    "NZA ": {"name": "Mbembe Tigon", "iso639": ["nza"]},
    "OCI ": {"name": "Occitan", "iso639": ["oci"]},
    "OCR ": {"name": "Oji-Cree", "iso639": ["ojs"]},
    "OJB ": {"name": "Ojibway", "iso639": ["oji"]},
    "ORI ": {"name": "Odia (formerly Oriya)", "iso639": ["ori"]},
    "ORO ": {"name": "Oromo", "iso639": ["orm"]},
    "OSS ": {"name": "Ossetian", "iso639": ["oss"]},
    "PAA ": {"name": "Palestinian Aramaic", "iso639": ["sam"]},
    "PAG ": {"name": "Pangasinan", "iso639": ["pag"]},
    "PAL ": {"name": "Pali", "iso639": ["pli"]},
    "PAM ": {"name": "Pampangan", "iso639": ["pam"]},
    "PAN ": {"name": "Punjabi", "iso639": ["pan"]},
    "PAP ": {"name": "Palpa", "iso639": ["plp"]},
    "PAP0": {"name": "Papiamentu", "iso639": ["pap"]},
    "PAS ": {"name": "Pashto", "iso639": ["pus"]},
    "PAU ": {"name": "Palauan", "iso639": ["pau"]},
    "PCC ": {"name": "Bouyei", "iso639": ["pcc"]},
    "PCD ": {"name": "Picard", "iso639": ["pcd"]},
    "PDC ": {"name": "Pennsylvania German", "iso639": ["pdc"]},
    "PGR ": {"name": "Polytonic Greek", "iso639": ["ell"]},
    "PHK ": {"name": "Phake", "iso639": ["phk"]},
    "PIH ": {"name": "Norfolk", "iso639": ["pih"]},
    "PIL ": {"name": "Filipino", "iso639": ["fil"]},
    "PLG ": {"name": "Palaung", "iso639": ["pce", "rbb", "pll"]},
    "PLK ": {"name": "Polish", "iso639": ["pol"]},
    "PMS ": {"name": "Piemontese", "iso639": ["pms"]},
    "PNB ": {"name": "Western Panjabi", "iso639": ["pnb"]},
    "POH ": {"name": "Pocomchi", "iso639": ["poh"]},
    "PON ": {"name": "Pohnpeian", "iso639": ["pon"]},
    "PRO ": {"name": "Provençal / Old Provençal", "iso639": ["pro"]},
    "PTG ": {"name": "Portuguese", "iso639": ["por"]},
    "PWO ": {"name": "Western Pwo Karen", "iso639": ["pwo"]},
    "QIN ": {
        "name": "Chin",
        "iso639": [
            "bgr",
            "biu",
            "cek",
            "cey",
            "cfm",
            "cbl",
            "cka",
            "ckn",
            "clj",
            "clt",
            "cmr",
            "cnb",
            "cnh",
            "cnk",
            "cnw",
            "csh",
            "csj",
            "csv",
            "csy",
            "ctd",
            "cth",
            "czt",
            "dao",
            "gnb",
            "hlt",
            "hmr",
            "hra",
            "lus",
            "mrh",
            "mwq",
            "pck",
            "pkh",
            "pub",
            "ral",
            "rtc",
            "sch",
            "sez",
            "shl",
            "smt",
            "tcp",
            "tcz",
            "vap",
            "weu",
            "zom",
            "zyp",
        ],
    },
    "QUC ": {"name": "K’iche’", "iso639": ["quc"]},
    "QUH ": {"name": "Quechua (Bolivia)", "iso639": ["quh"]},
    "QUZ ": {"name": "Quechua", "iso639": ["quz"]},
    "QVI ": {"name": "Quechua (Ecuador)", "iso639": ["qvi"]},
    "QWH ": {"name": "Quechua (Peru)", "iso639": ["qwh"]},
    "RAJ ": {"name": "Rajasthani", "iso639": ["raj"]},
    "RAR ": {"name": "Rarotongan", "iso639": ["rar"]},
    "RBU ": {"name": "Russian Buriat", "iso639": ["bxr"]},
    "RCR ": {"name": "R-Cree", "iso639": ["atj"]},
    "REJ ": {"name": "Rejang", "iso639": ["rej"]},
    "RIA ": {"name": "Riang", "iso639": ["ria"]},
    "RIF ": {"name": "Tarifit", "iso639": ["rif"]},
    "RIT ": {"name": "Ritarungo", "iso639": ["rit"]},
    "RKW ": {"name": "Arakwal", "iso639": ["rkw"]},
    "RMS ": {"name": "Romansh", "iso639": ["roh"]},
    "RMY ": {"name": "Vlax Romani", "iso639": ["rmy"]},
    "ROM ": {"name": "Romanian", "iso639": ["ron"]},
    "ROY ": {"name": "Romany", "iso639": ["rom"]},
    "RSY ": {"name": "Rusyn", "iso639": ["rue"]},
    "RTM ": {"name": "Rotuman", "iso639": ["rtm"]},
    "RUA ": {"name": "Kinyarwanda", "iso639": ["kin"]},
    "RUN ": {"name": "Rundi", "iso639": ["run"]},
    "RUP ": {"name": "Aromanian", "iso639": ["rup"]},
    "RUS ": {"name": "Russian", "iso639": ["rus"]},
    "SAD ": {"name": "Sadri", "iso639": ["sck"]},
    "SAN ": {"name": "Sanskrit", "iso639": ["san"]},
    "SAS ": {"name": "Sasak", "iso639": ["sas"]},
    "SAT ": {"name": "Santali", "iso639": ["sat"]},
    "SAY ": {"name": "Sayisi", "iso639": ["chp"]},
    "SCN ": {"name": "Sicilian", "iso639": ["scn"]},
    "SCO ": {"name": "Scots", "iso639": ["sco"]},
    "SCS ": {"name": "North Slavey", "iso639": ["scs"]},
    "SEK ": {"name": "Sekota", "iso639": ["xan"]},
    "SEL ": {"name": "Selkup", "iso639": ["sel"]},
    "SGA ": {"name": "Old Irish", "iso639": ["sga"]},
    "SGO ": {"name": "Sango", "iso639": ["sag"]},
    "SGS ": {"name": "Samogitian", "iso639": ["sgs"]},
    "SHI ": {"name": "Tachelhit", "iso639": ["shi"]},
    "SHN ": {"name": "Shan", "iso639": ["shn"]},
    "SIB ": {"name": "Sibe", "iso639": ["sjo"]},
    "SID ": {"name": "Sidamo", "iso639": ["sid"]},
    "SIG ": {"name": "Silte Gurage", "iso639": ["xst", "stv", "wle"]},
    "SKS ": {"name": "Skolt Sami", "iso639": ["sms"]},
    "SKY ": {"name": "Slovak", "iso639": ["slk"]},
    "SLA ": {"name": "Slavey", "iso639": ["den", "scs", "xsl"]},
    "SLV ": {"name": "Slovenian", "iso639": ["slv"]},
    "SML ": {"name": "Somali", "iso639": ["som"]},
    "SMO ": {"name": "Samoan", "iso639": ["smo"]},
    "SNA ": {"name": "Sena", "iso639": ["seh"]},
    "SNA0": {"name": "Shona", "iso639": ["sna"]},
    "SND ": {"name": "Sindhi", "iso639": ["snd"]},
    "SNH ": {"name": "Sinhala (Sinhalese)", "iso639": ["sin"]},
    "SNK ": {"name": "Soninke", "iso639": ["snk"]},
    "SOG ": {"name": "Sodo Gurage", "iso639": ["gru"]},
    "SOP ": {"name": "Songe", "iso639": ["sop"]},
    "SOT ": {"name": "Southern Sotho", "iso639": ["sot"]},
    "SQI ": {"name": "Albanian", "iso639": ["sqi"]},
    "SRB ": {"name": "Serbian", "iso639": ["cnr", "srp"]},
    "SRD ": {"name": "Sardinian", "iso639": ["srd"]},
    "SRK ": {"name": "Saraiki", "iso639": ["skr"]},
    "SRR ": {"name": "Serer", "iso639": ["srr"]},
    "SSL ": {"name": "South Slavey", "iso639": ["xsl"]},
    "SSM ": {"name": "Southern Sami", "iso639": ["sma"]},
    "STQ ": {"name": "Saterland Frisian", "iso639": ["stq"]},
    "SUK ": {"name": "Sukuma", "iso639": ["suk"]},
    "SUN ": {"name": "Sundanese", "iso639": ["sun"]},
    "SUR ": {"name": "Suri", "iso639": ["suq"]},
    "SVA ": {"name": "Svan", "iso639": ["sva"]},
    "SVE ": {"name": "Swedish", "iso639": ["swe"]},
    "SWA ": {"name": "Swadaya Aramaic", "iso639": ["aii"]},
    "SWK ": {"name": "Swahili", "iso639": ["swa"]},
    "SWZ ": {"name": "Swati", "iso639": ["ssw"]},
    "SXT ": {"name": "Sutu", "iso639": ["ngo", "xnj", "xnq"]},
    "SXU ": {"name": "Upper Saxon", "iso639": ["sxu"]},
    "SYL ": {"name": "Sylheti", "iso639": ["syl"]},
    "SYR ": {"name": "Syriac", "iso639": ["aii", "amw", "cld", "syc", "syr", "tru"]},
    "SYRE": {
        "name": "Syriac, Estrangela script-variant (equivalent to ISO 15924 'Syre')",
        "iso639": ["syc", "syr"],
    },
    "SYRJ": {
        "name": "Syriac, Western script-variant (equivalent to ISO 15924 'Syrj')",
        "iso639": ["syc", "syr"],
    },
    "SYRN": {
        "name": "Syriac, Eastern script-variant (equivalent to ISO 15924 'Syrn')",
        "iso639": ["syc", "syr"],
    },
    "SZL ": {"name": "Silesian", "iso639": ["szl"]},
    "TAB ": {"name": "Tabasaran", "iso639": ["tab"]},
    "TAJ ": {"name": "Tajiki", "iso639": ["tgk"]},
    "TAM ": {"name": "Tamil", "iso639": ["tam"]},
    "TAT ": {"name": "Tatar", "iso639": ["tat"]},
    "TCR ": {"name": "TH-Cree", "iso639": ["cwd"]},
    "TDD ": {"name": "Dehong Dai", "iso639": ["tdd"]},
    "TEL ": {"name": "Telugu", "iso639": ["tel"]},
    "TET ": {"name": "Tetum", "iso639": ["tet"]},
    "TGL ": {"name": "Tagalog", "iso639": ["tgl"]},
    "TGN ": {"name": "Tongan", "iso639": ["ton"]},
    "TGR ": {"name": "Tigre", "iso639": ["tig"]},
    "TGY ": {"name": "Tigrinya", "iso639": ["tir"]},
    "THA ": {"name": "Thai", "iso639": ["tha"]},
    "THT ": {"name": "Tahitian", "iso639": ["tah"]},
    "TIB ": {"name": "Tibetan", "iso639": ["bod"]},
    "TIV ": {"name": "Tiv", "iso639": ["tiv"]},
    "TKM ": {"name": "Turkmen", "iso639": ["tuk"]},
    "TMH ": {"name": "Tamashek", "iso639": ["taq", "thv", "thz", "tmh", "ttq"]},
    "TMN ": {"name": "Temne", "iso639": ["tem"]},
    "TNA ": {"name": "Tswana", "iso639": ["tsn"]},
    "TNE ": {"name": "Tundra Enets", "iso639": ["enh"]},
    "TNG ": {"name": "Tonga", "iso639": ["toi"]},
    "TOD ": {"name": "Todo", "iso639": ["xal"]},
    "TOD0": {"name": "Toma", "iso639": ["tod"]},
    "TPI ": {"name": "Tok Pisin", "iso639": ["tpi"]},
    "TRK ": {"name": "Turkish", "iso639": ["tur"]},
    "TSG ": {"name": "Tsonga", "iso639": ["tso"]},
    "TSJ ": {"name": "Tshangla", "iso639": ["tsj"]},
    "TUA ": {"name": "Turoyo Aramaic", "iso639": ["tru"]},
    "TUL ": {"name": "Tumbuka", "iso639": ["tcy"]},
    "TUM ": {"name": "Tulu", "iso639": ["tum"]},
    "TUV ": {"name": "Tuvin", "iso639": ["tyv"]},
    "TVL ": {"name": "Tuvalu", "iso639": ["tvl"]},
    "TWI ": {"name": "Twi", "iso639": ["twi"]},
    "TYZ ": {"name": "Tày", "iso639": ["tyz"]},
    "TZM ": {"name": "Tamazight", "iso639": ["tzm"]},
    "TZO ": {"name": "Tzotzil", "iso639": ["tzo"]},
    "UDM ": {"name": "Udmurt", "iso639": ["udm"]},
    "UKR ": {"name": "Ukrainian", "iso639": ["ukr"]},
    "UMB ": {"name": "Umbundu", "iso639": ["umb"]},
    "URD ": {"name": "Urdu", "iso639": ["urd"]},
    "USB ": {"name": "Upper Sorbian", "iso639": ["hsb"]},
    "UYG ": {"name": "Uyghur", "iso639": ["uig"]},
    "UZB ": {"name": "Uzbek", "iso639": ["uzb"]},
    "VEC ": {"name": "Venetian", "iso639": ["vec"]},
    "VEN ": {"name": "Venda", "iso639": ["ven"]},
    "VIT ": {"name": "Vietnamese", "iso639": ["vie"]},
    "VOL ": {"name": "Volapük", "iso639": ["vol"]},
    "VRO ": {"name": "Võro", "iso639": ["vro"]},
    "WA  ": {"name": "Wa", "iso639": ["wbm"]},
    "WAG ": {"name": "Wagdi", "iso639": ["wbr"]},
    "WAR ": {"name": "Waray-Waray", "iso639": ["war"]},
    "WCR ": {"name": "West-Cree", "iso639": ["crk"]},
    "WEL ": {"name": "Welsh", "iso639": ["cym"]},
    "WLF ": {"name": "Wolof", "iso639": ["wol"]},
    "WLN ": {"name": "Walloon", "iso639": ["wln"]},
    "WTM ": {"name": "Mewati", "iso639": ["wtm"]},
    "XBD ": {"name": "Lü", "iso639": ["khb"]},
    "XHS ": {"name": "Xhosa", "iso639": ["xho"]},
    "XJB ": {"name": "Minjangbal", "iso639": ["xjb"]},
    "XKF ": {"name": "Khengkha", "iso639": ["xkf"]},
    "XOG ": {"name": "Soga", "iso639": ["xog"]},
    "XPE ": {"name": "Kpelle (Liberia)", "iso639": ["xpe"]},
    "YAK ": {"name": "Sakha", "iso639": ["sah"]},
    "YAO ": {"name": "Yao", "iso639": ["yao"]},
    "YAP ": {"name": "Yapese", "iso639": ["yap"]},
    "YBA ": {"name": "Yoruba", "iso639": ["yor"]},
    "YCR ": {"name": "Y-Cree", "iso639": ["crj", "crk", "crl"]},
    "YIC ": {"name": "Yi Classic", "iso639": []},
    "YIM ": {"name": "Yi Modern", "iso639": ["iii"]},
    "ZEA ": {"name": "Zealandic", "iso639": ["zea"]},
    "ZGH ": {"name": "Standard Moroccan Tamazight", "iso639": ["zgh"]},
    "ZHA ": {"name": "Zhuang", "iso639": ["zha"]},
    "ZHH ": {"name": "Chinese, Traditional, Hong Kong SAR", "iso639": ["zho"]},
    "ZHP ": {"name": "Chinese, Phonetic", "iso639": ["zho"]},
    "ZHS ": {"name": "Chinese, Simplified", "iso639": ["zho"]},
    "ZHT ": {"name": "Chinese, Traditional", "iso639": ["zho"]},
    "ZHTM": {"name": "Chinese, Traditional, Macao SAR", "iso639": ["zho"]},
    "ZND ": {"name": "Zande", "iso639": ["zne"]},
    "ZUL ": {"name": "Zulu", "iso639": ["zul"]},
    "ZZA ": {"name": "Zazaki", "iso639": ["zza"]},
}
